/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.taxon.process;

import com.stratadata.model3.taxon.SynonymService;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class SynonymyUpdate {
    private final SynonymService synService;
    private final TaxonService taxonService;
    private final Taxon subjectTaxon;
    private int synSchID;
    private Taxon preferredTerm;
    private final List<Taxon> synonyms = new ArrayList<Taxon>();
    private final Predicate<String> confirmHandler;

    public SynonymyUpdate(SynonymService synService, TaxonService taxonService, Taxon subjectTaxon, int synSchID, Predicate<String> confirmHandler) {
        this.synService = synService;
        this.taxonService = taxonService;
        this.subjectTaxon = subjectTaxon;
        this.synSchID = synSchID;
        this.confirmHandler = confirmHandler;
        this.loadSynonymyOfSubject();
    }

    private void loadSynonymyOfSubject() {
        this.preferredTerm = null;
        this.synonyms.clear();
        this.synService.getPreferredTerm(this.synSchID, this.subjectTaxon.getSpecID(), this.taxonService).ifPresent(preferredTerm -> {
            this.preferredTerm = preferredTerm;
            this.synonyms.addAll(this.synService.getSynonyms(this.synSchID, preferredTerm.getSpecID(), this.taxonService));
        });
        if (this.preferredTerm == null) {
            this.synonyms.addAll(this.synService.getSynonyms(this.synSchID, this.subjectTaxon.getSpecID(), this.taxonService));
            if (!this.synonyms.isEmpty()) {
                this.preferredTerm = this.subjectTaxon;
            }
        }
    }

    public void setSynSchID(int synSchID) {
        if (synSchID == this.synSchID) {
            return;
        }
        this.synSchID = synSchID;
        this.loadSynonymyOfSubject();
    }

    public void removeSynonym(int specID) {
        if (specID == this.subjectTaxon.getSpecID()) {
            this.clearSynonymyWithConfirm();
            return;
        }
        this.synonyms.removeIf(taxon -> taxon.getSpecID() == specID);
    }

    public void addSynonym(Taxon synonym) throws SynUpdateException {
        if (this.synonyms.contains(synonym)) {
            return;
        }
        if (this.preferredTerm == null) {
            this.preferredTerm = this.subjectTaxon;
        }
        if (synonym.equals(this.preferredTerm)) {
            throw new SynUpdateException("This taxon is the preferred term!");
        }
        List<Taxon> existingSynonyms = this.synService.getSynonyms(this.synSchID, synonym.getSpecID(), this.taxonService);
        if (!existingSynonyms.isEmpty()) {
            throw new SynUpdateException("'" + String.valueOf(synonym) + "' is already the preferred term for:\n\n" + StringUtils.join(existingSynonyms, (String)"\n"));
        }
        Taxon existingPreferredTerm = this.synService.getPreferredTerm(this.synSchID, synonym.getSpecID(), this.taxonService).orElse(null);
        if (existingPreferredTerm != null && !this.confirmHandler.test("'" + String.valueOf(synonym) + "' is already a junior synonym of '" + String.valueOf(existingPreferredTerm) + "'.\nAre you sure you want to update it?")) {
            return;
        }
        this.synonyms.add(synonym);
    }

    public void setPreferredTerm(Taxon preferredTerm) {
        if (preferredTerm.equals(this.preferredTerm)) {
            return;
        }
        Taxon existingPreferredTerm = this.synService.getPreferredTerm(this.synSchID, preferredTerm.getSpecID(), this.taxonService).orElse(null);
        if (existingPreferredTerm != null) {
            if (this.confirmHandler.test("'" + String.valueOf(preferredTerm) + "' is already a junior synonym of '" + String.valueOf(existingPreferredTerm) + "'.\nDo you want to use this taxon as the preferred term instead?")) {
                preferredTerm = existingPreferredTerm;
            } else {
                return;
            }
        }
        List<Taxon> existingSynonyms = this.synService.getSynonyms(this.synSchID, preferredTerm.getSpecID(), this.taxonService);
        this.synonyms.clear();
        this.synonyms.addAll(existingSynonyms);
        if (preferredTerm.getSpecID() != this.subjectTaxon.getSpecID() && !this.synonyms.contains(this.subjectTaxon)) {
            this.synonyms.add(this.subjectTaxon);
        }
        Collections.sort(this.synonyms);
        this.preferredTerm = preferredTerm;
    }

    public void swapPreferredTermWithSynonym(Taxon synonym) {
        if (!this.synonyms.contains(synonym)) {
            throw new IllegalArgumentException("Synonym list does not contain new taxon");
        }
        this.synonyms.remove(synonym);
        this.synonyms.add(this.preferredTerm);
        Collections.sort(this.synonyms);
        this.preferredTerm = synonym;
    }

    public void clearSynonymyWithConfirm() {
        if (!this.confirmHandler.test("Clear synonymy for '" + String.valueOf(this.subjectTaxon) + "'?")) {
            return;
        }
        this.preferredTerm = null;
        this.synonyms.clear();
    }

    public void commitUpdate() {
        if (this.preferredTerm == null) {
            this.synService.removeSpecies(this.subjectTaxon.getSpecID());
            return;
        }
        this.synService.updateSynonymy(this.synSchID, this.preferredTerm.getSpecID(), this.synonyms.stream().map(Taxon::getSpecID).toList(), this.taxonService);
    }

    public Taxon getSubjectTaxon() {
        return this.subjectTaxon;
    }

    public Taxon getPreferredTerm() {
        return this.preferredTerm;
    }

    public List<Taxon> getSynonyms() {
        return new LinkedList<Taxon>(this.synonyms);
    }

    public int getSynSchID() {
        return this.synSchID;
    }

    public static class SynUpdateException
    extends Exception {
        public SynUpdateException(String message) {
            super(message);
        }
    }
}

