/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.taxon.process;

import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.GenusService;
import com.stratadata.model3.taxon.SearchMode;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonQual;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.model3.validation.SbugsValidator;
import com.stratadata.util.process.AbstractMultiStageProcess;
import com.stratadata.util.process.ProcessMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TaxonAdd
extends AbstractMultiStageProcess<TaxonAddStep> {
    private final ResourceBundle messages = ResourceBundle.getBundle("messages");
    private final TaxonService taxonService;
    private final GenusService genusService;
    private final Taxon taxon;
    private int specID;
    private int currentStep = 0;
    private List<Category> existingCats;
    private Genus existingMatchingGenus = null;

    public TaxonAdd(TaxonService taxonService, GenusService genusService, Taxon taxon) {
        this.taxonService = Objects.requireNonNull(taxonService);
        this.genusService = Objects.requireNonNull(genusService);
        this.taxon = Objects.requireNonNull(taxon);
    }

    public static TaxonAdd attemptAddWithoutConfirmations(TaxonService taxonService, GenusService genusService, Taxon taxon) {
        TaxonAdd ta = new TaxonAdd(taxonService, genusService, taxon);
        while (ta.isReady()) {
            if (ta.getCurrentMessage() != null) {
                ta.setResponse(ProcessMessage.Response.YES);
            }
            ta.process();
        }
        return ta;
    }

    @Override
    protected void process() {
        if (this.getResponse(this.getCurrentStep()) == ProcessMessage.Response.YES) {
            ++this.currentStep;
        }
        switch (this.getCurrentStep().ordinal()) {
            case 0: {
                this.validateTaxon();
                break;
            }
            case 1: {
                this.confirmQuestionableQualifier();
                break;
            }
            case 2: {
                this.checkForDuplicate();
                break;
            }
            case 3: {
                this.confirmTaxonExistsInOtherCategory();
                break;
            }
            case 4: {
                this.findExistingGenus();
                break;
            }
            case 5: {
                this.storeGenus();
                break;
            }
            case 6: {
                this.storeTaxon();
            }
        }
    }

    @Override
    public TaxonAddStep getCurrentStep() {
        return TaxonAddStep.values()[this.currentStep];
    }

    private void validateTaxon() {
        SbugsValidator validator = SbugsValidator.validate(this.taxon, SbugsValidator.ValidationStrategy.IGNORE_ID);
        List<String> validatorMessages = validator.getMessages();
        if (!validatorMessages.isEmpty()) {
            String message = this.messages.getString("taxon.process.TaxonAdd.invalidFields") + "\n";
            message = message + StringUtils.join(validator.getMessages(), (String)"\n");
            super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, message));
        } else {
            ++this.currentStep;
        }
    }

    private void confirmQuestionableQualifier() {
        for (int i = 0; i < 8; ++i) {
            if (!this.taxon.getQualifier(i).hasQual(TaxonQual.Q)) continue;
            String message = this.messages.getString("taxon.process.TaxonAdd.questionableQualifier") + "\n" + this.messages.getString("process.continueQuestion");
            this.addProcessMessage(TaxonAddStep.CONFIRM_QUALIFIERS, message, "");
            return;
        }
        ++this.currentStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForDuplicate() {
        Category category = this.taxon.getGenus().getCategory();
        this.taxon.getGenus().setCategory(null);
        try {
            List<Taxon> matchingTaxaInAllCategories = this.taxonService.findMatchingTaxa(this.taxon, null, SearchMode.LOOKUP);
            this.existingCats = new ArrayList<Category>();
            if (!matchingTaxaInAllCategories.isEmpty()) {
                for (Taxon match : matchingTaxaInAllCategories) {
                    if (match.getGenus().getCategory().equals(category)) {
                        super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, this.messages.getString("taxon.process.TaxonAdd.alreadyExists")));
                        return;
                    }
                    this.existingCats.add(match.getGenus().getCategory());
                }
            }
            ++this.currentStep;
        }
        finally {
            this.taxon.getGenus().setCategory(category);
        }
    }

    private void confirmTaxonExistsInOtherCategory() {
        if (!this.existingCats.isEmpty()) {
            String msg = String.format(this.messages.getString(this.existingCats.size() > 1 ? "taxon.process.TaxonAdd.alreadyExistsInCategories" : "taxon.process.TaxonAdd.alreadyExistsInCategory"), StringUtils.join(this.existingCats, (String)", ")) + "\n" + this.messages.getString("taxon.process.TaxonAdd.confirmAdd");
            super.addProcessMessage(TaxonAddStep.CONFIRM_TAXON_IN_OTHER_CAT, msg, this.messages.getString("taxon.process.TaxonAdd.title.duplicateTaxon"));
            return;
        }
        ++this.currentStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findExistingGenus() {
        Category category = this.taxon.getGenus().getCategory();
        this.taxon.getGenus().setCategory(null);
        try {
            List<Genus> matchingGeneraInAllCategories = this.genusService.findMatchingGenera(this.taxon.getGenus(), SearchMode.LOOKUP);
            if (!matchingGeneraInAllCategories.isEmpty()) {
                String otherCategoriesWithGenus;
                this.existingMatchingGenus = matchingGeneraInAllCategories.stream().filter(matchingGenus -> matchingGenus.getCategory().equals(category)).findAny().orElse(null);
                if (this.existingMatchingGenus == null && !(otherCategoriesWithGenus = matchingGeneraInAllCategories.stream().map(Genus::getCategory).filter(categoryOfMatchingGenus -> !categoryOfMatchingGenus.equals(category)).map(Category::getMnemonic).collect(Collectors.joining(", "))).isEmpty()) {
                    String msg = String.format(otherCategoriesWithGenus.contains(",") ? this.messages.getString("taxon.process.TaxonAdd.genusAlreadyExistsInCategories") : this.messages.getString("taxon.process.TaxonAdd.genusAlreadyExistsInCategory"), otherCategoriesWithGenus) + "\n" + String.format(this.messages.getString("taxon.process.TaxonAdd.confirmAddGenus"), category.getName());
                    super.addProcessMessage(TaxonAddStep.CONFIRM_GENUS_IN_OTHER_CAT, msg, this.messages.getString("taxon.process.TaxonAdd.title.duplicateGenus"));
                    return;
                }
            }
            ++this.currentStep;
        }
        finally {
            this.taxon.getGenus().setCategory(category);
        }
    }

    private void storeGenus() {
        if (this.existingMatchingGenus == null) {
            try {
                this.taxon.setGenus(this.genusService.addGenus(this.taxon.getGenus()));
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, String.format(this.messages.getString("taxon.process.TaxonAdd.error.addingGenus"), ex.getMessage())));
                return;
            }
        } else {
            this.taxon.setGenus(this.existingMatchingGenus);
        }
        ++this.currentStep;
    }

    private void storeTaxon() {
        try {
            Taxon addedTaxon = this.taxonService.addTaxon(this.taxon);
            this.specID = addedTaxon.getSpecID();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.FAIL, String.format(this.messages.getString("taxon.process.TaxonAdd.error.addingTaxon"), ex.getMessage())));
            return;
        }
        super.setResult(new AbstractMultiStageProcess.ProcessResult(AbstractMultiStageProcess.ResultType.SUCCESS, this.messages.getString("taxon.process.TaxonAdd.success")));
    }

    public int getSpecID() {
        return this.specID;
    }

    public Genus getExistingMatchingGenus() {
        return this.existingMatchingGenus;
    }

    public static enum TaxonAddStep {
        VALIDATE,
        CONFIRM_QUALIFIERS,
        CHECK_EXISTING,
        CONFIRM_TAXON_IN_OTHER_CAT,
        CONFIRM_GENUS_IN_OTHER_CAT,
        STORE_GENUS,
        STORE_TAXON;

    }
}

