/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.validation;

import com.stratadata.model3.validation.SbugsValidator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;

public class FieldLengthProperties {
    private static final Properties FIELD_LEN = new Properties();

    private FieldLengthProperties() {
    }

    public static int getFieldLength(Class clazz, String fieldName, int defaultValue) {
        try {
            Object fieldLengthProperty = FIELD_LEN.get(clazz.getCanonicalName() + "." + fieldName);
            if (fieldLengthProperty != null) {
                return Integer.parseInt(fieldLengthProperty.toString());
            }
        }
        catch (Exception e) {
            Logger.getLogger(FieldLengthProperties.class.getName()).warning("Error getting field length for " + clazz.getCanonicalName() + "." + fieldName + ": " + e.getMessage());
        }
        return defaultValue;
    }

    public static Optional<Integer> getFieldLength(Field field) {
        Object fieldLengthProperty = FIELD_LEN.get(field.getDeclaringClass().getCanonicalName() + "." + field.getName());
        if (fieldLengthProperty != null) {
            return Optional.of(Integer.parseInt(fieldLengthProperty.toString()));
        }
        return Optional.empty();
    }

    static {
        try {
            InputStream input = SbugsValidator.class.getClassLoader().getResourceAsStream("fieldLen.properties");
            FIELD_LEN.load(input);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

