/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well;

public enum GeoDatum {
    WGS84("WGS84", "WGS 84", "EPSG:4326"),
    NAD83("NAD83", "NAD 83", "EPSG:4267"),
    NAD27("NAD27", "NAD 27", "EPSG:4269"),
    ED50("ED50", "ED 50", "EPSG:4230"),
    ETRS89("ETRS89", "ETRS 89", "EPSG:4258"),
    OSGB36("OSGB36", "OSGB 36", "EPSG:4277"),
    GDA94("GDA94", "GDA 94", "EPSG:4283"),
    SAD69("SAD69", "SAD 69", "EPSG:4618"),
    SAD6996("SAD69(96)", "SAD 69(96)", "EPSG:5527");

    private final String name;
    private final String altName;
    private final String epsgCode;

    private GeoDatum(String name, String altName, String code) {
        this.name = name;
        this.altName = altName;
        this.epsgCode = code;
    }

    public String getName() {
        return this.name;
    }

    public String getAltName() {
        return this.altName;
    }

    public String getEpsgCode() {
        return this.epsgCode;
    }

    public static String parseEpsgCode(String geoDatum, boolean useDefault) {
        if (!geoDatum.isBlank()) {
            for (GeoDatum g : GeoDatum.values()) {
                if (!geoDatum.equalsIgnoreCase(g.name) && !geoDatum.equalsIgnoreCase(g.altName)) continue;
                return g.epsgCode;
            }
        }
        if (useDefault) {
            return GeoDatum.WGS84.epsgCode;
        }
        return "";
    }
}

