/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.analysis;

import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.audit.Audited;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.validation.LimitedLengthString;
import com.stratadata.model3.validation.NotNull;
import com.stratadata.model3.validation.Validatable;
import com.stratadata.model3.well.analysis.AnalysisID;
import com.stratadata.model3.well.analysis.Identification;
import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.analysis.SpeciesType;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@Validatable
public class Occurrence
implements Audited {
    private final AnalysisID analysisID;
    @NotNull
    private Taxon taxon;
    @NotNull
    private Situation situation = Situation.INSITU;
    @NotNull
    private Identification identType = Identification.POSITIVE;
    private SpeciesType specType;
    @LimitedLengthString
    private String subjAbund = "";
    private int coarse;
    private int medium;
    private int fine;
    private boolean marker;
    @LimitedLengthString
    private String preservation = "";
    @LimitedLengthString
    private String colour = "";
    @LimitedLengthString
    private String comment = "";
    private Audit audit = new AuditImpl();

    public Occurrence(AnalysisID id) {
        this.analysisID = id;
    }

    Occurrence() {
        this.analysisID = null;
    }

    public AnalysisID getAnalysisID() {
        return this.analysisID;
    }

    public int getSpecID() {
        return this.taxon.getSpecID();
    }

    public Taxon getTaxon() {
        return this.taxon;
    }

    public void setTaxon(Taxon taxon) {
        this.taxon = taxon;
    }

    public Situation getSituation() {
        return this.situation;
    }

    public void setSituation(Situation situation) {
        this.situation = Objects.requireNonNullElse(situation, this.situation);
    }

    public Identification getIdentType() {
        return this.identType;
    }

    public void setIdentType(Identification identType) {
        this.identType = Objects.requireNonNullElse(identType, this.identType);
    }

    public SpeciesType getSpeciesType() {
        return this.specType;
    }

    public void setSpeciesType(SpeciesType specType) {
        this.specType = specType;
    }

    @Override
    public Audit getAudit() {
        return this.audit;
    }

    public void setAudit(Audit audit) {
        this.audit = Objects.requireNonNullElse(audit, new AuditImpl());
    }

    public boolean isMarker() {
        return this.marker;
    }

    public void setMarker(boolean marker) {
        this.marker = marker;
    }

    public String getPreservation() {
        return this.preservation;
    }

    public void setPreservation(String preservation) {
        this.preservation = StringUtils.stripToEmpty((String)preservation);
    }

    public String getColour() {
        return this.colour;
    }

    public void setColour(String colour) {
        this.colour = StringUtils.stripToEmpty((String)colour);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = StringUtils.stripToEmpty((String)comment);
    }

    public String getSubjAbund() {
        return this.subjAbund;
    }

    public void setSubjAbund(String subjAbund) {
        this.subjAbund = StringUtils.stripToEmpty((String)subjAbund);
    }

    public int getCoarse() {
        return this.coarse;
    }

    public void setCoarse(int coarse) {
        this.coarse = coarse;
    }

    public int getMedium() {
        return this.medium;
    }

    public void setMedium(int medium) {
        this.medium = medium;
    }

    public int getFine() {
        return this.fine;
    }

    public void setFine(int fine) {
        this.fine = fine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Occurrence that = (Occurrence)o;
        return Objects.equals(this.analysisID, that.analysisID) && Objects.equals(this.taxon, that.taxon) && this.situation == that.situation && this.identType == that.identType && Objects.equals(this.specType, that.specType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.analysisID, this.taxon, this.situation, this.identType, this.specType});
    }

    public double getDerivedCount(AbundanceScheme abundanceScheme) {
        double total = this.getTotalCount();
        if (total < 0.001 && !this.subjAbund.isEmpty() && abundanceScheme != null) {
            total = abundanceScheme.getCountBySubjAbund(this.subjAbund);
        }
        return total;
    }

    public int getTotalCount() {
        return this.coarse + this.medium + this.fine;
    }
}

