/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.analysis.hdr;

import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeImpl;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public interface AbundanceSchemeService {
    public Optional<AbundanceScheme> findAbundanceScheme(int var1);

    public List<AbundanceScheme> getAllAbundanceSchemes();

    public int getAbundanceSchemeCount();

    public AbundanceScheme addAbundanceScheme(AbundanceScheme var1);

    public void updateAbundanceScheme(AbundanceSchemeImpl var1);

    public void deleteAbundanceScheme(int var1);

    default public boolean checkName(String proposedName, int existingID) {
        for (AbundanceScheme scheme : this.getAllAbundanceSchemes()) {
            if (existingID > 0 && scheme.getAbnSchID() == existingID || !scheme.getName().equalsIgnoreCase(proposedName)) continue;
            return false;
        }
        return true;
    }

    default public AbundanceScheme getDefaultAbundanceScheme() {
        List<AbundanceScheme> allSchemes = this.getAllAbundanceSchemes();
        return allSchemes.stream().filter(s -> s.getName().equalsIgnoreCase("Default Abundance Scheme")).findFirst().orElseGet(() -> allSchemes.stream().sorted(Comparator.comparingInt(AbundanceScheme::getAbnSchID)).findFirst().orElse(null));
    }

    public static boolean checkEquivalence(AbundanceScheme sch1, AbundanceScheme sch2) {
        if (sch1.getEntryCount() != sch2.getEntryCount()) {
            return false;
        }
        for (int i = 0; i < sch1.getEntryCount(); ++i) {
            AbundanceScheme.AbundanceSchemeEntry sch1Entry = sch1.getEntry(i);
            AbundanceScheme.AbundanceSchemeEntry sch2Entry = sch2.getEntry(i);
            if (sch1Entry.lowBound() == sch2Entry.lowBound() && sch1Entry.abr().equalsIgnoreCase(sch2Entry.abr())) continue;
            return false;
        }
        return true;
    }
}

