/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.curve;

import com.stratadata.model3.well.curve.Curve;
import java.util.List;
import java.util.stream.Stream;

public interface WellCurveService {
    default public void addListener(Listener l) {
    }

    default public void deleteListener(Listener l) {
    }

    default public Stream<Listener> getListeners() {
        return Stream.empty();
    }

    public int getWellID();

    public int getCurveCount();

    default public List<Curve> getCurves() {
        return this.getCurves(true);
    }

    public List<Curve> getCurves(boolean var1);

    default public List<Curve> getCurves(String abr) {
        return this.getCurves().stream().filter(curve -> curve.getAbr().equals(abr)).toList();
    }

    default public void setCurveActive(int curveID, boolean active) {
        Curve curve = this.getCurves(false).stream().filter(c -> c.getID() == curveID).findFirst().orElseThrow(IllegalArgumentException::new);
        if (curve.isActive() != active) {
            curve.setActive(active);
            this.getListeners().forEach(Listener::curveListUpdated);
        }
    }

    default public boolean checkOverlap(Curve curve) {
        boolean overlap = false;
        double topDepth = curve.getTopDepth();
        double baseDepth = curve.getBaseDepth();
        for (Curve c : this.getCurves(curve.getAbr())) {
            if (!(c.getTopDepth() >= topDepth && c.getTopDepth() <= baseDepth) && (!(c.getBaseDepth() >= topDepth) || !(c.getBaseDepth() <= baseDepth))) continue;
            overlap = true;
            break;
        }
        return overlap;
    }

    public static interface Listener {
        public void curveListUpdated();
    }
}

