/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.curve;

import com.stratadata.model3.well.curve.Curve;
import com.stratadata.model3.well.curve.WellCurveService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class WellCurveServiceImpl
implements WellCurveService {
    private final int wellID;
    private final Map<Integer, Curve> curves = new HashMap<Integer, Curve>();

    public WellCurveServiceImpl(int wellID) {
        this.wellID = wellID;
    }

    @Override
    public int getWellID() {
        return this.wellID;
    }

    @Override
    public int getCurveCount() {
        return (int)this.curves.values().stream().filter(Curve::isActive).count();
    }

    @Override
    public List<Curve> getCurves(boolean activeOnly) {
        return this.curves.values().stream().filter(activeOnly ? Curve::isActive : curve -> true).collect(Collectors.toCollection(ArrayList::new));
    }

    public void deleteCurves(Collection<Curve> toDelete) {
        for (Curve curve : toDelete) {
            this.curves.remove(curve.getID());
        }
    }

    public void addCurve(Curve curve) {
        this.curves.put(curve.getID(), curve);
    }
}

