/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.sample;

import com.stratadata.model3.SystemPreferences;
import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.audit.Audited;
import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.sample.SampleComparator;
import com.stratadata.model3.well.sample.SampleProperties;
import com.stratadata.model3.well.sample.SampleStringFactory;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Sample
implements Comparable<Sample>,
SampleProperties,
Audited {
    public static final double SMALL = 0.0029;
    private final long wellID;
    private final int sampID;
    private SectionType sectionType = SectionType.WELL;
    private SampleDepth depth;
    private SampleType type;
    private String label = "";
    private Audit audit = new AuditImpl();

    public Sample(long wellID, int sampID) {
        this.wellID = wellID;
        this.sampID = sampID;
    }

    @Override
    public int getSampID() {
        return this.sampID;
    }

    public long getWellID() {
        return this.wellID;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(label, ""));
    }

    @Override
    public SampleType getType() {
        return this.type;
    }

    public void setType(SampleType type) {
        this.type = Objects.requireNonNullElse(type, this.type);
    }

    @Override
    public SectionType getSectionType() {
        return this.sectionType;
    }

    public void setSectionType(SectionType sectionType) {
        this.sectionType = Objects.requireNonNullElse(sectionType, this.sectionType);
    }

    @Override
    public Double getTopDepth() {
        return this.depth.top;
    }

    @Override
    public Double getBaseDepth() {
        return this.depth.base;
    }

    public double getDepth() {
        return this.depth.getDepth(SystemPreferences.getInstance().useSampleTops());
    }

    public void setDepth(Double top, Double base, DepthUnits units) {
        if (top != null && base != null && top > base) {
            throw new IllegalArgumentException("Top depth larger than base depth in sample: " + top + " - " + base);
        }
        if (top != null && top > 99999.0 || base != null && base > 99999.0) {
            throw new IllegalArgumentException("Top or base depth unreasonably high value in sample: " + top + " - " + base);
        }
        this.depth = new SampleDepth(top == null ? null : Double.valueOf(DepthUtils.convToM(top, units)), base == null ? null : Double.valueOf(DepthUtils.convToM(base, units)));
    }

    @Override
    public boolean hasDepth() {
        return this.depth != null;
    }

    @Override
    public Audit getAudit() {
        return this.audit;
    }

    public void setAudit(Audit audit) {
        this.audit = Objects.requireNonNullElse(audit, new AuditImpl());
    }

    @Override
    public int compareTo(Sample o) {
        return SampleComparator.compareSamples(this, o);
    }

    public String toString() {
        return SampleStringFactory.toString(this, DepthUnits.M);
    }

    public String toString(DepthUnits units) {
        return SampleStringFactory.toString(this, units);
    }

    private record SampleDepth(Double top, Double base) {
        double getDepth(boolean useSampleTops) {
            if (useSampleTops) {
                if (this.top != null) {
                    return this.top;
                }
                if (this.base != null) {
                    return this.base;
                }
            } else {
                if (this.base != null) {
                    return this.base;
                }
                if (this.top != null) {
                    return this.top;
                }
            }
            return 0.0;
        }
    }
}

