/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.wellinterp;

import com.stratadata.model3.scheme.Boundary;

public class LOCNode
implements Comparable {
    private double depth;
    private double age;
    private int bnd;
    private String databaseKey = null;

    public LOCNode(double depth, double csu, int bnd) {
        this.depth = depth;
        this.age = csu;
        this.bnd = bnd;
    }

    LOCNode(LOCNode rhs) {
        this.depth = rhs.depth;
        this.age = rhs.age;
        this.bnd = rhs.bnd;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getAge() {
        return this.age;
    }

    public String getKey() {
        return LOCNode.getNodeKey(this.depth, this.age);
    }

    public int getBnd() {
        return this.bnd;
    }

    public void setDatabaseKey(String key) {
        this.databaseKey = key;
    }

    public String getDeletionKey() {
        if (this.databaseKey == null || this.databaseKey.isEmpty()) {
            return this.getKey();
        }
        return this.databaseKey;
    }

    public String getBoundaryType() {
        return Boundary.getBnd(this.bnd).getDescription();
    }

    public int compareTo(Object o) {
        LOCNode node = (LOCNode)o;
        if (this.depth < node.depth) {
            return -1;
        }
        if (this.depth > node.depth) {
            return 1;
        }
        if (node.getKey().equals(this.getKey())) {
            return 0;
        }
        if ((int)(node.getDepth() * 1000.0) == (int)(this.depth * 1000.0)) {
            if (!Boundary.getBnd(this.bnd).isDisconformable() && !Boundary.getBnd(node.bnd).isDisconformable()) {
                return this.age > node.getAge() ? 1 : -1;
            }
            if (Boundary.getBnd(node.bnd).isDisconformable()) {
                return 1;
            }
            return -1;
        }
        return -1;
    }

    public static String getNodeKey(double depth, double age) {
        String ageSuffix = String.format("%06d", Math.round(age * 1000.0));
        return Math.round(depth * 1000.0 + 10000.0) + "-" + ageSuffix;
    }

    void setDepth(double depth) {
        this.depth = depth;
    }

    void setAge(double age) {
        this.age = age;
    }

    void setBnd(int bnd) {
        this.bnd = bnd;
    }
}

