/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.wellinterp.generate;

import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.scheme.IgdType;
import com.stratadata.model3.scheme.StratigraphicUnit;
import com.stratadata.model3.scheme.StratigraphicUnitService;
import com.stratadata.model3.well.sample.DepthCorrectionService;
import com.stratadata.model3.well.sample.Sample;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.model3.well.sample.WellSampleService;
import com.stratadata.model3.wellinterp.DepthAgeCurve;
import com.stratadata.model3.wellinterp.LOCNode;
import com.stratadata.model3.wellinterp.StratigraphicInterval;
import com.stratadata.util.depth.DepthUnits;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class IntervalGenerator {
    Logger LOGGER = Logger.getLogger(IntervalGenerator.class.getName());
    boolean useSampleTops = false;
    private int schID;
    private StratigraphicUnitService scheme;
    private IgdType igdType;
    private long wellID;
    private DepthAgeCurve depthAgeCurve;
    private WellSampleService samples;
    private DepthCorrectionService depthCorrection;
    private SampleOption sampleOption;
    private boolean restrictToSamplesInDiscipline = false;
    private final boolean[] selectedHiers = new boolean[8];

    public IntervalGenerator(int schID, StratigraphicUnitService scheme, IgdType igdType, DepthAgeCurve depthAgeCurve, WellSampleService samples, DepthCorrectionService depthCorrection) {
        this.schID = schID;
        this.scheme = scheme;
        this.igdType = igdType;
        this.depthAgeCurve = depthAgeCurve;
        this.samples = samples;
        this.depthCorrection = depthCorrection;
    }

    public void selectHier(int hier) {
        this.selectedHiers[hier - 1] = true;
    }

    public void setSampleOption(SampleOption sampleOption) {
        this.sampleOption = sampleOption;
    }

    private boolean isValid() {
        return this.schID >= 0 && this.sampleOption != null;
    }

    public List<StratigraphicInterval> deriveIntervals() {
        if (!this.isValid()) {
            throw new IllegalStateException("Interval generator not fully initialised");
        }
        HashMap<Long, AgeNode> ageNodes = new HashMap<Long, AgeNode>();
        for (StratigraphicUnit unit : this.scheme.getUnits(this.schID)) {
            if (!unit.hasAges()) continue;
            ageNodes.computeIfAbsent(AgeNode.getKey(unit.getuAge()), k -> new AgeNode(unit.getuAge()));
            ageNodes.computeIfAbsent(AgeNode.getKey(unit.getlAge()), k -> new AgeNode(unit.getlAge()));
        }
        Iterator itAD = ageNodes.values().iterator();
        while (itAD.hasNext()) {
            AgeNode ad = (AgeNode)itAD.next();
            Double depth = this.depthAgeCurve.getDepthOfAge(ad.age, null, null, true);
            if (depth == null) {
                itAD.remove();
                continue;
            }
            ad.depth = depth;
        }
        LOCNode firstLocNode = this.depthAgeCurve.getNode(0);
        AgeNode youngestAgeNode = new AgeNode(firstLocNode.getAge());
        youngestAgeNode.depth = firstLocNode.getDepth();
        youngestAgeNode.bnd = Boundary.getBnd(firstLocNode.getBnd());
        ageNodes.put(AgeNode.getKey(youngestAgeNode.age), youngestAgeNode);
        LOCNode lastLocNode = this.depthAgeCurve.getNode(this.depthAgeCurve.getSize() - 1);
        AgeNode oldestAgeNode = new AgeNode(lastLocNode.getAge());
        oldestAgeNode.depth = lastLocNode.getDepth();
        oldestAgeNode.bnd = Boundary.getBnd(lastLocNode.getBnd());
        ageNodes.put(AgeNode.getKey(oldestAgeNode.age), oldestAgeNode);
        for (AgeNode a : ageNodes.values()) {
            a.bnd = Boundary.getBnd(this.depthAgeCurve.getBoundary(a.depth));
        }
        LinkedList<StratigraphicInterval> intervals = new LinkedList<StratigraphicInterval>();
        block6: for (StratigraphicUnit unit : this.scheme.getUnits(this.schID)) {
            Sample baseSample;
            Sample topSample;
            if (!this.selectedHiers[unit.getHier() - 1] || !unit.hasAges()) continue;
            long uppAge = AgeNode.getKey(unit.getuAge());
            AgeNode nodeForUppAge = unit.getuAge() < youngestAgeNode.age ? youngestAgeNode : (AgeNode)ageNodes.get(uppAge);
            if (nodeForUppAge == null) continue;
            long lowAgeKey = AgeNode.getKey(unit.getlAge());
            AgeNode nodeForLowAge = unit.getlAge() > oldestAgeNode.age ? oldestAgeNode : (AgeNode)ageNodes.get(lowAgeKey);
            if (nodeForLowAge == null) continue;
            switch (this.sampleOption.ordinal()) {
                case 1: {
                    topSample = this.findOrCreateSampleAt(nodeForUppAge);
                    baseSample = this.findOrCreateSampleAt(nodeForLowAge);
                    break;
                }
                default: {
                    double ageBase;
                    double ageTop;
                    topSample = this.getNearestExistingSample(nodeForUppAge);
                    baseSample = this.getNearestExistingSample(nodeForLowAge);
                    if (topSample == null || baseSample == null || (ageTop = this.depthAgeCurve.getAge(topSample.getDepth(), false, true)) > unit.getlAge() || (ageBase = this.depthAgeCurve.getAge(baseSample.getDepth(), false, true)) < unit.getuAge() || nodeForUppAge.bnd.isDisconformable() && nodeForLowAge.bnd.isDisconformable() && topSample == baseSample) continue block6;
                }
            }
            StratigraphicInterval interval = new StratigraphicInterval(this.igdType, this.schID, this.wellID, 0);
            interval.setTopSample(topSample);
            interval.setBaseSample(baseSample);
            interval.setHier(unit.getHier());
            interval.setTopBoundary(nodeForUppAge.bnd);
            interval.setUppZone(unit.getUnitID());
            interval.setUppInf(unit.getName());
            interval.setBaseBoundary(nodeForLowAge.bnd);
            IntervalGenerator.addInterval(interval, intervals);
        }
        Collections.sort(intervals);
        return intervals;
    }

    private Sample findOrCreateSampleAt(AgeNode node) {
        if (node.newSample != null) {
            return node.newSample;
        }
        return this.samples.findSample(node.depth, null).orElseGet(() -> {
            Sample s = new Sample(this.wellID, 0);
            s.setType(SampleType.LOG);
            s.setDepth(this.useSampleTops ? Double.valueOf(node.depth) : null, this.useSampleTops ? null : Double.valueOf(node.depth), DepthUnits.M);
            node.newSample = s;
            return s;
        });
    }

    private Sample getNearestExistingSample(AgeNode node) {
        Sample sample;
        if (node.bnd.isDisconformable()) {
            if (node.newSample == null) {
                this.findOrCreateSampleAt(node);
            }
            sample = node.newSample;
        } else {
            int b;
            sample = this.samples.findSampleNearestBelow(node.depth, null, this.depthCorrection).orElse(null);
            if (sample != null && (b = this.depthAgeCurve.getBoundary(sample.getDepth())) > 0) {
                node.bnd = Boundary.getBnd(b);
            }
        }
        return sample;
    }

    private static void addInterval(StratigraphicInterval newInterval, List<StratigraphicInterval> intervalList) {
        for (StratigraphicInterval existing : intervalList) {
            if (newInterval.getHier() != existing.getHier()) continue;
            if (newInterval.getTopSample() == existing.getTopSample()) {
                intervalList.remove(existing);
                intervalList.add(newInterval);
                return;
            }
            if (newInterval.getBaseSample() != existing.getBaseSample()) continue;
            return;
        }
        intervalList.add(newInterval);
    }

    public static enum SampleOption {
        SNAP_TO_NEAREST,
        CREATE_LOG_PICKS;

    }

    private static class AgeNode {
        final double age;
        double depth;
        Boundary bnd;
        Sample newSample;

        AgeNode(double age) {
            this.age = age;
        }

        public String toString() {
            return "AgeNode{age=" + this.age + ", depth=" + this.depth + ", bnd=" + String.valueOf((Object)this.bnd) + "}";
        }

        static long getKey(double age) {
            return (long)(age * 1.0E7);
        }
    }
}

