/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model2_1.CasingPoint;
import model2_1.SBdb;
import model2_1.Well;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class Casing
extends Observable {
    private final SBdb sbdb;
    private final List<CasingPoint> casing = new ArrayList<CasingPoint>();

    public List<CasingPoint> getList() {
        return this.casing;
    }

    public Casing(SBdb sbdb) {
        this.sbdb = sbdb;
    }

    public int getSize() {
        return this.casing.size();
    }

    void clear() {
        this.casing.clear();
    }

    public SBdb getDataModel() {
        return this.sbdb;
    }

    public CasingPoint getCasingPoint(int row) {
        return this.casing.get(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(CasingPoint casingPoint) throws SBException {
        List<CasingPoint> list = this.casing;
        synchronized (list) {
            this.casing.add(this.checkOverlap(casingPoint), casingPoint);
        }
        this.setChanged();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkOverlap(CasingPoint casingPoint) throws SBException {
        int insertPoint = 0;
        List<CasingPoint> list = this.casing;
        synchronized (list) {
            Iterator<CasingPoint> it = this.casing.iterator();
            int lastDiamIndex = -1;
            int diamIndex = -1;
            try {
                diamIndex = this.sbdb.getCasingDiameters().indexOf(casingPoint.getDiameter());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            int nzD = (int)(casingPoint.getDepth() * 100.0);
            while (it.hasNext()) {
                CasingPoint compareWith = it.next();
                try {
                    lastDiamIndex = this.sbdb.getCasingDiameters().indexOf(compareWith.getDiameter());
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                if (compareWith != casingPoint) {
                    int cD = (int)(compareWith.getDepth() * 100.0);
                    if (nzD == cD) {
                        throw new SBException("Casing point depth already exists: " + casingPoint.toString());
                    }
                    if (nzD < cD) {
                        if (diamIndex <= lastDiamIndex) break;
                        throw new SBException("Casing point not in descending diameter" + casingPoint);
                    }
                    ++insertPoint;
                    continue;
                }
                return -1;
            }
        }
        return insertPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(int wellID) throws SQLException {
        List<CasingPoint> list = this.casing;
        synchronized (list) {
            this.casing.clear();
        }
        String sql = "SELECT depth, diam FROM " + this.sbdb.DBTableName("casing") + " WHERE well_id=" + wellID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                double depth = rs.getDouble("depth");
                String diam = rs.getString("diam");
                CasingPoint casingPoint = new CasingPoint(depth, diam);
                casingPoint.status = CasingPoint.STORED;
                try {
                    this.add(casingPoint);
                }
                catch (SBException e) {
                    System.out.println("Error adding casing point: " + e.getMessage());
                }
            }
        }
        this.setChanged();
    }

    public boolean updateFromMaster(int wellID, String wellCode) throws SQLException, SBException, SBPermissionException {
        if (!this.sbdb.hasCasingMaster) {
            return true;
        }
        Casing viewCasing = new Casing(this.sbdb);
        viewCasing.loadFromView(this.sbdb, wellCode);
        LinkedList<CasingPoint> toAdd = new LinkedList<CasingPoint>();
        boolean conflict = false;
        for (CasingPoint viewC : viewCasing.casing) {
            boolean found = false;
            for (CasingPoint dbC : this.casing) {
                if (!dbC.getDiameter().equalsIgnoreCase(viewC.getDiameter())) continue;
                if (Math.abs(dbC.getDepth() - viewC.getDepth()) < (double)0.0029f) {
                    found = true;
                    break;
                }
                conflict = true;
                break;
            }
            if (conflict) break;
            if (found) continue;
            toAdd.add(viewC);
        }
        if (!conflict) {
            Well well = this.sbdb.getWell(wellID);
            for (CasingPoint casingPoint : toAdd) {
                well.addCasingPoint(casingPoint.getDepth(), casingPoint.getDiameter());
            }
        }
        return !conflict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromView(SBdb db, String wellCode) throws SQLException {
        List<CasingPoint> list = this.casing;
        synchronized (list) {
            this.casing.clear();
        }
        String sql = "SELECT depth, diam FROM " + db.DBTableName("CASING_MASTER") + " WHERE well_code=" + SB.DBString((String)wellCode);
        try (Statement stmt = db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                double depth = rs.getDouble("depth");
                String diam = rs.getString("diam");
                CasingPoint casingPoint = new CasingPoint(depth, diam);
                try {
                    this.add(casingPoint);
                }
                catch (SBException e) {
                    System.out.println("Error adding casing point: " + e.getMessage());
                }
            }
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.sbdb.DBTableName("casing") + " WHERE well_id=" + wellID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int wellID, Collection<CasingPoint> points) throws SQLException, SBException {
        List<CasingPoint> list = this.casing;
        synchronized (list) {
            if (this.sbdb != null && this.sbdb.isConnected()) {
                String sql = "DELETE FROM " + this.sbdb.DBTableName("casing") + " WHERE well_id=" + wellID;
                try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                    for (CasingPoint p : points) {
                        if (!this.casing.contains(p)) {
                            throw new IllegalArgumentException("Attempt to delete casing point from wrong well");
                        }
                        int nRows = stmt.executeUpdate(this.sbdb.modQuery(sql + " AND depth > " + (p.getDepth() - 0.01) + " AND depth < " + (p.getDepth() + 0.01)));
                        if (nRows >= 1) continue;
                        throw new SBException("Failed to delete casing point at depth: " + p.getDepth());
                    }
                }
            }
            this.casing.removeAll(points);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIntervalStatus(Color status) {
        List<CasingPoint> list = this.casing;
        synchronized (list) {
            Iterator<CasingPoint> it = this.casing.iterator();
            while (it.hasNext()) {
                it.next().status = status;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(int wellID) throws SQLException {
        List<CasingPoint> list = this.casing;
        synchronized (list) {
            Iterator<CasingPoint> it = this.casing.iterator();
            boolean refresh = false;
            while (it.hasNext()) {
                if (it.next().status != CasingPoint.NOTSTORED) continue;
                refresh = true;
                break;
            }
            if (!refresh) {
                return;
            }
            this.deleteAll(wellID);
            for (CasingPoint point : this.casing) {
                point.status = CasingPoint.NOTSTORED;
                point.store(this.sbdb, wellID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        List<CasingPoint> list = this.casing;
        synchronized (list) {
            Iterator<CasingPoint> it = this.casing.iterator();
            while (it.hasNext()) {
                it.next().writeDEX(out, eol, units);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeXML(BufferedWriter out, int ind, char units) throws IOException {
        List<CasingPoint> list = this.casing;
        synchronized (list) {
            Iterator<CasingPoint> it = this.casing.iterator();
            while (it.hasNext()) {
                it.next().writeXML(out, ind, units);
            }
        }
    }
}

