/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import model2_1.Audit;
import model2_1.Casing;
import model2_1.DEXFile;
import model2_1.SBdb;
import org.jdom2.Element;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SortEntry;
import util.status.SbugsStatus;

public class CasingPoint
implements SbugsStatus,
SortEntry {
    CasingPoint link = null;
    private double depth;
    private String diameter = "";
    private Audit audit = new Audit();
    Color status = SbugsStatus.UNKNOWN;

    public CasingPoint(double depth, String diameter) {
        this.depth = depth;
        this.setDiameter(diameter);
        this.status = NOTSTORED;
    }

    public CasingPoint(CasingPoint rhs) {
        this.copy(rhs);
    }

    CasingPoint(SBdb SB2, SBdb wsDB, int wellID, CasingPoint ws) throws SQLException, SBException {
        this.copy(ws);
        this.audit = new Audit(SB2, wsDB, ws.audit);
        this.status = ws.status;
        this.store(SB2, wellID);
        ws.link = this;
    }

    public String getSortEntry() {
        String entry = "" + (int)(this.depth * 100.0);
        while (entry.length() < 7) {
            entry = " " + entry;
        }
        return entry;
    }

    CasingPoint(DEXFile.DEXsection section) throws SBException {
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            if (label.equalsIgnoreCase("Diameter")) {
                this.setDiameter(value);
                continue;
            }
            if (!label.equalsIgnoreCase("Depth")) continue;
            this.depth = DepthUtils.parseDepthString((String)value);
        }
    }

    public CasingPoint(SBdb v2sbdb, int wellID, double depth, String diameter) throws SQLException {
        this.depth = depth;
        this.setDiameter(diameter);
        this.status = NOTSTORED;
        this.audit.created = this.audit.modified = new Date();
        this.audit.creator = this.audit.modifier = v2sbdb.getUser().getUsrID();
        this.store(v2sbdb, wellID);
    }

    public void copy(CasingPoint rhs) {
        this.depth = rhs.depth;
        this.diameter = rhs.diameter;
    }

    public double getDepth() {
        return this.depth;
    }

    public String getDiameter() {
        return this.diameter;
    }

    public String toString() {
        if (!this.diameter.endsWith("in") && !this.diameter.endsWith("\"")) {
            return this.diameter + "in";
        }
        return this.diameter;
    }

    public String statusString() {
        return this.toString();
    }

    public Color getDbStatus() {
        return this.link != null ? this.link.status : null;
    }

    public String dbStatusString() {
        return this.link != null ? this.link.statusString() : null;
    }

    public Color getStatus() {
        return this.status;
    }

    public void store(SBdb SB2, int wellID) throws SQLException {
        if (this.status == NOTSTORED) {
            String diamString = this.diameter;
            if (diamString.endsWith("in")) {
                diamString = diamString.substring(0, diamString.length() - 2);
            }
            if (diamString.endsWith("\"")) {
                diamString = diamString.substring(0, diamString.length() - 1);
            }
            try (Statement stmt = SB2.getDatabase().createStatement();){
                String sql = "INSERT INTO " + SB2.DBTableName("CASING") + " (well_id,depth,diam," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + this.depth + "," + SB.DBString((String)diamString) + "," + this.audit.sqlInsert(SB2, stmt) + ")";
                stmt.executeUpdate(SB2.modQuery(sql));
            }
            this.status = STORED;
        }
    }

    public void delete(SBdb SB2, int wellID) throws SQLException {
        String sql = "DELETE FROM " + SB2.DBTableName("CASING") + " WHERE well_id=" + wellID + " AND depth > " + (this.depth - 0.01) + " AND depth < " + (this.depth + 0.01);
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        this.status = NOTSTORED;
        stmt.close();
    }

    public void updateStatus(Casing oldData) {
        int nzD = (int)(this.depth * 100.0);
        this.status = NOTSTORED;
        for (int i = 0; i < oldData.getSize(); ++i) {
            int cD;
            CasingPoint casingPoint = oldData.getCasingPoint(i);
            if (casingPoint == this || (cD = (int)(casingPoint.depth * 100.0)) != nzD) continue;
            this.status = STORED;
            if (this.diameter.equalsIgnoreCase(casingPoint.diameter)) continue;
            this.status = CONFLICT;
            break;
        }
    }

    private void setDiameter(String diam) {
        if (diam != null) {
            this.diameter = (diam = diam.trim().toLowerCase()).endsWith("in") ? diam.substring(0, diam.length() - 2) : (diam.endsWith("\"") ? diam.substring(0, diam.length() - 1) : diam);
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        out.write("[CASING " + SB.getDepthString((double)this.depth, (char)units, (int)2).trim() + "]" + eol);
        out.write("Depth = " + SB.getDepthString((double)this.depth, (char)units, (int)2) + eol);
        out.write("Diameter = " + this.diameter);
        if (this.diameter.indexOf("in") < 0 && this.diameter.indexOf("\"") < 0) {
            out.write("in");
        }
        out.write(eol + eol);
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        out.write("<CasingPoint Depth=\"" + SB.getDepthString((double)this.depth, (char)units, (int)2).trim() + "\">\n");
        if (SB.getDepthString((double)this.depth, (char)units, (int)2) != null && SB.getDepthString((double)this.depth, (char)units, (int)2).length() > 0) {
            out.write((String)ind + "<Depth>" + SB.getDepthString((double)this.depth, (char)units, (int)2) + "</Depth>\n");
        }
        if (this.diameter != null && this.diameter.length() > 0) {
            out.write((String)ind + "<Diameter>" + this.diameter);
            if (this.diameter.indexOf("in") < 0 && this.diameter.indexOf("\"") < 0) {
                out.write("in");
            }
            out.write("</Diameter>\n");
        }
        out.write("</CasingPoint>\n");
    }

    CasingPoint(SBdb db, Element xml) throws SBException {
        String strg = xml.getChildTextNormalize("Diameter");
        if (strg != null) {
            this.setDiameter(strg);
        }
        if ((strg = xml.getChildTextNormalize("Depth")) != null) {
            this.depth = DepthUtils.parseDepthString((String)strg);
        }
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }
}

