/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model2_1.Audit;
import model2_1.Curve;
import model2_1.SBdb;
import model2_1.Well;
import util.SBException;

public class Curves
extends Observable {
    private final List<Curve> list = new LinkedList<Curve>();

    public Curves(SBdb db, Well well) throws SQLException {
        this.load(db, well.getWellID());
    }

    private void load(SBdb db, int wellID) throws SQLException {
        if (db.isConnected()) {
            System.out.println("Loading wireline log curves for well: " + wellID);
            String sql = "SELECT curve_id, abr, curve_mnem, filename, comments, " + Audit.sqlFieldString() + " FROM " + db.DBTableName("LOG_CURVE") + " WHERE well_id=" + wellID;
            try (Statement stmt = db.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(db.modQuery(sql));
                while (rs.next()) {
                    int curveID = rs.getInt("curve_id");
                    String abr = rs.getString("abr");
                    String curveMnem = rs.getString("curve_mnem");
                    String fileName = rs.getString("filename");
                    String comments = rs.getString("comments");
                    Audit audit = new Audit(rs);
                    this.list.add(new Curve(db, curveID, abr, curveMnem, fileName, comments, audit));
                }
            }
        }
    }

    public List<Curve> getCurves() {
        return this.list;
    }

    public int getSize() {
        return this.list.size();
    }

    void add(SBdb db, int wellID, Curve curve) throws SQLException, SBException {
        if (db.isConnected()) {
            curve.store(db, wellID);
        } else assert (curve.getID() > 0);
        this.list.add(curve);
        this.setChanged();
    }

    void delete(SBdb db, Collection<Curve> curves) throws SQLException {
        for (Curve curve : curves) {
            if (!this.list.contains(curve)) {
                throw new IllegalArgumentException("Attempt to delete curve from wrong well");
            }
            if (!db.isConnected()) continue;
            curve.delete(db);
        }
        this.list.removeAll(curves);
        this.setChanged();
    }

    public boolean checkOverlap(Curve curve) {
        boolean overlap = false;
        double topDepth = curve.getTopDepth();
        double baseDepth = curve.getBaseDepth();
        for (Curve c : this.list) {
            if (!c.getAbr().equals(curve.getAbr()) || !(c.getTopDepth() >= topDepth && c.getTopDepth() <= baseDepth) && (!(c.getBaseDepth() >= topDepth) || !(c.getBaseDepth() <= baseDepth))) continue;
            overlap = true;
            break;
        }
        return overlap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(SBdb db, Statement stmt, int wellID) throws SQLException, SBException {
        Object sql = "SELECT curve_id,updated ";
        sql = (String)sql + " FROM " + db.DBTableName("LOG_CURVE") + " WHERE well_id=" + wellID;
        sql = db.modQuery((String)sql);
        ResultSet rs = stmt.executeQuery((String)sql);
        Curve notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        boolean reload = false;
        List<Curve> list = this.list;
        synchronized (list) {
            while (rs.next()) {
                int key = rs.getInt("curve_id");
                keys.add(key);
                Timestamp time = rs.getTimestamp("updated");
                boolean found = false;
                for (Curve o : this.list) {
                    if (o.getID() != key) continue;
                    found = true;
                    if (time == null || !time.after(o.getUpdated())) break;
                    reload = true;
                    notifier = o;
                    break;
                }
                if (found) continue;
                reload = true;
                break;
            }
        }
        if (reload || keys.size() < this.list.size()) {
            if (notifier == null) {
                list = this.list;
                synchronized (list) {
                    notifier = this.list.get(0);
                }
            }
            this.list.clear();
            this.load(db, wellID);
            this.setChanged();
            if (notifier == null) {
                list = this.list;
                synchronized (list) {
                    notifier = this.list.get(0);
                }
            }
            this.notifyObservers(notifier);
        }
    }
}

