/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import model2_1.AbnScheme;
import model2_1.Audit;
import model2_1.Biocom;
import model2_1.CasingPoint;
import model2_1.CompositeStandard;
import model2_1.CoredInterval;
import model2_1.EnvScheme;
import model2_1.Genus;
import model2_1.IGDInterval;
import model2_1.IGDIntervalEnv;
import model2_1.IGDIntervalZone;
import model2_1.IGDScheme;
import model2_1.IGDUnit;
import model2_1.Licence;
import model2_1.LithInterval;
import model2_1.LithQualifier;
import model2_1.Lithdesc;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SeismicMarker;
import model2_1.Smpdtl;
import model2_1.Surface;
import model2_1.TVDepth;
import model2_1.TWTDepth;
import model2_1.Taxon;
import model2_1.TaxonCompareGenus;
import model2_1.TaxonCompareSpecies;
import model2_1.TaxonOcc;
import model2_1.TxGroup;
import model2_1.Userdef;
import model2_1.Well;
import model2_1.WellEvent;
import model2_1.WellInterp;
import model2_1.WsWell;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.status.SbugsStatus;

public final class DEXFile {
    Set dataTypes;
    String dataSource;
    static final int WELL = 1;
    static final int TaxonOcc = 2;
    WsWell well = null;
    List events;
    List sections = new LinkedList();
    boolean setWellHeaderUnits = false;
    SBdb ws;
    Lithdesc lithdesc = null;
    static SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
    String eol = "\r\n";
    boolean askedSequenceMFS = false;
    boolean useSequenceMFS = false;
    HashMap<Integer, Sample> duplicateSamples = new HashMap();

    public DEXFile(SBdb ws, Userdef dbDefaultUser, String filePath, Set dataTypes, Lithdesc lithdesc, int interpID) throws SBException, FileNotFoundException, IOException, SQLException, InvalidFieldException {
        this.ws = ws;
        this.dataTypes = dataTypes;
        this.lithdesc = lithdesc;
        try (BufferedReader in = new BufferedReader(new FileReader(filePath));){
            Userdef defaultUser = Userdef.copyToWorkspace(ws, dbDefaultUser);
            defaultUser.setLink(null);
            String buff = in.readLine();
            if (buff == null) {
                throw new SBException("The selected file contains no data");
            }
            DEXsection section2 = new DEXsection();
            boolean eofIncluded = false;
            while ((buff = DEXFile.readSection(section2, buff, in)) != null) {
                if (buff.toUpperCase().indexOf("[END OF FILE]") >= 0) {
                    eofIncluded = true;
                }
                this.sections.add(section2);
                section2 = new DEXsection();
            }
            if (!eofIncluded && section2.value.size() > 0) {
                this.sections.add(section2);
            }
            if (this.sections.isEmpty()) {
                throw new SBException("There are no DEX data in the file");
            }
            if (!eofIncluded) {
                JOptionPane.showMessageDialog(null, "Warning: No end of file marker found - file may be incomplete", "DEX", 2);
            }
            if (ws.getnLoadedWells() == 0) {
                dataTypes.clear();
            }
            ws.setUser(defaultUser);
            for (DEXsection section2 : this.sections) {
                if (section2.type.startsWith("ABUNDANCE FORMAT")) {
                    this.parseAbnScheme(section2);
                    continue;
                }
                if (section2.type.startsWith("SPECIES LIST")) {
                    StringBuffer groupName = new StringBuffer();
                    LinkedList<Taxon> groupTaxa = new LinkedList<Taxon>();
                    DEXFile.parseTaxa(ws, section2, groupName, groupTaxa);
                    if (groupName.length() <= 0) continue;
                    TxGroup group = ws.addTxGroup(groupName.toString(), "", 1, 0);
                    group.addTaxa(groupTaxa);
                    continue;
                }
                if (section2.type.startsWith("EVENT LIST")) {
                    this.parseEvents(section2);
                    continue;
                }
                if (section2.type.startsWith("COMPOSITE STANDARD")) {
                    this.parseCompositeStandard(section2);
                    continue;
                }
                if (section2.type.startsWith("PALAEOENVIRONMENT SCHEME")) {
                    this.parseEnvScheme(section2);
                    continue;
                }
                if (section2.type.endsWith("SCHEME")) {
                    ws.addIGDScheme(this.parseScheme(section2));
                    continue;
                }
                if (section2.type.startsWith("GROUP SET")) {
                    this.parseSet(section2);
                    continue;
                }
                if (!section2.type.startsWith("SPECIES GROUP")) continue;
                this.parseGroup(section2);
            }
            Iterator it = this.sections.iterator();
            boolean parseWarning = false;
            int[] wellAbn = new int[4];
            System.out.println();
            while (it.hasNext()) {
                try {
                    section2 = (DEXsection)it.next();
                    if (section2.type.startsWith("HEADER")) {
                        if (this.well != null) {
                            this.well.updateStatus(dataTypes);
                        }
                        this.well = ws.addWellToWorkspace(0, filePath);
                        this.duplicateSamples.clear();
                        for (int i = 0; i < wellAbn.length; ++i) {
                            wellAbn[i] = 0;
                        }
                        this.parseWellHeader(section2, this.well, wellAbn);
                        System.out.println("Adding well: " + this.well);
                        this.well.loadInterps();
                        this.well.getAddInterp(ws.getInterp(0)).load(this.well);
                        parseWarning = false;
                        continue;
                    }
                    if (section2.type.startsWith("SAMPLE")) {
                        Sample sample = this.parseSample(section2, wellAbn);
                        if (this.well.getType() != 'O' || !(sample.getDepth() < this.well.getHeader().getKicko())) continue;
                        this.well.getHeader().setKicko(sample.getDepth());
                        continue;
                    }
                    if (section2.type.startsWith("INTERVAL")) {
                        this.parseInterval(section2, this.well, interpID);
                        parseWarning = false;
                        continue;
                    }
                    if (section2.type.startsWith("BIOSTRATIGRAPHIC COMMENT")) {
                        this.parseBiocom(section2, this.well);
                        parseWarning = false;
                        continue;
                    }
                    if (section2.type.startsWith("CORE")) {
                        this.parseCore(section2, this.well);
                        parseWarning = false;
                        continue;
                    }
                    if (section2.type.startsWith("CASING")) {
                        this.parseCasing(section2, this.well);
                        parseWarning = false;
                        continue;
                    }
                    if (section2.type.startsWith("MARKER")) {
                        this.parseMarker(section2, this.well);
                        parseWarning = false;
                        continue;
                    }
                    if (section2.type.startsWith("TVD")) {
                        this.parseTVD(section2, this.well);
                        parseWarning = false;
                        continue;
                    }
                    if (section2.type.startsWith("TWT")) {
                        this.parseTWT(section2, this.well);
                        parseWarning = false;
                        continue;
                    }
                    if (!section2.type.equals("EVENT")) continue;
                    this.parseEvent(section2, this.well);
                    parseWarning = false;
                }
                catch (IllegalStateException | SBException eio) {
                    if (parseWarning) continue;
                    eio.printStackTrace();
                    int option = JOptionPane.showConfirmDialog(null, "Error while processing section: " + section2.type + "\n'" + eio.getMessage() + "'\nIgnore errors like these?", "DEX Reader", 1);
                    if (option == 2) break;
                    if (option != 0) continue;
                    parseWarning = true;
                }
            }
            HashSet<Taxon> reassigned = new HashSet<Taxon>();
            Iterator<Well> wellIt = ws.getWellIterator();
            while (wellIt.hasNext()) {
                Well w = wellIt.next();
                for (Sample s : w.getSamples()) {
                    for (Smpdtl dtl : s.getAnalyses()) {
                        for (TaxonOcc occ : dtl.getOccurUnsorted()) {
                            if (occ.getSpecType() <= 0 || !occ.getTaxon().getSubSpecies().endsWith(occ.getSpecTypeString())) continue;
                            Taxon.Builder builder = Taxon.Builder.copyOf(occ.getTaxon());
                            builder.subSpecies(occ.getTaxon().getSubSpecies().substring(0, occ.getTaxon().getSubSpecies().indexOf(occ.getSpecTypeString())));
                            builder.genus(occ.getTaxon().getGenus());
                            reassigned.add(occ.getTaxon());
                            occ.setTaxon(ws.getTaxon(builder));
                        }
                    }
                }
            }
            if (!reassigned.isEmpty()) {
                Iterator taxonIt = reassigned.iterator();
                Taxon taxon = (Taxon)taxonIt.next();
                block15: while (taxonIt.hasNext()) {
                    wellIt = ws.getWellIterator();
                    while (wellIt.hasNext()) {
                        Well w = wellIt.next();
                        for (Sample s : w.getSamples()) {
                            for (Smpdtl dtl : s.getAnalyses()) {
                                for (TaxonOcc occ : dtl.getOccurUnsorted()) {
                                    if (occ.getTaxon() != taxon) continue;
                                    taxonIt.remove();
                                    break block15;
                                }
                            }
                        }
                    }
                    taxon = (Taxon)taxonIt.next();
                }
                for (Taxon toRemove : reassigned) {
                    ws.removeTaxon(toRemove);
                }
            }
            if (this.well != null) {
                this.well.updateStatus(dataTypes);
            }
        }
    }

    static String readSection(DEXsection section, String buff, BufferedReader in) throws IOException, SBException {
        while (buff.length() == 0) {
            buff = in.readLine();
            buff = buff.trim();
        }
        if (!buff.substring(0, 1).equals("[")) {
            throw new SBException("Error reading line :" + buff);
        }
        section.type = buff.substring(1, buff.lastIndexOf(93)).toUpperCase();
        char[] sepChar = new char[]{'=', ':'};
        buff = in.readLine();
        while (buff != null) {
            if ((buff = buff.trim()).length() > 0) {
                if (buff.charAt(0) == '[') break;
                int sepCharIndex = buff.length();
                for (int i = 0; i < sepChar.length; ++i) {
                    int index = buff.indexOf(sepChar[i]);
                    if (index >= sepCharIndex || index <= 0) continue;
                    sepCharIndex = index;
                }
                if (sepCharIndex < buff.length() && sepCharIndex > 0) {
                    String label = buff.substring(0, sepCharIndex).trim();
                    String value = buff.substring(sepCharIndex + 1).trim();
                    section.label.add(label);
                    section.value.add(value);
                    section.sepChar.add(Character.valueOf(buff.charAt(sepCharIndex)));
                }
            }
            buff = in.readLine();
        }
        return buff;
    }

    void parseSet(DEXsection section) throws SQLException, SBException {
        String setName = "";
        String groupName = null;
        LinkedHashSet<Integer> groups = new LinkedHashSet<Integer>();
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            if (label.equalsIgnoreCase("Name")) {
                setName = value;
                continue;
            }
            if (label.equalsIgnoreCase("Group")) {
                groupName = value;
                continue;
            }
            if (!label.equalsIgnoreCase("ID")) continue;
            int groupID = Integer.parseInt(value);
            groups.add(groupID);
        }
        try {
            this.ws.addTxGroupSet(setName, (String)null, 0, groups, false);
        }
        catch (SBPermissionException pe) {
            throw new SBException(pe.getMessage());
        }
    }

    void parseGroup(DEXsection section) throws SBException, SQLException {
        String name = null;
        String abr = null;
        Color colour = null;
        int groupID = 0;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            if (label.equalsIgnoreCase("Name")) {
                name = value;
                continue;
            }
            if (label.equalsIgnoreCase("Group ID")) {
                groupID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Abbrevation")) {
                abr = value;
                continue;
            }
            if (!label.equalsIgnoreCase("Colour")) continue;
            StringTokenizer tok = new StringTokenizer(value, ",");
            int red = Integer.parseInt(tok.nextToken());
            int green = Integer.parseInt(tok.nextToken());
            int blue = Integer.parseInt(tok.nextToken());
            colour = new Color((char)red, (char)green, (char)blue);
        }
        StringBuffer groupName = new StringBuffer(50);
        LinkedList<Taxon> taxa = new LinkedList<Taxon>();
        DEXFile.parseTaxa(this.ws, section, groupName, taxa);
        try {
            TxGroup group = this.ws.addTxGroup(name, abr, groupID, 0);
            group.setColour(colour);
            group.addTaxa(taxa);
        }
        catch (SBPermissionException e) {
            throw new SBException(e.getMessage());
        }
    }

    final IGDScheme parseScheme(DEXsection section) throws SBException, SQLException {
        return IGDScheme.parseDEX(section, this.ws);
    }

    final void parseEvent(DEXsection section, Well well) throws SQLException, SBException {
        WellEvent event = WellEvent.parse(section, this.ws, well).build(this.ws);
        event.status = WellEvent.NOTSTORED;
        WellInterp wellInterp = well.getInterp(0);
        wellInterp.insertEvent(event);
    }

    final void parseInterval(DEXsection section, Well well, int interpID) throws SBException, SQLException, InvalidFieldException {
        int igdType = 0;
        int qType = 0;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("Type")) {
                igdType = IGDInterval.getIGDType(value);
                break;
            }
            if (label.equalsIgnoreCase("Palaeoenvironment") || label.equalsIgnoreCase("Palaeoenvironments")) {
                igdType = 5;
                break;
            }
            if (label.equalsIgnoreCase("Biozone data")) {
                igdType = 4;
                break;
            }
            if (label.equalsIgnoreCase("Interval Lithology")) {
                igdType = 12;
                break;
            }
            if (label.equalsIgnoreCase("Lithology Qualifier")) {
                igdType = 13;
                qType = 81;
                break;
            }
            if (label.equalsIgnoreCase("Lithology Accessory")) {
                igdType = 13;
                qType = 65;
                break;
            }
            if (!label.equalsIgnoreCase("Lithology Stringer")) continue;
            igdType = 13;
            qType = 83;
            break;
        }
        switch (igdType) {
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                this.parseIGDInterval(section, well, interpID);
                break;
            }
            case 12: {
                this.parseLithInterval(section, well);
                break;
            }
            case 13: {
                this.parseLithQualifier(section, well, (char)qType);
                break;
            }
            case 5: {
                this.parseIGDEnv(section, well, interpID);
                break;
            }
            default: {
                throw new SBException("Cannot process interval: " + section.type);
            }
        }
    }

    final void parseBiocom(DEXsection section, Well well) throws SBException, SQLException {
        Biocom biocom = Biocom.parseDEX(section, this.ws, well, this.duplicateSamples);
        if (biocom != null) {
            biocom.status = Biocom.NOTSTORED;
            well.getInterp(0).insertBiocom(biocom);
            this.addDataType(SBdb.did2comType(biocom.getDiscID()));
        }
    }

    final void parseCore(DEXsection section, Well well) throws SBException, SQLException {
        CoredInterval core = new CoredInterval(well, section);
        core.status = CoredInterval.NOTSTORED;
        well.getCores().add(core);
        this.addDataType(19);
    }

    final void parseCasing(DEXsection section, Well well) throws SBException, SQLException {
        CasingPoint casingPoint = new CasingPoint(section);
        casingPoint.status = CasingPoint.NOTSTORED;
        well.getCasing().add(casingPoint);
        this.addDataType(20);
    }

    final void parseMarker(DEXsection section, Well well) throws SBException, SQLException {
        SeismicMarker marker = new SeismicMarker(section);
        marker.status = SeismicMarker.NOTSTORED;
        well.getMarkers().add(marker);
        this.addDataType(24);
    }

    final void parseTVD(DEXsection section, Well well) throws SBException, SQLException {
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            if (!label.equalsIgnoreCase("Depth/TVD") || value.indexOf(58) <= 0) continue;
            double depth = DepthUtils.parseDepthString((String)value.substring(0, value.indexOf(58) - 1));
            double tvd = DepthUtils.parseDepthString((String)value.substring(value.indexOf(58) + 1));
            well.getTVDlist(false).add(new TVDepth(depth, tvd));
        }
        this.addDataType(25);
    }

    final void parseTWT(DEXsection section, Well well) throws SBException, SQLException {
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            if (!label.equalsIgnoreCase("Depth/TWT") || value.indexOf(58) <= 0) continue;
            double depth = DepthUtils.parseDepthString((String)value.substring(0, value.indexOf(58) - 1));
            double twt = Float.parseFloat(value.substring(value.indexOf(58) + 1));
            well.getTWTlist().add(new TWTDepth(depth, twt));
        }
        this.addDataType(26);
    }

    void parseLithQualifier(DEXsection section, Well well, char qType) throws SBException, SQLException {
        LithQualifier lithQual = new LithQualifier(this.ws);
        lithQual.qType = qType;
        int lithCode = 0;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("Top Depth")) {
                lithQual.topDepth = DepthUtils.parseDepthString((String)value);
                continue;
            }
            if (label.equalsIgnoreCase("Dictionary ID")) {
                lithCode = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Plot position")) {
                lithQual.xPlotPos = Float.parseFloat(value);
                continue;
            }
            if (label.equalsIgnoreCase("Alignment")) {
                lithQual.alignment = value.charAt(0);
                continue;
            }
            if (!label.equalsIgnoreCase("Width")) continue;
            lithQual.xPlotPos = Float.parseFloat(value);
        }
        if (lithCode > 0) {
            lithQual.desc = this.lithdesc.getLithology(lithCode);
            well.insertLithInterval(lithQual);
            this.addDataType(21);
        }
    }

    void parseLithInterval(DEXsection section, Well well) throws SBException, SQLException {
        LithInterval lithInt = new LithInterval(this.ws);
        int lithCode = 0;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("Top Depth")) {
                lithInt.topDepth = DepthUtils.parseDepthString((String)value);
                continue;
            }
            if (label.equalsIgnoreCase("Base Depth")) {
                lithInt.baseDepth = DepthUtils.parseDepthString((String)value);
                continue;
            }
            if (!label.equalsIgnoreCase("Dictionary ID")) continue;
            lithCode = Integer.parseInt(value);
        }
        if (lithCode > 0) {
            lithInt.desc = this.lithdesc.getLithology(lithCode);
            well.insertLithInterval(lithInt);
            this.addDataType(21);
        }
    }

    void parseIGDInterval(DEXsection section, Well well, int interpID) throws SBException, SQLException, InvalidFieldException {
        IGDIntervalZone zone = new IGDIntervalZone(this.ws, section, well, this.duplicateSamples);
        if (zone.igdType == 10) {
            try {
                this.parseSQPicks(section, well, interpID);
            }
            catch (SBPermissionException ex) {
                throw new SBException("Unexpected permission exception parsing SQPicks", (Throwable)ex);
            }
        } else {
            if (zone.getSchID() == 0) {
                String unassignedSchemeName = IGDInterval.getIGDName(zone.igdType) + " (undefined)";
                IGDScheme scheme = this.ws.getIGDScheme(unassignedSchemeName, zone.igdType);
                if (scheme == null) {
                    scheme = this.ws.addIGDScheme(zone.igdType, unassignedSchemeName);
                }
                zone.setSchID(scheme.getSchID());
            }
            well.getInterp(interpID).insertZone(zone);
            this.addDataType(IGDInterval.igdType2dType(zone.igdType));
        }
    }

    void parseSQPicks(DEXsection section, Well well, int interpID) throws SBException, SQLException, InvalidFieldException, SBPermissionException {
        String surfaceName;
        IGDUnit unit;
        Surface surface;
        Sample topSample;
        int topID = 0;
        int baseID = 0;
        int mfsID = 0;
        int tsID = 0;
        int schID = 0;
        int topBnd = 4;
        int baseBnd = 4;
        String uppInf = "";
        String lowInf = "";
        int uppZone = 0;
        int lowZone = 0;
        boolean qUzone = false;
        boolean qLzone = false;
        Audit audit = new Audit();
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("Top sample ID")) {
                topID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Base sample ID")) {
                baseID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Scheme ID")) {
                schID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Upper boundary")) {
                topBnd = IGDIntervalZone.getBoundaryTypeFromString(value);
                continue;
            }
            if (label.equalsIgnoreCase("Lower boundary")) {
                baseBnd = IGDIntervalZone.getBoundaryTypeFromString(value);
                continue;
            }
            if (label.equalsIgnoreCase("Upper unit")) {
                if (uppInf.length() != 0) continue;
                uppInf = value;
                continue;
            }
            if (label.equalsIgnoreCase("Upper dictionary ID")) {
                uppZone = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Lower unit")) {
                if (lowInf.length() != 0) continue;
                lowInf = value;
                continue;
            }
            if (label.equalsIgnoreCase("Lower dictionary ID")) {
                lowZone = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Upper informal unit")) {
                uppInf = value;
                continue;
            }
            if (label.equalsIgnoreCase("Lower informal unit")) {
                lowInf = value;
                continue;
            }
            if (label.equalsIgnoreCase("Upper questionable")) {
                qUzone = value.equalsIgnoreCase("YES");
                continue;
            }
            if (label.equalsIgnoreCase("Lower questionable")) {
                qLzone = value.equalsIgnoreCase("YES");
                continue;
            }
            if (label.equalsIgnoreCase("Maximum Flooding Surface ID")) {
                mfsID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Transgressive Surface ID")) {
                tsID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Modified")) {
                try {
                    audit.modified = SB.df.parse(value);
                }
                catch (ParseException ex) {
                    audit.modified = new Date();
                }
                audit.created = audit.modified;
                continue;
            }
            if (!label.equalsIgnoreCase("Modifier")) continue;
            audit.modifier = this.ws.getUser(value) == null ? this.ws.getAddUserID(value) : this.ws.getUser(value).getUsrID();
            audit.creator = audit.modifier;
        }
        IGDScheme scheme = this.ws.getIGDScheme(schID);
        if (scheme == null) {
            scheme = this.ws.getIGDScheme("Sequences", 10);
            if (scheme == null) {
                scheme = this.ws.addIGDScheme(10, "Sequences");
            }
            scheme.loadUnits();
        }
        well.getInterp(interpID).getSQPicks();
        Surface.SurfaceType defaultSurfaceType = Surface.SurfaceType.SB;
        if (mfsID == 0) {
            if (!this.askedSequenceMFS) {
                int opt = JOptionPane.showConfirmDialog(null, "Assume sequences are bounded by Maximum Flooding Surfaces (MFSs)?\nPress 'Yes' for Galloway, press 'No' for Vail.", "DEX Sequences", 0, 3);
                if (opt == 0) {
                    this.useSequenceMFS = true;
                }
                this.askedSequenceMFS = true;
            }
            if (this.useSequenceMFS) {
                defaultSurfaceType = Surface.SurfaceType.MFS;
            }
        } else {
            this.askedSequenceMFS = true;
        }
        if ((topSample = well.getSample(topID)) == null) {
            topSample = this.duplicateSamples.get(topID);
        }
        if (topSample == null) {
            System.out.println("Top sample (ID=" + topID + ") null for interval: " + this + " in well: " + well);
        } else if (well.getInterp(interpID).getSQPick(topSample) == null) {
            Surface surface2 = null;
            IGDUnit unit2 = null;
            String surfaceName2 = uppInf + " " + defaultSurfaceType.name();
            if (uppZone > 0 && (unit2 = scheme.findUnit(uppZone)) != null) {
                surfaceName2 = unit2.getName() + " " + defaultSurfaceType.name();
            }
            if ((surface2 = scheme.getSurface(surfaceName2, defaultSurfaceType)) == null) {
                try {
                    surface2 = scheme.addSurface(new Surface.Builder(scheme.getDatabase()).name(surfaceName2).type(Surface.SurfaceType.parseType(surfaceName2, Surface.SurfaceType.SB)));
                }
                catch (InvalidFieldException e) {
                    e.printStackTrace();
                }
            }
            well.getInterp(interpID).addSQPick(well, topSample, surface2, uppInf, qUzone, topBnd);
        }
        Sample baseSample = well.getSample(baseID);
        if (baseSample == null) {
            baseSample = this.duplicateSamples.get(baseID);
        }
        if (baseSample == null) {
            System.out.println("Base sample (ID=" + baseID + ") null for interval: " + this + " in well: " + well);
        } else if (baseSample != topSample && well.getInterp(interpID).getSQPick(baseSample) == null) {
            Surface surface3 = null;
            IGDUnit unit3 = null;
            String surfaceName3 = (lowInf.length() > 0 ? lowInf : uppInf) + " " + defaultSurfaceType.name();
            if (uppZone > 0 && (unit3 = lowZone > 0 ? scheme.findUnit(lowZone) : scheme.findUnit(uppZone)) != null) {
                surfaceName3 = unit3.getName() + " " + defaultSurfaceType.name();
            }
            if ((surface3 = scheme.getSurface(surfaceName3, defaultSurfaceType)) == null) {
                try {
                    surface3 = scheme.addSurface(new Surface.Builder(scheme.getDatabase()).name(surfaceName3).type(Surface.SurfaceType.parseType(surfaceName3, Surface.SurfaceType.SB)));
                }
                catch (InvalidFieldException e) {
                    e.printStackTrace();
                }
            }
            well.getInterp(interpID).addSQPick(well, baseSample, surface3, lowInf, qLzone, baseBnd);
        }
        if (mfsID > 0) {
            Sample mfsSample = well.getSample(mfsID);
            if (mfsSample == null) {
                mfsSample = this.duplicateSamples.get(mfsID);
            }
            if (mfsSample == null) {
                System.out.println("MFS sample (ID=" + mfsID + ") null for interval: " + this + " in well: " + well);
            } else if (well.getInterp(interpID).getSQPick(mfsSample) == null) {
                surface = null;
                unit = null;
                surfaceName = uppInf + " MFS";
                if (uppZone > 0 && (unit = scheme.findUnit(uppZone)) != null) {
                    surfaceName = unit.getName() + " MFS";
                }
                if ((surface = scheme.getSurface(surfaceName, Surface.SurfaceType.MFS)) == null) {
                    try {
                        surface = scheme.addSurface(new Surface.Builder(scheme.getDatabase()).name(surfaceName).type(Surface.SurfaceType.parseType(surfaceName, Surface.SurfaceType.SB)));
                    }
                    catch (InvalidFieldException e) {
                        e.printStackTrace();
                    }
                }
                well.getInterp(interpID).addSQPick(well, mfsSample, surface, uppInf, qUzone, 3);
            }
        }
        if (tsID > 0) {
            Sample tsSample = well.getSample(tsID);
            if (tsSample == null) {
                tsSample = this.duplicateSamples.get(tsID);
            }
            if (tsSample == null) {
                System.out.println("TS sample (ID=" + tsID + ") null for interval: " + this + " in well: " + well);
            } else if (well.getInterp(interpID).getSQPick(tsSample) == null) {
                surface = null;
                unit = null;
                surfaceName = (lowInf.length() > 0 ? lowInf : uppInf) + " TS";
                if (uppZone > 0 && (unit = lowZone > 0 ? scheme.findUnit(lowZone) : scheme.findUnit(uppZone)) != null) {
                    surfaceName = unit.getName() + " TS";
                }
                if ((surface = scheme.getSurface(surfaceName, Surface.SurfaceType.TS)) == null) {
                    try {
                        surface = scheme.addSurface(new Surface.Builder(scheme.getDatabase()).name(surfaceName).type(Surface.SurfaceType.parseType(surfaceName, Surface.SurfaceType.TS)));
                    }
                    catch (InvalidFieldException e) {
                        e.printStackTrace();
                    }
                }
                well.getInterp(interpID).addSQPick(well, tsSample, surface, lowInf, qUzone, 2);
            }
        }
        this.addDataType(14);
    }

    final void parseIGDEnv(DEXsection section, Well well, int interpID) throws SBException, SQLException {
        IGDIntervalEnv zone = IGDIntervalEnv.parse(section, this.ws, well, this.duplicateSamples);
        zone.status = SbugsStatus.NOTSTORED;
        well.getInterp(interpID).insertEnv(zone);
        this.addDataType(IGDInterval.igdType2dType(5));
    }

    final Sample parseSample(DEXsection section, int[] wellAbn) throws SBException, SQLException {
        Sample sample = Sample.parseSample(this.ws, this.lithdesc, section, this.well.getType(), this.well, this.dataTypes, wellAbn, !this.setWellHeaderUnits, this.duplicateSamples);
        this.addDataType(1);
        return sample;
    }

    final void parseWellHeader(DEXsection section, Well well, int[] wellAbn) throws SBException {
        this.setWellHeaderUnits = well.getHeader().parseDEX(section, wellAbn);
    }

    private void parseAbnScheme(DEXsection section) throws SBException, SQLException {
        AbnScheme abn = null;
        int val = 0;
        int oVal = 0;
        String abnAbr = null;
        String abnText = null;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            if (label.equalsIgnoreCase("Scheme ID")) {
                if (abnAbr != null && !abnAbr.equals("+")) {
                    if (abn == null) {
                        throw new SBException("Abundance scheme ID missing");
                    }
                    try {
                        abn.addClass(abnAbr, abnText, val, oVal);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, e.getMessage());
                        e.printStackTrace();
                    }
                    abnAbr = null;
                    val = 0;
                    oVal = 0;
                    abnText = null;
                }
                abn = new AbnScheme(Integer.parseInt(value));
                System.out.println("In DEX reader, adding abnScheme: " + abn.getName() + " ID = " + abn.getID());
                try {
                    this.ws.addAbnScheme(abn);
                    continue;
                }
                catch (SBPermissionException pe) {
                    throw new SBException("PermissionException parsing AbnScheme: " + pe.getMessage(), (Throwable)pe);
                }
            }
            if (label.equalsIgnoreCase("Scheme name")) {
                if (abn == null) {
                    throw new SBException("Abundance scheme ID missing");
                }
                abn.setName(value);
                continue;
            }
            if (label.equalsIgnoreCase("Number of categories")) continue;
            if (label.equalsIgnoreCase("Category number")) {
                if (abn == null) {
                    throw new SBException("Abundance scheme ID missing");
                }
                if (abnAbr != null && !abnAbr.equals("+")) {
                    try {
                        abn.addClass(abnAbr, abnText, val, oVal);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, e.getMessage());
                        e.printStackTrace();
                    }
                }
                abnAbr = null;
                val = 0;
                oVal = 0;
                abnText = null;
                continue;
            }
            if (label.equalsIgnoreCase("Name")) {
                abnText = value;
                continue;
            }
            if (label.equalsIgnoreCase("Entry")) {
                abnAbr = value;
                continue;
            }
            if (label.equalsIgnoreCase("Low Bound")) {
                val = Integer.parseInt(value);
                continue;
            }
            if (!label.equalsIgnoreCase("Output Value")) continue;
            oVal = Integer.parseInt(value);
        }
        if (abnAbr != null && !abnAbr.equals("+")) {
            if (abn == null) {
                throw new SBException("Abundance scheme ID missing");
            }
            try {
                abn.addClass(abnAbr, abnText, val, oVal);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage());
                e.printStackTrace();
            }
        }
    }

    final void parseEnvScheme(DEXsection section) throws SBException, SQLException {
        EnvScheme scheme = new EnvScheme(section, this.ws);
        try {
            this.ws.addEnvScheme(scheme);
        }
        catch (SBPermissionException ex) {
            throw new SBException("Permission exception adding env scheme to workspace");
        }
    }

    static void parseTaxa(SBdb ws, DEXsection section, StringBuffer groupName, List<Taxon> groupTaxa) throws SBException, SQLException {
        int donorID = 0;
        int numericCode = 0;
        Genus.Builder genBuilder = new Genus.Builder();
        Taxon.Builder txBuilder = new Taxon.Builder();
        String donorString = null;
        String cat_mnem = "";
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("Species") && sepChar == '=') {
                if (donorString != null) {
                    System.out.println("Building: " + donorString);
                    Taxon taxon = ws.addTaxon(txBuilder, genBuilder, cat_mnem, donorID, donorString);
                    if (groupTaxa != null) {
                        groupTaxa.add(taxon);
                    }
                    if (numericCode > 0) {
                        System.out.println("Can't process numeric Code: " + numericCode);
                    }
                }
                donorString = value;
                cat_mnem = "";
                numericCode = 0;
                genBuilder = new Genus.Builder();
                txBuilder = new Taxon.Builder();
                continue;
            }
            if (label.equalsIgnoreCase("Category") || label.equalsIgnoreCase("Code")) {
                cat_mnem = value;
                continue;
            }
            if (label.equalsIgnoreCase("ID")) {
                donorID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Pre-Genus qualifier")) {
                genBuilder.qual(0, value);
                continue;
            }
            if (label.equalsIgnoreCase("Genus")) {
                genBuilder.genusName(value);
                continue;
            }
            if (label.equalsIgnoreCase("Post-Genus qualifier")) {
                genBuilder.qual(1, value);
                continue;
            }
            if (label.equalsIgnoreCase("Pre-Subgenus qualifier")) {
                genBuilder.qual(2, value);
                continue;
            }
            if (label.equalsIgnoreCase("Subgenus")) {
                genBuilder.subGenus(value);
                continue;
            }
            if (label.equalsIgnoreCase("Post-Subgenus qualifier")) {
                genBuilder.qual(3, value);
                continue;
            }
            if (label.equalsIgnoreCase("Pre-Species qualifier")) {
                txBuilder.qual(4, value);
                continue;
            }
            if (label.equalsIgnoreCase("Species")) {
                if (value == null || value.isEmpty()) {
                    value = ".";
                }
                txBuilder.species(value);
                continue;
            }
            if (label.equalsIgnoreCase("Post-Species qualifier")) {
                txBuilder.qual(5, value);
                continue;
            }
            if (label.equalsIgnoreCase("Pre-Subspecies qualifier")) {
                txBuilder.qual(6, value);
                continue;
            }
            if (label.equalsIgnoreCase("Subspecies")) {
                txBuilder.subSpecies(value);
                continue;
            }
            if (label.equalsIgnoreCase("Post-Subspecies qualifier")) {
                txBuilder.qual(7, value);
                continue;
            }
            if (label.equalsIgnoreCase("Author")) {
                txBuilder.author(value);
                continue;
            }
            if (label.equalsIgnoreCase("Year")) {
                txBuilder.year(Integer.parseInt(value));
                continue;
            }
            if (label.equalsIgnoreCase("Code")) {
                numericCode = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Alphanumeric Code")) {
                txBuilder.alphaCode(value);
                continue;
            }
            if (label.equalsIgnoreCase("Numeric Code")) {
                try {
                    numericCode = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!label.equalsIgnoreCase("Group name") || groupName == null) continue;
            groupName.delete(0, groupName.length());
            groupName.append(value);
        }
        if (donorString != null) {
            Taxon taxon = ws.addTaxon(txBuilder, genBuilder, cat_mnem, donorID, donorString);
            if (groupTaxa != null) {
                groupTaxa.add(taxon);
            }
        }
    }

    final void parseCompositeStandard(DEXsection section) throws SBException, SQLException {
        CompositeStandard cmpStd = new CompositeStandard(this.ws, section);
        this.ws.getCompositeStandards().add(cmpStd);
    }

    final void parseEvents(DEXsection section) {
        System.out.println("+++++Attempting to parseEvents+++++++");
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(new Integer(dType))) {
            this.dataTypes.add(new Integer(dType));
        }
    }

    public static void writeProlog(FileWriter out, String eol, Licence licence) throws IOException, SQLException {
        out.write("[PROLOG]" + eol + "File Format = DEX Paleo Data Exchange Format" + eol + "Software = StrataBugs v2.1" + eol + "Data prepared by = " + licence.company + eol + "Location = " + licence.location + eol + "Date Locale = C" + eol + "Date = " + df.format(new Date()) + eol);
        out.write(eol);
    }

    final void writeSpecies(FileWriter out, List taxa, String eol, boolean usePref, int synScheme) throws IOException, SQLException, SBException {
        if (taxa.isEmpty()) {
            return;
        }
        out.write("[SPECIES LIST]" + eol);
        Collections.sort(taxa, new TaxonCompareGenus(new TaxonCompareSpecies()));
        for (Taxon taxon : taxa) {
            taxon.writeDEX(out, eol, usePref, synScheme);
        }
        out.write(eol);
    }

    public DEXFile(FileWriter out, SBdb ws, SBdb db, Set dataTypes, char units, int interpID, boolean usePref, int synScheme) throws IOException, SQLException, SBException {
        DEXFile.writeProlog(out, this.eol, db.licence);
        int[] schemeTypes = new int[]{3, 4, 2};
        for (int i = 0; i < schemeTypes.length; ++i) {
            for (IGDScheme scheme : ws.getIGDSchemes(schemeTypes[i])) {
                scheme.loadUnits();
                scheme.writeDEX(out, this.eol);
            }
        }
        for (EnvScheme scheme : ws.getEnvSchemes()) {
            scheme.writeDEX(out, this.eol);
        }
        if (ws.getAbnSchemes().size() > 0) {
            out.write("[ABUNDANCE FORMAT]" + this.eol);
        }
        for (AbnScheme abn : ws.getAbnSchemes()) {
            abn.writeDEX(out, this.eol);
            out.write(this.eol);
        }
        LinkedList taxa = new LinkedList();
        Iterator<Well> itWell = ws.getWellIterator();
        while (itWell.hasNext()) {
            Well outWell = itWell.next();
            char outputUnits = units == 'D' ? outWell.getWellUnits() : units;
            outWell.writeDEX(out, this.eol, true, df, dataTypes, outputUnits);
            WellInterp interp = null;
            if (outWell.hasInterpLoaded(interpID)) {
                interp = outWell.getInterp(interpID);
            }
            for (Sample sample : outWell.getSamples()) {
                boolean sampleIsUsed = false;
                Iterator en2 = dataTypes.iterator();
                while (en2.hasNext()) {
                    int columnType = (Integer)en2.next();
                    switch (columnType) {
                        case 1: {
                            sampleIsUsed = true;
                            break;
                        }
                        case 2: 
                        case 4: 
                        case 6: 
                        case 8: {
                            if (!sample.hasDisciplineData(SBdb.dt2discID(columnType))) break;
                            sampleIsUsed = true;
                        }
                    }
                    if (!sampleIsUsed) continue;
                    break;
                }
                if (!sampleIsUsed && interp != null && interp.sampleIsUsed(sample.getSampID(), dataTypes)) {
                    sampleIsUsed = true;
                }
                if (!sampleIsUsed && !sample.hasAgeData(interp) && sample.getLithology().getLithology().size() <= 0) continue;
                sample.writeDEX(out, dataTypes, true, true, taxa, outputUnits, this.eol, df);
            }
            if (interp == null) continue;
            interp.writeDEX(out, outputUnits, this.eol, dataTypes);
        }
        this.writeSpecies(out, taxa, this.eol, usePref, synScheme);
        out.write("[END OF FILE]" + this.eol);
    }

    class DEXsection {
        String type;
        String parameters;
        List label = new LinkedList();
        List value = new LinkedList();
        List sepChar = new LinkedList();

        DEXsection() {
        }
    }
}

