/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import model2_1.AgeConfidence;
import model2_1.CompositeStandard;
import model2_1.CompositeStandardEvent;
import model2_1.SBEvent;
import model2_1.SBdb;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class EventXLSReader {
    private final SBdb ws;
    private final Workbook wb;
    private String top;
    private String base;
    private final String name;
    private final List<Event> events = new LinkedList<Event>();
    private short eventTypeColumn = (short)-1;
    final int COL_AGE = 0;
    final int COL_TOP = 2;
    final int COL_BASE = 3;
    final int COL_SPORADIC = 4;
    final int COL_PRESENT = 5;
    final int COL_COMMON = 6;
    final int COL_FREQUENT = 7;
    final int COL_ABUNDANT = 8;
    final int COL_SP = 9;
    final int COL_DC = 10;
    final int COL_TAXON = 11;
    final int COL_AUTHOR = 12;

    public EventXLSReader(SBdb ws, File file) throws IOException, InvalidFormatException {
        this.ws = ws;
        try (FileInputStream is = new FileInputStream(file);){
            this.wb = WorkbookFactory.create((InputStream)is);
        }
        for (int j = 0; j < this.wb.getNumberOfSheets(); ++j) {
            Sheet sheet = this.wb.getSheetAt(j);
            System.out.println("Contains sheet: " + this.wb.getSheetName(j) + "/" + sheet.getSheetName() + "\n");
        }
        String n = file.getName();
        if (n.lastIndexOf(46) > 1) {
            n = n.substring(0, n.lastIndexOf(46));
        }
        this.name = n;
    }

    public List<String> scanPrefixes(List<String> ignoredColumns) {
        Sheet sheet = this.wb.getSheetAt(0);
        short nameCell = 0;
        Row titleRow = sheet.getRow(0);
        if (titleRow == null) {
            System.out.println("column titles null for sheet: " + this.ws);
            return null;
        }
        for (short cellNum = titleRow.getFirstCellNum(); cellNum < titleRow.getLastCellNum(); cellNum = (short)(cellNum + 1)) {
            Cell cell = titleRow.getCell((int)cellNum);
            if (cell == null) {
                System.out.println("Can't get cell for cellNum: " + cellNum);
                continue;
            }
            String colName = cell.getStringCellValue();
            try {
                EvXLSColumn column = EvXLSColumn.getColumnType(colName);
                if (column.equals((Object)EvXLSColumn.TYPE)) {
                    this.eventTypeColumn = cellNum;
                    continue;
                }
                if (!column.equals((Object)EvXLSColumn.EVENT)) continue;
                nameCell = cellNum;
                continue;
            }
            catch (IllegalStateException ex) {
                ignoredColumns.add(colName);
            }
        }
        LinkedList<String> prefixes = new LinkedList<String>();
        for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            String cellString;
            Cell cell;
            Row row = sheet.getRow(nRow);
            if (row == null || (cell = row.getCell((int)(this.eventTypeColumn < 0 ? nameCell : this.eventTypeColumn))) == null || cell.getCellType() != CellType.STRING && cell.getCellType() != CellType.FORMULA || (cellString = cell.getStringCellValue()) == null) continue;
            cellString = cellString.trim();
            if (this.eventTypeColumn < 0) {
                String[] eventNames;
                for (String eventName : eventNames = cellString.split(",")) {
                    String[] words;
                    if ((eventName = eventName.trim()).isEmpty() || (words = eventName.split(" ")).length <= 1 || prefixes.contains(words[0].toUpperCase())) continue;
                    prefixes.add(words[0].toUpperCase());
                }
                continue;
            }
            if (prefixes.contains(cellString)) continue;
            prefixes.add(cellString);
        }
        return prefixes;
    }

    public void getEvents(SBdb ws) throws SQLException, SBException {
        Sheet sheet = this.wb.getSheetAt(0);
        try {
            String[] columns = new String[20];
            Row titleRow = sheet.getRow(0);
            if (titleRow == null) {
                System.out.println("column titles null for sheet: " + ws);
                return;
            }
            for (short cellNum = titleRow.getFirstCellNum(); cellNum < titleRow.getLastCellNum(); cellNum = (short)(cellNum + 1)) {
                Cell cell = titleRow.getCell((int)cellNum);
                if (cellNum >= columns.length) {
                    System.out.println("CellNumber: " + cellNum + " exceeds column title length!");
                }
                if (cell == null) {
                    System.out.println("Can't get cell for cellNum: " + cellNum);
                    continue;
                }
                columns[cellNum] = cell.getStringCellValue();
            }
            for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
                Row row = sheet.getRow(nRow);
                if (row == null) continue;
                LinkedList<Event> toAddTop = new LinkedList<Event>();
                LinkedList<Event> toAddBase = new LinkedList<Event>();
                Double age = null;
                Double errMinus = null;
                Double errPlus = null;
                String desc = null;
                String comment = null;
                AgeConfidence conf = AgeConfidence.CONFIDENT;
                boolean isSingle = false;
                boolean isTop = false;
                String[] eventNames = null;
                for (short cellNum = row.getFirstCellNum(); cellNum < columns.length; cellNum = (short)(cellNum + 1)) {
                    Cell cell = row.getCell((int)cellNum);
                    if (cell == null || cell.toString().isEmpty()) continue;
                    try {
                        EvXLSColumn type = EvXLSColumn.getColumnType(columns[cellNum]);
                        switch (type) {
                            case TYPE: {
                                String cellTypeString = cell.getStringCellValue().trim();
                                if (cellTypeString == null) break;
                                if (this.top != null && cellTypeString.trim().equalsIgnoreCase(this.top)) {
                                    isSingle = false;
                                    isTop = true;
                                    break;
                                }
                                if (this.base != null && cellTypeString.trim().equalsIgnoreCase(this.base)) {
                                    isSingle = false;
                                    isTop = false;
                                    break;
                                }
                                isSingle = true;
                                isTop = false;
                                break;
                            }
                            case EVENT: {
                                String cellString = cell.getStringCellValue().trim();
                                if (cellString == null) break;
                                eventNames = cellString.split(",");
                                break;
                            }
                            case AGE: {
                                age = this.readCellValueAsNumeric(cell);
                                if (age == null) {
                                    throw new SBException("Can't read Age from cell contents '" + cell.toString() + "' at row number: " + nRow);
                                }
                                age = SB.round((double)age, (int)6);
                                break;
                            }
                            case AGEERRMINUS: {
                                errMinus = this.readCellValueAsNumeric(cell);
                                if (errMinus == null) {
                                    throw new SBException("Can't read negative error value from cell contents '" + cell.toString() + "' at row number: " + nRow);
                                }
                                errMinus = SB.round((double)errMinus, (int)6);
                                break;
                            }
                            case AGEERRPLUS: {
                                errPlus = this.readCellValueAsNumeric(cell);
                                if (errPlus == null) {
                                    throw new SBException("Can't read positive error value from cell contents '" + cell.toString() + "' at row number: " + nRow);
                                }
                                errPlus = SB.round((double)errPlus, (int)6);
                                break;
                            }
                            case DESC: {
                                desc = cell.getStringCellValue();
                                break;
                            }
                            case COMMENT: {
                                comment = cell.getStringCellValue();
                                break;
                            }
                            case CONFIDENCE: {
                                Object confString = cell.getStringCellValue();
                                if (((String)confString).length() > 1) {
                                    confString = ((String)confString).substring(0, 1).toUpperCase() + ((String)confString).substring(1).toLowerCase();
                                    conf = AgeConfidence.getConfidence((String)confString);
                                } else {
                                    break;
                                }
                            }
                        }
                        continue;
                    }
                    catch (IllegalStateException ex) {
                        // empty catch block
                    }
                }
                if (eventNames != null) {
                    for (String eventName : eventNames) {
                        SBEvent sbEvent;
                        if ((eventName = eventName.trim()).isEmpty()) continue;
                        if (this.eventTypeColumn < 0) {
                            if (this.top != null && eventName.toUpperCase().startsWith(this.top + " ")) {
                                eventName = eventName.substring(this.top.length() + 1).trim();
                                isSingle = false;
                                isTop = true;
                            } else if (this.base != null && eventName.toUpperCase().startsWith(this.base + " ")) {
                                eventName = eventName.substring(this.base.length() + 1).trim();
                                isSingle = false;
                                isTop = false;
                            } else {
                                isSingle = true;
                                isTop = false;
                            }
                        }
                        if ((sbEvent = ws.getSBEvent(eventName)) == null) {
                            sbEvent = ws.addSBEvent(new SBEvent.Builder().name(eventName).isGenerate(!isSingle).isSingle(isSingle));
                        }
                        Event rowEvent = null;
                        for (Event event : this.events) {
                            if (!event.name.equals(eventName)) continue;
                            if (event.event == sbEvent) break;
                            throw new SBException("Internal error: mis-match events");
                        }
                        if (rowEvent == null) {
                            rowEvent = new Event();
                            rowEvent.name = eventName;
                            rowEvent.event = sbEvent;
                            rowEvent.conf = AgeConfidence.CONFIDENT;
                            this.events.add(rowEvent);
                        }
                        if (isTop || isSingle) {
                            toAddTop.add(rowEvent);
                            continue;
                        }
                        toAddBase.add(rowEvent);
                    }
                }
                for (Event rowEvent : toAddTop) {
                    if (age != null) {
                        rowEvent.top = age;
                    }
                    if (errMinus != null) {
                        rowEvent.topErrMinus = errMinus;
                    }
                    if (errPlus == null) continue;
                    rowEvent.topErrPlus = errPlus;
                }
                for (Event rowEvent : toAddBase) {
                    if (age != null) {
                        rowEvent.base = age;
                    }
                    if (errMinus != null) {
                        rowEvent.baseErrMinus = errMinus;
                    }
                    if (errPlus == null) continue;
                    rowEvent.baseErrPlus = errPlus;
                }
                for (Event rowEvent : toAddTop) {
                    if (desc != null && !desc.isEmpty()) {
                        rowEvent.event.setEvDesc(desc);
                    }
                    if (comment != null && !comment.isEmpty()) {
                        rowEvent.comment = comment;
                    }
                    rowEvent.conf = conf;
                }
                for (Event rowEvent : toAddBase) {
                    if (desc != null && !desc.isEmpty()) {
                        rowEvent.event.setEvDesc(desc);
                    }
                    if (comment != null && !comment.isEmpty()) {
                        rowEvent.comment = comment;
                    }
                    rowEvent.conf = conf;
                }
            }
        }
        catch (SBPermissionException pe) {
            throw new SBException(pe.getMessage());
        }
    }

    private Double readCellValueAsNumeric(Cell cell) {
        Double value = null;
        if (cell.getCellType() == CellType.NUMERIC) {
            value = cell.getNumericCellValue();
        } else {
            String stringValue = cell.toString();
            try {
                value = Double.parseDouble(stringValue.trim());
            }
            catch (NumberFormatException pe) {
                value = null;
            }
        }
        return value;
    }

    public void getBujakEvents(SBdb ws) throws SQLException, SBException {
        Sheet sheet = this.wb.getSheetAt(0);
        try {
            for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
                SBEvent sbEvent;
                boolean isTop;
                Cell cell;
                Row row = sheet.getRow(nRow);
                if (row == null || (cell = row.getCell(0)) == null) continue;
                Double age = null;
                age = cell != null && cell.getCellType() == CellType.NUMERIC ? Double.valueOf(cell.getNumericCellValue()) : Double.valueOf(Double.parseDouble(cell.getStringCellValue()));
                age = SB.round((double)age, (int)6);
                cell = row.getCell(11);
                String cellString = cell.getStringCellValue().trim();
                if (cellString == null) continue;
                String[] eventType = new String[2];
                for (int col = 2; col <= 3; ++col) {
                    cell = row.getCell(col);
                    if (cell == null || cell.getStringCellValue() == null || cell.getStringCellValue().trim().isEmpty()) continue;
                    eventType[col - 2] = cell.getStringCellValue();
                }
                String abundSuffix = "";
                AgeConfidence conf = AgeConfidence.CONFIDENT;
                block11: for (int col = 4; col <= 8; ++col) {
                    cell = row.getCell(col);
                    if (cell == null || cell.getStringCellValue() == null || !cell.getStringCellValue().toLowerCase().equals("x")) continue;
                    switch (col) {
                        case 4: {
                            abundSuffix = "[S]";
                            conf = AgeConfidence.POSSIBLE;
                            continue block11;
                        }
                        case 5: {
                            continue block11;
                        }
                        case 6: {
                            abundSuffix = "[C]";
                            continue block11;
                        }
                        case 7: {
                            abundSuffix = "[F]";
                            continue block11;
                        }
                        case 8: {
                            abundSuffix = "[A]";
                        }
                    }
                }
                boolean isSingle = false;
                if (eventType[0] != null && eventType[0].toLowerCase().startsWith("x")) {
                    isTop = true;
                } else if (eventType[1] != null && eventType[1].toLowerCase().startsWith("x")) {
                    isTop = false;
                } else {
                    System.out.println("Ambiguous event type for taxon: " + cellString);
                    continue;
                }
                String eventName = cellString + (abundSuffix.length() > 0 ? " " : "") + abundSuffix;
                String eventDesc = "";
                cell = row.getCell(12);
                if (cell != null && cell.getCellType() == CellType.NUMERIC) {
                    eventDesc = cell.getStringCellValue();
                }
                if ((sbEvent = ws.getSBEvent(eventName)) == null) {
                    sbEvent = ws.addSBEvent(new SBEvent.Builder().name(eventName).isGenerate(!isSingle).isSingle(isSingle).desc(eventDesc));
                }
                Event rowEvent = null;
                for (Event event : this.events) {
                    if (!event.name.equals(eventName)) continue;
                    if (event.event != sbEvent) {
                        throw new SBException("Internal error: mis-match events");
                    }
                    rowEvent = event;
                    break;
                }
                if (rowEvent == null) {
                    rowEvent = new Event();
                    rowEvent.name = eventName;
                    rowEvent.event = sbEvent;
                    rowEvent.conf = conf;
                    this.events.add(rowEvent);
                }
                if (isSingle || isTop) {
                    rowEvent.top = age;
                    continue;
                }
                rowEvent.base = age;
            }
        }
        catch (SBPermissionException pe) {
            throw new SBException(pe.getMessage());
        }
    }

    public CompositeStandard getCompositeStandard(List<SBException> exceptions) throws SBException, SQLException {
        LinkedList<CompositeStandardEvent.Builder> builders = new LinkedList<CompositeStandardEvent.Builder>();
        Double minAge = null;
        Double maxAge = null;
        for (Event event : this.events) {
            Double[] eventAges;
            CompositeStandardEvent.Builder builder;
            if (event.event == null || event.event.getLink() == null) continue;
            if (!event.event.isSingle()) {
                if (event.top != null) {
                    builder = new CompositeStandardEvent.Builder().event(event.event);
                    builder.type(SBEvent.EventType.TOP);
                    builder.csu(event.top);
                    builder.confidence(event.conf);
                    builder.errMinus(event.topErrMinus);
                    builder.errPlus(event.topErrPlus);
                    builder.comment(event.comment);
                    builders.add(builder);
                }
                if (event.base != null) {
                    builder = new CompositeStandardEvent.Builder().event(event.event);
                    builder.type(SBEvent.EventType.BASE);
                    builder.csu(event.base);
                    builder.errPlus(event.baseErrPlus);
                    builder.errMinus(event.baseErrMinus);
                    builder.comment(event.comment);
                    builder.confidence(event.conf);
                    builders.add(builder);
                }
            } else {
                if (event.top == null) {
                    System.out.println("Event top is null for: " + event.name + ", base is: " + event.base);
                    if (event.base == null) continue;
                }
                builder = new CompositeStandardEvent.Builder().event(event.event);
                builder.type(SBEvent.EventType.SINGLE);
                builder.csu(event.top != null ? event.top : event.base);
                builder.errMinus(event.topErrMinus);
                builder.errPlus(event.topErrPlus);
                builder.confidence(event.conf);
                builder.comment(event.comment);
                builders.add(builder);
            }
            Double[] doubleArray = new Double[2];
            Double d = event.top != null ? Double.valueOf(event.top - (event.topErrMinus != null ? event.topErrMinus : 0.0)) : (doubleArray[0] = null);
            doubleArray[1] = event.base != null ? Double.valueOf(event.base + (event.baseErrPlus != null ? event.baseErrPlus : 0.0)) : null;
            for (Double age : eventAges = doubleArray) {
                if (age == null) continue;
                if (minAge == null || age < minAge) {
                    minAge = age;
                }
                if (maxAge != null && !(age > maxAge)) continue;
                maxAge = age;
            }
        }
        if (minAge == null) {
            minAge = 0.0;
        }
        if (maxAge == null) {
            maxAge = 0.0;
        }
        try {
            return this.ws.addCompositeStandard(this.name, minAge, maxAge, maxAge, maxAge, true, builders, null, 0);
        }
        catch (InvalidFieldException | SBPermissionException e) {
            exceptions.add(new SBException(e.getMessage()));
            return null;
        }
    }

    public void setPrefixes(String top, String base) {
        this.top = top;
        this.base = base;
    }

    private static enum EvXLSColumn {
        EVENT(new String[]{"EVENT", "NAME"}),
        TYPE(new String[]{"TYPE", "EVENTTYPE"}),
        GENERATE(new String[]{"GENERATE"}),
        DESC(new String[]{"DESC"}),
        AGE(new String[]{"AGE", "CSU"}),
        AGEERRMINUS(new String[]{"MINUS", "CSUMINUS", "AGEMINUS"}),
        AGEERRPLUS(new String[]{"PLUS", "CSUPLUS", "AGEPLUS"}),
        NULLCOLUMN(new String[]{"XXXXXXXXXXXXXXXXXXX"}),
        CONFIDENCE(new String[]{"CONFIDENCE"}),
        COMMENT(new String[]{"COMMENTS", "COMMENT"});

        private final String[] titles;

        private EvXLSColumn(String[] titles) {
            this.titles = titles;
        }

        static EvXLSColumn getColumnType(String title) {
            if (title == null || title.trim().isEmpty()) {
                return NULLCOLUMN;
            }
            title = title.toUpperCase().trim();
            for (EvXLSColumn col : EvXLSColumn.values()) {
                for (String title1 : col.titles) {
                    if (!title.equals(title1)) continue;
                    return col;
                }
            }
            throw new IllegalStateException("Unrecognised column title: " + title);
        }
    }

    private static class Event {
        String name;
        SBEvent event;
        Double top;
        Double topErrMinus;
        Double topErrPlus;
        Double base;
        Double baseErrMinus;
        Double baseErrPlus;
        String descr;
        AgeConfidence conf;
        String comment;

        private Event() {
        }
    }
}

