/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedList;
import model2_1.Audit;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.Well;
import model2_1.api.Discipline;
import model2_1.wellinterp.InterpItem;
import util.SB;
import util.SBException;
import util.status.SbugsStatus;

public abstract class IGDInterval
implements SbugsStatus,
InterpItem {
    final SBdb sbdb;
    int igdType;
    Sample topSample = null;
    Sample baseSample = null;
    String conflictReason;
    Color status = UNKNOWN;
    Audit audit = new Audit();
    public static final String[] igdTypes = new String[]{"Lithostratigraphy", "Chronostratigraphy", "Biozone", "Sequence", "Interpreted Lithology", "Lithology qualifiers", "Palaeoenvironment", "Biostratigraphic Comments", "Events", "Interval Comments", "LOC", "Faults"};
    static final String[] IGDIntervalTypes = new String[]{igdTypes[0], igdTypes[1], igdTypes[2], igdTypes[3]};
    public static final int IGD_LITHOSTRAT = 2;
    public static final int IGD_CHRONOSTRAT = 3;
    public static final int IGD_BIOZONE = 4;
    public static final int IGD_SEQUENCE = 10;
    public static final int IGD_INTLITHOLOGY = 12;
    public static final int IGD_QUALLITHOLOGY = 13;
    public static final int IGD_ENVIRONMENT = 5;
    public static final int IGD_ALLBSCOMMENTS = 19;
    public static final int IGD_EVENT = 20;
    public static final int IGD_SQPICK = 21;
    public static final int IGD_INTCOMMENTS = 22;
    public static final int IGD_LOC = 23;
    public static final int IGD_FAULTS = 24;
    public static final int IGD_AGECURVE = 25;
    public static final int IGD_CHRON = 26;

    public int getIGDType() {
        return this.igdType;
    }

    public Sample getTopSample() {
        return this.topSample;
    }

    @Override
    public Sample getBaseSample() {
        return this.baseSample;
    }

    public int getTopID() {
        return this.topSample.getSampID();
    }

    public int getBaseID() {
        return this.baseSample.getSampID();
    }

    @Override
    public Sample getSample() {
        return this.topSample;
    }

    @Override
    public Discipline getDiscipline() {
        return null;
    }

    public Date getCreated() {
        return new Date(this.audit.created.getTime());
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public String getCreatorAbr() {
        if (this.sbdb == null) {
            return "" + this.audit.creator;
        }
        try {
            return this.sbdb.getUser(this.audit.creator).getAbr();
        }
        catch (Exception e) {
            return "Not found: " + this.audit.creator;
        }
    }

    public Date getModified() {
        return new Date(this.audit.modified.getTime());
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public String getModifierAbr() {
        if (this.sbdb == null) {
            return "" + this.audit.modifier;
        }
        try {
            return this.sbdb.getUser(this.audit.modifier).getAbr();
        }
        catch (Exception e) {
            return "Not found: " + this.audit.modifier;
        }
    }

    IGDInterval(SBdb ws, IGDInterval dbInterval, Well wsWell) throws SQLException, SBException {
        this.sbdb = ws;
        this.audit = new Audit(dbInterval.audit);
        this.audit.fillWorkspace(dbInterval.sbdb, ws);
        this.topSample = wsWell.getSample(dbInterval.topSample.getSampID());
        this.baseSample = wsWell.getSample(dbInterval.baseSample.getSampID());
    }

    IGDInterval(SBdb db, IGDInterval wsInterval) throws SQLException, SBException {
        this.sbdb = db;
        this.audit = new Audit(this.sbdb, wsInterval.sbdb, wsInterval.audit);
        if (wsInterval.topSample == null) {
            throw new SBException("Interval top sample not linked: " + this);
        }
        this.topSample = wsInterval.topSample.link;
        if (wsInterval.baseSample == null) {
            throw new SBException("Interval base sample not linked: " + this);
        }
        this.baseSample = wsInterval.baseSample.link;
    }

    IGDInterval(SBdb sbdb) {
        this.sbdb = sbdb;
    }

    public Color getStatus() {
        return this.status;
    }

    public static int dType2IGDtype(int dType) throws SBException {
        switch (dType) {
            case 12: {
                return 2;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 4;
            }
            case 13: {
                return 10;
            }
            case 15: {
                return 5;
            }
            case 14: {
                return 21;
            }
            case 16: {
                return 20;
            }
            case 27: {
                return 24;
            }
        }
        throw new SBException("Can't translate data type '" + dType + "' into IGDtype");
    }

    public static int igdType2dType(int igdType) throws SBException {
        switch (igdType) {
            case 2: {
                return 12;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 11;
            }
            case 10: {
                return 13;
            }
            case 5: {
                return 15;
            }
            case 22: {
                return 18;
            }
        }
        throw new SBException("Can't translate igd type '" + igdType + "' into Data type");
    }

    public static int getIGDType(String type) {
        if (type.compareToIgnoreCase("Lithostratigraphy") == 0) {
            return 2;
        }
        if (type.compareToIgnoreCase("Chronostratigraphy") == 0) {
            return 3;
        }
        if (type.compareToIgnoreCase("Biozones") == 0) {
            return 4;
        }
        if (type.compareToIgnoreCase("Biozone") == 0) {
            return 4;
        }
        if (type.compareToIgnoreCase("Sequences") == 0) {
            return 10;
        }
        if (type.compareToIgnoreCase("Sequence") == 0) {
            return 10;
        }
        if (type.compareToIgnoreCase("Palaeoenvironments") == 0) {
            return 5;
        }
        if (type.equalsIgnoreCase("Palynoflaral Biozone")) {
            return 4;
        }
        if (type.equalsIgnoreCase("Nanofloral Biozone")) {
            return 4;
        }
        if (type.equalsIgnoreCase(SBdb.getDiscAdj('M') + " Biozone")) {
            return 4;
        }
        if (type.equalsIgnoreCase(SBdb.getDiscAdj('N') + " Biozone")) {
            return 4;
        }
        if (type.equalsIgnoreCase(SBdb.getDiscAdj('P') + " Biozone")) {
            return 4;
        }
        if (type.equalsIgnoreCase(SBdb.getDiscAdj('A') + " Biozone")) {
            return 4;
        }
        if (type.equalsIgnoreCase("Magnetostratigraphy")) {
            return 26;
        }
        return 0;
    }

    public static String getIGDName(int igdType) {
        switch (igdType) {
            case 2: {
                return "Lithostratigraphy";
            }
            case 3: {
                return "Chronostratigraphy";
            }
            case 4: {
                return "Biozones";
            }
            case 10: {
                return "Sequences";
            }
            case 5: {
                return "Palaeoenvironments";
            }
            case 19: {
                return "Biostratigraphic Comments";
            }
            case 21: {
                return "Sequence picks";
            }
            case 20: {
                return "Events";
            }
            case 26: {
                return "Magnetostratigraphy";
            }
            case 23: {
                return "Depth/Age curve";
            }
            case 22: {
                return "Interval Comments";
            }
        }
        return "Attempt to return string for type : " + igdType;
    }

    public String statusString() {
        return this.toString();
    }

    void copy(IGDInterval i) {
        this.igdType = i.igdType;
        this.topSample = i.topSample;
        this.baseSample = i.baseSample;
        this.audit = new Audit(i.audit);
    }

    @Override
    public Date getUpdated() {
        return this.audit.updated;
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException, SBException {
        out.write("[INTERVAL " + SB.getDepthString((double)this.topSample.getDepth('M'), (char)units, (int)2).trim() + " - " + SB.getDepthString((double)this.baseSample.getDepth('M'), (char)units, (int)2).trim() + "]" + eol);
    }

    public LinkedList<Integer> writeXML(BufferedWriter out, int indent, char units) throws IOException, SBException, SQLException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        String ind1 = SB.getXMLIndent((int)indent);
        String ind2 = SB.getXMLIndent((int)(indent + 3));
        out.write(ind1 + "<IGDInterval Depth=\"" + SB.getDepthString((double)this.topSample.getDepth('M'), (char)units, (int)2).trim() + " - " + SB.getDepthString((double)this.baseSample.getDepth('M'), (char)units, (int)2).trim() + "\">\n");
        out.write(ind2 + "<TopSampleDepth>" + SB.getDepthString((double)this.topSample.getDepth('M'), (char)units, (int)2).trim() + "</TopSampleDepth>\n");
        out.write(ind2 + "<BaseSampleDepth>" + SB.getDepthString((double)this.baseSample.getDepth('M'), (char)units, (int)2).trim() + "</BaseSampleDepth>\n");
        return userIDs;
    }

    public boolean checkDepthBracketing(int cTD, int cBD, int nzTD, int nzBD) {
        try {
            SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD, (boolean)true);
        }
        catch (SBException e) {
            this.status = CONFLICT;
            this.conflictReason = e.getMessage();
            return false;
        }
        return true;
    }

    IGDInterval(Builder builder) {
        this.sbdb = builder.sbdb;
        this.igdType = builder.igdType;
        this.topSample = builder.topSample;
        this.baseSample = builder.baseSample;
        this.status = builder.status;
        this.audit = builder.audit;
    }

    static abstract class Builder {
        final SBdb sbdb;
        final int igdType;
        final Sample topSample;
        final Sample baseSample;
        Color status = SbugsStatus.UNKNOWN;
        Audit audit = new Audit();

        Builder(SBdb sbdb, int igdType, Sample topSample, Sample baseSample) {
            this.sbdb = sbdb;
            this.igdType = igdType;
            this.topSample = topSample;
            this.baseSample = baseSample;
        }

        void validate() {
            if (this.igdType == 0) {
                throw new IllegalStateException("Attempt to build interval with no IGDType");
            }
            if (this.topSample == null) {
                throw new IllegalStateException("Attempt to build interval with no top sample");
            }
            if (this.baseSample == null) {
                throw new IllegalStateException("Attempt to build interval with no base sample");
            }
        }

        public Sample getBaseSample() {
            return this.baseSample;
        }

        public Sample getTopSample() {
            return this.topSample;
        }
    }
}

