/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import model2_1.Audit;
import model2_1.Chron;
import model2_1.IGDAge;
import model2_1.IGDUnit;
import model2_1.IGDUnitClass;
import model2_1.LithostratUnit;
import model2_1.SBdb;
import model2_1.Userdef;
import util.AgeFormat;
import util.SBException;
import util.SbugsLink;
import util.SortEntry;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public abstract class IGDUnitBase
implements SortEntry,
IGDUnitClass,
SbugsStatus,
Comparable,
SbugsLink {
    final SBdb sbdb;
    private final int schID;
    private final int unitID;
    private int hier;
    private String name = "";
    private Audit audit = new Audit();
    Color status = UNKNOWN;
    IGDUnitBase link = null;
    static final double AGE_PRECISION = 1000000.0;
    private int nOccs = -1;
    private int nCorrOccs = -1;

    IGDUnitBase(SBdb sbdb, int schID, int unitID) {
        this.sbdb = sbdb;
        this.schID = schID;
        this.unitID = unitID;
    }

    public int getSchID() {
        return this.schID;
    }

    public int getUnitID() {
        return this.unitID;
    }

    @Override
    public int getHier() {
        return this.hier;
    }

    final void setHier(int hier) {
        this.hier = hier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    final void setName(String name) {
        if (name == null) {
            name = "";
        }
        this.name = name;
    }

    public void updateWsName(String name) throws SBException {
        if (this.sbdb.isConnected()) {
            throw new SBException("Attempt to update unit name outside workspace");
        }
        if (name == null || name.isEmpty()) {
            throw new SBException("Attempt to update unit:" + this.getName() + " with empty string");
        }
        this.setName(name);
    }

    int getUageInt() {
        return (int)(this.getUage() * 1000000.0);
    }

    int getLageInt() {
        return (int)(this.getLage() * 1000000.0);
    }

    public String toString() {
        return this.getName();
    }

    public String toString(boolean useAge) {
        return this.toString(useAge, AgeFormat.MA);
    }

    public String toString(boolean useAge, AgeFormat ageFormat) {
        if (useAge) {
            return this.getName() + " (" + ageFormat.toAgeString(this.getUage(), 2) + " - " + ageFormat.toAgeString(this.getLage(), 2) + ")";
        }
        return this.toString();
    }

    public abstract String getAbr();

    @Override
    public String getSortEntry() {
        return IGDUnitBase.getSortEntry(this.getUage(), this.getLage(), this.hier, this.name);
    }

    public abstract IGDUnitBase getLink();

    public Color getStatus() {
        if (this.status == UNKNOWN && this.getSchID() != 0) {
            this.status = this.getUnitID() != 0 ? STORED : NOTSTORED;
        }
        return this.status;
    }

    public String statusString() {
        return this.toString();
    }

    public boolean isFuncEquivalent(SortEntry e) {
        if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
            return true;
        }
        IGDUnitBase unit = (IGDUnitBase)e;
        return this.name.toUpperCase().equals(unit.getName().toUpperCase());
    }

    public Date getCreated() {
        return new Date(this.audit.created.getTime());
    }

    public int getCreator() {
        return this.audit.creator;
    }

    Date getUpdated() {
        return new Date(this.audit.updated.getTime());
    }

    void setAudit(Audit audit) {
        this.audit = audit;
    }

    final Audit getAudit() {
        return this.audit;
    }

    public void setLink(IGDUnitBase linkUnit, List<IGDUnitBase> schemeUnits) {
        this.link = linkUnit;
        this.updateStatusLink(schemeUnits);
    }

    static String getSortEntry(double u_age, double l_age, int hier, String name) {
        String uAge = IGDUnitBase.roundAndPadAge(u_age);
        String lAge = IGDUnitBase.roundAndPadAge(l_age);
        String entry = uAge + "-" + hier + "-" + lAge + "-" + name.toUpperCase();
        return entry;
    }

    static String roundAndPadAge(double age) {
        long ageInt = Math.round(age * 1000000.0);
        String ageString = "" + ageInt;
        while (ageString.length() < 10) {
            ageString = "0" + ageString;
        }
        return ageString;
    }

    public int compareTo(Object o) {
        if (o instanceof IGDUnitBase) {
            IGDUnitBase comp = (IGDUnitBase)o;
            return this.getSortEntry().compareTo(comp.getSortEntry());
        }
        return -1;
    }

    static synchronized void insert(IGDUnitBase unit, List<IGDUnitBase> units) {
        boolean inserted = false;
        int i = 0;
        for (IGDUnitBase u : units) {
            if (u.getSortEntry().compareTo(unit.getSortEntry()) > 0) {
                units.add(i, unit);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            units.add(unit);
        }
    }

    abstract void delete(Statement var1) throws SQLException;

    abstract void storeDB(int var1, Statement var2) throws SQLException;

    @Override
    public abstract Color getColour();

    abstract void updateStatusLinkSubclass(List<IGDUnitBase> var1);

    public abstract void copyLink();

    void updateStatusLink(List<IGDUnitBase> schemeUnits) {
        if (this.link != null) {
            this.status = STORED;
            if (!this.getName().toUpperCase().equals(this.link.getName().toUpperCase())) {
                this.status = MergeStatus.merge((Color)this.status, (Color)CONFLICT);
            } else if (Math.abs(this.getUage() - this.link.getUage()) > 0.001) {
                this.status = this.getUage() > 0.001 ? MergeStatus.merge((Color)this.status, (Color)CONFLICT) : MergeStatus.merge((Color)this.status, (Color)PARTSTORED);
            } else if (Math.abs(this.getLage() - this.link.getLage()) > 0.001) {
                this.status = this.getLage() > 0.001 ? MergeStatus.merge((Color)this.status, (Color)CONFLICT) : MergeStatus.merge((Color)this.status, (Color)PARTSTORED);
            } else {
                this.updateStatusLinkSubclass(schemeUnits);
            }
        } else {
            this.status = NOTSTORED;
        }
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for scheme unit: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    public int getNoccs(boolean refresh) throws SQLException {
        if (this.nOccs < 0 || refresh) {
            this.nOccs = 0;
            if (this.sbdb != null && this.sbdb.isConnected()) {
                try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                    String sql = "SELECT count(top_id) AS nOccs FROM " + this.sbdb.DBTableName(this instanceof LithostratUnit ? "IGD_LSTRAT" : "IGD") + " WHERE sch_id=" + this.schID + " AND (upp_zone=" + this.getUnitID() + " OR low_zone=" + this.getUnitID() + ")";
                    ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                    if (rs.next()) {
                        this.nOccs = rs.getInt("nOccs");
                    }
                }
            }
        }
        return this.nOccs;
    }

    public int getNCorrLines(boolean refresh) throws SQLException {
        if (this.nCorrOccs < 0 || refresh) {
            this.nCorrOccs = 0;
            if (this.sbdb != null && this.sbdb.isConnected()) {
                try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                    String sql = "SELECT count(CORRSCH_ID) AS nOccs FROM " + this.sbdb.DBTableName("CHTLN_UNIT") + " WHERE igd_id=" + this.getUnitID();
                    ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                    if (rs.next()) {
                        this.nCorrOccs = rs.getInt("nOccs");
                    }
                }
            }
        }
        return this.nCorrOccs;
    }

    public List<String> getOccs() throws SQLException, SBException {
        ArrayList<String> occs;
        if (this.sbdb == null || !this.sbdb.isConnected()) {
            throw new SBException("Attempt to get occurrences when connection is: " + this.sbdb);
        }
        String sql = "SELECT DISTINCT v.well_id,w.well_name,v.well_code FROM " + this.sbdb.DBTableName(this instanceof LithostratUnit ? "IGD_LSTRAT" : "IGD") + " i," + this.sbdb.DBTableName("WELL_IDENT") + " v," + this.sbdb.DBTableName("WELLS") + " w WHERE (i.upp_zone=" + this.getUnitID() + " OR i.low_zone=" + this.getUnitID() + ") AND i.well_id=v.well_id AND v.well_code=w.well_code ORDER BY well_name";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            occs = new ArrayList<String>();
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                occs.add(rs.getString("well_name") + "(" + rs.getString("well_code") + ")");
            }
        }
        return occs;
    }

    public void setNoccs(int i) {
        this.nOccs = i;
    }

    abstract void writeXML(BufferedWriter var1, int var2, int var3, List<IGDUnitBase> var4) throws IOException;

    abstract void writeDEX(FileWriter var1, String var2, int var3) throws IOException;

    IGDUnitBase(Builder builder, int schID, int ID) {
        this.sbdb = builder.sbdb;
        this.unitID = ID;
        this.schID = schID;
        this.hier = builder.hier;
        this.name = builder.name;
        this.audit = builder.audit;
        this.status = builder.status;
    }

    public static abstract class Builder
    implements IGDUnitClass {
        final SBdb sbdb;
        private int hier;
        private String name = "";
        private Audit audit = new Audit();
        Color status = SbugsStatus.UNKNOWN;
        private int nOccs;

        Builder(SBdb sbdb) {
            if (sbdb == null) {
                throw new IllegalArgumentException("Illegal argument to IGDUnit.Builder: sbdb must not be null");
            }
            this.sbdb = sbdb;
        }

        public Builder hier(int hier) {
            if (hier > 0) {
                this.hier = hier;
            }
            return this;
        }

        public Builder name(String name) {
            if (name != null) {
                if (name.length() > 80) {
                    name = name.substring(0, 80);
                }
                this.name = name.trim().replaceAll("\\s+", " ");
            } else {
                this.name = "";
            }
            return this;
        }

        public Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        Builder status(Color status) {
            if (status != null) {
                this.status = status;
            }
            return this;
        }

        void validateFields() {
            if (this.name.isEmpty()) {
                throw new IllegalStateException("Attempt to build IGD Unit with empty name");
            }
            if (this.hier < 1) {
                throw new IllegalStateException("Attempt to build IGD Unit '" + this.name + "' with illegal hierarchy: " + this.hier);
            }
            if (this.getUage() > this.getLage()) {
                throw new IllegalStateException("Attempt to build IGD Unit '" + this.name + "' with upper age greater than lower age");
            }
        }

        IGDUnitBase build(int ID, int schID) {
            if (ID <= 0) {
                throw new IllegalArgumentException("Cannot build IGDUnit with ID " + ID);
            }
            if (schID <= 0) {
                throw new IllegalArgumentException("Cannot build IGDUnit with schID " + ID);
            }
            try {
                this.validateFields();
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(e.getMessage() + " (scheme ID: " + schID + ")");
            }
            if (this.status == SbugsStatus.UNKNOWN) {
                System.out.println("WARNING: building IGDUnit with unknown status...");
            }
            return this.buildThis(ID, schID);
        }

        abstract IGDUnitBase buildThis(int var1, int var2);

        abstract IGDUnitBase store(int var1, int var2) throws SQLException, SBException;

        public static Builder copyOf(IGDUnitBase base, SBdb sbdb) throws SQLException, SBException {
            Builder builder;
            if (base instanceof IGDUnit) {
                IGDUnit unit = (IGDUnit)base;
                IGDUnit.Builder b = new IGDUnit.Builder(sbdb, unit);
                b.age(true, new IGDAge(unit.getUigdAge()));
                b.age(false, new IGDAge(unit.getLigdAge()));
                b.abr(unit.getAbr()).colour(unit.getColour());
                b.comments(unit.getComments());
                builder = b;
            } else if (base instanceof Chron) {
                Chron chron = (Chron)base;
                builder = new Chron.Builder(sbdb, chron).polarity(chron.getPolarity()).uAge(chron.getUage()).lAge(chron.getLage());
            } else if (base instanceof LithostratUnit) {
                LithostratUnit lu = (LithostratUnit)base;
                LithostratUnit.Builder b = new LithostratUnit.Builder(sbdb, lu);
                b.age(lu.getAges()).x(lu.getXs()).colour(lu.getColour()).abr(lu.getAbr()).lithology(lu.getLithology()).bnd(true, lu.getUBnd().getBndInt()).bnd(false, lu.getLBnd().getBndInt());
                builder = b;
            } else {
                throw new IllegalArgumentException("Can't copy IGDUnitBase: " + base);
            }
            builder.hier(base.getHier()).name(base.getName()).audit(new Audit(base.getAudit()));
            builder.status = SbugsStatus.STORED;
            if (builder.sbdb != base.sbdb && !base.sbdb.isConnected() && builder.sbdb.isConnected()) {
                builder.audit(new Audit(builder.sbdb, base.sbdb, base.getAudit()));
            }
            return builder;
        }

        public abstract int getOriginalID();

        @Override
        public abstract Color getColour();

        @Override
        public String getSortEntry() {
            return IGDUnitBase.getSortEntry(this.getUage(), this.getLage(), this.hier, this.name);
        }

        public void setNOccs(int nOccs) {
            this.nOccs = nOccs;
        }

        @Override
        public int getHier() {
            return this.hier;
        }

        @Override
        public String getName() {
            return this.name;
        }

        SBdb getModel() {
            return this.sbdb;
        }

        Audit getAudit() {
            return this.audit;
        }

        public Date getModified() {
            return this.audit.modified;
        }

        public String getModifier() {
            try {
                if (this.audit.modifier > 0) {
                    return this.sbdb.getUser(this.audit.modifier).getAbr();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return "";
        }

        public String toString() {
            return this.name;
        }

        public int getNOccs() {
            return this.nOccs;
        }
    }
}

