/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import model2_1.Audit;
import model2_1.SBRestrictable;
import model2_1.SBdb;
import model2_1.Taxon;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class Overlay
extends Observable
implements Comparable {
    private int nRows;
    private int nCols;
    private final SBdb db;
    private int ovrID;
    private String name;
    private String descrip;
    private Audit audit = new Audit();
    private int[][] specIDs;
    private boolean[][] selected;
    private boolean loaded = false;
    private boolean mapChanged = false;
    private boolean maximiseText = true;
    private boolean useCodes = true;
    private boolean showImages = false;

    private Overlay(SBdb sbdb, int key) throws SQLException {
        this.ovrID = key;
        this.db = sbdb;
        String sql = "SELECT name,descrip,ovrows,ovcolumns,maxtext,usecodes," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("overlay") + " WHERE ovr_id=" + key;
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            if (rs.next()) {
                this.name = rs.getString("name");
                this.descrip = rs.getString("descrip");
                this.nRows = rs.getInt("ovrows");
                if (this.nRows == 0) {
                    this.nRows = 15;
                }
                this.nCols = rs.getInt("ovcolumns");
                if (this.nCols == 0) {
                    this.nCols = 16;
                }
                this.maximiseText = rs.getBoolean("maxtext");
                this.useCodes = rs.getBoolean("usecodes");
                this.audit = new Audit(rs);
            }
        }
    }

    private Overlay(SBdb db, int ovrID, String name, String descrip, int nRows, int nCols, boolean maximiseText, boolean useCodes, Audit audit) {
        this.db = db;
        this.ovrID = ovrID;
        this.name = name;
        this.descrip = descrip;
        this.nRows = nRows;
        this.nCols = nCols;
        this.maximiseText = maximiseText;
        this.useCodes = useCodes;
        this.audit = audit;
    }

    public Overlay(SBdb db, String name, String descrip, int nRows, int nCols, boolean maximiseText, boolean useCodes) throws SQLException, SBException, SBPermissionException {
        this.db = db;
        this.name = name;
        this.descrip = descrip;
        this.nRows = nRows;
        this.nCols = nCols;
        this.maximiseText = maximiseText;
        this.useCodes = useCodes;
        this.store();
    }

    public boolean mapChanged() {
        return this.mapChanged;
    }

    public int getSpecID(int row, int col) throws SQLException {
        if (!this.loaded) {
            this.load();
        }
        return this.specIDs[row][col];
    }

    public String toString() {
        return this.name;
    }

    public int getCols() {
        return this.nCols;
    }

    public int getRows() {
        return this.nRows;
    }

    public boolean getMaximiseText() {
        return this.maximiseText;
    }

    public boolean useCodes() {
        return this.useCodes;
    }

    public void reload() throws SQLException {
        this.loaded = false;
        this.load();
    }

    public void load() throws SQLException {
        if (!this.loaded) {
            this.specIDs = new int[this.nRows][this.nCols];
            this.selected = new boolean[this.nRows][this.nCols];
            String sql = "SELECT ovrow,ovcol,spec_id FROM " + this.db.DBTableName("ovr_map") + " WHERE ovr_id=" + this.ovrID;
            try (Statement stmt = this.db.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
                while (rs.next()) {
                    int row = rs.getInt("ovrow");
                    int col = rs.getInt("ovcol");
                    int specID = rs.getInt("spec_id");
                    if (row < 0 || col < 0 || specID <= 0) continue;
                    this.specIDs[row][col] = specID;
                    this.selected[row][col] = false;
                }
            }
            this.loaded = true;
            this.mapChanged = false;
        }
    }

    private void store() throws SQLException, SBException, SBPermissionException {
        if (this.db != null && this.db.isConnected()) {
            if (!SBRestrictable.canWrite(this.db)) {
                throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
            }
            try (Statement stmt = this.db.getDatabase().createStatement();){
                if (this.ovrID > 0) {
                    throw new SBException("Atempt to add existing overlay - use update()");
                }
                int tempOvrID = this.db.nextControl("overlay", "ovr_id");
                String sql = "INSERT INTO " + this.db.DBTableName("overlay") + " (ovr_id,name,descrip,ovrows,ovcolumns,maxtext,usecodes," + Audit.sqlFieldString() + ") VALUES (" + tempOvrID + "," + SB.DBString((String)this.name) + "," + SB.DBString((String)this.descrip) + "," + this.nRows + "," + this.nCols + "," + (this.maximiseText ? 1 : 0) + "," + (this.useCodes ? 1 : 0) + "," + this.audit.sqlInsert(this.db, stmt) + ")";
                stmt.executeUpdate(this.db.modQuery(sql));
                this.ovrID = tempOvrID;
            }
        }
    }

    public void update(String name, String descrip, int nRows, int nCols, boolean maximiseText, boolean useCodes) throws SQLException, SBException, SBPermissionException {
        if (this.db != null && this.db.isConnected()) {
            Audit tempAudit;
            if (!SBRestrictable.canWrite(this.db)) {
                throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
            }
            try (Statement stmt = this.db.getDatabase().createStatement();){
                tempAudit = new Audit(this.audit);
                if (this.ovrID == 0) {
                    throw new SBException("Attempt to update overlay - use add()");
                }
                String sql = "SELECT ovr_id FROM " + this.db.DBTableName("overlay") + " WHERE name=" + SB.DBString((String)name) + " AND ovr_id <> " + this.ovrID;
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
                if (rs.next()) {
                    stmt.close();
                    throw new SBException("New overlay name aleady exists");
                }
                this.setMap(nRows, nCols);
                sql = "UPDATE " + this.db.DBTableName("overlay") + " SET name=" + SB.DBString((String)name) + ",descrip=" + SB.DBString((String)descrip) + ",ovrows=" + nRows + ",ovcolumns=" + nCols + ",maxtext=" + (maximiseText ? 1 : 0) + ",usecodes=" + (useCodes ? 1 : 0) + "," + tempAudit.sqlUpdate(this.db, stmt, false) + " WHERE ovr_id=" + this.ovrID;
                stmt.executeUpdate(this.db.modQuery(sql));
            }
            this.audit = tempAudit;
            this.name = name;
            this.descrip = descrip;
            this.maximiseText = maximiseText;
            this.useCodes = useCodes;
            this.setChanged();
        }
    }

    public void setMap(int nRows, int nCols) throws SBException {
        if (!this.checkCapacity(nRows, nCols)) {
            throw new SBException("Attempt to resize overlay without capacity for existing taxa.");
        }
        int[][] tempSpec = new int[nRows][nCols];
        for (int row = 0; row < this.nRows && row < nRows; ++row) {
            for (int col = 0; col < this.nCols && col < nCols; ++col) {
                tempSpec[row][col] = this.specIDs[row][col];
            }
        }
        this.nRows = nRows;
        this.nCols = nCols;
        this.specIDs = tempSpec;
        this.selected = new boolean[nRows][nCols];
    }

    public void storeMap() throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.db)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        String psql = "INSERT INTO " + this.db.DBTableName("ovr_map") + " (ovr_id,ovrow,ovcol,spec_id) VALUES (" + this.ovrID + ",?,?,?)";
        try (Statement stmt = this.db.getDatabase().createStatement();
             PreparedStatement pStmt = this.db.getDatabase().prepareStatement(psql);){
            String sql = "DELETE FROM " + this.db.DBTableName("ovr_map") + " WHERE ovr_id=" + this.ovrID;
            stmt.executeUpdate(this.db.modQuery(sql));
            for (int row = 0; row < this.nRows; ++row) {
                for (int col = 0; col < this.nCols; ++col) {
                    int specID = this.specIDs[row][col];
                    if (specID <= 0) continue;
                    pStmt.setInt(1, row);
                    pStmt.setInt(2, col);
                    pStmt.setInt(3, specID);
                    pStmt.executeUpdate();
                }
            }
        }
        this.mapChanged = false;
    }

    public Taxon getTaxon(int row, int col) throws SQLException {
        if (!this.loaded) {
            this.load();
        }
        if (this.specIDs[row][col] > 0) {
            return this.db.getTaxon(this.specIDs[row][col]);
        }
        return null;
    }

    public static HashMap<Integer, Overlay> loadAll(SBdb db) throws SQLException {
        HashMap<Integer, Overlay> overlays = new HashMap<Integer, Overlay>();
        String sql = "SELECT ovr_id,name,descrip,ovrows,ovcolumns,maxtext,usecodes," + Audit.sqlFieldString() + " FROM " + db.DBTableName("overlay");
        try (Statement stmt = db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                int nCols;
                int ovrID = rs.getInt("ovr_id");
                String name = rs.getString("name");
                String descrip = rs.getString("descrip");
                int nRows = rs.getInt("ovrows");
                if (nRows == 0) {
                    nRows = 15;
                }
                if ((nCols = rs.getInt("ovcolumns")) == 0) {
                    nCols = 16;
                }
                boolean maximumText = rs.getBoolean("maxtext");
                boolean useCodes = rs.getBoolean("usecodes");
                Audit audit = new Audit(rs);
                overlays.put(ovrID, new Overlay(db, ovrID, name, descrip, nRows, nCols, maximumText, useCodes, audit));
            }
        }
        return overlays;
    }

    static void refresh(SBdb SB2, Statement stmt, HashMap<Integer, Overlay> overlays) throws SQLException, SBException {
        Object sql = "SELECT ovr_id,updated ";
        sql = (String)sql + " FROM " + SB2.DBTableName("overlay");
        sql = SB2.modQuery((String)sql);
        ResultSet rs = stmt.executeQuery((String)sql);
        Overlay notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        while (rs.next()) {
            int key = rs.getInt("ovr_id");
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (Overlay o : overlays.values()) {
                if (o.getOvrID() != key) continue;
                found = true;
                if (time == null || o.getUpdated() != null && !time.after(o.getUpdated())) break;
                Overlay overlay = new Overlay(SB2, key);
                o.copy(overlay);
                notifier = o;
                break;
            }
            if (found) continue;
            notifier = new Overlay(SB2, key);
            overlays.put(key, notifier);
        }
        if (keys.size() < overlays.size()) {
            Iterator<Overlay> it = overlays.values().iterator();
            while (it.hasNext()) {
                Overlay o = it.next();
                if (keys.contains(o.getOvrID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        if (notifier != null) {
            notifier.changeNotify();
        }
    }

    public int getOvrID() {
        return this.ovrID;
    }

    public String getName() {
        return this.name;
    }

    public String getDescrip() {
        return this.descrip;
    }

    private void changeNotify() {
        this.setChanged();
        this.notifyObservers();
    }

    private void copy(Overlay rhs) {
        this.ovrID = rhs.ovrID;
        this.nCols = rhs.nCols;
        this.nRows = rhs.nRows;
        this.name = rhs.name;
        this.descrip = rhs.descrip;
        this.maximiseText = rhs.maximiseText;
        this.useCodes = rhs.useCodes;
        this.audit = new Audit(rhs.audit);
    }

    private Date getUpdated() {
        return this.audit.updated;
    }

    public boolean checkCapacity(int rows, int columns) {
        if (rows >= this.nRows && columns >= this.nCols) {
            return true;
        }
        for (int row = 0; row < this.nRows; ++row) {
            for (int col = 0; col < this.nCols; ++col) {
                if (this.specIDs[row][col] <= 0 || row < rows && col < columns) continue;
                return false;
            }
        }
        return true;
    }

    void delete() throws SQLException, SBException, SBPermissionException {
        if (this.db == null || !this.db.isConnected()) {
            throw new SBException("Attempt to delete overlay with null or isconnected database.");
        }
        if (this.ovrID <= 0) {
            throw new SBException("Attempt to delete overlay with zero overlay ID.");
        }
        if (!SBRestrictable.canWrite(this.db)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = this.db.getDatabase().createStatement();){
            String sql = "DELETE FROM " + this.db.DBTableName("ovr_map") + " WHERE ovr_id=" + this.ovrID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "DELETE FROM " + this.db.DBTableName("overlay") + " WHERE ovr_id=" + this.ovrID;
            stmt.executeUpdate(this.db.modQuery(sql));
        }
    }

    public void setCell(int specID, int row, int col) throws SBException {
        if (row >= this.nRows || col >= this.nCols) {
            throw new SBException("Attempt to set cell (" + row + "," + col + ") outside range: " + this.nRows + "," + this.nCols);
        }
        this.specIDs[row][col] = specID;
        this.setChanged();
        this.mapChanged = true;
    }

    public boolean hasSpecID(int specID) {
        if (specID == 0) {
            return false;
        }
        for (int row = 0; row < this.nRows; ++row) {
            for (int col = 0; col < this.nCols; ++col) {
                if (this.specIDs[row][col] != specID) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean getSelection(int row, int col) {
        if (!this.loaded) {
            try {
                this.load();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.selected[row][col];
    }

    public void setSelection(int row, int col, boolean which) {
        this.selected[row][col] = which;
    }

    public void clearSelection() {
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                this.selected[r][c] = false;
            }
        }
    }

    public boolean[][] getSelectionArrayCopy() {
        boolean[][] selectedCopy = new boolean[this.selected.length][];
        for (int i = 0; i < this.selected.length; ++i) {
            selectedCopy[i] = (boolean[])this.selected[i].clone();
        }
        return selectedCopy;
    }

    public void setSelectionArray(boolean[][] newSelection) {
        int i;
        boolean wrongSize = false;
        if (newSelection.length != this.selected.length) {
            wrongSize = true;
        }
        if (!wrongSize) {
            for (i = 0; i < this.selected.length; ++i) {
                if (this.selected[i].length == newSelection[i].length) continue;
                wrongSize = true;
                break;
            }
        }
        if (wrongSize) {
            throw new IllegalArgumentException("newSelection array is different size to selection.");
        }
        for (i = 0; i < this.selected.length; ++i) {
            for (int j = 0; j < this.selected[i].length; ++j) {
                this.selected[i][j] = newSelection[i][j];
            }
        }
    }

    public void clearSelected() {
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                if (!this.selected[r][c]) continue;
                this.specIDs[r][c] = 0;
            }
        }
    }

    public void setImages(boolean selected) {
        this.showImages = selected;
    }

    public boolean showImages() {
        return this.showImages;
    }

    public void autoArrange(boolean byRow) {
        int[] specIDtemp = new int[this.nRows * this.nCols];
        int nTaxa = 0;
        if (byRow) {
            for (int r = 0; r < this.nRows; ++r) {
                for (int c = 0; c < this.nCols; ++c) {
                    if (this.specIDs[r][c] <= 0) continue;
                    specIDtemp[nTaxa++] = this.specIDs[r][c];
                }
            }
            int i = 0;
            for (int r = 0; r < this.nRows; ++r) {
                for (int c = 0; c < this.nCols; ++c) {
                    this.specIDs[r][c] = i < nTaxa ? specIDtemp[i++] : 0;
                }
            }
        } else {
            for (int c = 0; c < this.nCols; ++c) {
                for (int r = 0; r < this.nRows; ++r) {
                    if (this.specIDs[r][c] <= 0) continue;
                    specIDtemp[nTaxa++] = this.specIDs[r][c];
                }
            }
            int i = 0;
            for (int c = 0; c < this.nCols; ++c) {
                for (int r = 0; r < this.nRows; ++r) {
                    this.specIDs[r][c] = i < nTaxa ? specIDtemp[i++] : 0;
                }
            }
        }
    }

    public int compareTo(Object o) {
        if (o instanceof Overlay) {
            Overlay rhs = (Overlay)o;
            return this.name.compareToIgnoreCase(rhs.name);
        }
        return 0;
    }

    public void clearTaxon(int specID) {
        for (int c = 0; c < this.nCols; ++c) {
            for (int r = 0; r < this.nRows; ++r) {
                if (this.specIDs[r][c] != specID) continue;
                this.specIDs[r][c] = 0;
            }
        }
    }

    void replaceSpecID(int donor, int target) {
        for (int c = 0; c < this.nCols; ++c) {
            for (int r = 0; r < this.nRows; ++r) {
                if (this.specIDs[r][c] != donor) continue;
                this.specIDs[r][c] = target;
                this.setChanged();
            }
        }
    }
}

