/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model2_1.Audit;
import model2_1.SBRestrictable;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.Taxon;
import model2_1.Userdef;
import model2_1.WellHeader;
import model2_1.WellInterp;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsLink;
import util.status.SbugsStatus;

public class SBEvent
extends Observable
implements SbugsStatus,
SbugsLink,
Comparable {
    private final SBdb sbdb;
    private final int evID;
    private String name = "";
    private String abr;
    private Taxon taxon = null;
    private boolean isSingle = false;
    private boolean generate = false;
    private char evExtent;
    private String evDesc;
    private Audit audit;
    private SBEvent link = null;
    private Color status = UNKNOWN;
    private int nOccs = -1;
    public static final float SMALL = 1.0E-5f;

    public SBdb getDatabase() {
        return this.sbdb;
    }

    void writeDEX(FileWriter out, String eol, SimpleDateFormat df, boolean includeCompositeInfo) throws IOException {
        out.write("Event = " + this.toString() + eol);
        out.write("   ID : " + this.evID + eol);
        if (this.taxon != null) {
            out.write("Species id : " + this.taxon.getSpecID() + eol);
        }
        out.write("Paired : " + (this.isSingle ? "false" : "true") + eol);
        if (this.generate) {
            out.write("   Use as top or base : true" + eol);
        }
        if (this.evExtent != ' ' && this.evExtent > '\u0000') {
            out.write("   Extent : " + this.evExtent + eol);
        }
        if (this.evDesc != null && this.evDesc.length() > 0) {
            out.write("   Description : " + this.evDesc + eol);
        }
        out.write("   Created : " + df.format(this.audit.created) + eol);
        out.write("   Creator : " + this.audit.creator + eol);
        out.write(eol);
    }

    public void writeXML(BufferedWriter out, int indent) throws IOException {
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        out.write("<Event Name=\"" + SB.getXMLstring((String)this.getName()) + "\">\n");
        out.write((String)ind + "<Name>" + SB.getXMLstring((String)this.getName()) + "</Name>\n");
        if (this.abr != null) {
            out.write((String)ind + "<Abbreviation>" + SB.getXMLstring((String)this.abr) + "</Abbreviation>\n");
        }
        out.write((String)ind + "<ID>" + this.evID + "</ID>\n");
        if (this.taxon != null) {
            out.write((String)ind + "<SpeciesID>" + this.taxon.getSpecID() + "</SpeciesID>\n");
        }
        out.write((String)ind + "<Paired>" + Boolean.toString(!this.isSingle) + "</Paired>\n");
        out.write((String)ind + "<Generate>" + Boolean.toString(this.generate) + "</Generate>\n");
        if (this.evExtent != ' ' && this.evExtent > '\u0000') {
            out.write((String)ind + "<Extent>" + this.evExtent + "</Extent>\n");
        }
        if (this.evDesc != null && this.evDesc.length() > 0) {
            out.write((String)ind + "<Description>" + SB.getXMLstring((String)this.evDesc) + "</Description>\n");
        }
        this.audit.writeXML(out, indent);
        out.write("</Event>\n");
    }

    static void loadAll(SBdb sbdb, List list, int projectID) throws SQLException {
        String sql = "SELECT e.ev_id,e.name,e.spec_id,e.ev_type,e.generate,e.ev_extent,e.ev_desc,e.abr," + Audit.sqlFieldString("e");
        sql = sql + " FROM " + sbdb.DBTableName("EVENTDIC") + " e";
        if (projectID > 0) {
            sql = sql + ", " + sbdb.DBTableName("EVENTS") + " we, " + sbdb.DBTableName("SBWLMB") + " p WHERE e.ev_id=we.ev_id AND p.well_id=we.well_id AND p.ID=" + projectID;
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                String type;
                Builder builder = new Builder();
                int ID = rs.getInt("ev_id");
                builder.name(rs.getString("name"));
                int specID = rs.getInt("spec_id");
                if (specID > 0) {
                    builder.taxon(sbdb.getTaxon(specID));
                }
                builder.isSingle(!(type = rs.getString("ev_type").trim()).isEmpty() && type.charAt(0) == 'S');
                String generate = rs.getString("generate");
                builder.isGenerate(generate != null && !generate.trim().isEmpty() && generate.trim().charAt(0) == 'Y');
                builder.evExtent(SB.getDBChar((ResultSet)rs, (String)"ev_extent"));
                builder.desc(rs.getString("ev_desc"));
                builder.abr(rs.getString("abr"));
                builder.audit(new Audit(rs, "e"));
                SBEvent event = builder.build(ID, sbdb);
                event.status = STORED;
                list.add(event);
            }
        }
    }

    public static int getSBEventSQL(SBdb db, String name) throws SQLException {
        String sql = "SELECT ev_id FROM " + db.DBTableName("EVENTDIC") + " WHERE ucase(name)=" + SB.DBString((String)name.trim().toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5'));
        try (Statement stmt = db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            if (rs.next()) {
                int n = rs.getInt("ev_id");
                return n;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SBEvent load(SBdb sbdb, int evID, Statement statement, SBEvent event) throws SQLException {
        if (event != null && event.getEvID() != evID) {
            throw new IllegalArgumentException("Attempt to refresh sbEvent with incorrect ID");
        }
        String sql = "SELECT name,spec_id,ev_type,generate,ev_extent,ev_desc,abr," + Audit.sqlFieldString();
        sql = sql + " FROM " + sbdb.DBTableName("EVENTDIC") + " WHERE ev_id=" + evID;
        Statement stmt = statement == null ? sbdb.getDatabase().createStatement() : statement;
        try {
            Builder builder = new Builder();
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                String type;
                builder.name(rs.getString("name"));
                int specID = rs.getInt("spec_id");
                if (specID > 0) {
                    builder.taxon(sbdb.getTaxon(specID));
                }
                builder.isSingle(!(type = rs.getString("ev_type").trim()).isEmpty() && type.charAt(0) == 'S');
                String generate = rs.getString("generate");
                builder.isGenerate(generate != null && !generate.trim().isEmpty() && generate.trim().charAt(0) == 'Y');
                builder.evExtent(SB.getDBChar((ResultSet)rs, (String)"ev_extent"));
                builder.desc(rs.getString("ev_desc"));
                builder.abr(rs.getString("abr"));
                builder.audit(new Audit(rs));
                if (event == null) {
                    event = builder.build(evID, sbdb);
                    event.status = STORED;
                    SBEvent sBEvent = event;
                    return sBEvent;
                }
                event.name = builder.name;
                event.taxon = builder.taxon;
                event.isSingle = builder.isSingle;
                event.generate = builder.generate;
                event.evExtent = builder.evExtent;
                event.evDesc = builder.evDesc;
                event.abr = builder.abr;
                event.audit = builder.audit;
                event.setChanged();
                SBEvent sBEvent = event;
                return sBEvent;
            }
        }
        finally {
            if (statement == null) {
                stmt.close();
            }
        }
        return null;
    }

    public String statusString() {
        return this.toString(false, false);
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean abr) {
        return this.toString(abr, false);
    }

    public String toString(boolean abr, boolean useName) {
        if (abr && this.abr != null) {
            if (useName) {
                return this.name + " " + this.abr;
            }
            return this.abr;
        }
        return this.name;
    }

    public Color getStatus() {
        if (this.link != null) {
            this.status = STORED;
        }
        return this.status;
    }

    Date getUpdated() {
        return new Date(this.audit.updated.getTime());
    }

    void updateName(String name) throws SQLException, SBPermissionException {
        if (name.equals(this.name)) {
            return;
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        if (SBEvent.lookup(this.sbdb, name, 0, false) != null) {
            return;
        }
        Audit temp = new Audit(this.audit);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("EVENTDIC") + " SET name=" + SB.DBString((String)name) + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE ev_id=" + this.evID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.name = name;
        this.audit = temp;
        this.setChanged();
    }

    private void storeDB() throws SQLException, SBPermissionException {
        if (this.sbdb == null || !this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to store SBEvent in unconnected data model");
        }
        if (this.evID <= 0) {
            throw new IllegalStateException("Attempt to store SBEvent with illegal evID: " + this.evID);
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "INSERT INTO " + this.sbdb.DBTableName("EVENTDIC") + " (ev_id,";
            if (this.taxon != null) {
                sql = sql + "spec_id,";
            }
            sql = sql + "name,ev_type,generate,ev_extent,ev_desc,abr," + Audit.sqlFieldString() + ") VALUES (" + this.evID + ",";
            if (this.taxon != null) {
                sql = sql + this.taxon.getSpecID() + ",";
            }
            sql = sql + SB.DBString((String)this.name.trim()) + "," + (this.isSingle ? "'S'" : "'R'") + "," + (this.generate ? "'Y'" : "'N'") + "," + SB.DBChar((char)this.evExtent) + "," + SB.DBString((String)this.evDesc) + "," + (this.abr != null ? SB.DBString((String)this.abr) : "NULL") + "," + this.audit.sqlInsert(this.sbdb, stmt);
            sql = sql + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.status = STORED;
    }

    static SBEvent lookup(SBdb sbdb, String name, int specID, Boolean generate) throws SQLException {
        if ((name == null || name.isEmpty()) && specID <= 0) {
            throw new IllegalArgumentException("Attempt to lookup event with no name or specID");
        }
        String sql = "SELECT ev_id,name,spec_id,ev_type,generate,ev_extent,ev_desc,abr," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("EVENTDIC") + " WHERE ";
        if (name != null && !name.isEmpty()) {
            sql = sql + "(name=" + SB.DBString((String)name.trim()) + " OR ucase(name)=" + SB.DBString((String)name.trim().toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5')) + ")";
            if (specID > 0) {
                sql = sql + " AND ";
            }
        }
        if (specID > 0) {
            sql = sql + " spec_id=" + specID;
        }
        if (generate != null) {
            sql = sql + " AND generate=" + (generate != false ? "'Y'" : "'N'");
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                String type;
                Builder builder = new Builder();
                int ID = rs.getInt("ev_id");
                builder.name(rs.getString("name"));
                int speciesID = rs.getInt("spec_id");
                if (speciesID > 0) {
                    builder.taxon(sbdb.getTaxon(speciesID));
                }
                builder.isSingle(!(type = rs.getString("ev_type").trim()).isEmpty() && type.charAt(0) == 'S');
                String gen = rs.getString("generate");
                builder.isGenerate(gen != null && !gen.trim().isEmpty() && gen.trim().charAt(0) == 'Y');
                builder.evExtent(SB.getDBChar((ResultSet)rs, (String)"ev_extent"));
                builder.desc(rs.getString("ev_desc"));
                builder.abr(rs.getString("abr"));
                builder.audit(new Audit(rs));
                SBEvent event = builder.build(ID, sbdb);
                event.status = STORED;
                SBEvent sBEvent = event;
                return sBEvent;
            }
        }
        return null;
    }

    public int getSingleUpdates(boolean changeToSingle) throws SQLException {
        int count = 0;
        if (!this.isSingle && changeToSingle) {
            String sql = "SELECT count(ev_id) as nOcc FROM " + this.sbdb.DBTableName("EVENTS") + " WHERE ev_id=" + this.evID + " AND ev_type='L'";
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    count = rs.getInt("nOcc");
                }
            }
        }
        return count;
    }

    public void updateSingle(boolean changeToSingle) throws SQLException {
        if (this.isSingle && changeToSingle) {
            return;
        }
        if (!this.isSingle && !changeToSingle) {
            return;
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql;
            if (changeToSingle) {
                sql = "DELETE FROM " + this.sbdb.DBTableName("EVENTS") + " WHERE ev_id=" + this.evID + " AND ev_type='L'";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            sql = "UPDATE " + this.sbdb.DBTableName("EVENTS") + " SET ev_type='" + (changeToSingle ? " " : "F") + "'," + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE ev_id=" + this.evID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("EVENTDIC") + " SET ev_type='" + (changeToSingle ? "S" : "R") + "'," + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE ev_id=" + this.evID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("CMPSTDEV") + " SET ev_type='" + (changeToSingle ? " " : "F") + "'," + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE ev_id=" + this.evID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.isSingle = changeToSingle;
        this.sbdb.getDatabase().commit();
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkGenerateUnique(Taxon taxon) throws GenerateUniqueException, SQLException {
        if (taxon == null) {
            return;
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT name FROM " + this.sbdb.DBTableName("EVENTDIC") + " WHERE ev_id <> " + this.evID + " AND spec_id=" + taxon.getSpecID() + " AND generate='Y'";
        String existingName = null;
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                existingName = rs.getString("name").trim();
            }
        }
        finally {
            stmt.close();
        }
        if (existingName != null) {
            throw new GenerateUniqueException("Cannot set 'generate' attribute, currently set for event: " + existingName);
        }
    }

    void delete() throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "DELETE FROM " + this.sbdb.DBTableName("CHTLN_EV") + " WHERE ev_id=" + this.evID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("EVLOAD") + " WHERE ev_id=" + this.evID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("EVENTS") + " WHERE ev_id=" + this.evID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("CMPSTDEV") + " WHERE ev_id=" + this.evID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("EVENTDIC") + " WHERE ev_id=" + this.evID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.setChanged();
    }

    public int compareTo(Object rhsObj) {
        SBEvent rhs = (SBEvent)rhsObj;
        String s1 = this.name;
        String s2 = rhs.name;
        if (this.taxon != null) {
            s1 = this.taxon.toString(false, false);
        }
        if (rhs.taxon != null) {
            s2 = rhs.taxon.toString(false, false);
        }
        return s1.compareTo(s2);
    }

    public int getEvID() {
        return this.evID;
    }

    public Audit getAudit() {
        return new Audit(this.audit);
    }

    public int getSpecID() {
        if (this.taxon != null) {
            return this.taxon.getSpecID();
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public String getDictionaryName() {
        if (this.taxon != null && this.taxon.toString().equals(this.name)) {
            return "";
        }
        return this.name;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    void setSingle(boolean b) throws SBException {
        if (this.sbdb.isConnected()) {
            throw new SBException("Attempt to set isSingle on non-workspace SBEvent" + this.name);
        }
        this.isSingle = b;
    }

    public boolean isGenerate() {
        return this.generate;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public String getEvDesc() {
        return this.evDesc;
    }

    public String getAbr() {
        return this.abr;
    }

    public Taxon getTaxon() {
        return this.taxon;
    }

    public String getCatMnem() {
        if (this.taxon == null) {
            return null;
        }
        return this.taxon.getCatMnem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNoccs(boolean refresh) throws SQLException {
        if (this.nOccs < 0 || refresh) {
            this.nOccs = 0;
            String sql = "SELECT count(samp_id) AS nOccs FROM " + this.sbdb.DBTableName("EVENTS") + " WHERE ev_id=" + this.evID;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    this.nOccs = rs.getInt("nOccs");
                }
            }
        }
        return this.nOccs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNcmpStdOccs() throws SQLException {
        int n = 0;
        String sql = "SELECT count(std_id) AS nOccs FROM " + this.sbdb.DBTableName("CMPSTDEV") + " WHERE ev_id=" + this.evID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                n = rs.getInt("nOccs");
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNcorrOccs() throws SQLException {
        int n = 0;
        String sql = "SELECT count(CORRSCH_ID) AS nOccs FROM " + this.sbdb.DBTableName("CHTLN_EV") + " WHERE ev_id=" + this.evID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                n = rs.getInt("nOccs");
            }
        }
        return n;
    }

    public List<WellEventQueryResult> getWellOccs() throws SQLException, SBException {
        return this.getWellOccs(-1, -1);
    }

    public List<WellEventQueryResult> getWellOccs(int filterInterpID, int projID) throws SQLException, SBException {
        LinkedList<WellEventQueryResult> results = new LinkedList<WellEventQueryResult>();
        Object sql = "SELECT e.well_id,e.interp_id,i.descrip,e.samp_id,e.ev_type,w.well_name,w.units,w.type FROM ";
        sql = (String)sql + this.sbdb.DBTableName("EVENTS") + " e," + this.sbdb.DBTableName("INTERP") + " i," + this.sbdb.DBTableName("WELLS") + " w," + this.sbdb.DBTableName("WELL_IDENT") + " wi";
        if (projID > 0) {
            sql = (String)sql + "," + this.sbdb.DBTableName("SBWLMB") + " wl";
        }
        sql = (String)sql + " WHERE e.ev_id=" + this.evID + " AND e.interp_id=i.interp_id";
        if (filterInterpID >= 0) {
            sql = (String)sql + " AND i.interp_id=" + filterInterpID;
        }
        sql = (String)sql + " AND e.well_id=wi.well_id AND wi.well_code=w.well_code";
        if (projID > 0) {
            sql = (String)sql + " AND wi.well_id=wl.well_id AND wl.id=" + projID;
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                int interpID = rs.getInt("interp_id");
                String interpName = rs.getString("descrip");
                int sampID = rs.getInt("samp_id");
                char eventOccType = SB.getDBChar((ResultSet)rs, (String)"ev_type");
                String wellName = rs.getString("well_name");
                char units = SB.getDBChar((ResultSet)rs, (String)"units");
                char sectionType = SB.getDBChar((ResultSet)rs, (String)"type");
                Sample sample = Sample.load(this.sbdb, wellID, sampID, WellHeader.SectionType.getSectionType(sectionType), null);
                sample.displayUnits = units;
                WellEventQueryResult result = new WellEventQueryResult(wellID, interpID, eventOccType, wellName, interpName, sample);
                results.add(result);
            }
        }
        return results;
    }

    public static double[] getAgeStats(SBdb db, EventType eventType, List<WellEventQueryResult> occs) throws SQLException, SBException {
        ArrayList<Double> ages = null;
        for (WellEventQueryResult r : occs) {
            double age;
            if (r.type != eventType) continue;
            if (ages == null) {
                ages = new ArrayList<Double>();
            }
            WellInterp wellInterp = null;
            try {
                db.getWell(r.wellID).loadInterps();
                wellInterp = db.getWell(r.wellID).getInterp(r.interpID);
            }
            catch (SBException ex) {
                System.out.println("Exception from getAgeStats.getWell:" + ex.getMessage());
            }
            if (wellInterp == null) continue;
            wellInterp.loadLOC(r.wellID);
            if (wellInterp.getLOC() == null || !((age = wellInterp.getLOC().getAge(r.sample.getDepth(), false)) > 0.0)) continue;
            ages.add(age);
        }
        double[] stats = new double[3];
        for (int i = 0; i < stats.length; ++i) {
            stats[i] = 0.0;
        }
        if (ages != null && ages.size() >= 2) {
            double total = 0.0;
            for (Double d : ages) {
                total += d.doubleValue();
                stats[2] = stats[2] + 1.0;
            }
            double mean = total / (double)ages.size();
            Collections.sort(ages);
            double median = ages.size() % 2 == 0 ? ((Double)ages.get(ages.size() / 2) + (Double)ages.get(ages.size() / 2 - 1)) / 2.0 : (Double)ages.get((int)Math.floor(ages.size() / 2));
            stats[0] = mean;
            stats[1] = median;
        }
        return stats;
    }

    public List<CmpstdEventQueryResult> getCmpstdOccs() throws SQLException {
        LinkedList<CmpstdEventQueryResult> results = new LinkedList<CmpstdEventQueryResult>();
        Object sql = "SELECT c.std_id, c.ev_type, c.csu, s.name FROM ";
        sql = (String)sql + this.sbdb.DBTableName("CMPSTDEV") + " c," + this.sbdb.DBTableName("CMPSTD") + " s";
        sql = (String)sql + " WHERE ev_id=" + this.evID + " AND c.std_id=s.std_id";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
            while (rs.next()) {
                int stdID = rs.getInt("std_id");
                EventType evType = EventType.getType(rs.getString("ev_type"));
                double csu = rs.getDouble("csu");
                String csname = rs.getString("name");
                CmpstdEventQueryResult result = new CmpstdEventQueryResult(stdID, evType, csu, csname);
                results.add(result);
            }
        }
        return results;
    }

    public SBEvent getLink() {
        return this.link;
    }

    public void setLink(SBEvent link) {
        this.link = link;
    }

    public void findLink(SBdb db) throws SQLException {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to match database SBEvent");
        }
        if (this.sbdb == db) assert (false);
        this.link = db.getSBEvent(this.name, this.isSingle);
        if (this.link != null) {
            this.status = STORED;
        }
    }

    public boolean findLinkAnyType(SBdb db) throws SQLException, SBException {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to match database SBEvent");
        }
        if (this.sbdb == db) assert (false);
        if (this.link != null) {
            return false;
        }
        this.link = db.getSBEvent(this.name);
        if (this.link == null) {
            return false;
        }
        this.status = STORED;
        this.status = STORED;
        boolean switchedType = false;
        if (this.link.isSingle != this.isSingle) {
            this.isSingle = this.link.isSingle;
            switchedType = true;
        }
        return switchedType;
    }

    public void findLink(SBdb db, int evID) throws SQLException {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to match database SBEvent");
        }
        if (this.sbdb == db) assert (false);
        this.link = db.getSBEvent(evID);
        if (this.link != null) {
            this.status = STORED;
        }
    }

    void update(Builder builder) throws SQLException, GenerateUniqueException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        Audit temp = new Audit(builder.audit);
        GenerateUniqueException ex = null;
        if (this.sbdb.isConnected()) {
            builder.validate(this.evID, this.sbdb);
            if (builder.generate && !this.generate) {
                try {
                    this.checkGenerateUnique(builder.taxon);
                }
                catch (GenerateUniqueException e) {
                    builder.isGenerate(false);
                    ex = e;
                }
            }
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                String sql = "UPDATE " + this.sbdb.DBTableName("EVENTDIC") + " SET spec_id=" + (Serializable)(builder.getTaxon() == null ? "NULL" : Integer.valueOf(builder.getTaxon().getSpecID())) + ",name=" + SB.DBString((String)builder.name) + ",abr=" + SB.DBString((String)builder.abr) + ",ev_type=" + (builder.isSingle() ? "'S'" : "'R'") + ",generate=" + (builder.isGenerate() ? "'Y'" : "'N'") + ",ev_extent=" + SB.DBChar((char)this.evExtent) + ",ev_desc=" + SB.DBString((String)builder.getDesc()) + "," + temp.sqlUpdate(this.sbdb, stmt, false);
                sql = sql + " WHERE ev_id=" + this.evID;
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        this.name = builder.name;
        this.taxon = builder.taxon;
        this.isSingle = builder.isSingle;
        this.generate = builder.generate;
        this.evExtent = builder.evExtent;
        this.evDesc = builder.evDesc;
        this.abr = builder.abr;
        this.audit = temp;
        this.status = STORED;
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGenerate(boolean newGenerate) throws GenerateUniqueException, SQLException {
        if (this.generate == newGenerate) {
            return;
        }
        if (newGenerate) {
            this.checkGenerateUnique(this.taxon);
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + this.sbdb.DBTableName("EVENTDIC") + " SET generate=" + (newGenerate ? "'Y'" : "'N'") + "," + this.audit.sqlUpdate(this.sbdb, stmt, false);
        sql = sql + " WHERE ev_id=" + this.evID;
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.generate = newGenerate;
    }

    public static List<SBEvent> search(SBdb sbdb, String name) throws SQLException, SBException {
        name = name.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5');
        String sql = "SELECT ev_id FROM " + sbdb.DBTableName("EVENTDIC") + " WHERE ";
        if (name.indexOf(37) >= 0) {
            name = name.replace("[", "[[]");
            sql = sql + "ucase(name) like '" + name + "'";
        } else {
            sql = sql + "ucase(name)='" + name + "'";
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            LinkedList<SBEvent> resultList = new LinkedList<SBEvent>();
            while (rs.next()) {
                SBEvent event = sbdb.getSBEvent(rs.getInt("ev_id"));
                resultList.add(event);
            }
            LinkedList<SBEvent> linkedList = resultList;
            return linkedList;
        }
    }

    public static List<SBEvent> search(SBdb sbdb, int[] specIDs) throws SQLException, SBException {
        String sql = "SELECT ev_id FROM " + sbdb.DBTableName("EVENTDIC") + " WHERE spec_id=";
        for (int i = 0; i < specIDs.length; ++i) {
            if (i > 0) {
                sql = sql + " OR spec_id=";
            }
            sql = sql + specIDs[i];
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            LinkedList<SBEvent> resultList = new LinkedList<SBEvent>();
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                SBEvent event = sbdb.getSBEvent(rs.getInt("ev_id"));
                resultList.add(event);
            }
            LinkedList<SBEvent> linkedList = resultList;
            return linkedList;
        }
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for dictionary event: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    void setAbr(String abr) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set abr on connected database for dictionary event: " + this);
        }
        if (this.abr == null) {
            this.abr = abr;
        }
    }

    void setEvDesc(String desc) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set description on connected database for dictionary event: " + this);
        }
        if (this.evDesc == null || this.evDesc.isEmpty() || !this.evDesc.contains(desc)) {
            this.evDesc = desc;
        }
    }

    private SBEvent(Builder b, int evID, SBdb sbdb) {
        this.sbdb = sbdb;
        this.evID = evID;
        this.name = b.name;
        this.isSingle = b.isSingle;
        this.generate = b.generate;
        this.evDesc = b.evDesc;
        this.evExtent = b.evExtent;
        this.taxon = b.taxon;
        this.abr = b.abr;
        this.audit = b.audit;
        this.status = NOTSTORED;
    }

    public static int autoMerge(SBdb db) throws SQLException, IOException {
        int nEvents = 0;
        String fileName = "StrataBugs Event Merge Log.txt";
        File file = new File(fileName);
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
            System.out.println("Opened output file: " + file.getPath());
            out.write("\nStrataBugs event merge log: " + new Date() + "\n");
            Statement stmt = db.getDatabase().createStatement();
            Statement stmt2 = db.getDatabase().createStatement();
            String sql = "SELECT ev_id, spec_id, name FROM " + db.DBTableName("EVENTDIC") + " WHERE ev_desc='Generated from well data' AND generate='N'";
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                int nRows;
                int evID = rs.getInt("ev_id");
                int specID = rs.getInt("spec_id");
                String name = rs.getString("name");
                out.write("\nProcessing event: " + evID + " : " + name);
                sql = "SELECT count(*) AS nEvents FROM " + db.DBTableName("EVENTS") + " WHERE ev_id=" + evID;
                ResultSet rs2 = stmt2.executeQuery(sql);
                int nWellEvents = 0;
                if (rs2.next()) {
                    nWellEvents = rs2.getInt("nEvents");
                }
                rs2.close();
                sql = "SELECT count(*) AS nEvents FROM " + db.DBTableName("CMPSTDEV") + " WHERE ev_id=" + evID;
                rs2 = stmt2.executeQuery(sql);
                int nCmpStdEv = 0;
                if (rs2.next()) {
                    nCmpStdEv = rs2.getInt("nEvents");
                }
                rs2.close();
                out.write("\nEvent occurs: " + nWellEvents + " in wells and " + nCmpStdEv + " in Composite Standards");
                if (nWellEvents + nCmpStdEv > 0) {
                    int nRows2;
                    sql = "SELECT ev_id FROM " + db.DBTableName("EVENTDIC") + " WHERE name=" + SB.DBString((String)name) + " AND spec_id=" + specID + " AND generate='Y'";
                    rs2 = stmt2.executeQuery(sql);
                    int targetID = 0;
                    if (rs2.next()) {
                        targetID = rs2.getInt("ev_id");
                    }
                    rs2.close();
                    if (targetID == 0) {
                        out.write("\nNo target event found ******");
                        continue;
                    }
                    out.write("\nTarget event found is: " + targetID);
                    if (nWellEvents > 0) {
                        sql = "UPDATE " + db.DBTableName("EVENTS") + " SET ev_id=" + targetID + " WHERE ev_id=" + evID;
                        try {
                            nRows2 = stmt2.executeUpdate(sql);
                            out.write("\nNumber of well events updated " + nRows2);
                        }
                        catch (SQLException sqlex) {
                            out.write("\nCan't update well events due to: " + sqlex.toString());
                            continue;
                        }
                    }
                    if (nCmpStdEv > 0) {
                        sql = "UPDATE " + db.DBTableName("CMPSTDEV") + " SET ev_id=" + targetID + " WHERE ev_id=" + evID;
                        try {
                            nRows2 = stmt2.executeUpdate(sql);
                            out.write("\nNumber of composite standard events updated " + nRows2);
                        }
                        catch (SQLException sqlex) {
                            out.write("\nCan't update composite standard events due to: " + sqlex.toString());
                            continue;
                        }
                    }
                }
                if ((nRows = stmt2.executeUpdate(sql = "DELETE FROM " + db.DBTableName("EVENTDIC") + " WHERE ev_id=" + evID)) <= 0) continue;
                out.write("\n..Deleted.");
                ++nEvents;
            }
        }
        return nEvents;
    }

    void storeMatch(SBdb sbdb, String sourceID) throws SQLException {
        assert (!this.sbdb.isConnected() && sbdb.isConnected());
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "DELETE FROM " + sbdb.DBTableName("EVLOAD") + " WHERE source_id='" + sourceID + "' AND ucase(txt)=" + SB.DBString((String)this.name.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5'));
            int nRows = stmt.executeUpdate(sbdb.modQuery(sql));
            if (nRows == 0) {
                sql = "DELETE FROM " + sbdb.DBTableName("EVLOAD") + " WHERE source_id='" + sourceID + "' AND txt=" + SB.DBString((String)this.name);
                stmt.executeUpdate(sbdb.modQuery(sql));
            }
            if (this.link != null && !this.name.equals(this.link.getName())) {
                sql = "INSERT INTO " + sbdb.DBTableName("EVLOAD") + " (source_id,ev_id,txt) VALUES('" + sourceID + "'," + this.link.getEvID() + "," + SB.DBString((String)this.name) + ")";
                stmt.executeUpdate(sbdb.modQuery(sql));
            }
        }
    }

    public static class Builder {
        Audit audit = new Audit();
        private String name = "";
        private String abr;
        private boolean isSingle = false;
        public Boolean updateSingleToTops = null;
        private boolean generate = false;
        private String evDesc = "";
        private char evExtent;
        private Taxon taxon = null;

        static Builder copyOf(SBEvent event) {
            Builder builder = new Builder();
            builder.name(event.name).isSingle(event.isSingle).isGenerate(event.generate);
            builder.desc(event.evDesc).evExtent(event.evExtent).abr(event.abr);
            return builder;
        }

        void validate(int evID, SBdb sbdb) {
            if (evID < 1) {
                throw new IllegalArgumentException("Attempt to build SBEvent with illegal eventID: " + evID);
            }
            if (sbdb == null) {
                throw new IllegalArgumentException("Attempt to build SBEvent with null data model");
            }
            if (this.name.isEmpty()) {
                throw new IllegalStateException("Attempt to build SBEvent with no name");
            }
            if (SB.equal((Object)this.name, (Object)this.abr)) {
                this.abr = null;
            }
            if (this.taxon == null || this.isSingle) {
                this.generate = false;
            }
        }

        SBEvent build(int evID, SBdb sbdb) {
            this.validate(evID, sbdb);
            return new SBEvent(this, evID, sbdb);
        }

        SBEvent store(SBdb sbdb) throws SQLException, SBPermissionException {
            int specID = sbdb.nextControl("EVENTDIC", "ev_id");
            SBEvent event = this.build(specID, sbdb);
            event.storeDB();
            return event;
        }

        public Builder isSingle(boolean isSingle) {
            this.isSingle = isSingle;
            return this;
        }

        public Builder isGenerate(boolean isGenerate) {
            this.generate = isGenerate;
            return this;
        }

        public Builder name(String name) {
            this.name = name != null ? name.trim() : "";
            return this;
        }

        public Builder desc(String desc) {
            this.evDesc = desc != null ? desc.trim() : "";
            return this;
        }

        public Builder taxon(Taxon taxon) {
            this.taxon = taxon;
            return this;
        }

        public Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        public Builder evExtent(char extent) {
            this.evExtent = extent;
            return this;
        }

        public Builder abr(String abr) {
            if (abr != null && ((abr = abr.trim()).isEmpty() || abr.equals(this.name))) {
                abr = null;
            }
            this.abr = abr;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Taxon getTaxon() {
            return this.taxon;
        }

        public boolean isSingle() {
            return this.isSingle;
        }

        boolean isGenerate() {
            return this.generate;
        }

        String getDesc() {
            return this.evDesc;
        }

        char getExtent() {
            return this.evExtent;
        }

        String getAbr() {
            return this.abr;
        }
    }

    public static class GenerateUniqueException
    extends SBException {
        public GenerateUniqueException(String msg) {
            super(msg);
        }
    }

    public class WellEventQueryResult {
        public final int wellID;
        public final int interpID;
        public String wellName;
        public String interpName;
        public final Sample sample;
        public final EventType type;

        WellEventQueryResult(int wellID, int interpID, char type, String wellName, String interpName, Sample sample) {
            this.wellID = wellID;
            this.interpID = interpID;
            this.type = EventType.getType("" + type);
            this.wellName = wellName;
            this.interpName = interpName;
            this.sample = sample;
        }
    }

    public static final class EventType
    extends Enum<EventType> {
        public static final /* enum */ EventType TOP = new EventType('F', false, "Top");
        public static final /* enum */ EventType BASE = new EventType('L', false, "Base");
        public static final /* enum */ EventType SINGLE = new EventType('S', true, "Single");
        private final char charType;
        private final boolean isSingle;
        private final String displayName;
        private String prefixWell;
        private String prefixScheme;
        private static final /* synthetic */ EventType[] $VALUES;

        public static EventType[] values() {
            return (EventType[])$VALUES.clone();
        }

        public static EventType valueOf(String name) {
            return Enum.valueOf(EventType.class, name);
        }

        private EventType(char charType, boolean isSingle, String displayName) {
            this.charType = charType;
            this.isSingle = isSingle;
            this.displayName = displayName;
        }

        public char getChar() {
            return this.charType;
        }

        public boolean isSingle() {
            return this.isSingle;
        }

        public static void setPrefix(boolean well, String f, String l, boolean s) {
            if (well) {
                EventType.TOP.prefixWell = f.isEmpty() ? null : f;
                EventType.BASE.prefixWell = l.isEmpty() ? null : l;
            } else {
                EventType.TOP.prefixScheme = f.isEmpty() ? null : f;
                EventType.BASE.prefixScheme = l.isEmpty() ? null : l;
            }
            EventType.SINGLE.prefixWell = s ? null : "";
            EventType.SINGLE.prefixScheme = s ? null : "";
        }

        public String toString() {
            if (this.prefixWell == null && this.prefixScheme == null || this.prefixWell.isEmpty() && this.prefixScheme.isEmpty()) {
                return this.displayName;
            }
            if (this.prefixWell.equals(this.prefixScheme)) {
                return this.prefixWell;
            }
            return this.prefixWell + "/" + this.prefixScheme;
        }

        public String toString(boolean well) {
            if (well) {
                return this.prefixWell != null ? this.prefixWell : this.displayName;
            }
            return this.prefixScheme != null ? this.prefixScheme : this.displayName;
        }

        public String toString(boolean well, boolean standalone) {
            String s = this.toString(well);
            if (standalone && s.isEmpty()) {
                s = this.displayName;
            }
            return s;
        }

        public static EventType getType(String value) {
            if (value == null || value.trim().isEmpty() || value.equalsIgnoreCase("Single") || value.equals("0") || value.equals("S")) {
                return SINGLE;
            }
            if (value.equalsIgnoreCase("LDO") || value.equalsIgnoreCase("FAD") || value.equalsIgnoreCase("Base")) {
                return BASE;
            }
            if (value.equalsIgnoreCase("FDO") || value.equalsIgnoreCase("LAD") || value.equalsIgnoreCase("Top")) {
                return TOP;
            }
            if (value.charAt(0) == 'L') {
                return BASE;
            }
            if (value.charAt(0) == 'F') {
                return TOP;
            }
            assert (false);
            return TOP;
        }

        public static EventType parseType(String value) {
            if (value == null) {
                return null;
            }
            switch (value.trim().toUpperCase()) {
                case "LDO": 
                case "LO": 
                case "FAD": 
                case "BASE": {
                    return BASE;
                }
                case "FDO": 
                case "FO": 
                case "LAD": 
                case "TOP": {
                    return TOP;
                }
            }
            return null;
        }

        static {
            $VALUES = new EventType[]{TOP, BASE, SINGLE};
        }
    }

    public class CmpstdEventQueryResult {
        public String stdName;
        public EventType type;
        public double csu;
        public int stdID;

        CmpstdEventQueryResult(int stdID, EventType type, double csu, String name) {
            this.stdID = stdID;
            this.type = type;
            this.csu = csu;
            this.stdName = name;
        }
    }
}

