/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import model2_1.SBdb;
import org.jdom2.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import util.ImageUtils;
import util.SB;
import util.SBException;

public class SBImage {
    SBdb SB;
    private ImageIcon image = null;
    private ImageIcon imageThumb = null;
    private ImageIcon sizedImage = null;
    private int imageID = 0;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private String picPath;
    private String zipPath;
    private String caption;
    SBImage link = null;
    boolean isUnreferenced = false;

    SBImage(SBdb SB2, int imageID) throws SQLException {
        this.SB = SB2;
        this.imageID = imageID;
        this.loadDetails();
    }

    SBImage(SBdb SB2, String picPath) throws SQLException {
        this.SB = SB2;
        this.picPath = picPath;
        this.caption = picPath;
        this.isUnreferenced = true;
    }

    public SBImage(SBdb SB2, File file, boolean create, boolean storeImageInDatabase) throws SBException, SQLException, FileNotFoundException, IOException {
        this.picPath = file.getPath();
        this.image = ImageUtils.readImageIcon((String)this.picPath);
        this.SB = SB2;
        if (create) {
            this.store(storeImageInDatabase);
        }
    }

    public SBImage(SBdb SB2, Image image) {
        this.SB = SB2;
        this.picPath = null;
        this.image = new ImageIcon(image);
    }

    public String getZipPath() {
        return this.zipPath;
    }

    SBImage(SBdb db, Element xml, ZipFile zip) throws SBException {
        String strg = xml.getChildTextNormalize("ImageID");
        if (strg == null) {
            throw new SBException("ID null in XML - invalid");
        }
        this.imageID = Integer.parseInt(strg);
        this.SB = db;
        String fileName = xml.getChildTextNormalize("File");
        this.caption = xml.getChildTextNormalize("Caption");
        this.picPath = fileName;
        if (zip != null) {
            this.zipPath = zip.getName();
        }
    }

    SBImage(SBdb SB2, SBImage rhs) throws SQLException, SBException, IOException {
        this.SB = SB2;
        this.caption = rhs.caption;
        this.zipPath = rhs.zipPath;
        this.picPath = rhs.picPath;
        this.image = rhs.image;
        if (SB2 != null && SB2.isConnected()) {
            this.store(SB2.storeImage());
            this.image = null;
        } else {
            this.link = rhs;
        }
    }

    void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
    }

    void displayMetadata(Node node, int level) {
        Node child;
        this.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                System.out.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
        }
        if ((child = node.getFirstChild()) != null) {
            System.out.println(">");
            while (child != null) {
                this.displayMetadata(child, level + 1);
                child = child.getNextSibling();
            }
            this.indent(level);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    void delete() throws SBException, SQLException {
        if (this.imageID == 0) {
            throw new SBException("Attempt to delete image with no ID");
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.SB.DBTableName("SBIMAGE") + " WHERE image_id=" + this.imageID;
        int nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.imageID = 0;
    }

    public int getImageID() {
        return this.imageID;
    }

    public ImageIcon getImage() throws SQLException, SBException, IOException {
        this.load();
        return this.image;
    }

    public void clearImage() {
        this.image = null;
    }

    public String getCaption() throws SQLException, SBException {
        return this.caption;
    }

    public ImageIcon getImage(int maxWidth, int maxHeight, boolean clearImage) throws SQLException, SBException, IOException {
        if (maxWidth != this.lastWidth || this.lastHeight != maxHeight) {
            this.load();
            if (this.image != null) {
                this.sizedImage = ImageUtils.buildResizedImageIcon((ImageIcon)this.image, (int)maxWidth, (int)maxHeight);
                this.lastWidth = maxWidth;
                this.lastHeight = maxHeight;
                if (clearImage) {
                    this.clearImage();
                }
            }
        }
        return this.sizedImage;
    }

    public ImageIcon getThumb(int maxSize) throws SQLException, SBException, IOException {
        if (this.imageThumb != null) {
            return this.imageThumb;
        }
        this.load();
        if (this.image != null) {
            int iHeight;
            Image i = this.image.getImage();
            int iWidth = i.getWidth(null);
            Image resizedImage = iWidth > (iHeight = i.getHeight(null)) ? i.getScaledInstance(maxSize, maxSize * iHeight / iWidth, 2) : i.getScaledInstance(maxSize * iWidth / iHeight, maxSize, 2);
            this.imageThumb = new ImageIcon(resizedImage);
            this.clearImage();
        }
        return this.imageThumb;
    }

    public String getPath() {
        return this.picPath;
    }

    void export(File folder, boolean updatePath) throws SQLException, SBException, FileNotFoundException, IOException {
        String exportPath = folder + File.separator + "sbugs_" + this.imageID + ".jpg";
        this.writeImage(new File(exportPath));
        if (this.picPath == null) {
            this.loadPicPathFromDb();
        }
        if (updatePath || this.picPath == null) {
            String sql = "UPDATE " + this.SB.DBTableName("sbimage") + " SET pic_path=? WHERE image_id=" + this.imageID;
            PreparedStatement pStmt = this.SB.getDatabase().prepareStatement(this.SB.modQuery(sql));
            pStmt.setString(1, exportPath);
            pStmt.executeUpdate();
            this.loadPicPathFromDb();
        }
    }

    String getExportFileName() {
        return "sbugs_" + this.imageID + ".jpg";
    }

    void exportIfOriginalFileMissing(File folder) throws SQLException, SBException, FileNotFoundException, IOException {
        File originalFile;
        Statement stmt = this.SB.getDatabase().createStatement();
        if (this.picPath == null && this.image == null) {
            this.loadPicPathFromDb();
        }
        boolean fileExists = false;
        if (this.picPath != null && (originalFile = new File(this.picPath)).exists()) {
            fileExists = true;
        }
        if (fileExists) {
            String sql = "UPDATE " + this.SB.DBTableName("SBIMAGE") + " SET image_data=NULL WHERE image_id=" + this.imageID;
            stmt.executeUpdate(this.SB.modQuery(sql));
        } else {
            this.picPath = folder + File.separator + "sbugs_" + this.imageID + ".jpg";
            this.writeImage(new File(this.picPath));
            String sql = "UPDATE " + this.SB.DBTableName("sbimage") + " SET pic_path=?, image_data=NULL WHERE image_id=" + this.imageID;
            PreparedStatement pStmt = this.SB.getDatabase().prepareStatement(this.SB.modQuery(sql));
            pStmt.setString(1, this.picPath);
            pStmt.executeUpdate();
        }
    }

    public void writeImage(File jpeg) throws SQLException, SBException, IOException {
        this.load();
        Image img = this.image.getImage();
        if (img.getWidth(null) <= 0 || img.getHeight(null) <= 0) {
            System.out.println("Failed to load/write image: " + this.image.getDescription() + " ImageID=" + this.imageID);
        }
        BufferedImage bi = ImageUtils.convertImageToBufferedImage((Image)this.image.getImage());
        ImageIO.write((RenderedImage)bi, "jpg", jpeg);
        this.image = null;
    }

    public void writeImage(int width, int height, OutputStream jpeg) throws SQLException, SBException, IOException {
        this.load();
        if (this.image == null) {
            return;
        }
        ImageIcon icon = this.getImage(width, height, true);
        BufferedImage bi = ImageUtils.convertImageToBufferedImage((Image)icon.getImage());
        if (!ImageIO.write((RenderedImage)bi, "jpg", jpeg)) {
            throw new SBException("No image writer found in writeImage");
        }
        this.image = null;
    }

    private void load() throws SQLException, SBException, IOException {
        if (this.image == null && this.imageID == 0 && !this.isUnreferenced) {
            throw new SBException("image is null and imageID is zero in DBImage.load");
        }
        if (this.image == null) {
            if (!this.isUnreferenced) {
                SBdb db;
                if (this.link != null) {
                    db = this.link.SB;
                } else {
                    db = this.SB;
                    if (this.picPath != null && this.picPath.length() > 0 && db == null || !db.isConnected()) {
                        this.loadFromPath();
                        return;
                    }
                }
                Statement stmt = db.getDatabase().createStatement();
                String sql = "SELECT pic_path,image_data,caption FROM " + db.DBTableName("SBIMAGE") + " WHERE image_id=" + this.imageID;
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    this.picPath = rs.getString("pic_path");
                    this.caption = rs.getString("caption");
                    if (db.storeImage()) {
                        this.tryLoadImageFromResultSet(rs);
                        if (this.image != null) continue;
                        this.tryLoadImageFromPicPath();
                        continue;
                    }
                    this.tryLoadImageFromPicPath();
                    if (this.image != null) continue;
                    this.tryLoadImageFromResultSet(rs);
                }
                stmt.close();
            } else {
                this.loadFromPath();
            }
        }
    }

    private void tryLoadImageFromResultSet(ResultSet rs) throws SQLException, IOException {
        byte[] by = null;
        if (this.SB.dbType != SBdb.DBType.MSSQLSERVER) {
            by = rs.getBytes("IMAGE_DATA");
        } else {
            InputStream ios = rs.getBinaryStream("IMAGE_DATA");
            if (ios != null) {
                int b;
                ByteArrayOutputStream bio = new ByteArrayOutputStream();
                while ((b = ios.read()) >= 0) {
                    bio.write(b);
                }
                by = bio.toByteArray();
            }
        }
        if (by != null) {
            this.image = new ImageIcon(by);
        }
    }

    private void tryLoadImageFromPicPath() throws IOException {
        if (this.picPath != null && this.picPath.length() > 0 && new File(this.picPath).exists()) {
            this.image = ImageUtils.readImageIcon((String)this.picPath);
        }
    }

    private void loadFromPath() throws SBException, IOException {
        if (this.picPath == null || this.picPath.isEmpty()) {
            throw new SBException("Trying to get unreferenced image with no picPath");
        }
        File picFile = new File(this.picPath);
        if (!picFile.exists()) {
            if (this.zipPath != null && this.zipPath.length() > 0) {
                try {
                    int nBytes;
                    ZipFile zip = new ZipFile(this.zipPath);
                    ZipEntry entry = zip.getEntry(this.picPath);
                    if (entry == null) {
                        throw new SBException("Can't find zip file entry for image: " + this.picPath);
                    }
                    InputStream fileIn = zip.getInputStream(entry);
                    picFile = File.createTempFile("SBImage" + this.imageID + "-", ".jpg");
                    picFile.deleteOnExit();
                    String tempPicPath = picFile.getPath();
                    FileOutputStream fos = new FileOutputStream(tempPicPath);
                    byte[] bytes = new byte[Short.MAX_VALUE];
                    while ((nBytes = fileIn.read(bytes, 0, bytes.length)) > 0) {
                        fos.write(bytes, 0, nBytes);
                    }
                    fos.close();
                    this.image = new ImageIcon(tempPicPath);
                }
                catch (IOException ios) {
                    ios.printStackTrace();
                    throw new SBException("IO Exception when reading image from zip file path: " + ios.toString());
                }
            }
        } else {
            this.image = ImageUtils.readImageIcon((String)this.picPath);
        }
    }

    private void loadDetails() throws SQLException {
        if (this.SB != null && this.SB.isConnected()) {
            Statement stmt = this.SB.getDatabase().createStatement();
            String sql = "SELECT pic_path,image_data,caption FROM " + this.SB.DBTableName("SBIMAGE") + " WHERE image_id=" + this.imageID;
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                this.picPath = rs.getString("pic_path");
                this.caption = rs.getString("caption");
            }
            stmt.close();
        }
    }

    void importImage() throws SQLException, SBException, FileNotFoundException, IOException {
        this.loadPicPathIfNeeded();
        if (this.picPath == null) {
            return;
        }
        File file = new File(this.picPath);
        if (!file.exists()) {
            System.out.println("Cannot import image from file: " + this.picPath);
            return;
        }
        this.updateImageFromFile(this.picPath);
    }

    void importImageFromExportFolder(File exportFolder) throws SQLException, IOException {
        String exportPath = exportFolder + File.separator + "sbugs_" + this.imageID + ".jpg";
        if (new File(exportPath).exists()) {
            this.updateImageFromFile(exportPath);
        }
    }

    private void updateImageFromFile(String imageFilePath) throws SQLException, IOException {
        String sql = "UPDATE " + this.SB.DBTableName("sbimage") + " SET image_data=? WHERE image_id=" + this.imageID;
        PreparedStatement pStmt = this.SB.getDatabase().prepareStatement(this.SB.modQuery(sql));
        FileInputStream fileIn = new FileInputStream(imageFilePath);
        pStmt.setBinaryStream(1, (InputStream)fileIn, (int)new File(imageFilePath).length());
        pStmt.executeUpdate();
        pStmt.close();
        fileIn.close();
    }

    final void store(boolean storeImageInDatabase) throws SQLException, SBException, IOException {
        this.imageID = this.SB.nextControl("sbimage", "image_id");
        String sql = "INSERT INTO " + this.SB.DBTableName("sbimage") + " (image_id,pic_path,caption";
        if (storeImageInDatabase) {
            sql = sql + ",image_data";
        }
        sql = sql + ") VALUES (?, ?, ?";
        if (storeImageInDatabase) {
            sql = sql + ", ?";
        }
        sql = sql + ")";
        PreparedStatement pStmt = this.SB.getDatabase().prepareStatement(this.SB.modQuery(sql));
        pStmt.setInt(1, this.imageID);
        pStmt.setString(2, this.picPath);
        pStmt.setString(3, this.caption);
        InputStream fileIn = null;
        ZipFile zip = null;
        System.out.println("zipPath: " + this.zipPath);
        System.out.println("picPath: " + this.picPath);
        if (this.zipPath != null) {
            zip = new ZipFile(this.zipPath);
        }
        if (storeImageInDatabase) {
            int len = 0;
            if (this.image == null) {
                if (zip != null) {
                    ZipEntry entry = zip.getEntry(this.picPath);
                    if (entry == null) {
                        throw new SBException("Can't find zip file entry for image: " + this.picPath);
                    }
                    fileIn = zip.getInputStream(entry);
                    len = (int)entry.getSize();
                } else {
                    Logger.getLogger(SBImage.class.getName()).log(Level.WARNING, "Suspicous storing of image with no image data, trying to load data before proceeding.");
                    this.tryLoadImageFromPicPath();
                    if (this.image == null) {
                        Logger.getLogger(SBImage.class.getName()).log(Level.WARNING, "No data found from Pic Path, trying to load from the database.");
                        this.load();
                        Logger.getLogger(SBImage.class.getName()).log(Level.WARNING, "No data found from database, aborting.");
                        throw new SBException("Can't find zip file entry for image: " + this.picPath);
                    }
                }
            } else {
                ByteArrayOutputStream bos = ImageUtils.buildByteStreamFromImage((Image)this.image.getImage());
                len = bos.size();
                fileIn = new ByteArrayInputStream(bos.toByteArray());
            }
            pStmt.setBinaryStream(4, fileIn, len);
        } else if (zip != null) {
            int nBytes;
            ZipEntry entry = zip.getEntry(this.picPath);
            if (entry == null) {
                throw new SBException("Can't find zip file entry for image: " + this.picPath);
            }
            fileIn = zip.getInputStream(entry);
            Object imageFolder = this.SB.getImageFolder();
            if (imageFolder != null && !((String)imageFolder).isEmpty() && !((String)imageFolder).endsWith(File.separator)) {
                imageFolder = (String)imageFolder + File.separator;
            }
            FileOutputStream fos = new FileOutputStream((String)imageFolder + this.picPath);
            byte[] bytes = new byte[Short.MAX_VALUE];
            while ((nBytes = fileIn.read(bytes, 0, bytes.length)) > 0) {
                fos.write(bytes, 0, nBytes);
            }
            fos.close();
        }
        pStmt.executeUpdate();
        pStmt.close();
        if (fileIn != null) {
            fileIn.close();
        }
        if (zip != null) {
            zip.close();
        }
        this.SB.putImage(this);
    }

    public void setCaption(String text) throws SQLException {
        if (this.caption == null || !this.caption.equals(text)) {
            if (this.imageID > 0 && this.SB != null && this.SB.isConnected()) {
                Statement stmt = this.SB.getDatabase().createStatement();
                String sql = "UPDATE " + this.SB.DBTableName("SBIMAGE") + " SET caption=" + util.SB.DBString((String)text) + " WHERE image_id=" + this.imageID;
                stmt.executeUpdate(this.SB.modQuery(sql));
                stmt.close();
            }
            this.caption = text;
        }
    }

    File writeXML(BufferedWriter out, String ind) throws IOException, SQLException, SBException {
        out.write(ind + "<ImageID>" + this.imageID + "</ImageID>\r\n");
        File tempFile = File.createTempFile("SBImage" + this.imageID + "-", ".jpg");
        System.out.println("Writing image to file: " + tempFile.getAbsolutePath());
        this.writeImage(tempFile);
        out.write(ind + "<File>" + tempFile.getName() + "</File>\r\n");
        if (this.caption != null && this.caption.length() > 0) {
            out.write(ind + "<Caption>" + util.SB.getXMLstring((String)this.caption) + "</Caption>\r\n");
        }
        return tempFile;
    }

    void setUnstored() {
        this.imageID = 0;
    }

    private void loadPicPathIfNeeded() throws SQLException {
        if (this.picPath == null && this.image == null) {
            this.loadPicPathFromDb();
        }
    }

    private void loadPicPathFromDb() throws SQLException {
        String sql;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql = "SELECT pic_path FROM " + this.SB.DBTableName("SBIMAGE") + " WHERE image_id=" + this.imageID);
        if (rs.next()) {
            this.picPath = rs.getString("pic_path");
        }
    }
}

