/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import model2_1.SBdb;
import model2_1.Userdef;
import util.SBException;
import util.SBObservable;
import util.SBPermissionException;

public abstract class SBRestrictable
extends SBObservable {
    private final String tableBase;
    private final String keyField;
    private final boolean restrictable;
    private final boolean hideable;
    private final ACM ACM = new ACM();
    private HashSet<Userdef> acl = null;
    public static final int PUBLIC_WRITE = 0;
    public static final int HIDDEN = 2;
    public static final int PUBLIC_READ_ONLY = 128;
    public static final int RESTRICTED_READ = 512;
    public static final int RESTRICTED_WRITE = 1024;
    private static final int acmTimeout = 6000;
    private static final String icon_linked = "linked";
    private static final String NO_PERMISSION = "You do not have permission to edit the database.";
    private static final String NO_PERMISSION_EXCEPTION = "Insufficent privilege to edit database!";

    protected SBRestrictable(String tableName, String keyField, boolean restrictable) {
        this.tableBase = tableName;
        this.keyField = keyField;
        this.restrictable = restrictable;
        this.hideable = false;
    }

    protected SBRestrictable(String tableName, String keyField, boolean restrictable, boolean hideable) {
        this.tableBase = tableName;
        this.keyField = keyField;
        this.restrictable = restrictable;
        this.hideable = hideable;
    }

    protected abstract int getID();

    public boolean isRestrictable() {
        return this.restrictable;
    }

    public boolean isHideable() {
        return this.hideable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAcm(SBdb sbdb, Statement stmt) throws SQLException {
        if (this.ACM.needsRefresh()) {
            if (!sbdb.isConnected()) {
                this.ACM.set(0);
                return;
            }
            String sql = "SELECT acm FROM " + sbdb.DBTableName(this.tableBase) + " WHERE " + this.keyField + "=" + this.getID();
            Statement statement = stmt == null ? sbdb.getDatabase().createStatement() : stmt;
            try (ResultSet rs = statement.executeQuery(sbdb.modQuery(sql));){
                if (rs.next()) {
                    this.ACM.set(rs.getInt("acm"));
                } else {
                    this.ACM.set(0);
                }
            }
            finally {
                if (stmt == null) {
                    statement.close();
                }
            }
        }
    }

    protected final void setAcm(int acm) {
        if (acm < 0) {
            throw new IllegalArgumentException("Bad argument: " + acm + " to setAcm");
        }
        this.ACM.set(acm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAcm(SBdb sbdb, Statement stmt, int acm) throws SQLException {
        Statement statement = stmt == null ? sbdb.getDatabase().createStatement() : stmt;
        String sql = "UPDATE " + sbdb.DBTableName(this.tableBase) + " SET acm=" + acm + " WHERE " + this.keyField + "=" + this.getID();
        try {
            statement.executeUpdate(sbdb.modQuery(sql));
        }
        finally {
            if (stmt == null) {
                statement.close();
            }
        }
        this.ACM.set(acm);
    }

    public int getAcm() throws SBException {
        if (this.ACM.acm < 0) {
            throw new SBException("ACM not set in getAcm for: " + this);
        }
        return this.ACM.acm;
    }

    public int getAcm(boolean ignoreHidden) throws SBException {
        if (this.ACM.acm < 0) {
            throw new SBException("ACM not set in getAcm for: " + this);
        }
        if ((this.ACM.acm & 2) > 0) {
            return this.ACM.acm - 2;
        }
        return this.ACM.acm;
    }

    public boolean isReadOnly() throws SBException {
        if (this.ACM.acm < 0) {
            throw new SBException("ACM not set in isReadOnly for: " + this);
        }
        return (this.ACM.acm & 0x80) > 0;
    }

    public boolean isHidden() throws SBException {
        if (this.ACM.acm < 0) {
            throw new SBException("ACM not set in isReadOnly for: " + this);
        }
        return (this.ACM.acm & 2) > 0;
    }

    public HashSet<Userdef> getAcl(SBdb sbdb) throws SQLException {
        if (this.acl == null && this.ACM.acm == 0) {
            return new HashSet<Userdef>();
        }
        this.loadAcl(sbdb, null, false);
        return new HashSet<Userdef>(this.acl);
    }

    public void setAcl(SBdb sbdb, HashSet<Userdef> acl) throws SQLException, SBException, SBPermissionException {
        this.setAcl(sbdb, acl, this.ACM.acm);
    }

    public void setAcl(SBdb sbdb, HashSet<Userdef> acl, int acm) throws SQLException, SBException, SBPermissionException {
        if (acm > 0) {
            Iterator<Userdef> it = acl.iterator();
            boolean keyUser = false;
            while (it.hasNext()) {
                Userdef u = it.next();
                if ((u.getPriv() & 0x400) <= 0) continue;
                keyUser = true;
                break;
            }
            if (!keyUser) {
                throw new SBPermissionException("Error - cannot grant permissions without key user");
            }
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                String sql = "DELETE FROM " + sbdb.DBTableName(this.tableBase + "_ACL") + " WHERE " + this.keyField + "=" + this.getID();
                stmt.executeUpdate(sbdb.modQuery(sql));
                if (this.acl == null) {
                    this.acl = new HashSet();
                } else {
                    this.acl.clear();
                }
                for (Userdef u : acl) {
                    sql = "INSERT INTO " + sbdb.DBTableName(this.tableBase + "_ACL") + " (" + this.keyField + ",USER_ID) VALUES (" + this.getID() + ", " + u.getUsrID() + ")";
                    stmt.executeUpdate(sbdb.modQuery(sql));
                    this.acl.add(u);
                }
            }
        }
        String sql = "DELETE FROM " + sbdb.DBTableName(this.tableBase + "_ACL") + " WHERE " + this.keyField + "=" + this.getID();
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        this.acl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAcl(SBdb sbdb, Statement stmt, boolean refresh) throws SQLException {
        if (this.ACM.acm == 0) {
            this.acl = null;
            return;
        }
        if (!refresh && this.acl != null && !this.acl.isEmpty()) {
            return;
        }
        this.acl = new HashSet();
        String sql = "SELECT user_ID FROM " + sbdb.DBTableName(this.tableBase + "_ACL") + " WHERE " + this.keyField + "=" + this.getID();
        Statement statement = stmt == null ? sbdb.getDatabase().createStatement() : stmt;
        try (ResultSet rs = statement.executeQuery(sql);){
            while (rs.next()) {
                int userID = rs.getInt("user_ID");
                this.acl.add(sbdb.getUser(userID));
            }
        }
        finally {
            if (stmt == null) {
                statement.close();
            }
        }
    }

    public boolean canRead(SBdb sbdb, Statement stmt) throws SQLException, SBException {
        if (this.ACM.needsRefresh()) {
            this.loadAcm(sbdb, stmt);
        }
        if (this.ACM.acm == 0) {
            return true;
        }
        if ((this.ACM.acm & 0x80) > 0) {
            return true;
        }
        this.loadAcl(sbdb, stmt, false);
        return this.acl.contains(sbdb.getUser());
    }

    public boolean canWrite(SBdb sbdb, Statement stmt) throws SQLException {
        if (sbdb.getUser() == null) {
            return true;
        }
        if (sbdb.getUser().isReadOnly()) {
            return false;
        }
        if (this.ACM.needsRefresh()) {
            this.loadAcm(sbdb, stmt);
        }
        if (this.ACM.acm == 0 || this.ACM.acm == 2) {
            return true;
        }
        if ((this.ACM.acm & 0x400) > 0) {
            this.loadAcl(sbdb, stmt, false);
            if (this.acl.contains(sbdb.getUser())) {
                return true;
            }
        }
        return false;
    }

    public static boolean canWrite(SBdb sbdb) {
        Userdef user = sbdb.getUser();
        if (user == null) {
            return true;
        }
        return !sbdb.getUser().isReadOnly();
    }

    public boolean canRestrict(SBdb sbdb, Statement stmt) throws SQLException, SBException {
        Userdef user = sbdb.getUser();
        if ((user.getPriv() & 0x400) == 0) {
            return false;
        }
        if (this.ACM.needsRefresh()) {
            this.loadAcm(sbdb, stmt);
        }
        if (this.ACM.acm == 0) {
            return true;
        }
        this.loadAcl(sbdb, stmt, false);
        return this.acl.contains(sbdb.getUser());
    }

    public static String getPermissionString(int acm) {
        if ((acm & 2) > 0) {
            acm -= 2;
        }
        switch (acm) {
            default: {
                return "";
            }
            case 128: {
                return "Read-only";
            }
            case 1024: {
                return "Restricted";
            }
            case 512: 
        }
        return "Restricted, read-only";
    }

    public String getIconString() {
        int acm = this.ACM.acm;
        if ((acm & 2) > 0) {
            acm -= 2;
        }
        switch (acm) {
            default: {
                return null;
            }
            case 128: 
        }
        return icon_linked;
    }

    public String getDeniedReason(SBdb sbdb, String action, String description, boolean attempted) {
        if (!SBRestrictable.canWrite(sbdb)) {
            return attempted ? NO_PERMISSION_EXCEPTION : NO_PERMISSION;
        }
        if (this.ACM.acm == 128 || this.ACM.acm == 130) {
            if (attempted) {
                return "Attempt to " + (String)(action != null ? action + " in" : "edit") + " read-only " + (description != null ? description : "object") + "!";
            }
            return "Cannot " + (action != null ? action : "edit") + ": this " + (description != null ? description : "object") + " is read-only." + ((sbdb.getUser().getPriv() & 0x400) > 0 ? " Use Permissions dialog to change." : "");
        }
        if ((this.ACM.acm & 0x400) > 0 && !this.acl.contains(sbdb.getUser())) {
            if (attempted) {
                return "Attempt to edit restricted data!";
            }
            return "You do not have permission to edit this restricted " + (description != null ? description : "object") + ".";
        }
        assert (false);
        return "";
    }

    public String getDeniedReason(SBdb sbdb, String description, boolean attempted) {
        return this.getDeniedReason(sbdb, null, description, attempted);
    }

    public static String getDeniedReason(boolean attempted) {
        return attempted ? NO_PERMISSION_EXCEPTION : NO_PERMISSION;
    }

    private static class ACM {
        int acm = -1;
        private Date loaded;

        private ACM() {
        }

        void set(int acm) {
            assert (acm >= 0);
            this.acm = acm;
            this.loaded = new Date();
        }

        boolean needsRefresh() {
            if (this.acm < 0) {
                return true;
            }
            return new Date().getTime() - this.loaded.getTime() > 6000L;
        }
    }
}

