/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SampleType;
import model2_1.Well;
import model2_1.WsWell;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.DepthUtils;
import util.SBException;

public class SampleReaderXLS {
    List nonInserts = new LinkedList();
    int donorSampleID = 1;
    Set<Integer> dataTypes;
    int wellColumn = 0;
    int topDepthColumn = -1;
    int baseDepthColumn = -1;
    int sampleTypeColumn = -1;
    int sampleLabelColumn = -1;
    int ageColumn = -1;
    int ageErrorPlusColumn = -1;
    int ageErrorMinusColumn = -1;
    int ratioColumn = -1;
    char units = (char)77;
    SBdb ws;

    public SampleReaderXLS(SBdb ws, File fileName, Set<Integer> dataTypes) throws SBException, FileNotFoundException, IOException, SQLException, InvalidFormatException {
        this.dataTypes = dataTypes;
        this.ws = ws;
        FileInputStream file = new FileInputStream(fileName);
        Workbook wb = WorkbookFactory.create((InputStream)file);
        dataTypes.clear();
        Sheet sheet = wb.getSheetAt(0);
        System.out.println("processing sheet: " + wb.getSheetName(0) + "\n");
        this.parseSheet(sheet);
        try {
            file.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    final void parseSheet(Sheet sheet) throws SBException, SQLException {
        boolean parsedTitles = false;
        WsWell well = null;
        int sampID = 1;
        for (int nRow = 0; nRow <= sheet.getLastRowNum(); ++nRow) {
            Row row = sheet.getRow(nRow);
            if (row == null) continue;
            if (!parsedTitles) {
                parsedTitles = this.parseTitles(row);
                continue;
            }
            Sample.Builder sampleBuilder = new Sample.Builder();
            Double age = null;
            Double ratio = null;
            Float ageErrorPlus = null;
            Float ageErrorMinus = null;
            String type = "CO";
            String wellName = null;
            Object label = null;
            block31: for (short i = 0; i <= row.getLastCellNum(); i = (short)(i + 1)) {
                Cell cell = row.getCell((int)i);
                if (cell == null || cell.getCellType() == CellType.BLANK) continue;
                if (i == this.wellColumn) {
                    wellName = cell.getStringCellValue();
                    continue;
                }
                if (i == this.topDepthColumn) {
                    switch (cell.getCellType()) {
                        case NUMERIC: 
                        case FORMULA: {
                            sampleBuilder.topDepth(DepthUtils.convToM((double)cell.getNumericCellValue(), (char)this.units));
                            break;
                        }
                        case STRING: {
                            if (cell.getStringCellValue().trim().contains("-")) {
                                sampleBuilder = Sample.parseDepthString(cell.getStringCellValue(), this.units, false, this.ws.useSampleTops());
                                break;
                            }
                            sampleBuilder.topDepth(DepthUtils.convToM((double)new Double(cell.getStringCellValue()), (char)this.units));
                            break;
                        }
                    }
                    continue;
                }
                if (i == this.baseDepthColumn) {
                    switch (cell.getCellType()) {
                        case NUMERIC: 
                        case FORMULA: {
                            sampleBuilder.baseDepth(DepthUtils.convToM((double)cell.getNumericCellValue(), (char)this.units));
                            break;
                        }
                        case STRING: {
                            if (cell.getStringCellValue().trim().contains("-")) {
                                sampleBuilder = Sample.parseDepthString(cell.getStringCellValue(), this.units, false, this.ws.useSampleTops());
                                break;
                            }
                            sampleBuilder.baseDepth(DepthUtils.convToM((double)new Double(cell.getStringCellValue()), (char)this.units));
                            break;
                        }
                    }
                    continue;
                }
                if (i == this.sampleTypeColumn) {
                    type = cell.getStringCellValue();
                    continue;
                }
                if (i == this.sampleLabelColumn) {
                    switch (cell.getCellType()) {
                        case NUMERIC: 
                        case FORMULA: {
                            label = "" + cell.getNumericCellValue();
                            if (!((String)label).endsWith(".0")) break;
                            label = ((String)label).substring(0, ((String)label).length() - 2);
                            break;
                        }
                        case STRING: {
                            label = cell.getStringCellValue();
                        }
                    }
                    continue;
                }
                if (i == this.ageColumn) {
                    switch (cell.getCellType()) {
                        case NUMERIC: 
                        case FORMULA: {
                            age = cell.getNumericCellValue();
                            break;
                        }
                        case STRING: {
                            age = new Double(cell.getStringCellValue());
                            break;
                        }
                    }
                    continue;
                }
                if (i == this.ageErrorPlusColumn) {
                    switch (cell.getCellType()) {
                        case NUMERIC: 
                        case FORMULA: {
                            ageErrorPlus = Float.valueOf((float)cell.getNumericCellValue());
                            break;
                        }
                        case STRING: {
                            ageErrorPlus = new Float(cell.getStringCellValue());
                            break;
                        }
                    }
                    continue;
                }
                if (i == this.ageErrorMinusColumn) {
                    switch (cell.getCellType()) {
                        case NUMERIC: 
                        case FORMULA: {
                            ageErrorMinus = Float.valueOf((float)cell.getNumericCellValue());
                            break;
                        }
                        case STRING: {
                            ageErrorMinus = new Float(cell.getStringCellValue());
                            break;
                        }
                    }
                    continue;
                }
                if (i != this.ratioColumn) continue;
                switch (cell.getCellType()) {
                    case NUMERIC: 
                    case FORMULA: {
                        ratio = cell.getNumericCellValue();
                        continue block31;
                    }
                    case STRING: {
                        ratio = new Double(cell.getStringCellValue());
                        continue block31;
                    }
                }
            }
            if (well == null || wellName != null && !well.getWellName().equalsIgnoreCase(wellName)) {
                this.addDataType(1);
                if (well != null) {
                    well.updateStatus(this.dataTypes);
                }
                well = this.ws.addWellToWorkspace(0, null);
                System.out.println("Setting well name as: " + wellName);
                well.getHeader().setWellName(wellName);
                well.getHeader().setWellCode(Well.makeCode(wellName));
                well.getHeader().setWellUnits(this.units);
                well.loadInterps();
                sampID = 1;
            }
            try {
                sampleBuilder.type(SampleType.parseType(type)).label((String)label);
                sampleBuilder.getDepth(this.ws.useSampleTops());
                Sample sample = well.addSample(sampleBuilder, sampID++, null);
                if (age != null) {
                    sample.setAge(0, age, null, ageErrorPlus, ageErrorMinus, ratio, 0);
                    System.out.println("Setting age for sample: " + sample + " to: " + sample.getAge(0));
                    this.addDataType(29);
                }
                System.out.println("Sample: " + sample.toString() + " Added to well: " + well);
                continue;
            }
            catch (Exception ex) {
                System.out.println("Exception ading sample: " + type + " to Well:" + well);
                ex.printStackTrace();
            }
        }
        if (well != null) {
            well.updateStatus(this.dataTypes);
        }
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(new Integer(dType))) {
            this.dataTypes.add(new Integer(dType));
        }
    }

    boolean parseTitles(Row row) {
        boolean isTitleRow = false;
        for (short i = 0; i <= row.getLastCellNum(); i = (short)(i + 1)) {
            Cell cell = row.getCell((int)i);
            if (cell == null || cell.getCellType() != CellType.STRING) continue;
            String strg = cell.getStringCellValue();
            if (strg.toUpperCase().startsWith("DEPTH")) {
                if (this.ws.useSampleTops()) {
                    this.topDepthColumn = i;
                } else {
                    this.baseDepthColumn = i;
                }
                isTitleRow = true;
                if (strg.toLowerCase().contains("(ft)")) {
                    this.units = (char)70;
                }
            }
            if (strg.toUpperCase().startsWith("TOP DEPTH") && this.topDepthColumn < 0) {
                this.topDepthColumn = i;
                isTitleRow = true;
                if (strg.toLowerCase().contains("(ft)")) {
                    this.units = (char)70;
                }
            }
            if (strg.toUpperCase().startsWith("BASE DEPTH") && this.baseDepthColumn < 0) {
                this.baseDepthColumn = i;
                isTitleRow = true;
                if (strg.toLowerCase().contains("(ft)")) {
                    this.units = (char)70;
                }
            }
            if (strg.toUpperCase().startsWith("LABEL")) {
                if (this.sampleLabelColumn >= 0) continue;
                this.sampleLabelColumn = i;
                continue;
            }
            if (strg.equalsIgnoreCase("SAMPLE TYPE") || strg.equalsIgnoreCase("TYPE")) {
                if (this.sampleTypeColumn >= 0) continue;
                this.sampleTypeColumn = i;
                continue;
            }
            if (strg.toUpperCase().equals("AGE")) {
                if (this.ageColumn >= 0) continue;
                this.ageColumn = i;
                continue;
            }
            if (strg.toUpperCase().equals("AGE ERROR PLUS")) {
                if (this.ageErrorPlusColumn >= 0) continue;
                this.ageErrorPlusColumn = i;
                continue;
            }
            if (strg.toUpperCase().equals("AGE ERROR MINUS")) {
                if (this.ageErrorMinusColumn >= 0) continue;
                this.ageErrorMinusColumn = i;
                continue;
            }
            if (!strg.toUpperCase().equals("RATIO") || this.ratioColumn >= 0) continue;
            this.ratioColumn = i;
        }
        return isTitleRow;
    }
}

