/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import model2_1.IGDScheme;
import model2_1.SBdb;
import model2_1.Surface;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.InvalidFieldException;
import util.SBException;

public class SequenceXLSReader {
    private SequenceXLSReader() {
    }

    public static void read(SBdb ws, File file, boolean appendTypes) throws SBException, FileNotFoundException, IOException, SQLException, InvalidFormatException {
        FileInputStream is = new FileInputStream(file);
        Workbook wb = WorkbookFactory.create((InputStream)is);
        ((InputStream)is).close();
        String name = file.getName();
        if (name.lastIndexOf(46) > 1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        IGDScheme scheme = new IGDScheme(ws, 10, name, null, IGDScheme.SequenceType.DEPOSITIONAL, 0);
        scheme.setSchID(1);
        SequenceXLSReader.parseSheet(ws, wb.getSheetAt(0), scheme, appendTypes);
        if (!scheme.getSurfaces().isEmpty()) {
            ws.addIGDScheme(scheme);
        }
    }

    private static void parseSheet(SBdb ws, Sheet sheet, IGDScheme scheme, boolean appendTypes) throws SBException, FileNotFoundException, IOException, SQLException {
        Row titleRow = sheet.getRow(0);
        if (titleRow == null) {
            System.out.println("column titles null");
            return;
        }
        String[] colNames = new String[20];
        int maxCol = 0;
        for (short cellNum = titleRow.getFirstCellNum(); cellNum <= titleRow.getLastCellNum(); cellNum = (short)(cellNum + 1)) {
            Cell cell = titleRow.getCell((int)cellNum);
            if (cellNum >= colNames.length) {
                System.out.println("CellNumber: " + cellNum + " exceeds column title length!");
            }
            if (cell == null) continue;
            colNames[cellNum] = cell.getStringCellValue();
            maxCol = cellNum;
        }
        ColType[] columns = new ColType[maxCol + 1];
        for (int i = 0; i <= maxCol; ++i) {
            columns[i] = ColType.getColumnType(colNames[i]);
        }
        for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            Row row = sheet.getRow(nRow);
            if (row == null) continue;
            try {
                Surface.Builder b = SequenceXLSReader.parseSurface(ws, row, columns, appendTypes);
                if (b == null) continue;
                scheme.addSurface(b);
                continue;
            }
            catch (InvalidFieldException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private static Surface.Builder parseSurface(SBdb ws, Row row, ColType[] columns, boolean appendTypes) throws SBException, SQLException {
        Surface.Builder builder = new Surface.Builder(ws);
        block8: for (short cellNum = row.getFirstCellNum(); cellNum < columns.length; cellNum = (short)(cellNum + 1)) {
            Cell cell = row.getCell((int)cellNum);
            if (cell == null) continue;
            switch (columns[cellNum]) {
                case NAME: {
                    System.out.println(cell.toString());
                    builder.name(cell.getStringCellValue());
                    continue block8;
                }
                case TYPE: {
                    String surfaceName = cell.getStringCellValue();
                    Surface.SurfaceType type = Surface.SurfaceType.parseType(surfaceName, null);
                    if (type == null && !builder.getName().isEmpty()) {
                        type = Surface.SurfaceType.parseType(builder.getName(), null);
                    }
                    builder.type(type);
                    continue block8;
                }
                case AGE: {
                    System.out.println("Age: " + cell.toString());
                    Double age = null;
                    if (cell.getCellType() == CellType.NUMERIC) {
                        age = cell.getNumericCellValue();
                    } else if (cell.getCellType() == CellType.STRING) {
                        try {
                            age = Double.parseDouble(cell.getStringCellValue());
                        }
                        catch (Exception ex) {
                            System.out.println("Error parsing: " + ex.getMessage());
                        }
                    }
                    if (age == null) continue block8;
                    builder.age(age);
                    continue block8;
                }
                case MAGNITUDE: {
                    System.out.println("Magnitude: " + cell.toString());
                    String magnitude = cell.getStringCellValue();
                    if (StringUtils.isBlank((CharSequence)magnitude)) continue block8;
                    if (magnitude.equalsIgnoreCase("major")) {
                        builder.magnitude(Surface.Magnitude.MAJOR.getValue());
                        continue block8;
                    }
                    if (magnitude.contains("medium")) {
                        builder.magnitude(Surface.Magnitude.MEDIUM.getValue());
                        continue block8;
                    }
                    if (!magnitude.contains("minor")) continue block8;
                    builder.magnitude(Surface.Magnitude.MINOR.getValue());
                }
            }
        }
        if (builder.getName().isEmpty() || builder.getType() == null) {
            System.out.println("Didn't build: '" + builder.getName() + "' " + builder.getType());
            return null;
        }
        if (appendTypes && !builder.getName().contains(builder.getTypeString())) {
            builder.name(builder.getName() + " " + builder.getTypeString());
        }
        return builder;
    }

    private static enum ColType {
        NAME(new String[]{"LABEL", "SURFACE", "NAME"}),
        TYPE(new String[]{"TYPE", "SURFACE TYPE"}),
        MAGNITUDE(new String[]{"MAGNITUDE"}),
        AGE(new String[]{"AGE", "MA"});

        private String[] titles;

        private ColType(String[] titles) {
            this.titles = titles;
        }

        static ColType getColumnType(String title) {
            title = title.toUpperCase();
            for (ColType col : ColType.values()) {
                for (int i = 0; i < col.titles.length; ++i) {
                    if (!title.startsWith(col.titles[i])) continue;
                    return col;
                }
            }
            throw new IllegalArgumentException("Unrecognised column title: " + title);
        }
    }
}

