/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import model2_1.SBRestrictable;
import model2_1.SBdb;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class SynonymScheme {
    private final SBdb sbdb;
    private final int ID;
    private String name;
    public static final String DEFAULT_TEXT = "Default scheme";
    private HashMap<Integer, Integer> synonymy = null;

    SynonymScheme(SBdb sbdb, String name) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        this.sbdb = sbdb;
        this.ID = sbdb.nextControl("SYNSCH", "SCH_ID");
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "INSERT INTO " + sbdb.DBTableName("synsch") + " (sch_id,name) VALUES (" + this.ID + "," + SB.DBString((String)name) + ")";
            stmt.executeUpdate(sbdb.modQuery(sql));
            this.name = name;
        }
    }

    SynonymScheme(SBdb SB2, int ID, String name) {
        this.sbdb = SB2;
        this.ID = ID;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getSchID() {
        return this.ID;
    }

    public String toString() {
        return this.getName();
    }

    void load() throws SQLException {
        if (this.synonymy == null) {
            this.synonymy = new HashMap();
        } else {
            this.synonymy.clear();
        }
        String sql = "SELECT spec_id,pref FROM " + this.sbdb.DBTableName("SYNONYMY") + " WHERE sch_id=" + this.ID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int specID = rs.getInt("spec_id");
                int prefID = rs.getInt("pref");
                this.synonymy.put(specID, prefID);
            }
        }
    }

    void addSyn(int specID, int prefID) throws SBException {
        if (this.sbdb.isConnected()) {
            throw new SBException("Attempt to add synonymy to connected instance");
        }
        if (this.synonymy == null) {
            this.synonymy = new HashMap();
        }
        if (this.synonymy.get(specID) != null) {
            if (prefID == this.synonymy.get(specID)) {
                return;
            }
            throw new SBException("Attempt to add preferred term for specID: " + specID + " which already has preferred term: " + prefID);
        }
        this.synonymy.put(specID, prefID);
    }

    SynonymScheme copyToWorkspace(SBdb ws, boolean removeNonWorkspaceTaxa) throws SQLException {
        SynonymScheme wsSch = new SynonymScheme(ws, this.ID, this.name);
        wsSch.synonymy = new HashMap();
        wsSch.synonymy.putAll(this.synonymy);
        if (removeNonWorkspaceTaxa) {
            Iterator<Map.Entry<Integer, Integer>> it = wsSch.synonymy.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Integer> entry = it.next();
                if (ws.getTaxon(entry.getKey()) != null && ws.getTaxon(entry.getValue()) != null) continue;
                it.remove();
            }
        }
        return wsSch;
    }

    int getPref(int specID) throws SQLException {
        Integer pref;
        if (this.synonymy == null) {
            this.load();
        }
        if ((pref = this.synonymy.get(specID)) != null) {
            return pref;
        }
        return 0;
    }

    List getSyn(int prefID) throws SQLException, SBException {
        if (this.synonymy == null) {
            this.load();
        }
        LinkedList<Integer> syn = new LinkedList<Integer>();
        Set<Map.Entry<Integer, Integer>> set = this.synonymy.entrySet();
        for (Map.Entry<Integer, Integer> entry : set) {
            if (entry.getValue() != prefID) continue;
            syn.add(entry.getKey());
        }
        return syn;
    }

    void remove(int specID) throws SQLException, SBPermissionException {
        if (this.synonymy == null) {
            this.load();
        }
        this.delete(specID);
        this.deleteSyn(specID);
    }

    void removeRefs(int specID) throws SQLException, SBPermissionException {
        if (this.synonymy != null) {
            this.synonymy.remove(specID);
            this.removeSyn(specID);
        }
    }

    void delete(int specID) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        if (this.synonymy.get(specID) != null) {
            String sql = "DELETE FROM " + this.sbdb.DBTableName("synonymy") + " WHERE spec_id=" + specID + " AND sch_id=" + this.ID;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            this.synonymy.remove(specID);
        }
    }

    void deleteSyn(int specID) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "DELETE FROM " + this.sbdb.DBTableName("synonymy") + " WHERE pref=" + specID + " AND sch_id=" + this.ID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.removeSyn(specID);
    }

    private void removeSyn(int specID) {
        Set<Map.Entry<Integer, Integer>> set = this.synonymy.entrySet();
        Iterator<Map.Entry<Integer, Integer>> it = set.iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Integer> entry = it.next();
            if (entry.getValue() != specID) continue;
            it.remove();
        }
    }

    void updateSyn(int specID, List<Integer> syn) throws SQLException, SBException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        if (this.synonymy == null) {
            this.load();
        }
        Set<Map.Entry<Integer, Integer>> set = this.synonymy.entrySet();
        for (Map.Entry<Integer, Integer> entry : set) {
            for (Integer synID : syn) {
                if (entry.getValue().intValue() != synID.intValue()) continue;
                throw new SBException("Taxon: " + synID + " is already a preferred term");
            }
        }
        this.deleteSyn(specID);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            for (Integer synID : syn) {
                String sql = "INSERT INTO " + this.sbdb.DBTableName("synonymy") + " (spec_id,pref,sch_id) VALUES (" + synID + "," + specID + "," + this.ID + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        for (Integer n : syn) {
            this.synonymy.put(n, specID);
        }
    }

    public boolean hasSynonyms() {
        return this.synonymy != null && !this.synonymy.isEmpty();
    }

    public HashMap<Integer, Integer> getSynonyms() throws SQLException {
        if (this.synonymy == null) {
            this.load();
        }
        return new HashMap<Integer, Integer>(this.synonymy);
    }

    public int getNTerms() throws SQLException, SBException {
        int nTerms = 0;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT count(spec_id) as nterms FROM " + this.sbdb.DBTableName("SYNONYMY") + " WHERE sch_id=" + this.ID;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                nTerms = rs.getInt("nterms");
            }
            if (this.synonymy == null) {
                this.load();
            }
            if (nTerms != this.synonymy.size()) {
                throw new SBException("Number of terms from scheme: " + this.ID + " does not match synonyms loaded: " + nTerms + " vs. " + this.synonymy.size());
            }
        }
        return nTerms;
    }

    void delete() throws SQLException, SBPermissionException {
        if (this.ID == 1) {
            return;
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName("synonymy") + " WHERE sch_id=" + this.ID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("synsch") + " WHERE sch_id=" + this.ID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    public void setName(String name) throws SQLException, SBException, InvalidFieldException, SBPermissionException {
        if (name.equals(this.name)) {
            return;
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT sch_id FROM " + this.sbdb.DBTableName("synsch") + " WHERE ucase(name)='" + name.toUpperCase() + "'";
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                throw new InvalidFieldException("Scheme already exists");
            }
            sql = "UPDATE " + this.sbdb.DBTableName("synsch") + " SET name=" + SB.DBString((String)name) + " WHERE sch_id=" + this.ID;
            if (stmt.executeUpdate(this.sbdb.modQuery(sql)) != 1) {
                throw new SBException("Cannot update synonym scheme name");
            }
            this.name = name;
        }
    }

    public void writeXML(BufferedWriter out, int indent) throws IOException, SQLException, SBException {
        assert (!this.sbdb.isConnected());
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        String ind2 = (String)ind + (String)ind + (String)ind;
        ind = (String)ind + (String)ind;
        out.write((String)ind + "<SchemeID>" + this.ID + "</SchemeID>\n");
        out.write((String)ind + "<SchemeName>" + SB.getXMLstring((String)this.name) + "</SchemeName>\n");
        for (Map.Entry<Integer, Integer> entry : this.synonymy.entrySet()) {
            out.write((String)ind + "<Entry Species=\"" + SB.getXMLstring((String)this.sbdb.getTaxon(entry.getKey()).toString(false)) + "\">\n");
            out.write(ind2 + "<SpeciesID>" + entry.getKey() + "</SpeciesID>\n");
            out.write(ind2 + "<Pref>" + SB.getXMLstring((String)this.sbdb.getTaxon(entry.getValue()).toString(false)) + "</Pref>\n");
            out.write(ind2 + "<PrefID>" + entry.getValue() + "</PrefID>\n");
            out.write((String)ind + "</Entry>\n");
        }
    }

    static HashMap<Integer, SynonymScheme> getSchemes(SBdb sbdb) throws SQLException {
        HashMap<Integer, SynonymScheme> schemes = new HashMap<Integer, SynonymScheme>();
        schemes.put(1, new SynonymScheme(sbdb, 1, DEFAULT_TEXT));
        if (sbdb.isConnected()) {
            Statement stmt = sbdb.getDatabase().createStatement();
            String sql = "SELECT sch_id,name FROM " + sbdb.DBTableName("SYNSCH");
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int ID = rs.getInt("sch_id");
                String name = rs.getString("name");
                if (schemes.get(ID) == null) {
                    schemes.put(ID, new SynonymScheme(sbdb, ID, name));
                    continue;
                }
                if (ID == 1) continue;
                System.out.println("Duplicate Synonym Scheme: " + ID + "," + name);
            }
        }
        return schemes;
    }
}

