/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.sql.SQLException;
import java.util.Comparator;
import model2_1.Taxon;
import model2_1.TaxonCompareGenus;
import util.exception.StackError;

class TaxonCompareSIPMCode
implements Comparator {
    private int dict;
    private TaxonCompareGenus cascade = null;

    public TaxonCompareSIPMCode(int dict, TaxonCompareGenus cascade) {
        this.dict = dict;
        this.cascade = cascade;
    }

    public int compare(Object t2, Object t1) {
        Taxon taxon1 = (Taxon)t1;
        Taxon taxon2 = (Taxon)t2;
        int retval = 0;
        try {
            if (taxon2.getSipmCode(this.dict) == null) {
                if (taxon1.getSipmCode(this.dict) != null) {
                    retval = 1;
                }
            } else {
                retval = taxon1.getSipmCode(this.dict) == null ? -1 : taxon2.getSipmCode(this.dict).compareTo(taxon1.getSipmCode(this.dict));
            }
            if (retval == 0 && this.cascade != null) {
                return this.cascade.compare(t2, t1);
            }
        }
        catch (SQLException sql) {
            StackError.showStackError((String)"SQL Error", (SQLException)sql);
        }
        return retval;
    }
}

