/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.logging.Logger;
import model2_1.SBdb;
import model2_1.Taxon;

public class TaxonReferenceCache {
    private static final Logger LOGGER = Logger.getLogger(TaxonReferenceCache.class.getName());
    private HashMap<Integer, CachedTaxonReference> cache;

    void init(SBdb sbdb) throws SQLException {
        if (!sbdb.isConnected()) {
            return;
        }
        LOGGER.info("Cacheing notes, references and urls...");
        this.cache = new HashMap();
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            CachedTaxonReference rc;
            int specID;
            String sql = "SELECT spec_id, notes FROM " + sbdb.DBTableName("TXNOTES");
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                specID = rs.getInt("spec_id");
                String notes = rs.getString("notes");
                if (notes == null || notes.isEmpty()) continue;
                rc = this.cache.get(specID);
                if (rc == null) {
                    rc = new CachedTaxonReference();
                    rc.notes = notes;
                    this.cache.put(specID, rc);
                    continue;
                }
                rc.notes = notes;
            }
            sql = "SELECT spec_id, reference FROM " + sbdb.DBTableName("TXREFS");
            rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                specID = rs.getInt("spec_id");
                String refs = rs.getString("reference");
                if (refs == null || refs.isEmpty()) continue;
                rc = this.cache.get(specID);
                if (rc == null) {
                    rc = new CachedTaxonReference();
                    rc.refs = refs;
                    this.cache.put(specID, rc);
                    continue;
                }
                rc.refs = refs;
            }
            sql = "SELECT spec_id, url FROM " + sbdb.DBTableName("TXURL");
            rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                specID = rs.getInt("spec_id");
                String url = rs.getString("url");
                if (url == null || url.isEmpty()) continue;
                rc = this.cache.get(specID);
                if (rc == null) {
                    rc = new CachedTaxonReference();
                    rc.url = url;
                    this.cache.put(specID, rc);
                    continue;
                }
                rc.url = url;
            }
        }
    }

    void loadNotesAndRefs(SBdb db, Statement dbStmt, Taxon taxon) throws SQLException {
        CachedTaxonReference rc;
        if (this.cache == null) {
            this.init(db);
        }
        if ((rc = this.cache.get(taxon.getSpecID())) != null) {
            taxon.loadNotesAndRefs(dbStmt);
        }
    }

    void updateNoteRefs(Taxon taxon, String notes, String reference, String url) {
        if (this.cache == null) {
            return;
        }
        CachedTaxonReference rc = this.cache.get(taxon.getSpecID());
        if (rc == null) {
            rc = new CachedTaxonReference();
            rc.specID = taxon.getSpecID();
            this.cache.put(taxon.getSpecID(), rc);
        }
        rc.notes = notes;
        rc.refs = reference;
        rc.url = url;
    }

    private static class CachedTaxonReference {
        int specID;
        String notes;
        String refs;
        String url;

        private CachedTaxonReference() {
        }
    }
}

