/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import model2_1.AbnScheme;
import model2_1.AnalystHeader;
import model2_1.Audit;
import model2_1.Biocom;
import model2_1.Casing;
import model2_1.CasingPoint;
import model2_1.CoOccurrence;
import model2_1.CoreImage;
import model2_1.CoredInterval;
import model2_1.Cores;
import model2_1.Coreshift;
import model2_1.Curve;
import model2_1.Curves;
import model2_1.EnvScheme;
import model2_1.GrainSizeList;
import model2_1.IGDInterval;
import model2_1.IGDIntervalZone;
import model2_1.IPSBathy;
import model2_1.ImageSet;
import model2_1.InterpHdr;
import model2_1.LithBase;
import model2_1.LithInterval;
import model2_1.LithQualifier;
import model2_1.Lithdesc;
import model2_1.Lithology;
import model2_1.Markers;
import model2_1.SBImage;
import model2_1.SBRestrictable;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SampleInsertException;
import model2_1.SampleLithologyUnit;
import model2_1.SampleType;
import model2_1.SeismicMarker;
import model2_1.Smpdtl;
import model2_1.TVDList;
import model2_1.TVDepth;
import model2_1.TWTDepth;
import model2_1.TWTList;
import model2_1.Taxon;
import model2_1.TaxonCompareGenus;
import model2_1.TaxonCompareSpecies;
import model2_1.TaxonOcc;
import model2_1.Userdef;
import model2_1.WellHeader;
import model2_1.WellInterp;
import model2_1.api.Discipline;
import model2_1.exception.NotInitialisedException;
import util.DepthUtils;
import util.InvalidFieldException;
import util.RSUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsCompoundEdit;
import util.SbugsEdit;
import util.SortEntryComparator;
import util.exception.StackError;
import util.status.DTMonitor;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public class Well
extends SBRestrictable
implements Comparable {
    final SBdb db;
    private final int wellID;
    private final SampleList samples = new SampleList();
    private final HashSet<Integer> sampleAgesLoaded = new HashSet();
    WellHeader header = new WellHeader();
    Coreshift coreShift;
    private boolean analysesLoaded = false;
    private List<AnalystHeader> analystHeaders;
    List<WellInterp> interps;
    List<LithBase> lithIntervals;
    private final GrainSizeList grainSize = new GrainSizeList();
    Cores cores;
    List<CoreImage> coreImages;
    Casing casing;
    Curves curves;
    Markers markers;
    TVDList TVD;
    TVDList TVDplan;
    TWTList TWT;
    IPSBathy ipsBathy;
    public static final int SORTDOWNHOLE = 0;
    public static final int SORTUPHOLE = 1;
    public static final int SORTALPHA = 3;

    public SBdb getDataModel() {
        return this.db;
    }

    void updateHeader(WellHeader header) throws SQLException, SBException {
        this.header.update(this.db, header);
    }

    public int getWellID() {
        return this.wellID;
    }

    @Override
    public int getID() {
        return this.wellID;
    }

    public String getWellName() {
        return this.header.getWellName();
    }

    public String getWellCode() {
        return this.header.getWellCode();
    }

    public char getType() {
        return this.header.getType();
    }

    public char getWellUnits() {
        return this.header.getWellUnits();
    }

    public double getTD() {
        return this.header.getTD();
    }

    public WellHeader getHeader() {
        return this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Sample> getSamples() throws SQLException {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            if (this.samples.samples == null) {
                this.samples.samples = new TreeSet();
                this.loadSamples();
            }
            return new ArrayList<Sample>(this.samples.samples);
        }
    }

    public List<Sample> getSamples(boolean corrected, boolean correctCuttings) throws SQLException {
        List<Sample> samps = this.getSamples();
        if (!corrected) {
            return samps;
        }
        LinkedList<Sample.CorrectedSample> corrSamps = new LinkedList<Sample.CorrectedSample>();
        for (Sample sample : samps) {
            double corrDepth = this.getDepth(sample, corrected, correctCuttings);
            corrSamps.add(new Sample.CorrectedSample(corrDepth, sample));
        }
        Collections.sort(corrSamps);
        LinkedList<Sample> list = new LinkedList<Sample>();
        for (Sample.CorrectedSample cs : corrSamps) {
            list.add(cs.sample);
        }
        return list;
    }

    public List<LithBase> getLithIntervals() throws SQLException {
        if (this.lithIntervals == null) {
            this.lithIntervals = new LinkedList<LithBase>();
            if (this.db != null && this.db.isConnected()) {
                this.db.getLithdesc();
                this.loadLithIntervals(this.lithIntervals, this.db.lithdesc);
                this.loadLithQualifiers(this.lithIntervals, this.db.lithdesc);
            }
        }
        return this.lithIntervals;
    }

    public void loadLithology() throws SQLException {
        this.lithIntervals = new LinkedList<LithBase>();
        this.loadLithIntervals(this.lithIntervals, this.db.lithdesc);
        this.loadLithQualifiers(this.lithIntervals, this.db.lithdesc);
    }

    public Cores getCores() throws SQLException, SBException {
        if (this.cores == null) {
            this.cores = new Cores(this.db);
            if (this.db != null && this.db.isConnected()) {
                this.cores.load(this.wellID);
            }
        }
        return this.cores;
    }

    public void deleteCoredIntervals(Collection<CoredInterval> toDelete) throws SBPermissionException, SQLException, SBException {
        if (!this.canWrite(this.db, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "well", true));
        }
        this.cores.delete(this.wellID, toDelete);
        this.db.updateAuditTrail("CORES", "DELETE " + toDelete.size() + " from " + this.toString() + " [" + this.getWellID() + "]");
    }

    public List<CoreImage> getCoreImages() throws SQLException {
        if (this.coreImages == null) {
            this.coreImages = new LinkedList<CoreImage>();
            if (this.db != null && this.db.isConnected()) {
                CoreImage.load(this.wellID, this.db, this.coreImages);
                System.out.println("Loaded core images");
            }
        }
        return this.coreImages;
    }

    public void deleteCoreImage(CoreImage coreImage) throws SBException, SQLException {
        if (this.coreImages == null) {
            throw new SBException("Attempt to delete core image when no images loaded");
        }
        if (!this.canWrite(this.db, null)) {
            throw new SBException(this.getDeniedReason(this.db, "well", true));
        }
        coreImage.delete(this.wellID);
        this.coreImages.remove(coreImage);
        this.setChanged();
        this.notifyObservers(coreImage);
    }

    public CoreImage addCoreImage(double topDepth, double baseDepth, SBImage image) throws SBException, SQLException, FileNotFoundException, IOException {
        if (this.coreImages == null) {
            throw new SBException("Attempt to add core image when no images loaded");
        }
        if (!this.canWrite(this.db, null)) {
            throw new SBException(this.getDeniedReason(this.db, "well", true));
        }
        CoreImage coreImage = new CoreImage(this.db, this.wellID, topDepth, baseDepth, image);
        int insertPoint = 0;
        for (CoreImage ci : this.coreImages) {
            if (ci.getTopDepth() > coreImage.getTopDepth()) break;
            ++insertPoint;
        }
        this.coreImages.add(insertPoint, coreImage);
        this.setChanged();
        this.notifyObservers(coreImage);
        return coreImage;
    }

    public Casing getCasing() throws SQLException {
        if (this.casing == null) {
            this.casing = new Casing(this.db);
            if (this.db != null && this.db.isConnected()) {
                this.casing.load(this.wellID);
            }
        }
        return this.casing;
    }

    public Casing getCasing(boolean refresh) throws SQLException {
        if (refresh && this.casing != null) {
            this.casing.deleteObservers();
            this.casing = null;
        }
        return this.getCasing();
    }

    public void addCasingPoint(double depth, String diam) throws SBPermissionException, SBException, SQLException {
        if (!Well.canWrite(this.db)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "well", true));
        }
        CasingPoint point = new CasingPoint(depth, diam);
        this.casing.checkOverlap(point);
        point.store(this.db, this.wellID);
        this.casing.add(point);
    }

    public void deleteCasingPoints(Collection<CasingPoint> toDelete) throws SBPermissionException, SQLException, SBException {
        if (!Well.canWrite(this.db)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "well", true));
        }
        this.casing.delete(this.wellID, toDelete);
        this.db.updateAuditTrail("CASING", "DELETE " + toDelete.size() + " from " + this.toString() + " [" + this.getWellID() + "]");
    }

    public Markers getMarkers() throws SQLException {
        if (this.markers == null) {
            this.markers = new Markers(this.db);
            if (this.db != null && this.db.isConnected()) {
                this.markers.load(this.wellID);
            }
        }
        return this.markers;
    }

    public void addMarker(double depth, String name, Color colour) throws SBPermissionException, SQLException, SBException {
        if (!this.canWrite(this.db, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "well", true));
        }
        SeismicMarker marker = new SeismicMarker(depth, name, colour);
        this.markers.checkOverlap(marker);
        marker.store(this.db, this.wellID);
        this.markers.add(marker);
    }

    public void deleteMarkers(Collection<SeismicMarker> toDelete) throws SBPermissionException, SQLException {
        if (!this.canWrite(this.db, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "well", true));
        }
        this.markers.delete(this.wellID, toDelete);
        this.db.updateAuditTrail("MARKER", "DELETE " + toDelete.size() + " from " + this.toString() + " [" + this.wellID + "]");
    }

    public TVDList getTVDlist(boolean isPlan) throws SQLException {
        if (isPlan) {
            if (this.TVDplan == null) {
                this.TVDplan = new TVDList(this.db, true);
                if (this.db != null && this.db.isConnected()) {
                    this.TVDplan.load(this.wellID);
                }
            }
            return this.TVDplan;
        }
        if (this.TVD == null) {
            this.TVD = new TVDList(this.db, false);
            if (this.db != null && this.db.isConnected()) {
                this.TVD.load(this.wellID);
            }
        }
        return this.TVD;
    }

    public TWTList getTWTlist() throws SQLException {
        if (this.TWT == null) {
            this.TWT = new TWTList(this.db);
            if (this.db != null && this.db.isConnected()) {
                this.TWT.load(this.wellID);
            }
        }
        return this.TWT;
    }

    public IPSBathy getIPSBathy() throws SQLException {
        if (this.ipsBathy == null) {
            this.ipsBathy = new IPSBathy(this.db, this.wellID);
        }
        return this.ipsBathy;
    }

    void removeInterp(WellInterp wellInterp) {
        if (this.interps.remove(wellInterp)) {
            this.setChanged();
        }
    }

    public Iterator<WellInterp> getInterpIterator() {
        return this.interps.iterator();
    }

    public WellInterp getInterp(int interpID) throws SBException {
        Iterator<WellInterp> iterator = this.interps.iterator();
        while (iterator.hasNext()) {
            WellInterp interp;
            WellInterp thisInterp = interp = iterator.next();
            if (interpID != thisInterp.interpID) continue;
            return thisInterp;
        }
        throw new SBException("InterpID: " + interpID + " not found in well: " + this);
    }

    public WellInterp getAddInterp(int interpID, HashMap<Integer, InterpHdr> interpHdrs) throws SQLException {
        for (WellInterp interp : this.interps) {
            if (interpID != interp.interpID) continue;
            return interp;
        }
        WellInterp thisInterp = new WellInterp(this.db, interpID, interpHdrs, this.header.getType(), true);
        this.interps.add(thisInterp);
        this.setChanged();
        this.notifyObservers(thisInterp);
        return thisInterp;
    }

    public WellInterp getAddInterp(InterpHdr interpHdr) throws SQLException {
        for (WellInterp interp : this.interps) {
            if (interpHdr.getInterpID() != interp.interpID) continue;
            return interp;
        }
        WellInterp thisInterp = new WellInterp(this.db, interpHdr.getInterpID(), this.db.getInterpHdrs(), this.header.getType(), true);
        this.interps.add(thisInterp);
        this.setChanged();
        this.notifyObservers(thisInterp);
        return thisInterp;
    }

    public boolean hasInterpLoaded(int interpID) {
        if (this.interps == null) {
            return false;
        }
        for (WellInterp thisInterp : this.interps) {
            if (interpID != thisInterp.interpID) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.wellID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAnalyses(AnalystHeader hdr) throws SQLException, SBException {
        Object sql;
        try (Statement stmt = this.db.getDatabase().createStatement();){
            if (!this.canWrite(this.db, stmt)) {
                throw new SBException(this.getDeniedReason(this.db, "delete analyses", "well", true));
            }
            sql = "SELECT DISTINCT image_set_id FROM " + this.db.DBTableName("TAXONOCC") + " WHERE well_id=" + this.wellID + " AND analy_id=" + hdr.getAnalyID();
            LinkedList<Integer> imageSetIDs = new LinkedList<Integer>();
            ResultSet rs = stmt.executeQuery(this.db.modQuery((String)sql));
            while (rs.next()) {
                imageSetIDs.add(rs.getInt("image_set_id"));
            }
            sql = "DELETE FROM " + this.db.DBTableName("TAXONOCC") + " WHERE well_id=" + this.wellID + " AND analy_id=" + hdr.getAnalyID();
            stmt.executeUpdate(this.db.modQuery((String)sql));
            for (Integer i : imageSetIDs) {
                System.out.println("Deleting imageSet: " + i);
                ImageSet.deleteWithTypeCheck(this.db, i, this.wellID);
            }
            sql = "DELETE FROM " + this.db.DBTableName("SMPDTL") + " WHERE well_id=" + this.wellID + " AND analy_id=" + hdr.getAnalyID();
            stmt.executeUpdate(this.db.modQuery((String)sql));
            sql = "DELETE FROM " + this.db.DBTableName("ANALY_HDR") + " WHERE well_id=" + this.wellID + " AND analy_id=" + hdr.getAnalyID();
            stmt.executeUpdate(this.db.modQuery((String)sql));
        }
        Sample changedSample = null;
        sql = this.samples;
        synchronized (sql) {
            for (Sample sample : this.samples) {
                sample.removeDtl(hdr.getAnalyID());
                if (!sample.hasChanged()) continue;
                changedSample = sample;
            }
        }
        Iterator<AnalystHeader> itH = this.analystHeaders.iterator();
        while (itH.hasNext()) {
            if (itH.next() != hdr) continue;
            itH.remove();
        }
        this.setChanged();
        this.notifyObservers();
        if (changedSample != null) {
            changedSample.notifyObservers();
        }
    }

    public int getAnalysesOccs(AnalystHeader hdr) throws SBException, SQLException {
        int nOccs = 0;
        for (Smpdtl dtl : this.getAnalyses(hdr.getDiscID(), hdr.getAnalyst(), hdr.getAnalyNumber())) {
            if (dtl.getAnalyID() != hdr.getAnalyID()) continue;
            ++nOccs;
        }
        return nOccs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSmpdtl(Sample dbSample, Smpdtl dbSmpdtl) throws SBException {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            dbSample.addDtl(dbSmpdtl);
        }
    }

    public boolean setAnalystHeader(AnalystHeader hdr, double top, double base, Date from, Date to, String comments, int envSchID, int abnSchID, Color colour) throws SQLException, SBException {
        boolean updated = false;
        if (!this.canWrite(this.db, null)) {
            throw new SBException(this.getDeniedReason(this.db, "well", true));
        }
        EnvScheme envSch = null;
        if (envSchID > 0) {
            envSch = this.db.getEnvScheme(envSchID);
        }
        AbnScheme abnSch = null;
        if (abnSchID > 0) {
            abnSch = this.db.getAbnScheme(abnSchID, true);
        }
        Iterator<Smpdtl> it = this.getAnalyses(hdr.getDiscID(), hdr.getAnalyst(), hdr.getAnalyNumber()).iterator();
        double topTemp = 99999.0;
        double baseTemp = 0.0;
        while (it.hasNext()) {
            double depth;
            Smpdtl dtl = it.next();
            if (dtl.getAnalyID() != hdr.getAnalyID()) continue;
            if (dtl.getCreated() != null && (from == null || dtl.getCreated().before(from))) {
                updated = true;
                from = dtl.getCreated();
            }
            if (dtl.getCreated() != null && (to == null || dtl.getCreated().after(to))) {
                updated = true;
                to = dtl.getCreated();
            }
            if ((depth = dtl.getSample().getDepth()) < topTemp) {
                topTemp = depth;
            }
            if (depth > baseTemp) {
                baseTemp = depth;
            }
            if (envSch != null) {
                if (dtl.getProximal() > envSch.getNClasses()) {
                    throw new SBException("Cannot assign palaeoenvironment scheme because sample data environment falls outside new scheme");
                }
                if (dtl.getDistal() > envSch.getNClasses()) {
                    throw new SBException("Cannot assign palaeoenvironment scheme because sample data environment falls outside new scheme");
                }
            }
            if (dtl.checkSubjAbunds(abnSch)) continue;
            throw new SBException("Abundance scheme not appropriate for existing abundance data in sample set in depth: " + dtl.getSample());
        }
        if (topTemp < 99999.0 && topTemp > top) {
            updated = true;
            top = topTemp;
        }
        if (baseTemp > base) {
            updated = true;
            base = baseTemp;
        }
        hdr.update(this.wellID, top, base, from, to, comments, envSchID, abnSchID, colour);
        this.setChanged();
        return updated;
    }

    void loadAnalystHeaders() throws SQLException {
        if (this.analystHeaders == null) {
            this.analystHeaders = new LinkedList<AnalystHeader>();
            if (this.db != null && this.db.isConnected()) {
                AnalystHeader.loadAll(this.db, this.wellID, this.analystHeaders);
            }
        }
    }

    public List<AnalystHeader> getAnalystHeaders() throws SQLException {
        this.loadAnalystHeaders();
        return new LinkedList<AnalystHeader>(this.analystHeaders);
    }

    public Iterator<AnalystHeader> getAnalystHeaderIterator() throws SQLException {
        return this.getAnalystHeaders().iterator();
    }

    public AnalystHeader addAnalystHeader(String analyst, char discID, int analyNumber, Double top, Double base, Date from, Date to, String comments, int envSchID, int abnSchID, Color colour) throws SQLException, SBException {
        if (!this.canWrite(this.db, null)) {
            throw new SBException(this.getDeniedReason(this.db, "well", true));
        }
        if (this.getAnalystHeader(analyst, discID, analyNumber, false) != null) {
            throw new SBException("Analyst Header already exists");
        }
        AnalystHeader hdr = new AnalystHeader(this.db, this.wellID, analyst, Discipline.getDisc(discID), analyNumber, from, to, top, base, comments, envSchID, abnSchID, colour);
        this.analystHeaders.add(hdr);
        this.setChanged();
        this.notifyObservers(hdr);
        return hdr;
    }

    void addAnalystHeader(AnalystHeader hdr) throws SBException, SQLException {
        if (this.getAnalystHeader(hdr.getAnalyst(), hdr.getDiscID(), hdr.getAnalyNumber(), false) != null) {
            throw new SBException("Analyst Header already exists");
        }
        this.analystHeaders.add(hdr);
    }

    public void setAnalystHeader(AnalystHeader hdr, String analyst, char discID, int analyNumber) throws SQLException, SBException {
        if (!this.canWrite(this.db, null)) {
            throw new SBException(this.getDeniedReason(this.db, "well", true));
        }
        AnalystHeader existing = this.getAnalystHeader(analyst, discID, analyNumber, false);
        if (existing != null && existing.getAnalyID() != hdr.getAnalyID()) {
            throw new SBException("Cannot update analyst header details - header already exists");
        }
        hdr.updateDetails(this.wellID, this.db.getUserID(analyst), Discipline.getDisc(discID), analyNumber);
        this.setChanged();
        this.notifyObservers(hdr);
    }

    public AnalystHeader getAnalystHeader(String analyst, char discID, int analyNo, boolean create) throws SQLException, SBException {
        this.loadAnalystHeaders();
        Iterator<AnalystHeader> it = this.analystHeaders.iterator();
        AnalystHeader aHead = null;
        while (it.hasNext()) {
            AnalystHeader aHeader = it.next();
            if (!analyst.equalsIgnoreCase(aHeader.getAnalyst()) || discID != aHeader.getDiscID() || analyNo != aHeader.getAnalyNumber()) continue;
            aHead = aHeader;
            break;
        }
        if (aHead == null && create) {
            aHead = new AnalystHeader(this.db, this.wellID, analyst, Discipline.getDisc(discID), analyNo, this.analystHeaders.size());
            this.analystHeaders.add(aHead);
        }
        return aHead;
    }

    AnalystHeader getAnalystHeader(int analyID, boolean load) throws SQLException, SBException {
        this.loadAnalystHeaders();
        Iterator<AnalystHeader> it = this.analystHeaders.iterator();
        AnalystHeader analystHeader = null;
        while (it.hasNext()) {
            AnalystHeader aHeader = it.next();
            if (aHeader.getAnalyID() != analyID) continue;
            analystHeader = aHeader;
            break;
        }
        if (analystHeader == null && load) {
            analystHeader = new AnalystHeader(this.db, this.wellID, analyID);
            this.analystHeaders.add(analystHeader);
        }
        return analystHeader;
    }

    public char getPrefUnits(char units) {
        if (units == 'D') {
            units = this.header.getWellUnits();
        }
        return units;
    }

    String wellCode() {
        return this.header.getWellCode();
    }

    char type() {
        return this.header.getType();
    }

    public void fillInterpCombo(JComboBox combo) {
        combo.removeAllItems();
        Iterator<WellInterp> it = this.interps.iterator();
        while (it.hasNext()) {
            combo.addItem(it.next());
        }
    }

    public void loadInterps() throws SQLException, SBException {
        this.loadInterps(this.db.getInterpHdrs());
    }

    public void loadInterp(WellInterp wellInterp) throws SQLException, SBException {
        this.getSamples();
        wellInterp.load(this);
        this.loadSampleAges(wellInterp.interpID);
    }

    private void queryInterp(Statement stmt, HashMap<Integer, InterpHdr> interpHdrs, String tableName) throws SQLException {
        String sql = "SELECT DISTINCT interp_id FROM " + this.db.DBTableName(tableName) + " WHERE well_id=" + this.wellID;
        ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
        int interpID = 0;
        while (rs.next()) {
            try {
                interpID = rs.getInt("interp_id");
                this.getInterp(interpID);
            }
            catch (SBException se) {
                this.interps.add(new WellInterp(this.db, interpID, interpHdrs, this.type(), false));
            }
        }
    }

    void loadInterps(HashMap<Integer, InterpHdr> interpHdrs) throws SQLException, SBException {
        if (this.interps != null) {
            return;
        }
        this.interps = new LinkedList<WellInterp>();
        if (this.db.isConnected()) {
            try {
                String sql = "select INTERP_ID from " + this.db.DBTableName("IGD") + " where WELL_ID = ? union select INTERP_ID from " + this.db.DBTableName("IGD_LSTRAT") + " where WELL_ID = ? union select INTERP_ID from " + this.db.DBTableName("IGD_ENV") + " where WELL_ID = ? union select INTERP_ID from " + this.db.DBTableName("BCMMNTS") + " where WELL_ID = ? union select INTERP_ID from " + this.db.DBTableName("EVENTS") + " where WELL_ID = ? union select INTERP_ID from " + this.db.DBTableName("SQPICK") + " where WELL_ID = ? union select INTERP_ID from " + this.db.DBTableName("INTCMMNTS") + " where WELL_ID = ? union select INTERP_ID from " + this.db.DBTableName("LOC") + " where WELL_ID = ? union select INTERP_ID from " + this.db.DBTableName("FAULTS") + " where WELL_ID = ? union select INTERP_ID from " + this.db.DBTableName("SBSSR") + " where WELL_ID = ?";
                PreparedStatement stmt = this.db.getDatabase().prepareStatement(this.db.modQuery(sql));
                for (int i = 1; i <= 10; ++i) {
                    stmt.setInt(i, this.wellID);
                }
                ResultSet rs = stmt.executeQuery();
                int interpID = 0;
                while (rs.next()) {
                    try {
                        interpID = rs.getInt("interp_id");
                        this.getInterp(interpID);
                    }
                    catch (SBException se) {
                        this.interps.add(new WellInterp(this.db, interpID, interpHdrs, this.type(), false));
                    }
                }
            }
            catch (Exception e) {
                this.interps = null;
                throw e;
            }
        }
        this.getAddInterp(0, interpHdrs);
    }

    public void loadGrainSize() throws SQLException {
        if (this.grainSize.size() == 0 && this.db != null && this.db.isConnected()) {
            this.grainSize.load(this.db, this.wellID);
        }
    }

    public GrainSizeList getGrainSize() {
        return this.grainSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeCoOcc(List coOcc, boolean addAbund) throws SQLException, SBException, FileNotFoundException, IOException {
        if (!this.canWrite(this.db, null)) {
            throw new SBException("Cannot update read-only well: " + this);
        }
        for (CoOccurrence occ : coOcc) {
            TaxonOcc donor = null;
            TaxonOcc target = null;
            Sample sample = null;
            Smpdtl dtl = null;
            SampleList sampleList = this.samples;
            synchronized (sampleList) {
                for (Sample s : this.samples) {
                    if (s.getSampID() != occ.sampID) continue;
                    for (Smpdtl smpdtl : s.getAnalyses()) {
                        if (smpdtl.getAnalyID() != occ.analyID) continue;
                        dtl = smpdtl;
                        sample = s;
                        Iterator<TaxonOcc> occIt = smpdtl.getOccurIterator();
                        while (occIt.hasNext()) {
                            TaxonOcc to = occIt.next();
                            if (to.getTaxon() == occ.donor.getTaxon() && to.getIdentType() == occ.donor.getIdentType() && to.getReworked() == occ.donor.getReworked() && to.getSpecType() == occ.donor.getSpecType()) {
                                donor = to;
                            }
                            if (to.getTaxon() != occ.target.getTaxon() || to.getIdentType() != occ.target.getIdentType() || to.getReworked() != occ.target.getReworked() || to.getSpecType() != occ.target.getSpecType()) continue;
                            target = to;
                        }
                        break block4;
                    }
                }
            }
            if (donor == null || target == null) {
                throw new SBException("Cannot relocate donor/target in merge CoOccurrences");
            }
            if (addAbund) {
                String comments;
                String colour;
                String preserv;
                int coarse = target.getCoarse() + donor.getCoarse();
                int medium = target.getMedium() + donor.getMedium();
                int fine = target.getFine() + donor.getFine();
                String subjAbund = target.getSubAbund();
                if (donor.getSubAbund() != null && donor.getSubAbund().length() > 0) {
                    if (subjAbund == null || subjAbund.length() == 0) {
                        subjAbund = donor.getSubAbund();
                    } else {
                        int schID = this.getAnalystHeader(occ.analyID, false).getAbnSchID();
                        if (schID == 0) {
                            throw new SBException("Cannot merge semi-quantitative abundance: abundance scheme not set.");
                        }
                        AbnScheme scheme = this.db.getAbnScheme(schID, false);
                        if (scheme == null) {
                            throw new SBException("Cannot merge semi-quantitative abundance: abundance scheme not found.");
                        }
                        subjAbund = scheme.getAbr(scheme.getCount(subjAbund) + scheme.getCount(donor.getSubAbund()));
                    }
                }
                boolean marker = target.isMarker();
                if (donor.isMarker()) {
                    marker = true;
                }
                boolean caved = target.getCaved();
                if (donor.getCaved()) {
                    caved = true;
                }
                if ((preserv = target.getPreservation()) == null || preserv.length() == 0) {
                    preserv = donor.getPreservation();
                }
                if ((colour = target.getColour()) == null || colour.length() == 0) {
                    colour = donor.getColour();
                }
                if ((comments = target.getComment()) == null || comments.length() == 0) {
                    comments = donor.getComment();
                }
                ImageSet imageSet = null;
                if (target.hasImageSet()) {
                    imageSet = target.getImageSet();
                }
                if (imageSet == null && donor.hasImageSet()) {
                    imageSet = donor.getImageSet();
                    donor.deleteImageSet(this.wellID, occ.sampID, occ.analyID);
                }
                dtl.deleteOcc(this.wellID, target);
                dtl.insertOccurrence(new TaxonOcc.Builder(this.db, target.getTaxon(), target.getReworked(), target.getQuestionable(), target.getSpecType()).count(coarse, medium, fine).subjAbund(subjAbund).caved(caved).marker(marker).preservation(preserv).colour(colour).comment(comments).imageSet(imageSet), this.wellID, true);
            }
            dtl.deleteOcc(this.wellID, donor);
            dtl.notifyObservers();
        }
    }

    public void mergeTaxa(Taxon donor, Taxon target) throws SQLException, SBException {
        try (Statement stmt = this.db.getDatabase().createStatement();){
            if (!this.canWrite(this.db, stmt)) {
                throw new SBException(this.getDeniedReason(this.db, "merge taxa", "well", true));
            }
            String sql = "UPDATE " + this.db.DBTableName("taxonocc") + " SET spec_id=" + target.getSpecID() + " WHERE spec_id=" + donor.getSpecID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            this.updateTaxonRef(donor, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTaxonRef(Taxon donor, Taxon target) throws SBException {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            if (this.samples.samples == null) {
                return;
            }
            for (Sample s : this.samples) {
                for (Smpdtl d : s.getAnalysesCopy()) {
                    if (!d.updateTaxonRef(donor, target)) continue;
                    d.notifyObservers();
                }
            }
        }
    }

    Well(SBdb sbdb, int wellID) throws SQLException, SBException, SBPermissionException {
        super("WELL_IDENT", "WELL_ID", true);
        if (wellID <= 0) {
            throw new IllegalArgumentException("Attempt to create a well with ID: " + wellID);
        }
        if (sbdb == null) {
            throw new IllegalArgumentException("Attempt to create a well with null data model");
        }
        this.db = sbdb;
        this.wellID = wellID;
        if (this.db.isConnected()) {
            if (!this.canRead(this.db, null)) {
                throw new SBPermissionException("You do not have permission to access well: " + this.getWellName() + "/" + this.getWellCode());
            }
            this.header.load(sbdb, wellID);
        }
    }

    public int compareTo(Object o) {
        Well rhs = (Well)o;
        return this.header.compareTo(rhs.header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSampleNearestBelow(double depth, boolean correctDepths, boolean correctCuttings, Discipline discID) throws SBException, SQLException {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                if (!(depth <= this.getDepth(sample, correctDepths, correctCuttings))) continue;
                if (discID != null) {
                    if (sample.getAnySmpdtl(discID.getChar(), "") == null) continue;
                    return sample;
                }
                return sample;
            }
        }
        return null;
    }

    public Sample getSampleNearestAbove(double depth, boolean correctDepths, boolean correctCuttings, Discipline discID) throws SQLException, SBException {
        List<Sample> sampleList = this.getSamples();
        for (int i = sampleList.size() - 1; i >= 0; --i) {
            Sample sample = sampleList.get(i);
            if (!(depth >= this.getDepth(sample, correctDepths, correctCuttings))) continue;
            if (discID != null) {
                if (sample.getAnySmpdtl(discID.getChar(), "") == null) continue;
                return sample;
            }
            return sample;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSampleNearest(double depth, float withinRange, boolean correctDepths, boolean correctCuttings) throws SQLException, SBException {
        Sample sample = null;
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample1 : this.samples) {
                double distAbove;
                sample = sample1;
                double sampleDepth = this.getDepth(sample, correctDepths, correctCuttings);
                if (!(depth <= sampleDepth)) continue;
                double distBelow = sampleDepth - depth;
                Sample sampleAbove = this.getSampleNearestAbove(depth, correctDepths, correctCuttings, null);
                if (sampleAbove != null && (distAbove = depth - this.getDepth(sampleAbove, correctDepths, correctCuttings)) < distBelow && distAbove < (double)withinRange) {
                    return sampleAbove;
                }
                if (distBelow < (double)withinRange) {
                    return sample;
                }
                return null;
            }
        }
        if (sample != null && this.getDepth(sample, correctDepths, correctCuttings) - depth < (double)withinRange) {
            return sample;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSampleNearestWithinRange(double depth, boolean correctDepths, boolean correctCuttings, float mdMin, float mdMax) throws SQLException, SBException {
        Sample nearest = null;
        double nearestMDdiff = Math.abs(mdMax - mdMin);
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                double sampleDepth = this.getDepth(sample, correctDepths, correctCuttings);
                if (sampleDepth < (double)mdMin) continue;
                if (sampleDepth > (double)mdMax) break;
                double diff = Math.abs(depth - sampleDepth);
                if (!(diff < nearestMDdiff)) continue;
                nearest = sample;
                nearestMDdiff = diff;
            }
        }
        if (nearest != null) {
            return nearest;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSample(double depth, String type, boolean useAnyType) {
        if (!useAnyType && type == null) {
            type = "CU";
        }
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                if (!useAnyType && !sample.getTypeString().equals(type)) continue;
                if (this.db.useSampleTops()) {
                    if (sample.getTopDepth() == null || !(Math.abs(depth - sample.getTopDepth()) < (double)0.0029f)) continue;
                    return sample;
                }
                if (sample.getBaseDepth() == null || !(Math.abs(depth - sample.getBaseDepth()) < (double)0.0029f)) continue;
                return sample;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSample(Double topDepth, Double baseDepth, SampleType type, boolean useAnyType) {
        if (!useAnyType && type == null) {
            type = SampleType.CU;
        }
        Sample bestMatch = null;
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                try {
                    if (!useAnyType && sample.getType() != type || !sample.compareDepth(topDepth, baseDepth)) continue;
                    if (bestMatch != null) {
                        if ((topDepth != null || sample.hasTopDepth()) && (baseDepth != null || sample.hasBaseDepth())) continue;
                        bestMatch = sample;
                        continue;
                    }
                    bestMatch = sample;
                }
                catch (SBException sBException) {}
            }
        }
        return bestMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSample(Double topDepth, Double baseDepth, SampleType type) {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                try {
                    if (sample.getType() != type || !sample.compareDepth(topDepth, baseDepth)) continue;
                    return sample;
                }
                catch (SBException sBException) {
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getnthSample(int n) {
        int i = 0;
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                if (i == n) {
                    return sample;
                }
                ++i;
            }
        }
        throw new IllegalArgumentException("Not enough samples to get sample " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getnSamples() {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            return this.samples.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSamples(Collection<Sample> samples) throws SQLException, SBPermissionException {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            if (this.db.isConnected()) {
                if (!this.canWrite(this.db, null)) {
                    throw new SBPermissionException(this.getDeniedReason(this.db, "well", true));
                }
                for (Sample sample : samples) {
                    if (!this.samples.samples.contains(sample)) {
                        throw new IllegalArgumentException("Error finding sample: " + sample + ", samp_id=" + sample.getSampID() + " in deleteSamples, from well: " + this + " well_id=" + this.wellID);
                    }
                    sample.delete(this.wellID);
                }
            }
            this.samples.samples.removeAll(samples);
        }
        this.setChanged();
        this.db.updateAuditTrail("SAMPLE", "DELETE " + samples.size() + " from " + this.toString() + " [" + this.wellID + "]");
    }

    public int hasSampleIGD(Sample sample) throws SQLException, SBException {
        for (WellInterp in : this.interps) {
            int i = in.hasSampleIGD(sample);
            if (i > 0) {
                return i;
            }
            if (!sample.hasAgeData(in.interpID)) continue;
            return 1;
        }
        if (sample.sampleLithology.getLithology().size() > 0) {
            return 22;
        }
        if (this.db.isConnected()) {
            return sample.hasIGDdataInDB(this.wellID);
        }
        return 0;
    }

    public boolean hasSampleLithology() throws SQLException, SBException {
        for (Sample s : this.getSamples()) {
            if (s.getLithology().lithology.isEmpty()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSample(int sampID) {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                if (sample.getSampID() != sampID) continue;
                return sample;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSample(int sampID, boolean mergedDonor) {
        Sample sample = this.getSample(sampID);
        if (sample != null) {
            return sample;
        }
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample candidate : this.samples) {
                if (!candidate.hasMergedID(sampID)) continue;
                return candidate;
            }
        }
        return null;
    }

    public Sample addSample(Double topDepth, Double baseDepth, String sampleType, String label) throws SQLException, SampleInsertException, SBPermissionException {
        return this.addSample(topDepth, baseDepth, SampleType.parseType(sampleType), label);
    }

    public Sample addSample(Double topDepth, Double baseDepth, SampleType sampleType, String label) throws SQLException, SampleInsertException, SBPermissionException {
        Sample.Builder builder = new Sample.Builder();
        builder.type(sampleType).topDepth(topDepth).baseDepth(baseDepth).label(label);
        return this.addSample(builder, this.getNextSampID(), null);
    }

    public Sample addSample(double depth, SampleType sampleType, String label) throws SQLException, SampleInsertException, SBPermissionException {
        Sample.Builder builder = new Sample.Builder();
        builder.type(sampleType).depth(this.db, depth).label(label);
        return this.addSample(builder, this.getNextSampID(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextSampID() {
        if (this.db.isConnected()) {
            return 0;
        }
        int maxID = 0;
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                maxID = Math.max(maxID, sample.getSampID());
            }
        }
        return ++maxID;
    }

    public Sample addSampleCopy(Statement stmt, Sample wsSample) throws SQLException, SampleInsertException, SBPermissionException, SBException {
        assert (this.db.isConnected());
        Sample.Builder builder = Sample.copyToDatabase(this.db, wsSample);
        Sample dbSample = this.addSample(builder, 0, stmt);
        wsSample.setLink(dbSample);
        wsSample.status = SbugsStatus.STORED;
        return dbSample;
    }

    public void updateSample(Sample sample, Sample.Builder builder) throws SBException, SQLException {
        if (!this.canWrite(this.db, null)) {
            throw new SBException(this.getDeniedReason(this.db, "well", true));
        }
        this.samples.updateSample(sample, builder);
    }

    public void refresh(Statement stmt) throws SQLException, SBException {
        this.header.refresh(this.db, this.wellID, stmt);
        AnalystHeader.refresh(stmt, this.db, this.wellID, this.analystHeaders);
        this.refreshSamples(stmt);
        this.refreshAnalyses(stmt);
        this.refreshCores(stmt);
        this.refreshMarkers(stmt);
        this.refreshLogs(stmt);
        if (this.interps != null) {
            for (WellInterp wellInterp : this.interps) {
                wellInterp.refresh(stmt, this);
            }
        }
    }

    synchronized void refreshCores(Statement stmt) throws SQLException, SBException {
        if (this.cores != null) {
            this.cores.refresh(stmt, this.wellID);
        }
    }

    synchronized void refreshMarkers(Statement stmt) throws SQLException, SBException {
        if (this.markers != null) {
            this.markers.refresh(stmt, this.wellID);
        }
    }

    synchronized void refreshLogs(Statement stmt) throws SQLException, SBException {
        if (this.curves != null) {
            this.curves.refresh(this.db, stmt, this.wellID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshSamples(Statement stmt) throws SQLException, SBException {
        Timestamp time;
        if (this.samples.samples == null) {
            return;
        }
        String sql = "SELECT samp_id,updated FROM " + this.db.DBTableName("SAMPLES") + " WHERE well_id=" + this.wellID;
        ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
        Sample notifier = null;
        HashSet<Integer> sampleIDs = new HashSet<Integer>();
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            while (rs.next()) {
                int sampID = rs.getInt("samp_id");
                sampleIDs.add(sampID);
                time = rs.getTimestamp("updated");
                boolean found = false;
                for (Sample s : this.samples) {
                    if (s.getSampID() != sampID) continue;
                    found = true;
                    if (time == null || !time.after(s.getUpdated())) break;
                    notifier = Sample.load(this.db, this.wellID, sampID, this.getSectionType(), s);
                    break;
                }
                if (found) continue;
                notifier = Sample.load(this.db, this.wellID, sampID, this.getSectionType(), null);
                this.samples.add(notifier);
            }
            if (sampleIDs.size() < this.samples.samples.size()) {
                Iterator<Sample> it = this.samples.iterator();
                while (it.hasNext()) {
                    Sample s = it.next();
                    if (sampleIDs.contains(s.getSampID())) continue;
                    it.remove();
                    if (notifier != null) continue;
                    notifier = s;
                }
            }
        }
        sql = "SELECT samp_id,interp_id,updated FROM " + this.db.DBTableName("SBSSR") + " WHERE well_id=" + this.wellID;
        rs = stmt.executeQuery(this.db.modQuery(sql));
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            int interpID = rs.getInt("interp_id");
            time = rs.getTimestamp("updated");
            Sample sample = this.getSample(sampID);
            if (time == null || sample.getAgeUpdated(interpID) != null && !time.after(sample.getAgeUpdated(interpID))) continue;
            sample.loadAges(this.wellID, interpID);
            if (notifier != null) continue;
            notifier = sample;
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
    }

    boolean hasSamplesLoaded() {
        return this.samples.samples != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSamples() throws SQLException {
        if (!this.db.isConnected()) {
            return;
        }
        System.out.println("WellID: " + this.wellID + " loading samples...");
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            if (this.samples.samples == null) {
                this.samples.samples = new TreeSet();
            }
            try (Statement stmt = this.db.getDatabase().createStatement();){
                String sql = "SELECT samp_id,top_depth,base_depth,type,grid_x,grid_y,label," + Audit.sqlFieldString();
                sql = sql + " FROM " + this.db.DBTableName("SAMPLES") + " WHERE well_id=" + this.wellID;
                sql = sql + " ORDER BY base_depth, top_depth, type, samp_id";
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
                boolean askedDuplicates = false;
                boolean mergeDuplicates = false;
                while (rs.next()) {
                    int sampID = rs.getInt("samp_id");
                    BigDecimal topDepth = SB.getBigDecimal((ResultSet)rs, (String)"top_depth", (this.db.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                    BigDecimal baseDepth = SB.getBigDecimal((ResultSet)rs, (String)"base_depth", (this.db.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                    String sampleType = rs.getString("type");
                    int gridX = rs.getInt("grid_x");
                    int gridY = rs.getInt("grid_y");
                    String strg = rs.getString("label");
                    Audit audit = new Audit(rs);
                    Sample.Builder sample = new Sample.Builder().topDepth(topDepth != null ? Double.valueOf(topDepth.doubleValue()) : null).baseDepth(baseDepth != null ? Double.valueOf(baseDepth.doubleValue()) : null).type(SampleType.parseType(sampleType)).label(strg).audit(audit);
                    boolean exists = false;
                    for (Sample existing : this.samples) {
                        if (existing.getSortEntry().compareTo(sample.getSortEntry(this.db.useSampleTops())) != 0) continue;
                        if (existing.getSampID() != sampID) {
                            if (StackError.hasGui()) {
                                if (!askedDuplicates) {
                                    int opt = JOptionPane.showConfirmDialog(null, "Warning: Duplicate sample found at depth: " + existing.toString(this.header.getWellUnits()) + "\nDo you want to attempt to auto-merge ALL such duplicates?", "Duplicates", 0, 3);
                                    if (opt == 0) {
                                        mergeDuplicates = true;
                                    }
                                    askedDuplicates = true;
                                }
                                if (mergeDuplicates) {
                                    String reason = this.mergeSampleCheckConflicts(existing.getSampID(), sampID);
                                    if (reason == null) {
                                        Sample temp = sample.buildExisting(this.db, this.wellID, sampID, WellHeader.SectionType.getSectionType(this.header.getType()));
                                        try {
                                            this.mergeSamplesDB(temp, existing);
                                            exists = true;
                                        }
                                        catch (SBException | SBPermissionException sbe) {
                                            reason = sbe.getMessage();
                                        }
                                    }
                                    if (reason != null) {
                                        JOptionPane.showMessageDialog(null, "Duplicate sample at depth: " + existing.toString(this.header.getWellUnits()) + "\ncannot be merged because: " + reason, "Well: " + this.getWellName(), 2);
                                    }
                                } else {
                                    JOptionPane.showMessageDialog(null, "Warning: Duplicate sample found.\nYou must merge sample labelled as DUPLICATE at depth: " + existing.toString(this.header.getWellUnits()) + "\nUse Samples menu: merge.", "Well: " + this.getWellName(), 2);
                                }
                            }
                            System.out.println("Warning: Duplicate sample for well: " + this + ", sample: " + sample + ", ID: " + sampID + " Original sample ID: " + existing.getSampID());
                            sample.label((strg == null ? "" : strg) + " DUPLICATE");
                            continue;
                        }
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    this.samples.add(sample.buildExisting(this.db, this.wellID, sampID, WellHeader.SectionType.getSectionType(this.header.getType())));
                }
                this.loadSampleLithology();
                this.loadSampleAges(0);
                if (mergeDuplicates) {
                    this.getDataModel().commit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSamples(boolean force) throws SQLException {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            if (force || this.samples.samples == null) {
                this.loadSamples();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int loadAllSamples(SBdb sbdb) throws SQLException, SBException {
        int nSamples = 0;
        String sql = "SELECT WELL_ID,SAMP_ID,TOP_DEPTH,BASE_DEPTH,TYPE,GRID_X,GRID_Y,LABEL," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("samples") + " ORDER BY well_id,samp_id";
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                int sampID = rs.getInt("samp_id");
                Well well = sbdb.getWell(wellID);
                if (well == null) {
                    System.out.println("WARNING: well is null for sample: " + sampID);
                    continue;
                }
                SampleList sampleList = well.samples;
                synchronized (sampleList) {
                    if (well.samples.samples == null) {
                        well.samples.samples = new TreeSet();
                    }
                }
                try {
                    BigDecimal topDepth = SB.getBigDecimal((ResultSet)rs, (String)"top_depth", (sbdb.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                    BigDecimal baseDepth = SB.getBigDecimal((ResultSet)rs, (String)"base_depth", (sbdb.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                    String sampleType = rs.getString("type");
                    int gridX = rs.getInt("grid_x");
                    int gridY = rs.getInt("grid_y");
                    String strg = rs.getString("label");
                    Audit audit = new Audit(rs);
                    Sample.Builder builder = new Sample.Builder().type(SampleType.getType(sampleType)).label(strg).topDepth(topDepth != null ? Double.valueOf(topDepth.doubleValue()) : null).baseDepth(baseDepth != null ? Double.valueOf(baseDepth.doubleValue()) : null).audit(audit);
                    Sample sample = well.addSample(builder, sampID, null);
                    sample.loadLithology(wellID, sbdb.getLithdesc());
                    ++nSamples;
                }
                catch (SBException | SBPermissionException sbe) {
                    System.out.println("Exception inserting sample for well: " + well + " : " + sbe.getMessage());
                }
            }
        }
        return nSamples;
    }

    void loadSampleAges(WellInterp wellInterp) throws SQLException, SBException {
        this.loadSampleAges(wellInterp.interpID);
    }

    public void loadSampleAges(int interpID) throws SQLException {
        if (!this.db.isConnected()) {
            return;
        }
        if (!this.sampleAgesLoaded.contains(interpID)) {
            System.out.println("Loading sample ages for interpID: " + interpID);
            String sql = "SELECT samp_id,age,age_below,ageplus,ageminus,ratio FROM " + this.db.DBTableName("SBSSR") + " WHERE well_id=" + this.wellID + " AND interp_id=" + interpID;
            try (Statement stmt = this.db.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
                this.getSamples();
                while (rs.next()) {
                    int sampID = rs.getInt("samp_id");
                    Sample sample = this.getSample(sampID);
                    if (sample != null) {
                        Double age = RSUtils.getDoubleOrNull((ResultSet)rs, (String)"age");
                        Double ageBelow = RSUtils.getDoubleOrNull((ResultSet)rs, (String)"age_below");
                        Float ageErrorPlus = RSUtils.getFloatOrNull((ResultSet)rs, (String)"ageplus");
                        Float ageErrorMinus = RSUtils.getFloatOrNull((ResultSet)rs, (String)"ageminus");
                        Double ratio = RSUtils.getDoubleOrNull((ResultSet)rs, (String)"ratio");
                        sample.setAge(interpID, age, ageBelow, ageErrorPlus, ageErrorMinus, ratio, this.wellID);
                        continue;
                    }
                    System.out.println("Cannot find sample: " + sampID + " in loadSampleAges");
                }
            }
            this.sampleAgesLoaded.add(interpID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSampleAges(int interpID) throws SQLException, SBException {
        String sql = "DELETE FROM " + this.db.DBTableName("SBSSR") + " WHERE well_id=" + this.wellID + " AND interp_id=" + interpID;
        try (Statement stmt = this.db.getDatabase().createStatement();){
            if (!this.canWrite(this.db, stmt)) {
                throw new SBException("Cannot update read-only well: " + this);
            }
            stmt.executeUpdate(this.db.modQuery(sql));
        }
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                if (!sample.hasAgeData(interpID)) continue;
                sample.removeAgeData(interpID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTopSampleDepth() throws SQLException {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            this.loadSamples(false);
            if (this.samples.size() > 0) {
                return this.samples.samples.first().getDepth('M');
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBaseSampleDepth() throws SQLException {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            this.loadSamples(false);
            if (this.samples.size() > 0) {
                return this.samples.samples.last().getDepth('M');
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getBaseSample(boolean correctDepths, boolean correctCuttings) throws SQLException {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            this.loadSamples(false);
            if (this.samples.size() == 0) {
                return null;
            }
            if (!correctDepths && !correctCuttings) {
                return this.samples.samples.last();
            }
        }
        List<Sample> sortedSamples = this.getSamples(correctDepths, correctCuttings);
        return sortedSamples.get(sortedSamples.size());
    }

    private void loadSampleLithology() throws SQLException {
        String sql = "SELECT samp_id,lith_id,percnt FROM " + this.db.DBTableName("SBSLITH") + " WHERE well_id=" + this.wellID + " ORDER BY samp_id";
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            int lastID = 0;
            Sample sample = null;
            while (rs.next()) {
                int lithID;
                int sampID = rs.getInt("samp_id");
                if (sampID != lastID) {
                    sample = this.getSample(sampID);
                    if (sample == null) {
                        throw new IllegalStateException("Cannot find sample: " + sampID + " in loadSampleLithology");
                    }
                    sample.sampleLithology.getLithology().clear();
                    lastID = sampID;
                }
                if ((lithID = rs.getInt("lith_id")) == 0) continue;
                SampleLithologyUnit lith = new SampleLithologyUnit(this.db, this.db.getLithdesc().getLithology(lithID), rs.getInt("percnt"));
                sample.sampleLithology.add(lith);
            }
        }
    }

    public String statusString() {
        return this.header.statusString();
    }

    public String toString() {
        return this.header.toString();
    }

    public void update(String code, WellHeader header) throws SQLException, SBException {
        if (!this.canWrite(this.db, null)) {
            throw new SBException(this.getDeniedReason(this.db, "well", true));
        }
        header.update(this.db);
        this.header.copy(header);
        this.updateCode(code);
        this.notifyObservers(header);
    }

    private void updateCode(String newCode) throws SQLException, SBException {
        if ((newCode = newCode.trim()).equals(this.wellCode())) {
            return;
        }
        if (Well.getWellID(this.db, newCode) > 0) {
            throw new SBException("Well of code: '" + newCode + "' already exists");
        }
        if (this.db.isConnected()) {
            try (Statement stmt = this.db.getDatabase().createStatement();){
                String[] sql = new String[]{"UPDATE " + this.db.DBTableName("well_ident") + " SET well_code=NULL WHERE well_id=" + this.wellID, "UPDATE " + this.db.DBTableName("wells") + " SET well_code='" + newCode + "' WHERE well_code='" + this.wellCode() + "'", "UPDATE " + this.db.DBTableName("well_ident") + " SET well_code='" + newCode + "' WHERE well_id=" + this.wellID};
                for (String q : sql) {
                    if (stmt.executeUpdate(this.db.modQuery(q)) == 1) continue;
                    throw new SBException("Error running statement: " + q + "\nNumber of rows updated not equal to 1");
                }
            }
            this.db.getDatabase().commit();
        }
        this.header.setWellCode(newCode);
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDisciplineData(char discID) {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                if (!sample.hasDisciplineData(discID)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hasSemiQuantData(AnalystHeader hdr) throws SQLException, SBException {
        String semiQuant = null;
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                semiQuant = sample.hasSemiQuantData(hdr, semiQuant);
            }
        }
        return semiQuant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSampleEnvData(AnalystHeader hdr) {
        boolean hasData = false;
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            Sample sample;
            Iterator<Sample> iterator = this.samples.iterator();
            while (iterator.hasNext() && !(hasData = (sample = iterator.next()).hasEnvData(hdr))) {
            }
        }
        return hasData;
    }

    public boolean hasShifts() throws SQLException {
        return this.getCoreShift().getSize() > 0;
    }

    public List<EnvScheme> getEnvSchemes() throws SQLException, SBException {
        HashSet<EnvScheme> set = new HashSet<EnvScheme>();
        LinkedList<EnvScheme> list = new LinkedList<EnvScheme>();
        this.loadAnalystHeaders();
        for (AnalystHeader hdr : this.analystHeaders) {
            if (!this.hasSampleEnvData(hdr)) continue;
            EnvScheme scheme = this.db.getEnvScheme(hdr.getEnvSchID());
            set.add(scheme);
        }
        for (EnvScheme scheme : set) {
            list.add(scheme);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillTaxonList(HashMap<Integer, Taxon> taxa, char discID, int analyst, int analyNo) {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                sample.fillTaxa(taxa, discID, analyst, analyNo);
            }
        }
    }

    public void sortTaxonList(List taxa, Discipline discID, int sort) throws SBException, SQLException {
        Collections.sort(taxa, new TaxonCompareGenus(new TaxonCompareSpecies()));
        double[] depths = new double[taxa.size()];
        for (int i = 0; i < taxa.size(); ++i) {
            Taxon taxon = (Taxon)taxa.get(i);
            depths[i] = this.getEndSampleDepth(taxon.getSpecID(), discID, sort);
        }
        boolean swap = true;
        block1: while (swap) {
            swap = false;
            for (int i = 1; i < depths.length; ++i) {
                if (!(sort == 0 && depths[i] < depths[i - 1]) && (sort != 1 || !(depths[i] > depths[i - 1]))) continue;
                swap = true;
                double tempDepth = depths[i];
                depths[i] = depths[i - 1];
                depths[i - 1] = tempDepth;
                Taxon tempTaxon = (Taxon)taxa.get(i);
                taxa.remove(i);
                taxa.add(i - 1, tempTaxon);
                continue block1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getEndSampleDepth(int specID, Discipline discID, int sort) throws SBException, SQLException {
        double depth = 0.0;
        if (sort == 0) {
            SampleList sampleList = this.samples;
            synchronized (sampleList) {
                this.loadSamples(false);
                for (Sample sample : this.samples) {
                    if (sample.hasInSituSpecies(discID, specID, 'R')) {
                        depth = sample.getDepth('M');
                        break;
                    }
                    if (!sample.hasSpecies(discID, specID) || !(depth < (double)0.0029f)) continue;
                    depth = sample.getDepth('M');
                }
            }
        } else {
            List<Sample> sampleList = this.getSamples();
            for (int i = sampleList.size() - 1; i >= 0; --i) {
                Sample sample = sampleList.get(i);
                if (sample.hasInSituSpecies(discID, specID, 'C')) {
                    depth = sample.getDepth('M');
                    break;
                }
                if (!sample.hasSpecies(discID, specID) || !(depth < (double)0.0029f)) continue;
                depth = sample.getDepth('M');
            }
        }
        return depth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample addSample(Sample.Builder builder, int sampID, Statement stmt) throws SampleInsertException, SQLException, SBPermissionException {
        if (!this.canWrite(this.db, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "add sample to", "well", true));
        }
        this.checkSample(builder, sampID);
        Sample sample = sampID == 0 ? (!this.db.isConnected() ? builder.buildExisting(this.db, this.wellID, this.getNextSampID(), this.getSectionType()) : builder.buildStore(this.db, this.wellID, this.getSectionType(), stmt)) : builder.buildExisting(this.db, this.wellID, sampID, this.getSectionType());
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            this.samples.add(sample);
        }
        this.setChanged();
        return sample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSample(Sample.Builder builder, int sampID) throws SampleInsertException {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample existing : this.samples) {
                if (!existing.isEquivalent(builder)) continue;
                throw new SampleInsertException("Well: " + this + ". Duplicate sample at depth: " + existing.toString() + ". Did not add sample with ID: " + sampID, existing);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample checkSample(Sample.Builder builder) {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample existing : this.samples) {
                if (!existing.isEquivalent(builder)) continue;
                return existing;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSample(Sample.Builder builder) {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                if (!sample.getSortEntry().equals(builder.getSortEntry(this.db.useSampleTops()))) continue;
                return sample;
            }
        }
        return null;
    }

    public WellHeader.SectionType getSectionType() {
        return WellHeader.SectionType.getSectionType(this.header.getType());
    }

    Well(SBdb db, int wellID, String wellCode, WellHeader header) throws SQLException, SBException {
        super("WELL_IDENT", "WELL_ID", true);
        if (wellID <= 0) {
            throw new IllegalArgumentException("Attempt to create a well with ID: " + wellID);
        }
        if (db == null) {
            throw new IllegalArgumentException("Attempt to create a well with null data model");
        }
        this.db = db;
        this.wellID = wellID;
        this.header = new WellHeader(header);
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql = "INSERT INTO " + db.DBTableName("WELLS") + " (well_name,well_code,country," + Audit.sqlFieldString() + ") VALUES (" + SB.DBString((String)this.header.getWellName()) + "," + SB.DBString((String)wellCode) + "," + SB.DBString((String)this.header.getCountry()) + "," + this.header.audit.sqlInsert(db, stmt) + ")";
            stmt.executeUpdate(db.modQuery(sql));
            this.header.setWellCode(wellCode);
            this.header.updateFromMaster(db, SB.DBdf, true);
            this.header.update(db);
            sql = "INSERT INTO " + db.DBTableName("WELL_IDENT") + " (well_id,well_code,descrip) VALUES (" + wellID + "," + SB.DBString((String)wellCode) + "," + SB.DBString((String)this.header.getDescrip()) + ")";
            stmt.executeUpdate(db.modQuery(sql));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Smpdtl> getAnalyses(char discID, String analyst, int analyNo) throws SQLException, SBException {
        LinkedList<Smpdtl> smpdtls = new LinkedList<Smpdtl>();
        if (!this.analysesLoaded) {
            this.loadAnalyses();
        }
        SortEntryComparator smpdtlComparator = new SortEntryComparator();
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                List<Smpdtl> sampleAnalyses = sample.getAnalysesCopy();
                Collections.sort(sampleAnalyses, smpdtlComparator);
                for (Smpdtl smpdtl : sampleAnalyses) {
                    boolean required = true;
                    if (discID > '\u0000' && discID != smpdtl.getDiscID()) {
                        required = false;
                    }
                    if (analyst != null && analyst.length() > 0 && !analyst.equals(smpdtl.getAnalyst())) {
                        required = false;
                    }
                    if (analyNo > 0 && smpdtl.getAnalyNo() != analyNo) {
                        required = false;
                    }
                    if (!required) continue;
                    smpdtls.add(smpdtl);
                }
            }
        }
        return smpdtls;
    }

    public List<Smpdtl> getAnalyses(Discipline discID, String analyst, int analyNo) throws SQLException, SBException {
        return this.getAnalyses(Discipline.getChar(discID), analyst, analyNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshAnalyses(Statement stmt) throws SQLException, SBException {
        if (!this.analysesLoaded) {
            return;
        }
        String sql = "SELECT samp_id,analy_id,updated FROM " + this.db.DBTableName("SMPDTL") + " WHERE well_id=" + this.wellID + " ORDER BY samp_id";
        ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
        Smpdtl notifier = null;
        HashSet<CallSite> keys = new HashSet<CallSite>();
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            Smpdtl smpdtl;
            block3: while (rs.next()) {
                int sampID = rs.getInt("samp_id");
                int analyID = rs.getInt("analy_id");
                keys.add((CallSite)((Object)(sampID + "|" + analyID)));
                Timestamp time = rs.getTimestamp("updated");
                boolean found = false;
                for (Sample sample : this.samples) {
                    if (sample.getSampID() != sampID) continue;
                    for (Smpdtl d : sample.getAnalyses()) {
                        if (d.getAnalyID() != analyID) continue;
                        found = true;
                        if (time == null || !time.after(d.getUpdated())) break;
                        Smpdtl smpdtl2 = new Smpdtl(this.db, this.wellID, sample, this.getAnalystHeader(analyID, true));
                        d.copyAll(smpdtl2);
                        d.copyOccs(smpdtl2);
                        notifier = d;
                        break;
                    }
                    if (found) continue block3;
                    smpdtl = new Smpdtl(this.db, this.wellID, sample, this.getAnalystHeader(analyID, true));
                    sample.insert(smpdtl);
                    notifier = smpdtl;
                    continue block3;
                }
            }
            for (Sample o : this.samples) {
                for (Smpdtl d : o.getAnalyses()) {
                    Iterator<TaxonOcc> occIt = d.getOccurIterator();
                    while (occIt.hasNext()) {
                        TaxonOcc t = occIt.next();
                        if (this.db.hasTaxon(t.getTaxon())) continue;
                        smpdtl = new Smpdtl(this.db, this.wellID, o, this.getAnalystHeader(d.getAnalyID(), true));
                        d.copyAll(smpdtl);
                        d.copyOccs(smpdtl);
                        notifier = d;
                    }
                }
            }
            for (Sample sample : this.samples) {
                for (Smpdtl dtl : sample.getAnalysesCopy()) {
                    if (keys.contains(sample.getSampID() + "|" + dtl.getAnalyID())) continue;
                    sample.removeDtl(dtl.getAnalyID());
                    if (notifier != null) continue;
                    notifier = dtl;
                }
            }
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers((Object)notifier);
        }
    }

    public void loadAnalyses() throws SQLException, SBException {
        if (this.analysesLoaded) {
            return;
        }
        this.loadSamples(false);
        if (this.db == null || !this.db.isConnected()) {
            return;
        }
        System.out.println("Loading analyses...");
        try (PreparedStatement pStmtTaxonOcc = Smpdtl.getLoadPrepStmt(this.db);){
            this.db.loadTaxa(this.wellID);
            String sql = "SELECT samp_id,analy_id,picker,source,barren,notes,proximal,distal,fov,weight,coarse,medium,fine," + Audit.sqlFieldString();
            sql = sql + " FROM " + this.db.DBTableName("SMPDTL") + " WHERE well_id=" + this.wellID;
            try (Statement stmt = this.db.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
                while (rs.next()) {
                    int sampID = rs.getInt("samp_id");
                    int analyID = rs.getInt("analy_id");
                    String picker = rs.getString("picker");
                    String source = rs.getString("source");
                    Smpdtl.AnalysisType analysisType = Smpdtl.AnalysisType.getTypeFromDB(rs.getString("barren"));
                    String notes = rs.getString("notes");
                    int proximal = rs.getInt("proximal");
                    int distal = rs.getInt("distal");
                    int fov = rs.getInt("fov");
                    float weight = rs.getFloat("weight");
                    float coarse = rs.getFloat("coarse");
                    float medium = rs.getFloat("medium");
                    float fine = rs.getFloat("fine");
                    Sample sample = this.getSample(sampID);
                    if (sample == null) {
                        System.out.println("Null sample for sampID =" + sampID + ", wellID=" + this.wellID + " in Well.loadAnalyses");
                        continue;
                    }
                    Smpdtl dtl = new Smpdtl(this.db, sample, this.getAnalystHeader(analyID, true), picker, source, notes, proximal, distal, fov, weight, coarse, medium, fine, new Audit(rs), analysisType);
                    dtl.load(this.wellID, pStmtTaxonOcc);
                    Iterator<Smpdtl> it = sample.analyses.iterator();
                    boolean toAdd = true;
                    while (it.hasNext()) {
                        Smpdtl analysis = it.next();
                        if (analysis.getAnalyID() != analyID) continue;
                        String message = "Duplicate analyst for discID: " + analysis.getDiscID() + ", analyst:" + analysis.getAnalyst() + ", sample ID: " + sampID + ", analyID: " + analyID;
                        if (dtl.getNOccs() > 0 && analysis.getNOccs() == 0) {
                            System.out.println(message + ", sample details: " + analysis + " removed.");
                            it.remove();
                            break;
                        }
                        if (dtl.getNOccs() == analysis.getNOccs()) {
                            System.out.println(message + ", sample details: " + dtl + " ignored.");
                            toAdd = false;
                            continue;
                        }
                        throw new SBException(message + ", analyses have different occurrence records");
                    }
                    if (!toAdd) continue;
                    sample.analyses.add(dtl);
                    sample.detailsLoaded[SBdb.did2i((char)this.getAnalystHeader((int)analyID, (boolean)true).getDiscID())] = true;
                }
                rs.close();
            }
        }
        this.analysesLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateSubjAbund(String donor, String target, int analyID) throws SQLException, SBException {
        int nUpdated = 0;
        try (Statement stmt = this.db.getDatabase().createStatement();){
            if (!this.canWrite(this.db, stmt)) {
                throw new SBException("Cannot update read-only well: " + this);
            }
            String sql = "UPDATE " + this.db.DBTableName("TAXONOCC") + " SET abund=" + SB.DBString((String)target) + " WHERE well_id=" + this.wellID + " AND analy_id=" + analyID + " AND abund=" + SB.DBString((String)donor);
            nUpdated = stmt.executeUpdate(this.db.modQuery(sql));
        }
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            for (Sample sample : this.samples) {
                for (Smpdtl smpdtl : sample.getAnalyses()) {
                    if (smpdtl.getAnalyID() != analyID) continue;
                    smpdtl.replaceSubjAbund(donor, target);
                    if (!smpdtl.hasChanged()) continue;
                    smpdtl.notifyObservers();
                }
            }
        }
        return nUpdated;
    }

    void loadLithIntervals(List<LithBase> lithology, Lithdesc lithdesc) throws SQLException {
        if (!this.db.isConnected()) {
            return;
        }
        try (Statement stmt = this.db.getDatabase().createStatement();){
            String sql = "SELECT top_depth,base_depth,lith_id FROM " + this.db.DBTableName("SBILITH") + " WHERE well_id=" + this.wellID + " ORDER BY top_depth";
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                LithInterval lithInt = new LithInterval(this.db);
                lithInt.topDepth = rs.getDouble("top_depth");
                lithInt.baseDepth = rs.getDouble("base_depth");
                lithInt.desc = lithdesc.getLithology(rs.getInt("lith_id"));
                assert (lithInt.desc != null);
                lithInt.status = SbugsStatus.STORED;
                this.insertLithInterval(lithInt);
            }
        }
    }

    void loadLithQualifiers(List<LithBase> lithology, Lithdesc lithdesc) throws SQLException {
        if (!this.db.isConnected()) {
            return;
        }
        try (Statement stmt = this.db.getDatabase().createStatement();){
            String sql = "SELECT top_depth,type,alignment,plotpos,lith_id FROM " + this.db.DBTableName("SBQLITH") + " WHERE well_id=" + this.wellID + " ORDER BY top_depth";
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                LithQualifier lithQual = new LithQualifier(this.db);
                lithQual.topDepth = rs.getDouble("top_depth");
                lithQual.qType = rs.getString("type").charAt(0);
                lithQual.alignment = rs.getString("alignment").charAt(0);
                lithQual.xPlotPos = rs.getFloat("plotpos");
                int lithCode = rs.getInt("lith_id");
                if (lithCode != 0) {
                    lithQual.desc = lithdesc.getLithology(lithCode);
                }
                this.insertLithInterval(lithQual);
            }
        }
    }

    private static int getWellID(SBdb sbdb, String code) throws SQLException {
        if (sbdb.isConnected()) {
            String sql = "SELECT well_id FROM " + sbdb.DBTableName("WELL_IDENT") + " WHERE well_code='" + code + "'";
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                int id = 0;
                if (rs.next()) {
                    id = rs.getInt("well_id");
                }
                int n = id;
                return n;
            }
        }
        Iterator<Well> it = sbdb.getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            if (!well.getWellCode().equalsIgnoreCase(code)) continue;
            return well.getWellID();
        }
        return 0;
    }

    public void storeGrainSize(GrainSizeList list) throws SQLException, SBPermissionException {
        if (!this.canWrite(this.db, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "well", true));
        }
        list.store(this.db, this.wellID);
        this.grainSize.clear();
        this.grainSize.addAll(list);
        this.setChanged();
    }

    public void storeLithology(List<LithBase> newList) throws SQLException, SBException {
        if (!this.canWrite(this.db, null)) {
            throw new SBException(this.getDeniedReason(this.db, "well", true));
        }
        String[] sql = new String[]{"DELETE FROM " + this.db.DBTableName("SBILITH") + " WHERE well_id=" + this.wellID, "DELETE FROM " + this.db.DBTableName("SBQLITH") + " WHERE well_id=" + this.wellID};
        try (Statement stmt = this.db.getDatabase().createStatement();){
            for (String q : sql) {
                stmt.executeUpdate(this.db.modQuery(q));
            }
        }
        this.lithIntervals.clear();
        for (LithBase lithBase : newList) {
            LithBase copy = null;
            if (lithBase instanceof LithInterval) {
                copy = new LithInterval(this.db, this.wellID, (LithInterval)lithBase);
            } else if (lithBase instanceof LithQualifier) {
                copy = new LithQualifier(this.db, this.wellID, (LithQualifier)lithBase);
            }
            assert (copy != null);
            this.lithIntervals.add(copy);
        }
        this.setChanged();
    }

    public List<String> getAnalysts(Discipline discID) throws SQLException, SBException {
        try (Statement stmt = this.db.getDatabase().createStatement();){
            String sql = "SELECT distinct (analyst) FROM " + this.db.DBTableName("ANALY_HDR") + " WHERE disc_id='" + discID.getChar() + "' AND well_id=" + this.wellID;
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(this.db.getUser(rs.getInt("analyst")).getAbr());
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
    }

    void writeDEX(FileWriter out, String eol, boolean fullHeader, SimpleDateFormat df, Set dataTypes, char units) throws IOException, SQLException, SBException {
        Iterator en2 = dataTypes.iterator();
        boolean wantCores = false;
        boolean wantCasing = false;
        boolean wantLithology = false;
        boolean wantMarkers = false;
        boolean wantTVD = false;
        boolean wantTWT = false;
        this.header.writeDEX(out, eol, fullHeader, df, units);
        while (en2.hasNext()) {
            int columnType = (Integer)en2.next();
            char discID = '\u0000';
            switch (columnType) {
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    discID = SBdb.dt2discID(columnType);
                    break;
                }
                case 19: {
                    wantCores = true;
                    break;
                }
                case 20: {
                    wantCasing = true;
                    break;
                }
                case 24: {
                    wantMarkers = true;
                    break;
                }
                case 21: {
                    wantLithology = true;
                    break;
                }
                case 25: {
                    wantTVD = true;
                    break;
                }
                case 26: {
                    wantTWT = true;
                    break;
                }
            }
            if (discID <= '\u0000') continue;
            Iterator<AnalystHeader> itra = this.getAnalystHeaderIterator();
            int[] abnDiscID = new int[4];
            for (int i = 0; i < 4; ++i) {
                abnDiscID[i] = 0;
            }
            while (itra.hasNext()) {
                AnalystHeader h = itra.next();
                if (h.getAbnSchID() <= 0 || h.getDiscID() != discID || abnDiscID[SBdb.did2i(discID)] == h.getAbnSchID()) continue;
                if (abnDiscID[SBdb.did2i(discID)] > 0) {
                    throw new SBException("Cannot export multiple analysts with different Abundance Schemes to DEX file");
                }
                out.write("Abundance scheme ID = ");
                out.write("" + h.getAbnSchID());
                out.write(eol + "  Discipline : " + discID + eol);
                abnDiscID[SBdb.did2i((char)discID)] = h.getAbnSchID();
            }
        }
        out.write(eol);
        if (wantCores) {
            this.cores.writeDEX(out, eol, units, this);
        }
        if (wantCasing) {
            this.casing.writeDEX(out, eol, units);
        }
        if (wantMarkers) {
            this.markers.writeDEX(out, eol, units);
        }
        if (wantTVD && this.TVD != null) {
            this.TVD.writeDEX(out, eol, units);
        }
        if (wantTWT && this.TWT != null) {
            this.TWT.writeDEX(out, eol, units);
        }
        if (wantLithology) {
            for (LithBase zone : this.lithIntervals) {
                zone.writeDEX(out, eol, units);
            }
        }
    }

    void writeText(FileWriter out, int dType, char delim, char units) throws IOException, SBException {
        DecimalFormat nFormat = new DecimalFormat("#####0.0##");
        switch (dType) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                for (WellInterp in : this.interps) {
                    List<IGDIntervalZone> vect = in.getIGDList(IGDInterval.dType2IGDtype(dType), 0);
                    for (IGDIntervalZone zone : vect) {
                        out.write(this.header.getWellName() + delim + nFormat.format(zone.getTopSample().getDepth(units)) + delim + zone.getTopBnd() + delim + nFormat.format(zone.getBaseSample().getDepth(units)) + delim + zone.getBaseBnd() + delim + zone.toString() + "\r\n");
                    }
                }
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                for (WellInterp in : this.interps) {
                    for (Biocom comm : in.getComments()) {
                        if (comm.getDiscID() != SBdb.dt2discID(dType)) continue;
                        out.write(this.header.getWellName() + delim + nFormat.format(comm.getTopSample().getDepth(units)) + delim + "-" + delim + nFormat.format(comm.getBaseSample() != null ? comm.getBaseSample().getDepth(units) : comm.getTopSample().getDepth(units)) + delim + "-" + delim + comm.getText().replace('\n', delim).replace('\r', ' ') + "\r\n");
                    }
                }
                break;
            }
            default: {
                throw new SBException("Export for data type: " + SBdb.dTypeNames[dType] + " is not currently supported");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshDataRange(int dType, DTMonitor monitor) throws SQLException, SBException {
        monitor.setStatus(DTMonitor.UNKNOWN);
        ArrayList<Double> depths = new ArrayList<Double>();
        String sql = null;
        boolean fourDepths = false;
        switch (dType) {
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 22: {
                SampleList sampleList = this.samples;
                synchronized (sampleList) {
                    if (this.samples.samples != null) {
                        block22: for (Sample sample : this.samples) {
                            switch (dType) {
                                case 22: {
                                    if (sample.getLithology() != null && !sample.getLithology().getLithology().isEmpty()) break;
                                    continue block22;
                                }
                                case 2: 
                                case 4: 
                                case 6: 
                                case 8: {
                                    if (sample.hasDisciplineData(SBdb.dt2discID(dType))) break;
                                    continue block22;
                                }
                            }
                            if (sample.getBaseDepth() != null) {
                                depths.add(sample.getBaseDepth());
                            }
                            if (sample.getTopDepth() == null) continue;
                            depths.add(sample.getTopDepth());
                        }
                    }
                }
                switch (dType) {
                    case 1: {
                        sql = "SELECT max(top_depth) as maxtop, max(base_depth) as maxbot, min(top_depth) as mintop, min(base_depth) as minbot FROM " + this.db.DBTableName("samples") + " WHERE well_id=" + this.wellID;
                        break;
                    }
                    case 22: {
                        sql = "SELECT max(s.top_depth) as maxtop,max(s.base_depth) as maxbot, min(s.top_depth) as mintop, min(s.base_depth) as minbot FROM " + this.db.DBTableName("samples") + " s," + this.db.DBTableName("sbslith") + " l  WHERE s.well_id=" + this.wellID + " AND s.well_id=l.well_id AND s.samp_id=l.samp_id";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: 
                    case 8: {
                        sql = "SELECT max(s.top_depth) as maxtop, max(s.base_depth) as maxbot, min(s.top_depth) as mintop, min(s.base_depth) as minbot FROM " + this.db.DBTableName("samples") + " s," + this.db.DBTableName("smpdtl") + " d, " + this.db.DBTableName("analy_hdr") + " h  WHERE s.well_id=" + this.wellID + " AND s.samp_id=d.samp_id AND s.well_id=d.well_id AND h.disc_id='" + SBdb.dt2discID(dType) + "' AND h.analy_id=d.analy_id AND h.well_id=s.well_id";
                    }
                }
                fourDepths = true;
                break;
            }
            case 21: {
                this.refreshLithologyRange(monitor);
                break;
            }
            case 19: {
                for (CoredInterval core : this.getCores().getList()) {
                    depths.add(core.getTopDepth());
                    depths.add(core.getBaseDepth());
                    monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)core.status));
                }
                sql = "SELECT min(top_depth) as mintop, max(base_depth) as maxbot FROM " + this.db.DBTableName("CORES") + " WHERE well_id=" + this.wellID;
                break;
            }
            case 20: {
                for (CasingPoint casingPoint : this.getCasing().getList()) {
                    depths.add(casingPoint.getDepth());
                    monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)casingPoint.status));
                }
                sql = "SELECT min(depth) as mintop,max(depth) as maxbot FROM " + this.db.DBTableName("casing") + " WHERE well_id=" + this.wellID;
                break;
            }
            case 24: {
                for (SeismicMarker marker : this.getMarkers().getList()) {
                    depths.add(marker.getDepth());
                    monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)marker.status));
                }
                sql = "SELECT min(depth) as mintop,max(depth) as maxbot FROM " + this.db.DBTableName("wellsmark") + " WHERE well_id=" + this.wellID;
                break;
            }
            case 25: {
                for (TVDepth tvd : this.getTVDlist(false).getList()) {
                    depths.add(tvd.getDDepth());
                }
                monitor.setStatus(this.TVD.getStatus());
                sql = "SELECT min(ddepth) as mintop,max(ddepth) as maxbot FROM " + this.db.DBTableName("welltvd") + " WHERE well_id=" + this.wellID;
                break;
            }
            case 26: {
                for (int i = 0; i < this.getTWTlist().getSize(); ++i) {
                    TWTDepth twt = this.TWT.get(i);
                    depths.add(twt.getDepth());
                }
                sql = "SELECT min(ddepth) as mintop,max(ddepth) as maxbot FROM " + this.db.DBTableName("welltwt") + " WHERE well_id=" + this.wellID;
                break;
            }
            case 23: {
                for (Curve curve : this.getCurves().getCurves()) {
                    depths.add(curve.getTopDepth());
                    depths.add(curve.getBaseDepth());
                }
                sql = "SELECT min(depth) as mintop,max(depth) as maxbot FROM " + this.db.DBTableName("log_trace") + " WHERE curve_id in(SELECT curve_id FROM " + this.db.DBTableName("LOG_CURVE") + " WHERE well_id=" + this.wellID + ")";
                break;
            }
            default: {
                throw new SBException("No status for data type: " + dType);
            }
        }
        if (sql != null) {
            Well.refreshRange(this.db, monitor, depths, fourDepths, sql);
        }
        if (monitor.getDepthFrom() > 99990.0 && monitor.getDepthTo() < -99990.0) {
            monitor.setDepthFrom(0.0);
            monitor.setDepthTo(0.0);
            monitor.setHasData(false);
        }
    }

    static void refreshRange(SBdb db, DTMonitor monitor, List<Double> depths, boolean hasFourDepths, String sql) throws SQLException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(0.0);
        boolean hasDataLoaded = false;
        for (Double depth : depths) {
            if (depth == null) continue;
            hasDataLoaded = true;
            if (depth < monitor.getDepthFrom()) {
                monitor.setDepthFrom(depth.doubleValue());
            }
            if (depth > monitor.getDepthTo()) {
                monitor.setDepthTo(depth.doubleValue());
            }
            monitor.setHasData(true);
        }
        if (!hasDataLoaded && db.isConnected()) {
            monitor.setDepthFrom(99999.0);
            monitor.setDepthTo(-99999.0);
            monitor.setStatus(DTMonitor.UNKNOWN);
            try (Statement stmt = db.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(db.modQuery(sql));
                if (rs.next()) {
                    if (hasFourDepths) {
                        monitor.setDataRanges(rs, "maxtop", "maxbot", "mintop", "minbot", db.getDBType() == SBdb.DBType.SQLITE);
                    } else {
                        monitor.setDepthFrom(rs.getDouble("mintop"));
                        monitor.setDepthTo(rs.getDouble("maxbot"));
                        monitor.setHasData(true);
                        if (monitor.getDepthFrom() == 0.0 && monitor.getDepthTo() == 0.0) {
                            monitor.setHasData(false);
                        }
                    }
                } else {
                    monitor.setHasData(false);
                }
            }
        }
    }

    private void refreshLithologyRange(DTMonitor monitor) throws SQLException, SBException {
        monitor.setDepthFrom(99999.0);
        monitor.setDepthTo(-99999.0);
        boolean hasDataLoaded = false;
        this.getLithIntervals();
        Iterator<LithBase> iterator = this.lithIntervals.iterator();
        while (iterator.hasNext()) {
            LithBase lithInterval;
            LithBase lithInt = lithInterval = iterator.next();
            hasDataLoaded = true;
            double topDepth = lithInt.topDepth;
            double baseDepth = lithInt instanceof LithInterval ? ((LithInterval)lithInt).baseDepth : topDepth;
            if (topDepth < monitor.getDepthFrom()) {
                monitor.setDepthFrom(topDepth);
            }
            if (baseDepth > monitor.getDepthTo()) {
                monitor.setDepthTo(baseDepth);
            }
            monitor.setHasData(true);
            monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)lithInt.status));
        }
        if (!hasDataLoaded && this.db.isConnected()) {
            monitor.setHasData(false);
            String sql = "SELECT min(top_depth) as mintop,max(base_depth) as maxbot FROM " + this.db.DBTableName("sbilith") + " b WHERE well_id=" + this.wellID;
            try (Statement stmt = this.db.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
                if (rs.next()) {
                    monitor.setDepthFrom(rs.getDouble("mintop"));
                    monitor.setDepthTo(rs.getDouble("maxbot"));
                    monitor.setHasData(true);
                    if (monitor.getDepthFrom() == 0.0 && monitor.getDepthTo() == 0.0) {
                        monitor.setHasData(false);
                    }
                }
                if ((rs = stmt.executeQuery(this.db.modQuery(sql = "SELECT min(top_depth) as mintop FROM " + this.db.DBTableName("sbqlith") + " b WHERE well_id=" + this.wellID))).next()) {
                    double mintop = rs.getDouble("mintop");
                    if (mintop < monitor.getDepthFrom()) {
                        monitor.setDepthFrom(mintop);
                    }
                    if (mintop > monitor.getDepthTo()) {
                        monitor.setDepthTo(mintop);
                    }
                    monitor.setHasData(true);
                    if (monitor.getDepthFrom() == 0.0 && monitor.getDepthTo() == 0.0) {
                        monitor.setHasData(false);
                    }
                }
            }
        }
    }

    static void deleteWell(SBdb SB2, String wellCode) throws SQLException, SBException {
        if (wellCode.isEmpty()) {
            return;
        }
        String sql = "SELECT well_id FROM " + SB2.DBTableName("well_ident") + " WHERE well_code='" + wellCode + "'";
        try (Statement stmt = SB2.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
            int id = 0;
            if (rs.next()) {
                id = rs.getInt("well_id");
            }
            sql = "DELETE FROM " + SB2.DBTableName("SBSSR") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("BCMMNTS") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "SELECT image_set_id FROM " + SB2.DBTableName("TAXONOCC") + " WHERE well_id=" + id + " AND image_set_id IS NOT NULL";
            rs = stmt.executeQuery(SB2.modQuery(sql));
            LinkedList<Integer> setids = new LinkedList<Integer>();
            while (rs.next()) {
                setids.add(rs.getInt("image_set_id"));
            }
            sql = "DELETE FROM " + SB2.DBTableName("TAXONOCC") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            Iterator it = setids.iterator();
            while (it.hasNext()) {
                ImageSet.deleteWithTypeCheck(SB2, (Integer)it.next(), id);
            }
            sql = "DELETE FROM " + SB2.DBTableName("TAXONOCC") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("SMPDTL") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("IGD") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("IGD_LSTRAT") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("IGD_ENV") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("SQPICK") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("INTCMMNTS") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("IGD_HDR") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("LOCNODE") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("LOC") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("FAULTS") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("SBILITH") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("SBQLITH") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("SBGS") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("IPS_BATHY") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            if (!SB2.sbwlIsView) {
                sql = "DELETE FROM " + SB2.DBTableName("SBWLMB") + " WHERE well_id =" + id;
                stmt.executeUpdate(SB2.modQuery(sql));
            }
            sql = "DELETE FROM " + SB2.DBTableName("ANALY_HDR") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("IGD_COLMAP") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("IGD_HDR") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("SBSLITH") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("EVENTS") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("SAMPLES") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("CASING") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("CORES") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("CORESHIFT") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            HashSet<Integer> imageDeletions = new HashSet<Integer>();
            sql = "SELECT image_id FROM " + SB2.DBTableName("COREIMAGE") + " WHERE well_id=" + id;
            rs = stmt.executeQuery(SB2.modQuery(sql));
            while (rs.next()) {
                int imageID = rs.getInt("image_id");
                imageDeletions.add(imageID);
            }
            sql = "DELETE FROM " + SB2.DBTableName("COREIMAGE") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            Iterator itr = imageDeletions.iterator();
            while (itr.hasNext()) {
                SB2.deleteImage((Integer)itr.next());
            }
            imageDeletions.clear();
            sql = "DELETE FROM " + SB2.DBTableName("WELLSMARK") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("WELLTVD") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("TVDHDR") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("WELLTWT") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "SELECT curve_id FROM " + SB2.DBTableName("LOG_CURVE") + " WHERE well_id=" + id;
            rs = stmt.executeQuery(SB2.modQuery(sql));
            Statement stmt3 = SB2.getDatabase().createStatement();
            while (rs.next()) {
                int curveID = rs.getInt("curve_id");
                sql = "DELETE FROM " + SB2.DBTableName("LOG_TRACE") + " WHERE curve_id=" + curveID;
                stmt3.executeUpdate(SB2.modQuery(sql));
            }
            sql = "DELETE FROM " + SB2.DBTableName("LOG_CURVE") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("INTERVAL_LOG_TRACE") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            if (id > 0) {
                sql = "SELECT chart_id FROM " + SB2.DBTableName("SBCHARTS") + " WHERE well_id=" + id;
                rs = stmt.executeQuery(SB2.modQuery(sql));
                Statement stmt4 = SB2.getDatabase().createStatement();
                while (rs.next()) {
                    int chartID = rs.getInt("chart_id");
                    sql = "DELETE FROM " + SB2.DBTableName("SBCHCLIN") + " WHERE chart_id =" + chartID;
                    stmt4.executeUpdate(SB2.modQuery(sql));
                    sql = "DELETE FROM " + SB2.DBTableName("SBCHPANL") + " WHERE chart_id =" + chartID;
                    stmt4.executeUpdate(SB2.modQuery(sql));
                    sql = "DELETE FROM " + SB2.DBTableName("SBLOGTRC") + " WHERE chart_id =" + chartID;
                    stmt4.executeUpdate(SB2.modQuery(sql));
                }
                sql = "DELETE FROM " + SB2.DBTableName("SBCHARTS") + " WHERE well_id =" + id;
                stmt.executeUpdate(SB2.modQuery(sql));
            }
            sql = "DELETE FROM " + SB2.DBTableName("CHTPREF_BLK") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("CHTPREF_CHT") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "UPDATE " + SB2.DBTableName("CHTPREF_SCH") + " set well_id=NULL WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("CHTMBR") + " WHERE well_id=" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            if (SB2.hasChartBlockWellID()) {
                sql = "DELETE FROM " + SB2.DBTableName("CHTBLOCK") + " WHERE well_id=" + id;
                stmt.executeUpdate(SB2.modQuery(sql));
            }
            sql = "DELETE FROM " + SB2.DBTableName("WELL_IDENT_ACL") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("WELL_IDENT") + " WHERE well_id =" + id;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("WELLS") + " WHERE well_code =" + SB.DBString((String)wellCode);
            stmt.executeUpdate(SB2.modQuery(sql));
        }
    }

    static void loadWellMasterFields(SBdb SB2, List wellMasterFields) throws SQLException {
        if (SB2.hasWellsMaster) {
            DatabaseMetaData meta = SB2.getDatabase().getMetaData();
            String schema = SB2.getSchema();
            ResultSet rs = meta.getColumns(null, schema, "WELLS_MASTER", null);
            while (rs.next()) {
                wellMasterFields.add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
        }
    }

    static String getName(SBdb SB2, int wellID) throws SQLException {
        String wellName = null;
        if (wellID > 0) {
            String sql = "SELECT w.well_name FROM " + SB2.DBTableName("WELL_IDENT") + " v, " + SB2.DBTableName("WELLS") + " w  WHERE v.well_id=" + wellID + " AND v.well_code=w.well_code";
            try (Statement stmt = SB2.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
                if (rs.next()) {
                    wellName = rs.getString("well_name");
                }
            }
        }
        return wellName;
    }

    public static String makeCode(String name) {
        Object code = "";
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                code = (String)code + c;
                continue;
            }
            if (c == '-' || c == '_') {
                code = (String)code + c;
                continue;
            }
            if (c != '/') continue;
            code = (String)code + "-";
        }
        if (((String)(code = ((String)code).toUpperCase())).length() > 25) {
            code = ((String)code).substring(0, 24);
            System.out.println("Warning: well code truncated");
        }
        return code;
    }

    public void deleteCoredInterval(CoredInterval coredInterval) throws SQLException, SBException, SBPermissionException {
        if (!Well.canWrite(this.db)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "well", true));
        }
        this.cores.delete(this.wellID, coredInterval);
    }

    public LinkedList<Integer> getAbnSchemeList() throws SQLException {
        LinkedList<Integer> abnSchemeList = new LinkedList<Integer>();
        Well well = this;
        Iterator<AnalystHeader> itAn = well.getAnalystHeaderIterator();
        while (itAn.hasNext()) {
            AnalystHeader anHdr = itAn.next();
            abnSchemeList.add(anHdr.getAbnSchID());
        }
        return abnSchemeList;
    }

    public LinkedList<Integer> getEnvSchemeList() throws SQLException, SBException {
        LinkedList<Integer> envSchemeList = new LinkedList<Integer>();
        Well well = this;
        Iterator<AnalystHeader> itAn = well.getAnalystHeaderIterator();
        block0: while (itAn.hasNext()) {
            AnalystHeader anHdr = itAn.next();
            for (Smpdtl dtl : this.getAnalyses(anHdr.getDiscID(), anHdr.getAnalyst(), anHdr.getAnalyNumber())) {
                if (dtl.getProximal() <= 0) continue;
                envSchemeList.add(anHdr.getEnvSchID());
                continue block0;
            }
        }
        return envSchemeList;
    }

    public void insertLithInterval(LithBase newLith) {
        this.insertLithInterval(newLith, true);
    }

    public void insertLithInterval(LithBase newLith, boolean notify) {
        if (this.lithIntervals == null) {
            try {
                this.getLithIntervals();
            }
            catch (Exception e) {
                System.out.println("Exception in add lith interval: " + e.getMessage());
            }
        }
        int insertPoint = 0;
        for (LithBase lith : this.lithIntervals) {
            if (newLith.getSortEntry().compareTo(lith.getSortEntry()) < 0) break;
            ++insertPoint;
        }
        this.lithIntervals.add(insertPoint, newLith);
        if (notify) {
            this.notifyObservers(newLith);
        }
    }

    public void insertLithInterval(LithQualifier newLith) {
        if (this.lithIntervals == null) {
            try {
                this.getLithIntervals();
            }
            catch (Exception e) {
                System.out.println("Exception in add lith interval: " + e.getMessage());
            }
        }
        int insertPoint = 0;
        for (LithBase lith : this.lithIntervals) {
            if (newLith.getSortEntry().compareTo(lith.getSortEntry()) < 0) break;
            ++insertPoint;
        }
        this.lithIntervals.add(insertPoint, newLith);
    }

    public SbugsEdit deleteLithBase(LithBase lithBase) throws SQLException, SBException {
        if (!this.canWrite(this.db, null)) {
            throw new SBException(this.getDeniedReason(this.db, "delete lithology", "well", true));
        }
        LithBaseEdit edit = new LithBaseEdit(lithBase, null);
        edit.doEdit();
        return edit;
    }

    void deleteLithIntervals() throws SQLException {
        String sql = "DELETE FROM " + this.db.DBTableName("SBILITH") + " WHERE well_id=" + this.wellID;
        try (Statement stmt = this.db.getDatabase().createStatement();){
            stmt.executeUpdate(this.db.modQuery(sql));
        }
        this.lithIntervals.clear();
        this.setChanged();
    }

    public void deleteLithBases(LinkedList<LithBase> bases) throws SQLException, SBException {
        if (this.db.isConnected() && !this.canWrite(this.db, null)) {
            throw new SBException(this.getDeniedReason(this.db, "delete lithology intervals", "well", true));
        }
        Statement stmt = this.db.isConnected() ? this.db.getDatabase().createStatement() : null;
        for (LithBase base : bases) {
            if (stmt != null) {
                base.delete(this.wellID, stmt);
            }
            if (this.lithIntervals.remove(base)) continue;
            throw new IllegalArgumentException("Attempt to remove lithology which was not in well: " + base);
        }
        if (stmt != null) {
            stmt.close();
        }
        this.setChanged();
    }

    public double getDepth(Sample sample, char units, boolean correctCores, boolean correctCuttings) throws SQLException {
        if (sample.getType().correctDepth(correctCores, correctCuttings)) {
            return DepthUtils.convFromM((double)this.getCorrectedDepth(sample.getDepth()), (char)units);
        }
        return sample.getDepth(units);
    }

    public double getDepth(Sample sample, boolean correctCores, boolean correctCuttings) throws SQLException {
        if (sample.getType().correctDepth(correctCores, correctCuttings)) {
            return this.getCorrectedDepth(sample.getDepth());
        }
        return sample.getDepth();
    }

    public double getSampleTopDepth(Sample sample, char units, boolean correctCores, boolean correctCuttings) throws SQLException, SBException {
        if (sample.getType().correctDepth(correctCores, correctCuttings)) {
            return DepthUtils.convFromM((double)this.getCorrectedDepth(sample.getTopDepth()), (char)units);
        }
        return sample.getTopDepth(units);
    }

    public double getSampleBaseDepth(Sample sample, char units, boolean correctCores, boolean correctCuttings) throws SQLException, SBException {
        if (sample.getType().correctDepth(correctCores, correctCuttings)) {
            return DepthUtils.convFromM((double)this.getCorrectedDepth(sample.getBaseDepth()), (char)units);
        }
        return sample.getBaseDepth(units);
    }

    public double getCorrectedDepth(double depth) throws SQLException {
        if (this.header.getType() != 'W') {
            return depth;
        }
        return this.getCoreShift().getCorrectedDepth(depth);
    }

    void storeCasing(SBdb ws, Casing wsCasing) throws SQLException, SBException {
        this.getCasing();
        for (CasingPoint wsCasingPoint : wsCasing.getList()) {
            boolean found = false;
            for (CasingPoint dbCasingPoint : this.casing.getList()) {
                if (!dbCasingPoint.getSortEntry().equals(wsCasingPoint.getSortEntry())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.casing.add(new CasingPoint(this.db, ws, this.wellID, wsCasingPoint));
        }
        this.casing.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSampleAge(Sample sample, int interpID, Double age, Double ageBelow, Float ageErrorPlus, Float ageErrorMinus, Double ratio) throws SBPermissionException, SQLException {
        if (!this.canWrite(this.db, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "well", true));
        }
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            if (!this.samples.samples.contains(sample)) {
                throw new IllegalStateException("Attempt to edit sample not in well: " + sample.toString());
            }
        }
        sample.setAge(interpID, age, ageBelow, ageErrorPlus, ageErrorMinus, ratio, this.wellID);
        sample.storeAge(this.wellID, interpID);
    }

    void storeTVD(SBdb ws, TVDList wsTVDList) throws SQLException, SBException {
        this.getTVDlist(false);
        for (TVDepth wsTVDepth : wsTVDList.getList()) {
            boolean found = false;
            for (TVDepth dbTVDepth : this.TVD.getList()) {
                if (!(Math.abs(dbTVDepth.getDDepth() - wsTVDepth.getDDepth()) < (double)0.0029f)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.TVD.add(new TVDepth(wsTVDepth), this.wellID);
        }
    }

    void storeTWT(SBdb ws, TWTList wsTWTList) throws SQLException, SBException {
        this.getTVDlist(false);
        for (TWTDepth wsTWTDepth : wsTWTList.getList()) {
            boolean found = false;
            for (TWTDepth dbTWTDepth : this.TWT.getList()) {
                if (!(Math.abs(dbTWTDepth.getDepth() - wsTWTDepth.getDepth()) < (double)0.0029f)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.TWT.add(new TWTDepth(wsTWTDepth));
        }
    }

    void storeCores(SBdb ws, Cores wsCores) throws SQLException, SBException {
        this.getCores();
        for (CoredInterval wsCore : wsCores.getList()) {
            boolean found = false;
            for (CoredInterval dbCore : this.cores.getList()) {
                if (!dbCore.getSortEntry().equals(wsCore.getSortEntry())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.cores.add(new CoredInterval(this.db, ws, this.wellID, wsCore));
        }
        this.cores.notifyObservers();
    }

    void storeCoreshift(SBdb ws, Coreshift wsCoreshift) throws SQLException {
        if (this.coreShift == null) {
            this.coreShift = new Coreshift(this.db, wsCoreshift);
        } else {
            for (int i = 0; i < wsCoreshift.getSize(); ++i) {
                Coreshift.CoreShiftDepth d = wsCoreshift.get(i);
                this.coreShift.add(this.wellID, d.depth, d.shift);
            }
        }
        this.coreShift.store(this.wellID);
    }

    void storeMarkers(SBdb ws, Markers wsMarkers) throws SQLException, SBException {
        this.getMarkers();
        for (int i = 0; i < wsMarkers.getSize(); ++i) {
            SeismicMarker wsMarker = wsMarkers.get(i);
            boolean found = false;
            for (int j = 0; j < this.markers.getSize(); ++j) {
                SeismicMarker dbMarker = this.markers.get(j);
                if (!dbMarker.getSortEntry().equals(wsMarker.getSortEntry())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.markers.add(new SeismicMarker(this.db, ws, this.wellID, wsMarker));
        }
        this.markers.notifyObservers();
    }

    void checkLithInterval(LithInterval lithInt) throws InvalidFieldException {
        for (LithBase base : this.lithIntervals) {
            LithInterval i;
            if (!(base instanceof LithInterval) || (i = (LithInterval)base) == lithInt) continue;
            int nzTD = (int)(i.getTopDepth() * 1000.0);
            int nzBD = (int)(i.getBaseDepth() * 1000.0);
            int cTD = (int)(lithInt.getTopDepth() * 1000.0);
            int cBD = (int)(lithInt.getBaseDepth() * 1000.0);
            try {
                SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD);
            }
            catch (SBException sbe) {
                throw new InvalidFieldException(sbe.getMessage() + i);
            }
        }
    }

    void storeLithology(SBdb ws, List<LithBase> wsLiths) throws SQLException, SBException, InvalidFieldException {
        this.getLithIntervals();
        for (LithBase wsLith : wsLiths) {
            if (wsLith instanceof LithQualifier) continue;
            boolean found = false;
            LithInterval wsLithInterval = (LithInterval)wsLith;
            for (LithBase dbLith : this.lithIntervals) {
                if (dbLith instanceof LithQualifier || !dbLith.getSortEntry().equals(wsLithInterval.getSortEntry())) continue;
                found = true;
                break;
            }
            if (found) continue;
            try {
                this.checkLithInterval(wsLithInterval);
            }
            catch (InvalidFieldException e) {
                throw new InvalidFieldException("Error storing interval: " + wsLithInterval + ": " + e.getMessage() + "\nCheck for overlapping intervals.");
            }
            this.insertLithInterval(new LithInterval(this.db, this.wellID, wsLithInterval));
        }
        for (LithBase wsLith : wsLiths) {
            if (!(wsLith instanceof LithQualifier)) continue;
            LithQualifier wsQual = (LithQualifier)wsLith;
            boolean found = false;
            for (LithBase dbLith : this.lithIntervals) {
                LithQualifier dbQual;
                if (!(dbLith instanceof LithQualifier) || !(dbQual = (LithQualifier)dbLith).getSortEntry().equals(wsQual.getSortEntry()) || dbQual.getLithCode() != wsQual.getLithCode() || dbQual.alignment != wsQual.alignment || dbQual.qType != wsQual.qType || wsQual.xPlotPos != dbQual.xPlotPos) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.insertLithInterval(new LithQualifier(this.db, this.wellID, wsQual));
        }
        if (wsLiths.size() > 0) {
            this.setChanged();
            this.notifyObservers(wsLiths.get(0));
        }
    }

    public Coreshift getCoreShift() throws SQLException {
        if (this.coreShift == null) {
            this.coreShift = new Coreshift(this.db, this.wellID);
        }
        return this.coreShift;
    }

    public void updateCoreShift(Coreshift coreshift) throws SQLException, SBPermissionException {
        if (!Well.canWrite(this.db)) {
            throw new SBPermissionException(Well.getDeniedReason(true));
        }
        this.coreShift.update(this.wellID, coreshift);
    }

    public String getCoreNumber(double depth) {
        if (this.cores != null) {
            CoredInterval foundCore = null;
            for (CoredInterval core : this.cores.getList()) {
                if (core.getTopDepth() <= depth && core.getBaseDepth() >= depth) {
                    foundCore = core;
                }
                if (!(core.getBaseDepth() > depth)) continue;
                break;
            }
            if (foundCore != null) {
                return foundCore.getCorenum();
            }
        }
        return "";
    }

    void setAnalysesLoaded() {
        this.analysesLoaded = true;
    }

    public Curves getCurves() throws SQLException {
        if (this.curves == null) {
            this.curves = new Curves(this.db, this);
        }
        return this.curves;
    }

    public void addCurve(Curve curve) throws SBPermissionException, SQLException, SBException {
        if (!this.canWrite(this.db, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "well", true));
        }
        this.curves.add(this.db, this.getWellID(), curve);
    }

    public void deleteCurves(Collection<Curve> toDelete) throws SBPermissionException, SQLException {
        if (!this.canWrite(this.db, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "well", true));
        }
        this.curves.delete(this.db, toDelete);
        if (this.db.isConnected()) {
            for (Curve curve : toDelete) {
                this.db.updateAuditTrail("LOG_CURVE", "DELETE " + curve.getAbr() + " from " + this.toString() + " [" + this.wellID + "]");
            }
        }
    }

    public void updateCurve(Curve curve, String comment) throws SBPermissionException, SQLException {
        if (!this.canWrite(this.db, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "well", true));
        }
        if (!this.curves.getCurves().contains(curve)) {
            throw new IllegalArgumentException("Attempt to update Curve in wrong well");
        }
        curve.updateComments(comment, this.db);
    }

    public void updateCurve(Curve curve, List<Curve.CurveValue> rowsToDelete) throws SBPermissionException, SQLException {
        if (!this.canWrite(this.db, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "well", true));
        }
        if (!this.curves.getCurves().contains(curve)) {
            throw new IllegalArgumentException("Attempt to update Curve in wrong well");
        }
        curve.deleteRows(this.db, rowsToDelete);
    }

    public void setDataChanged() {
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeSamples(Sample donor, Sample target) throws SQLException, SBException, SBPermissionException {
        SampleList sampleList = this.samples;
        synchronized (sampleList) {
            this.mergeSamplesDB(donor, target);
            target.mergeAnalyses(donor);
            this.samples.samples.remove(donor);
        }
        for (WellInterp wellInterp : this.interps) {
            wellInterp.mergeSamples(donor, target);
        }
        this.setChanged();
    }

    private void mergeSamplesDB(Sample donor, Sample target) throws SQLException, SBException, SBPermissionException {
        try (Statement stmt = this.db.getDatabase().createStatement();){
            if (!this.canWrite(this.db, stmt)) {
                throw new SBPermissionException(this.getDeniedReason(this.db, "well", true));
            }
            String sql = "INSERT INTO " + this.db.DBTableName("SMPDTL") + " (well_id,samp_id,analy_id,picker,source,barren,fov,weight,coarse,medium,fine,notes,proximal,distal," + Audit.sqlFieldString() + ") SELECT well_id," + target.getSampID() + ",analy_id,picker,source,barren,fov,weight,coarse,medium,fine,notes,proximal,distal," + Audit.sqlFieldString() + " FROM " + this.db.DBTableName("SMPDTL") + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("TAXONOCC") + " SET samp_id=" + target.getSampID() + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "DELETE FROM " + this.db.DBTableName("SMPDTL") + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("IGD") + " SET top_id=" + target.getSampID() + " WHERE top_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("IGD") + " SET base_id=" + target.getSampID() + " WHERE base_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("IGD_ENV") + " SET top_id=" + target.getSampID() + " WHERE top_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("IGD_ENV") + " SET base_id=" + target.getSampID() + " WHERE base_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("IGD_LSTRAT") + " SET top_id=" + target.getSampID() + " WHERE top_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("IGD_LSTRAT") + " SET base_id=" + target.getSampID() + " WHERE base_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("BCMMNTS") + " SET usamp_id=" + target.getSampID() + " WHERE usamp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("BCMMNTS") + " SET lsamp_id=" + target.getSampID() + " WHERE lsamp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("EVENTS") + " SET samp_id=" + target.getSampID() + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("SQPICK") + " SET samp_id=" + target.getSampID() + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("FAULTS") + " SET samp_id=" + target.getSampID() + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("SBSLITH") + " SET samp_id=" + target.getSampID() + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("SBSSR") + " SET samp_id=" + target.getSampID() + " WHERE samp_id=" + donor.getSampID() + " AND well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
        }
        donor.delete(this.wellID);
        this.db.updateAuditTrail("SAMPLE", "MERGE " + donor + " with " + target + " in " + this.toString() + " [" + this.wellID + "]");
    }

    public String mergeSampleCheckConflicts(int sample1, int sample2) throws SQLException {
        try (Statement stmt = this.db.getDatabase().createStatement();){
            String table = this.db.DBTableName("SMPDTL");
            String sql = "SELECT d1.samp_id FROM " + table + " d1," + table + " d2 WHERE d1.samp_id=" + sample1 + " AND d2.samp_id=" + sample2 + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id  AND d1.analy_id=d2.analy_id";
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            if (rs.next()) {
                String string = "Both samples contain analyses from the same suite";
                return string;
            }
            table = this.db.DBTableName("IGD");
            sql = "SELECT d1.top_id, d1.igd_type, d1.sch_id AS sch_id1, d2.sch_id AS sch_id2 FROM " + table + " d1," + table + " d2 WHERE d1.top_id=" + sample1 + " AND d2.top_id=" + sample2 + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id  AND d1.igd_type=d2.igd_type AND d1.interp_id=d2.interp_id";
            rs = stmt.executeQuery(this.db.modQuery(sql));
            if (rs.next()) {
                int igdType = rs.getInt("igd_type");
                int schID1 = rs.getInt("sch_id1");
                int schID2 = rs.getInt("sch_id2");
                if (igdType != 4) {
                    String string = "Both samples contain " + IGDInterval.getIGDName(igdType) + " intervals";
                    return string;
                }
                if (schID1 == schID2) {
                    String string = "Both samples contain biozone intervals of the same scheme.";
                    return string;
                }
            }
            if ((rs = stmt.executeQuery(this.db.modQuery(sql = "SELECT d1.top_id FROM " + (table = this.db.DBTableName("IGD_LSTRAT")) + " d1," + table + " d2 WHERE d1.top_id=" + sample1 + " AND d2.top_id=" + sample2 + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id  AND d1.interp_id=d2.interp_id"))).next()) {
                String string = "Both samples contain Lithostratigraphy intervals";
                return string;
            }
            table = this.db.DBTableName("IGD_ENV");
            sql = "SELECT d1.top_id FROM " + table + " d1," + table + " d2 WHERE d1.top_id=" + sample1 + " AND d2.top_id=" + sample2 + " AND d1.well_id=" + this.wellID + " AND d1.interp_id=d2.interp_id AND d1.well_id=d2.well_id ";
            rs = stmt.executeQuery(this.db.modQuery(sql));
            if (rs.next()) {
                String string = "Both samples contain palaeoenvironments of the same type";
                return string;
            }
            table = this.db.DBTableName("BCMMNTS");
            sql = "SELECT d1.usamp_id FROM " + table + " d1," + table + " d2 WHERE d1.usamp_id=" + sample1 + " AND d2.usamp_id=" + sample2 + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id  AND d1.interp_id=d2.interp_id AND d1.analyst=d2.analyst";
            rs = stmt.executeQuery(this.db.modQuery(sql));
            if (rs.next()) {
                String string = "Both samples contain comments of the same analyst";
                return string;
            }
            table = this.db.DBTableName("EVENTS");
            sql = "SELECT d1.samp_id FROM " + table + " d1," + table + " d2 WHERE d1.samp_id=" + sample1 + " AND d2.samp_id=" + sample2 + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id  AND d1.interp_id=d2.interp_id AND d1.ev_id=d2.ev_id";
            rs = stmt.executeQuery(this.db.modQuery(sql));
            if (rs.next()) {
                String string = "Both samples contain the same events";
                return string;
            }
            table = this.db.DBTableName("FAULTS");
            sql = "SELECT d1.samp_id FROM " + table + " d1," + table + " d2 WHERE d1.samp_id=" + sample1 + " AND d2.samp_id=" + sample2 + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id  AND d1.interp_id=d2.interp_id";
            rs = stmt.executeQuery(this.db.modQuery(sql));
            if (rs.next()) {
                String string = "Both samples contain fault data";
                return string;
            }
            table = this.db.DBTableName("SBSLITH");
            sql = "SELECT d1.samp_id FROM " + table + " d1," + table + " d2 WHERE d1.samp_id=" + sample1 + " AND d2.samp_id=" + sample2 + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id ";
            rs = stmt.executeQuery(this.db.modQuery(sql));
            if (rs.next()) {
                String string = "Both samples contain sample lithologies";
                return string;
            }
            table = this.db.DBTableName("SBSSR");
            sql = "SELECT d1.samp_id FROM " + table + " d1," + table + " d2 WHERE d1.samp_id=" + sample1 + " AND d2.samp_id=" + sample2 + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id ";
            rs = stmt.executeQuery(this.db.modQuery(sql));
            if (rs.next()) {
                String string = "Both samples contain sample age data";
                return string;
            }
            table = this.db.DBTableName("SQPICK");
            sql = "SELECT d1.samp_id FROM " + table + " d1," + table + " d2 WHERE d1.samp_id=" + sample1 + " AND d2.samp_id=" + sample2 + " AND d1.well_id=" + this.wellID + " AND d1.well_id=d2.well_id  AND d1.interp_id=d2.interp_id";
            rs = stmt.executeQuery(this.db.modQuery(sql));
            if (rs.next()) {
                String string = "Both samples contain sequence pick data";
                return string;
            }
        }
        return null;
    }

    public boolean hasDepthData() throws SQLException {
        boolean hasDepth = false;
        if (!this.db.isConnected()) {
            return false;
        }
        try (Statement stmt = this.db.getDatabase().createStatement();){
            String[] tables;
            for (String table : tables = new String[]{"SAMPLES", "CASING", "COREIMAGE", "CORES", "CORESHIFT", "INTCMMNTS", "LOCNODE", "SBGS", "SBILITH", "SBQLITH", "WELLSMARK", "WELLTVD", "WELLTWT"}) {
                String sql = "SELECT well_id FROM " + this.db.DBTableName(table) + " WHERE well_id=" + this.wellID;
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
                if (!rs.next()) continue;
                hasDepth = true;
                break;
            }
        }
        return hasDepth;
    }

    public void updateDepthUnits() throws SQLException, SBException {
        try (Statement stmt = this.db.getDatabase().createStatement();){
            Object factor = this.header.getWellUnits() == 'F' ? "/" : "*";
            factor = (String)factor + "0.3048";
            String sql = "UPDATE " + this.db.DBTableName("samples") + " SET top_depth=top_depth" + (String)factor + ", base_depth=base_depth" + (String)factor + "," + new Audit().sqlUpdate(this.db, stmt, false) + " WHERE well_id=" + this.wellID;
            int rows = stmt.executeUpdate(this.db.modQuery(sql));
            if (rows > 0) {
                this.refreshSamples(stmt);
            }
            sql = "UPDATE " + this.db.DBTableName("cores") + " SET top_depth=top_depth" + (String)factor + ", base_depth=base_depth" + (String)factor + "," + new Audit().sqlUpdate(this.db, stmt, false) + " WHERE well_id=" + this.wellID;
            rows = stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("coreimage") + " SET top_depth=top_depth" + (String)factor + ", base_depth=base_depth" + (String)factor + " WHERE well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("coreshift") + " SET depth=depth" + (String)factor + " WHERE well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            if (rows > 0) {
                this.refreshCores(stmt);
            }
            boolean interpRefresh = false;
            sql = "UPDATE " + this.db.DBTableName("intcmmnts") + " SET top_depth=top_depth" + (String)factor + ", base_depth=base_depth" + (String)factor + "," + new Audit().sqlUpdate(this.db, stmt, false) + " WHERE well_id=" + this.wellID;
            rows = stmt.executeUpdate(this.db.modQuery(sql));
            if (rows > 0) {
                interpRefresh = true;
            }
            if ((rows = stmt.executeUpdate(this.db.modQuery(sql = "UPDATE " + this.db.DBTableName("locnode") + " SET depth=depth" + (String)factor + " WHERE well_id=" + this.wellID))) > 0) {
                sql = "UPDATE " + this.db.DBTableName("loc") + " SET " + new Audit().sqlUpdate(this.db, stmt, false) + " WHERE well_id=" + this.wellID;
                stmt.executeUpdate(this.db.modQuery(sql));
                interpRefresh = true;
            }
            this.lithIntervals = null;
            sql = "UPDATE " + this.db.DBTableName("sbgs") + " SET depth=depth" + (String)factor + " WHERE well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("sbilith") + " SET top_depth=top_depth" + (String)factor + ", base_depth=base_depth" + (String)factor + " WHERE well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("sbqlith") + " SET top_depth=top_depth" + (String)factor + " WHERE well_id=" + this.wellID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "UPDATE " + this.db.DBTableName("wellsmark") + " SET depth=depth" + (String)factor + "," + new Audit().sqlUpdate(this.db, stmt, false) + " WHERE well_id=" + this.wellID;
            rows = stmt.executeUpdate(this.db.modQuery(sql));
            if (rows > 0) {
                this.refreshMarkers(stmt);
            }
            if ((rows = stmt.executeUpdate(this.db.modQuery(sql = "UPDATE " + this.db.DBTableName("welltvd") + " SET ddepth=ddepth" + (String)factor + ",tvdepth=tvdepth" + (String)factor + ",incrvs=incrvs" + (String)factor + " WHERE well_id=" + this.wellID))) > 0) {
                this.TVD = null;
                this.TVDplan = null;
            }
            if ((rows = stmt.executeUpdate(this.db.modQuery(sql = "UPDATE " + this.db.DBTableName("welltwt") + " SET ddepth=ddepth" + (String)factor + " WHERE well_id=" + this.wellID))) > 0) {
                this.TWT = null;
            }
            if (interpRefresh) {
                for (WellInterp wellInterp : this.interps) {
                    wellInterp.refresh(stmt, this);
                }
            }
        }
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.db != null && this.db.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for well: " + this);
        }
        this.header.audit.setAnalyst(analyst.getUsrID());
    }

    public SbugsCompoundEdit addLithInterval(LithBase.Builder b) throws SBException, SQLException {
        if (!this.canWrite(this.db, null)) {
            throw new SBException(this.getDeniedReason(this.db, "update lithology", "well", true));
        }
        assert (b != null);
        LithBase base = null;
        if (b instanceof LithInterval.Builder) {
            double snapScale;
            LithInterval.Builder builder = (LithInterval.Builder)b;
            double nearestTop = snapScale = Math.min(0.5, builder.getBaseDepth() - builder.getTopDepth());
            double nearestBase = snapScale;
            double origTop = b.getTopDepth();
            double origBase = builder.getBaseDepth();
            for (LithBase l : this.lithIntervals) {
                if (!(l instanceof LithInterval)) continue;
                LithInterval existing = (LithInterval)l;
                if (Math.abs(existing.getTopDepth() - origBase) < nearestTop && existing.getTopDepth() - builder.getBaseDepth() < -snapScale && existing.getTopDepth() > builder.getBaseDepth()) {
                    builder = new LithInterval.Builder(this.db, builder.getTopDepth(), builder.getLithology(), existing.getTopDepth());
                    nearestTop = Math.abs(existing.getTopDepth() - origBase);
                }
                if (!(Math.abs(existing.getBaseDepth() - builder.getTopDepth()) < nearestBase) || !(existing.getBaseDepth() - builder.getTopDepth() < snapScale) || !(existing.getBaseDepth() < builder.getTopDepth())) continue;
                builder = new LithInterval.Builder(this.db, existing.getBaseDepth(), builder.getLithology(), builder.getBaseDepth());
                nearestBase = Math.abs(existing.getBaseDepth() - origTop);
            }
            LithInterval interval = builder.build();
            base = interval;
            try {
                this.checkLithInterval(interval);
            }
            catch (InvalidFieldException e) {
                throw new SBException(e.getMessage());
            }
            LithInterval above = null;
            LithInterval below = null;
            for (LithBase l : this.lithIntervals) {
                if (!(l instanceof LithInterval)) continue;
                LithInterval lith = (LithInterval)l;
                if (lith.isNeighbourAbove(interval) && lith.getLithCode() == interval.getLithCode()) {
                    above = lith;
                }
                if (!lith.isNeighbourBelow(interval) || lith.getLithCode() != interval.getLithCode()) continue;
                below = lith;
            }
            SbugsCompoundEdit edit = new SbugsCompoundEdit("Add lithology interval: " + base.getLithology().getDescr());
            if (above != null ^ below != null) {
                if (above != null) {
                    edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(above, new LithInterval.Builder(this.db, above.getTopDepth(), above.getLithology(), interval.getBaseDepth()).build())));
                }
                if (below != null) {
                    edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(below, new LithInterval.Builder(this.db, interval.getTopDepth(), base.getLithology(), below.getBaseDepth()).build())));
                }
                return edit;
            }
            if (above != null && below != null) {
                edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(below, null)));
                edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(above, null)));
                edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(null, new LithInterval.Builder(this.db, above.getTopDepth(), base.getLithology(), below.getBaseDepth()).build())));
                return edit;
            }
        }
        if (base == null) {
            base = b.build();
        }
        SbugsCompoundEdit edit = new SbugsCompoundEdit("Add lithology interval: " + base.getLithology().getDescr());
        edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(null, base)));
        return edit;
    }

    public AbstractUndoableEdit addLithInterval(Lithology lith, double topDepth, double baseDepth) throws SBException, SQLException {
        if (!this.canWrite(this.db, null)) {
            throw new SBException(this.getDeniedReason(this.db, "add lithology interval", "well", true));
        }
        assert (!lith.isQual());
        if (topDepth > baseDepth) {
            double temp = baseDepth;
            baseDepth = topDepth;
            topDepth = temp;
        }
        LinkedList<LithInterval> intervals = new LinkedList<LithInterval>();
        for (LithBase l : this.getLithIntervals()) {
            if (!(l instanceof LithInterval)) continue;
            intervals.add((LithInterval)l);
        }
        ListIterator it = intervals.listIterator(0);
        while (it.hasNext()) {
            LithInterval existing = (LithInterval)it.next();
            if (topDepth > existing.getTopDepth() && topDepth < existing.getBaseDepth()) {
                if (it.hasNext() && !(((LithInterval)it.next()).getBaseDepth() > baseDepth)) break;
                topDepth = existing.getBaseDepth();
                break;
            }
            if (!(baseDepth > existing.getTopDepth()) || !(baseDepth < existing.getBaseDepth())) continue;
            it.previous();
            if (it.hasPrevious() && !(((LithInterval)it.previous()).getTopDepth() < topDepth)) break;
            baseDepth = existing.getTopDepth();
            break;
        }
        LithInterval.Builder builder = new LithInterval.Builder(this.db, topDepth, lith, baseDepth);
        SbugsCompoundEdit edit = this.addLithInterval(builder);
        edit.doEdits();
        return edit;
    }

    public AbstractUndoableEdit insertInterval(Lithology lith, double depth) throws SBException, SQLException, SBPermissionException {
        if (!this.canWrite(this.db, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "update lithology", "well", true));
        }
        assert (!lith.isQual());
        LithInterval.Builder builder = null;
        LithInterval lastInterval = null;
        for (LithBase base : this.getLithIntervals()) {
            if (!(base instanceof LithInterval)) continue;
            LithInterval interval = (LithInterval)base;
            if (lastInterval == null) {
                lastInterval = interval;
                continue;
            }
            if (depth > lastInterval.getBaseDepth() && depth < interval.getTopDepth()) {
                builder = new LithInterval.Builder(this.db, lastInterval.getBaseDepth(), lith, interval.getTopDepth());
            }
            lastInterval = interval;
        }
        if (builder == null) {
            return null;
        }
        SbugsCompoundEdit edit = this.addLithInterval(builder);
        edit.doEdits();
        return edit;
    }

    public AbstractUndoableEdit updateLithInterval(LithInterval interval, Lithology newLithology) throws SBException, SQLException, SBPermissionException {
        if (!this.canWrite(this.db, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "update lithology", "well", true));
        }
        assert (newLithology != null && !newLithology.isQual());
        LithBaseEdit deletion = new LithBaseEdit(interval, null);
        deletion.doEdit();
        SbugsCompoundEdit addition = this.addLithInterval(LithInterval.Builder.copyOf(interval, newLithology));
        addition.doEdits();
        SbugsCompoundEdit edit = new SbugsCompoundEdit("Update lithology");
        edit.addEdit((UndoableEdit)((Object)deletion));
        edit.addEdit((UndoableEdit)addition);
        return edit;
    }

    public SbugsCompoundEdit updateLithInterval(double currentDepth, double newDepth) throws SQLException, InvalidFieldException, SBPermissionException {
        if (!this.canWrite(this.db, null)) {
            throw new SBPermissionException(this.getDeniedReason(this.db, "update lithology", "well", true));
        }
        LithBase above = null;
        LithInterval below = null;
        for (LithBase base : this.lithIntervals) {
            if (!(base instanceof LithInterval)) continue;
            LithInterval lith = (LithInterval)base;
            if (Math.abs(lith.getTopDepth() - currentDepth) < 0.5) {
                below = lith;
            } else if (Math.abs(lith.getBaseDepth() - currentDepth) < 0.5) {
                above = lith;
            }
            if (Math.abs(lith.getTopDepth() - newDepth) < 0.5) {
                newDepth = lith.getTopDepth();
                continue;
            }
            if (!(Math.abs(lith.getBaseDepth() - newDepth) < 0.5)) continue;
            newDepth = lith.getBaseDepth();
        }
        if (above == null && below == null) {
            return null;
        }
        if (above != null && newDepth < above.getTopDepth()) {
            throw new InvalidFieldException("Cannot update lithology interval boundary: new depth obscures " + (LithInterval)above);
        }
        if (below != null && newDepth > below.getBaseDepth()) {
            throw new InvalidFieldException("Cannot update lithology interval boundary: new depth obscures " + below);
        }
        SbugsCompoundEdit edit = new SbugsCompoundEdit("Edit lithology boundary");
        if (above == null ^ below == null) {
            LithInterval.Builder temp = null;
            if (!(above == null || newDepth > above.getTopDepth() && newDepth < ((LithInterval)above).getBaseDepth())) {
                temp = new LithInterval.Builder(this.db, currentDepth, above.getLithology(), newDepth);
            } else if (!(below == null || newDepth > below.getTopDepth() && newDepth < below.getBaseDepth())) {
                temp = new LithInterval.Builder(this.db, newDepth, below.getLithology(), currentDepth);
            }
            if (temp != null) {
                try {
                    return this.addLithInterval(temp);
                }
                catch (SBException e) {
                    throw new InvalidFieldException(e.getMessage());
                }
            }
        }
        if (newDepth < currentDepth) {
            if (above != null) {
                edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(above, new LithInterval(this.db, above.getTopDepth(), newDepth, above.getLithology()))));
            }
            if (below != null) {
                edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(below, new LithInterval(this.db, newDepth, below.getBaseDepth(), below.getLithology()))));
            }
        } else {
            if (below != null) {
                edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(below, new LithInterval(this.db, newDepth, below.getBaseDepth(), below.getLithology()))));
            }
            if (above != null) {
                edit.addEdit((UndoableEdit)((Object)new LithBaseEdit(above, new LithInterval(this.db, above.getTopDepth(), newDepth, above.getLithology()))));
            }
        }
        return edit;
    }

    public AbstractUndoableEdit fillLithIntervals(Lithology lithology) throws SBException, SQLException {
        assert (lithology != null);
        SbugsCompoundEdit edit = new SbugsCompoundEdit("Fill lithology intervals with " + lithology.getDescr());
        LithInterval lastLith = null;
        for (LithBase base : this.lithIntervals) {
            if (base instanceof LithQualifier) continue;
            LithInterval interval = (LithInterval)base;
            if (lastLith == null) {
                lastLith = interval;
                continue;
            }
            if (Math.abs(lastLith.getBaseDepth() - interval.getTopDepth()) > 0.1) {
                edit.addEdit((UndoableEdit)this.addLithInterval(new LithInterval.Builder(this.db, lastLith.getBaseDepth(), lithology, interval.getTopDepth())));
            }
            lastLith = interval;
        }
        edit.doEdits();
        return edit;
    }

    private class SampleList
    implements Iterable<Sample> {
        TreeSet<Sample> samples;

        private SampleList() {
        }

        @Override
        public Iterator<Sample> iterator() {
            if (this.samples != null) {
                return this.samples.iterator();
            }
            throw new NotInitialisedException("Sample list");
        }

        void add(Sample sample) {
            if (sample.getSampID() < 1) {
                throw new IllegalArgumentException("Attempt to add sample to well with illegal ID: " + sample);
            }
            sample.displayUnits = Well.this.getWellUnits();
            if (!this.samples.add(sample)) assert (false);
        }

        synchronized void updateSample(Sample sample, Sample.Builder builder) throws SBException, SQLException {
            if (!this.samples.contains(sample)) {
                throw new IllegalArgumentException("Attempt to update a sample which is not in well sample list: exit to refresh data.");
            }
            this.samples.remove(sample);
            if (sample.update(builder)) {
                Well.this.setChanged();
            }
            this.samples.add(sample);
        }

        int size() {
            return this.samples != null ? this.samples.size() : 0;
        }
    }

    class LithBaseEdit
    extends SbugsEdit {
        final LithBase originalLith;
        final LithBase newLith;
        final String presentationName;

        private LithBaseEdit(LithBase originalInterval, LithBase newInterval) {
            this.originalLith = originalInterval;
            this.newLith = newInterval;
            Object s = originalInterval != null && newInterval != null ? "update lithology interval" : (originalInterval != null ? "delete lithology (" + originalInterval.toString() + ")" : "new lithology (" + newInterval + ")");
            this.presentationName = s;
        }

        public void undo() {
            try {
                if (this.newLith != null) {
                    this.deleteAction(this.newLith);
                }
                if (this.originalLith != null) {
                    this.insertAction(this.originalLith);
                }
                Well.this.db.commit();
                Well.this.setChanged();
                Well.this.notifyObservers(this.originalLith != null ? this.originalLith : this.newLith);
            }
            catch (SQLException sql) {
                StackError.showStackError((String)"SQLException in lith interval undo", (SQLException)sql);
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error in lith interval undo", (Exception)((Object)sbe));
            }
            super.undo();
        }

        public void redo() {
            try {
                if (this.originalLith != null) {
                    this.deleteAction(this.originalLith);
                }
                if (this.newLith != null) {
                    this.insertAction(this.newLith);
                }
                Well.this.db.commit();
                Well.this.setChanged();
                Well.this.notifyObservers(this.newLith != null ? this.newLith : this.originalLith);
            }
            catch (SQLException sql) {
                StackError.showStackError((String)"SQLException in lith interval redo", (SQLException)sql);
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error in lith interval redo", (Exception)((Object)sbe));
            }
            super.redo();
        }

        private void deleteAction(LithBase lithBase) throws SQLException, SBException {
            lithBase.delete(Well.this.getWellID(), null);
            Well.this.lithIntervals.remove(lithBase);
        }

        private void insertAction(LithBase lithBase) throws SQLException {
            lithBase.status = SbugsStatus.NOTSTORED;
            if (lithBase instanceof LithInterval) {
                Well.this.insertLithInterval((LithInterval)lithBase);
            } else if (lithBase instanceof LithQualifier) {
                Well.this.insertLithInterval((LithQualifier)lithBase);
            }
            lithBase.store(Well.this.getWellID());
        }

        public void doEdit() throws SBException, SQLException {
            this.redo();
        }

        public String getPresentationName() {
            return this.presentationName;
        }
    }

    public static enum Sort {
        SORTDOWNHOLE("first downhole occurrence", 0),
        SORTUPHOLE("first uphole occurrence", 1),
        SORTALPHA("alphabetical", 3);

        private final String name;
        private final int integerEquivalent;

        private Sort(String name, int integerEquivalent) {
            this.name = name;
            this.integerEquivalent = integerEquivalent;
        }

        public String toString() {
            return this.name;
        }

        public int getIntegerEquivalent() {
            return this.integerEquivalent;
        }
    }
}

