/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipFile;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import model2_1.AbnScheme;
import model2_1.Audit;
import model2_1.CoOccurrence;
import model2_1.Project;
import model2_1.SBRestrictable;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.Smpdtl;
import model2_1.Well;
import model2_1.WellHeader;
import model2_1.WsWell;
import org.jdom2.Element;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class WellManager {
    private final SBdb sbdb;
    private final HashMap<Integer, Well> wells = new HashMap();
    private final TreeMap<Integer, Project> projects = new TreeMap();
    private boolean projectsLoaded = false;

    WellManager(SBdb sbdb) throws SQLException {
        this.sbdb = sbdb;
    }

    Iterator<Well> getWellIterator() {
        return this.wells.values().iterator();
    }

    public static void sortWells(List<Well> list, WELLSORT direction) {
        LinkedList<Well> removed = new LinkedList<Well>();
        Iterator<Well> it = list.iterator();
        while (it.hasNext()) {
            Well w = it.next();
            if (w.getHeader().getLat_dec() != null && w.getHeader().getLong_dec() != null) continue;
            it.remove();
            removed.add(w);
        }
        if (list.size() < 2) {
            list.addAll(removed);
            return;
        }
        boolean sorted = false;
        while (!sorted) {
            sorted = true;
            for (int i = 1; i < list.size(); ++i) {
                Well w1 = list.get(i - 1);
                Well w2 = list.get(i);
                switch (direction) {
                    case NS: {
                        if (!(w1.getHeader().getLat_dec() < w2.getHeader().getLat_dec())) break;
                        sorted = false;
                        break;
                    }
                    case SN: {
                        if (!(w1.getHeader().getLat_dec() > w2.getHeader().getLat_dec())) break;
                        sorted = false;
                        break;
                    }
                    case WE: {
                        if (!(w1.getHeader().getLong_dec() > w2.getHeader().getLong_dec())) break;
                        sorted = false;
                        break;
                    }
                    case EW: {
                        if (!(w1.getHeader().getLong_dec() < w2.getHeader().getLong_dec())) break;
                        sorted = false;
                    }
                }
                if (sorted) continue;
                list.remove(i - 1);
                list.add(i, w1);
            }
        }
        list.addAll(removed);
    }

    List<Well> getWells(int projID, WELLSORT order) throws SQLException, SBException {
        List<Well> list = this.getWells(projID);
        WellManager.sortWells(list, order);
        return list;
    }

    /*
     * Exception decompiling
     */
    List<Well> getWells(int projID) throws SQLException, SBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Iterator<Well> getWellIterator(int projectID) throws SQLException, SBException {
        return this.getWells(projectID).iterator();
    }

    Iterator<Well> getWellIterator(int projectID, WELLSORT order) throws SQLException, SBException {
        return this.getWells(projectID, order).iterator();
    }

    int getnWells(int projID) throws SQLException, SBException {
        return this.getWells(projID).size();
    }

    Well getWellAt(int nWell) {
        ArrayList<Well> list = new ArrayList<Well>(this.wells.values());
        Collections.sort(list);
        return list.get(nWell);
    }

    Well getWell(int wellID) throws SQLException, SBException {
        Well well = this.wells.get(wellID);
        if (well == null && this.sbdb.isConnected()) {
            try {
                well = new Well(this.sbdb, wellID);
                this.wells.put(wellID, well);
            }
            catch (IllegalStateException | SBPermissionException pe) {
                throw new SBException(pe.getMessage(), pe);
            }
        }
        return well;
    }

    void addWell(Well well) {
        if (well.getWellID() == 0) {
            throw new IllegalArgumentException("Attempt to add well with ID 0");
        }
        if (this.wells.get(well.getWellID()) != null) {
            if (this.wells.get(well.getWellID()) == well) {
                assert (false);
                return;
            }
            throw new IllegalArgumentException("Attempt to add duplicate well");
        }
        this.wells.put(well.getWellID(), well);
    }

    Well addWell(String wellCode, WellHeader header) throws SQLException, SBException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT well_code FROM " + this.sbdb.DBTableName("WELL_IDENT") + " WHERE well_code='" + wellCode + "'";
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                throw new SBException("Well code: '" + wellCode + "' Already exists. Well not saved");
            }
            if (header.getCountry() == null || header.getCountry().isEmpty()) {
                throw new SBException("Cannot add well '" + wellCode + "': country name missing");
            }
            if (header.getDescrip() == null || header.getDescrip().trim().isEmpty()) {
                header.setDescrip("Created: " + SB.DBdf.format(new Date()));
            }
        }
        int wellID = this.sbdb.nextControl("WELL_IDENT", "WELL_ID");
        Well well = new Well(this.sbdb, wellID, wellCode, header);
        this.addWell(well);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            well.loadAcm(this.sbdb, stmt);
        }
        return well;
    }

    WsWell addWellToWorkspace(int wellID, String filePath) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to add workspace well to connected database");
        }
        if (wellID <= 0) {
            wellID = this.getNextWellID();
        }
        try {
            WsWell well = new WsWell(this.sbdb, wellID, filePath);
            this.addWell(well);
            well.getSamples();
            return well;
        }
        catch (SQLException | SBException | SBPermissionException e) {
            throw new RuntimeException(e);
        }
    }

    private int getNextWellID() {
        int wellID = 1;
        for (Well well : this.wells.values()) {
            if (well.getWellID() < wellID) continue;
            wellID = well.getWellID() + 1;
        }
        return wellID;
    }

    WsWell addWellToWorkspace(Well dbWell) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to add workspace well to connected database");
        }
        if (!dbWell.getDataModel().isConnected()) {
            throw new IllegalArgumentException("Attempt to copy workspace well to workspace");
        }
        if (this.wells.get(dbWell.getWellID()) != null) {
            return (WsWell)this.wells.get(dbWell.getWellID());
        }
        try {
            WsWell well = new WsWell(this.sbdb, dbWell);
            this.addWell(well);
            well.getSamples();
            return well;
        }
        catch (SQLException | SBException | SBPermissionException e) {
            throw new RuntimeException(e);
        }
    }

    void parseWell(Element xml, Set<Integer> dataTypes, ZipFile zip, String fileName) throws SQLException, SBException, ParseException, SBPermissionException {
        int wellID = this.getNextWellID();
        WsWell well = new WsWell(this.sbdb, xml, dataTypes, zip, fileName, wellID);
        this.addWell(well);
    }

    void deleteWell(Well well) throws SQLException, SBException, SBPermissionException {
        if (this.wells.get(well.getWellID()) != well) {
            throw new IllegalStateException("Attempt to delete well which was not loaded");
        }
        if (this.sbdb.isConnected()) {
            if (!well.canWrite(this.sbdb, null)) {
                throw new SBPermissionException(well.getDeniedReason(this.sbdb, "well", true));
            }
            Well.deleteWell(this.sbdb, well.getWellCode());
            this.sbdb.updateAuditTrail("WELL", "DELETE " + well.toString() + " [" + well.getWellID() + "]");
        }
        this.wells.remove(well.getWellID());
        for (Integer projID : well.getHeader().getProjIDs()) {
            Project project = this.getProject(projID);
            project.updateAudit(this.sbdb);
            project.notifyObservers(well);
        }
    }

    int size() {
        return this.wells.size();
    }

    private void loadProjects() throws SQLException {
        if (this.projectsLoaded) {
            return;
        }
        if (this.sbdb.isConnected()) {
            String sql = "SELECT id,name," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("SBWLLST");
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int projID = rs.getInt("id");
                    String name = rs.getString("name");
                    Audit audit = new Audit(rs);
                    Project project = new Project(projID, name, audit);
                    this.projects.put(projID, project);
                }
            }
        }
        this.projectsLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putProject(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Attempt to put null project");
        }
        if (!this.projectsLoaded) {
            assert (false);
            System.out.println("WARNING: projects not loaded!");
        }
        TreeMap<Integer, Project> treeMap = this.projects;
        synchronized (treeMap) {
            this.projects.put(project.getID(), project);
        }
    }

    Project addProject(String name) throws SQLException, SBPermissionException, InvalidFieldException {
        Project project2;
        if (name == null || name.isEmpty()) {
            throw new IllegalStateException("Attempt to add project with no name");
        }
        name = name.trim();
        this.loadProjects();
        for (Project project2 : this.projects.values()) {
            if (!project2.getName().equalsIgnoreCase(name)) continue;
            throw new InvalidFieldException("That name is already in use.");
        }
        int projID = this.sbdb.nextControl("SBWLLST", "ID");
        project2 = new Project(projID, name, new Audit());
        project2.store(this.sbdb);
        this.putProject(project2);
        return project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteProject(int projID) throws SQLException, SBPermissionException {
        this.loadProjects();
        Project project = this.projects.get(projID);
        if (project == null) {
            throw new IllegalStateException("Attempt to delete project which did not exist");
        }
        project.delete(this.sbdb);
        for (Well well : this.wells.values()) {
            well.getHeader().removeFromProject(projID);
        }
        TreeMap<Integer, Project> treeMap = this.projects;
        synchronized (treeMap) {
            this.projects.remove(projID);
        }
        this.sbdb.updateAuditTrail("PROJECT", "DELETE " + project.getName() + " [" + projID + "]");
    }

    void loadList(DefaultListModel model) throws SQLException {
        this.loadProjects();
        ArrayList<Project> list = new ArrayList<Project>();
        for (Project p : this.projects.values()) {
            list.add(p);
        }
        Collections.sort(list);
        for (Project p : list) {
            model.addElement(p);
        }
    }

    void loadCombo(DefaultComboBoxModel model, boolean includeDefault) throws SQLException {
        this.loadProjects();
        if (includeDefault) {
            model.addElement("<none>");
        }
        ArrayList<Project> list = new ArrayList<Project>(this.projects.values());
        Collections.sort(list);
        for (Project p : list) {
            model.addElement(p);
        }
    }

    Iterator<Well> getWellIterator(String projectName) throws SQLException, SBException {
        this.loadProjects();
        Project project = null;
        for (Project p : this.projects.values()) {
            if (!p.getName().equalsIgnoreCase(projectName)) continue;
            project = p;
            break;
        }
        if (project != null) {
            return this.getWells(project.getID()).iterator();
        }
        return null;
    }

    Project getProject(int projID) throws SQLException {
        this.loadProjects();
        return this.projects.get(projID);
    }

    Project getProject(String projectName) throws SQLException {
        this.loadProjects();
        Project project = null;
        for (Project p : this.projects.values()) {
            if (!p.getName().equalsIgnoreCase(projectName)) continue;
            project = p;
            break;
        }
        return project;
    }

    int getnProjects() throws SQLException {
        this.loadProjects();
        return this.projects.size();
    }

    void addWells(List<Well> wells, int projID) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        Project project = this.getProject(projID);
        ListIterator<Well> it = wells.listIterator();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            while (it.hasNext()) {
                Well well = it.next();
                if (!well.getHeader().isProjectMember(projID)) {
                    String sql = "INSERT INTO " + this.sbdb.DBTableName("SBWLMB") + " (id,well_id) VALUES (" + projID + "," + well.getWellID() + ")";
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                    continue;
                }
                it.remove();
            }
        }
        if (!wells.isEmpty()) {
            for (Well well : wells) {
                if (well.getHeader().isProjectMember(projID)) continue;
                well.getHeader().addToProject(projID);
            }
            project.updateAudit(this.sbdb);
            project.notifyObservers(wells.get(0));
        }
    }

    void removeWellFromProject(Well well, int projID) throws SQLException, SBPermissionException {
        assert (this.wells.get(well.getWellID()) != null);
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        Project project = this.getProject(projID);
        if (well.getHeader().isProjectMember(projID)) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                String sql = "DELETE FROM " + this.sbdb.DBTableName("SBWLMB") + " WHERE ID=" + projID + " AND WELL_ID=" + well.getWellID();
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            well.getHeader().removeFromProject(projID);
            project.updateAudit(this.sbdb);
            project.notifyObservers(well);
        }
    }

    public boolean projectEquals(List<Well> list, int projID) throws SQLException, SBException {
        return this.getWells(projID).equals(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshProjects(Statement stmt) throws SQLException, SBException {
        if (!this.projectsLoaded) {
            return;
        }
        TreeMap<Integer, Project> treeMap = this.projects;
        synchronized (treeMap) {
            String sql = "SELECT id,updated FROM " + this.sbdb.DBTableName("SBWLLST");
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            Project notifier = null;
            HashSet<Integer> keys = new HashSet<Integer>();
            while (rs.next()) {
                int key = rs.getInt("id");
                keys.add(key);
                Timestamp time = rs.getTimestamp("updated");
                boolean found = false;
                for (Project o : this.projects.values()) {
                    if (o.getID() != key) continue;
                    found = true;
                    if (time == null || o.getUpdated() != null && !time.after(o.getUpdated())) break;
                    Project project = new Project(this.sbdb, key);
                    o.copy(project);
                    notifier = o;
                    break;
                }
                if (found) continue;
                notifier = new Project(this.sbdb, key);
                this.projects.put(notifier.getID(), notifier);
            }
            if (keys.size() < this.projects.size()) {
                Iterator<Project> it = this.projects.values().iterator();
                while (it.hasNext()) {
                    Project o = it.next();
                    if (keys.contains(o.getID())) continue;
                    it.remove();
                    if (notifier != null) continue;
                    notifier = o;
                }
            }
            if (notifier != null) {
                // empty if block
            }
        }
    }

    void refreshWells(Statement stmt) throws SQLException, SBException {
        LinkedList<Well> list = new LinkedList<Well>(this.wells.values());
        for (Well well : list) {
            well.refresh(stmt);
        }
    }

    void writeWellLocations(Project project, BufferedWriter out, String eol) throws IOException, SQLException, SBException {
        if (project != null) {
            out.write("<name>" + project.getName() + "</name>" + eol);
        }
        String br = "<br/>";
        LinkedList<Well> sortedWells = new LinkedList<Well>(project != null ? this.getWells(project.getID()) : this.wells.values());
        Collections.sort(sortedWells);
        for (Well w : sortedWells) {
            WellHeader h = w.getHeader();
            if (h.getLat_dec() == null || h.getLong_dec() == null || !(Math.abs(h.getLat_dec()) > 0.0) || !(Math.abs(h.getLong_dec()) > 0.0)) continue;
            out.write("<Placemark>" + eol);
            out.write("<name>" + w.getWellName() + "</name>" + eol);
            out.write("<description>");
            Object descrip = "";
            descrip = (String)descrip + "Well code: " + w.getWellCode() + "<br/>";
            if (w.getHeader().getDescrip() != null) {
                String desc = h.getDescrip().replace("Version created at", "StrataBugs");
                descrip = (String)descrip + desc + "<br/>";
            }
            descrip = (String)descrip + h.getCountry() + "<br/>";
            if (!h.getField().isEmpty()) {
                descrip = (String)descrip + h.getField() + "<br/>";
            }
            if (!h.getOper().isEmpty()) {
                descrip = (String)descrip + h.getOper() + "<br/>";
            }
            descrip = (String)descrip + "TD: " + SB.getDepthString((double)w.getTD(), (char)h.getWellUnits(), (int)2) + "<br/>";
            out.write(SB.getXMLstring((String)descrip) + "</description>" + eol);
            out.write("<Point>" + eol);
            out.write("<coordinates>" + h.getLong_dec() + "," + h.getLat_dec() + (h.getRTE() + h.getSL()) + "</coordinates>" + eol);
            out.write("</Point>" + eol);
            out.write("</Placemark>" + eol);
        }
    }

    void mergeOcc(CoOccurrence coOcc, boolean mergeAbundance) throws SQLException, SBException {
        Smpdtl smpdtl;
        Sample sample;
        Well well;
        boolean loaded = true;
        if (this.wells.get(coOcc.getWellID()) == null) {
            well = this.getWell(coOcc.getWellID());
            loaded = false;
        } else {
            well = this.getWell(coOcc.getWellID());
            well.loadSamples();
        }
        AbnScheme abn = this.sbdb.getAbnScheme(well.getAnalystHeader(coOcc.analyID, true).getAbnSchID(), true);
        if (abn == null) {
            abn = this.sbdb.getDefaultAbnScheme();
        }
        if (mergeAbundance) {
            coOcc.target.merge(coOcc.donor, abn);
        }
        coOcc.donor.delete(coOcc.wellID, coOcc.sampID, coOcc.analyID);
        if (mergeAbundance) {
            coOcc.target.delete(coOcc.wellID, coOcc.sampID, coOcc.analyID);
            coOcc.target.store(null, coOcc.wellID, coOcc.sampID, coOcc.analyID, abn);
        }
        if (loaded && (sample = well.getSample(coOcc.sampID)) != null && (smpdtl = sample.getSmpdtl(coOcc.analyID)) != null) {
            if (mergeAbundance) {
                smpdtl.replaceOcc(coOcc.wellID, coOcc.target);
            }
            smpdtl.removeOcc(coOcc.donor);
            smpdtl.notifyObservers();
        }
    }

    Well getProjectTopDepth(int projID) throws SBException, SQLException {
        return this.getProjectDepth(true, false, projID);
    }

    Well getProjectBaseDepth(boolean useTVD, int projID) throws SBException, SQLException {
        return this.getProjectDepth(false, useTVD, projID);
    }

    private Well getProjectDepth(boolean top, boolean useTVD, int projID) throws SBException, SQLException {
        Double depth = null;
        Well w = null;
        Iterator<Well> wellIterator = this.getWellIterator(projID);
        while (wellIterator.hasNext()) {
            Well well = wellIterator.next();
            if (top) {
                double topDepth = well.getTopSampleDepth();
                if (depth != null && !(topDepth < depth)) continue;
                depth = topDepth;
                w = well;
                continue;
            }
            double baseDepth = 0.0;
            if (useTVD) {
                baseDepth = well.getTVDlist(false).getBaseTVD();
            }
            if (baseDepth == 0.0) {
                baseDepth = well.getBaseSampleDepth();
            }
            if (depth != null && !(baseDepth > depth)) continue;
            depth = baseDepth;
            w = well;
        }
        return w;
    }

    public static enum WELLSORT {
        NS(0, "North - South"),
        SN(180, "South - North"),
        WE(270, "West - East"),
        EW(90, "East - West");

        private final int origin;
        private final String desc;

        private WELLSORT(int sort, String desc) {
            this.origin = sort;
            this.desc = desc;
        }

        public int toInt() {
            return this.origin;
        }

        public String toString() {
            return this.desc;
        }
    }
}

