/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import model2_1.SBRestrictable;
import model2_1.SBdb;
import model2_1.WellHeader;
import util.InvalidFieldException;

public class WellSearchResult
implements Comparable {
    String wellName;
    String wellCode;
    String country;
    String field;
    String oper;
    String county;
    String location;
    String permisson;
    char units;
    int wellID;

    public String getWellName() {
        return this.wellName;
    }

    public String getWellCode() {
        return this.wellCode;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCounty() {
        return this.county;
    }

    public String getField() {
        return this.field;
    }

    public String getOperator() {
        return this.oper;
    }

    public int getWellID() {
        return this.wellID;
    }

    public char getUnits() {
        return this.units;
    }

    public String getPermission() {
        return this.permisson;
    }

    public int compareTo(Object rhs) {
        return this.compareTo((WellSearchResult)rhs);
    }

    public int compareTo(WellSearchResult rhs) {
        if (this.wellName.equalsIgnoreCase(rhs.wellName)) {
            return this.wellCode.compareToIgnoreCase(rhs.wellCode);
        }
        return WellSearchResult.compareTo(this.wellName, rhs.wellName);
    }

    public static int compareTo(String lhs, String rhs) {
        String splitParams = "[\\ \\/\\-\\_]";
        String[] s1 = lhs.split("[\\ \\/\\-\\_]");
        String[] s2 = rhs.split("[\\ \\/\\-\\_]");
        for (int i = 0; i < Math.min(s1.length, s2.length); ++i) {
            int r;
            int c = s1[i].compareTo(s2[i]);
            if (c == 0 || (r = WellSearchResult.compareNameComponent(s1[i], s2[i])) == 0) continue;
            return r;
        }
        return lhs.compareTo(rhs);
    }

    private static int compareNameComponent(String s1, String s2) {
        try {
            if (s1.length() > 0 && s2.length() > 0) {
                int i2;
                int i;
                String s1Suffix = "";
                String s2Suffix = "";
                for (i = 0; i < s1.length() && Character.isDigit(s1.charAt(i)); ++i) {
                }
                if (i < s1.length()) {
                    s1Suffix = s1.substring(i);
                }
                s1 = s1.substring(0, i);
                for (i = 0; i < s2.length() && Character.isDigit(s2.charAt(i)); ++i) {
                }
                if (i < s2.length()) {
                    s2Suffix = s2.substring(i);
                }
                s2 = s2.substring(0, i);
                int i1 = s1.isEmpty() ? 0 : Integer.parseInt(s1);
                int n = i2 = s2.isEmpty() ? 0 : Integer.parseInt(s2);
                if (i1 == i2) {
                    return s1Suffix.compareTo(s2Suffix);
                }
                return i1 - i2;
            }
        }
        catch (NumberFormatException e) {
            System.out.println("message from NFE: " + e.getMessage());
        }
        return s1.compareTo(s2);
    }

    public static List search(SBdb SB2, String wellName, String wellCode, String country, String field, String oper, String county) throws SQLException {
        LinkedList<WellSearchResult> results = new LinkedList<WellSearchResult>();
        String sql = "SELECT well_name,w.well_code,country,field,operator,county,well_id,v.acm FROM " + SB2.DBTableName("WELLS") + " w," + SB2.DBTableName("WELL_IDENT") + " v WHERE w.well_code=v.well_code ";
        if (wellName.compareTo("%") > 0) {
            sql = sql + " AND ucase(well_name) like '" + wellName.trim().toUpperCase() + "'";
        }
        if (wellCode.compareTo("%") > 0) {
            sql = sql + " AND ucase(w.well_code) like '" + wellCode.trim().toUpperCase() + "'";
        }
        if (country.compareTo("%") > 0) {
            sql = sql + " AND ucase(country) like '" + country.trim().toUpperCase() + "'";
        }
        if (field.compareTo("%") > 0) {
            sql = sql + " AND ucase(field) like '" + field.trim().toUpperCase() + "'";
        }
        if (county.compareTo("%") > 0) {
            sql = sql + " AND ucase(county) like '" + county.trim().toUpperCase() + "'";
        }
        if (oper.compareTo("%") > 0) {
            sql = sql + " AND ucase(operator) like '" + oper.trim().toUpperCase() + "'";
        }
        sql = sql + " ORDER BY ucase(well_name),ucase(w.well_code),ucase(country),ucase(field)";
        try (Statement stmt = SB2.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
            while (rs.next()) {
                WellSearchResult result = new WellSearchResult();
                result.wellName = rs.getString("well_name");
                result.wellCode = rs.getString("well_code");
                result.country = rs.getString("country");
                result.field = rs.getString("field");
                result.oper = rs.getString("operator");
                result.county = rs.getString("county");
                result.wellID = rs.getInt("well_id");
                result.permisson = SBRestrictable.getPermissionString(rs.getInt("acm"));
                if (WellHeader.checkWellPerm(SB2, result.country, result.field, result.oper) == 0) continue;
                results.add(result);
            }
        }
        try {
            Collections.sort(results);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        return new ArrayList(results);
    }

    public static List searchMaster(SBdb SB2, String wellName, String wellCode, String country) throws SQLException, InvalidFieldException {
        LinkedList<WellSearchResult> results = new LinkedList<WellSearchResult>();
        boolean clauseAdded = false;
        String sql = "SELECT well_name,well_code,country FROM " + SB2.DBTableName("WELLS_MASTER") + " WHERE ";
        if (wellName.compareTo("%") > 0) {
            clauseAdded = true;
            sql = sql + " ucase(well_name) like '" + wellName.trim().toUpperCase() + "'";
        }
        if (wellCode.compareTo("%") > 0) {
            if (clauseAdded) {
                sql = sql + " AND ";
            }
            clauseAdded = true;
            sql = sql + " ucase(well_code) like '" + wellCode.trim().toUpperCase() + "'";
        }
        if (country.compareTo("%") > 0) {
            if (clauseAdded) {
                sql = sql + " AND ";
            }
            clauseAdded = true;
            sql = sql + " ucase(country) like '" + country.trim().toUpperCase() + "'";
        }
        if (!clauseAdded) {
            throw new InvalidFieldException("No search terms specified.");
        }
        sql = sql + " ORDER BY ucase(well_name),ucase(well_code),ucase(country)";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            WellSearchResult result = new WellSearchResult();
            result.wellName = rs.getString("well_name");
            result.wellCode = rs.getString("well_code");
            result.country = rs.getString("country");
            results.add(result);
        }
        stmt.close();
        return new ArrayList(results);
    }
}

