/*
 * Decompiled with CFR 0.152.
 */
package model2_1.organiser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PaleoImportRecord {
    private final Double topDepth;
    private final String topSampleType;
    private final Double baseDepth;
    private final String baseSampleType;
    private final String paleoLabel;
    private final String paleoLabelLower;
    private final String wellName;
    private final String wellCode;

    public PaleoImportRecord(Double topDepth, String topSampleType, Double baseDepth, String baseSampleType, String paleoLabel, String palaeoLabelLower, String wellName, String wellCode) {
        if (topDepth == null && baseDepth == null) {
            throw new IllegalArgumentException("Can't contruct a PaleoImportRecord with null for both top and base depth.");
        }
        if (paleoLabel == null) {
            throw new IllegalArgumentException("Can't contruct a PaleoImportRecord with null for paleoLabel.");
        }
        if (wellCode == null) {
            throw new IllegalArgumentException("Can't contruct a PaleoImportRecord with null value for wellCode parameter.");
        }
        if (wellName == null) {
            throw new IllegalArgumentException("Can't contruct a PaleoImportRecord with null value for wellName parameter.");
        }
        this.wellName = wellName;
        this.wellCode = wellCode;
        this.topDepth = topDepth;
        this.topSampleType = topSampleType;
        this.baseDepth = baseDepth;
        this.baseSampleType = baseSampleType;
        this.paleoLabel = paleoLabel;
        this.paleoLabelLower = palaeoLabelLower;
    }

    public Double getTopDepth() {
        return this.topDepth;
    }

    public String getTopSampleType() {
        return this.topSampleType;
    }

    public Double getBaseDepth() {
        return this.baseDepth;
    }

    public String getBaseSampleType() {
        return this.baseSampleType;
    }

    public String getPaleoLabel() {
        return this.paleoLabel;
    }

    public String getPaleoLabelLower() {
        return this.paleoLabelLower;
    }

    public String getWellName() {
        return this.wellName;
    }

    public String getWellCode() {
        return this.wellCode;
    }

    public Double getDepth(boolean useTopDepth) {
        if (useTopDepth) {
            if (this.getTopDepth() != null) {
                return this.getTopDepth();
            }
            return this.getBaseDepth();
        }
        if (this.getBaseDepth() != null) {
            return this.getBaseDepth();
        }
        return this.getTopDepth();
    }

    public static <T extends PaleoImportRecord> Map<String, List<T>> buildMapOfWellCodesToRecords(List<T> records) {
        HashMap<String, List<T>> map = new HashMap<String, List<T>>();
        for (PaleoImportRecord record : records) {
            String code = record.getWellCode();
            if (!map.containsKey(code)) {
                map.put(code, new ArrayList());
            }
            ((List)map.get(code)).add(record);
        }
        return map;
    }
}

