/*
 * Decompiled with CFR 0.152.
 */
package model2_1.wellinterp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import java.util.Set;
import javax.swing.undo.UndoableEdit;
import model2_1.IGDIntervalEnv;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.Well;
import model2_1.WsWell;
import model2_1.wellinterp.InterpEdit;
import model2_1.wellinterp.InterpList;
import model2_1.wellinterp.InterpListObserver;
import model2_1.wellinterp.RefreshKey;
import org.jdom2.Element;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsCompoundEdit;

public class IGDIntervalEnvList
extends InterpList<IGDIntervalEnv> {
    public IGDIntervalEnvList(int interpID, InterpListObserver observer) {
        super(interpID, observer);
    }

    @Override
    public String getItemDescriptor() {
        return "environment interval";
    }

    @Override
    String getAuditType() {
        return "ENV";
    }

    @Override
    public void load(Well well) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InterpEdit<IGDIntervalEnv> add() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    IGDIntervalEnv copyToDatabase(IGDIntervalEnv wsT, int wellID, SBdb db) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public EnvEdit add(IGDIntervalEnv.Builder builder, int wellID, SBdb sbdb) throws InvalidFieldException, SQLException, SBException {
        this.checkOverlap(null, builder.getTopSample(), builder.getBaseSample(), null);
        EnvEdit edit = new EnvEdit(wellID, null, builder, sbdb);
        edit.doEdit();
        return edit;
    }

    public EnvEdit update(IGDIntervalEnv original, IGDIntervalEnv.Builder builder, int wellID, SBdb sbdb) throws SQLException, InvalidFieldException, SBException {
        this.checkOverlap(null, builder.getTopSample(), builder.getBaseSample(), original);
        EnvEdit edit = new EnvEdit(wellID, original, builder, sbdb);
        edit.doEdit();
        return edit;
    }

    public UndoableEdit updateBoundary(Sample oldSample, Sample newSample, int wellID, SBdb sbdb) throws SBException, SQLException, InvalidFieldException {
        Object edit;
        IGDIntervalEnv moveTop = null;
        IGDIntervalEnv moveBase = null;
        for (IGDIntervalEnv env : this.getItems()) {
            if (env.getTopSample() == oldSample) {
                moveTop = env;
                continue;
            }
            if (env.getBaseSample() == oldSample) {
                moveBase = env;
            }
            if (moveTop == null || moveBase == null) continue;
            break;
        }
        if (moveTop == null && moveBase == null) {
            System.out.println("Cannot find env interval to update");
            return null;
        }
        if (moveTop != null ^ moveBase != null) {
            edit = moveTop != null ? this.update(moveTop, IGDIntervalEnv.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()), wellID, sbdb) : this.update(moveBase, IGDIntervalEnv.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample), wellID, sbdb);
        } else {
            boolean moveDown;
            edit = new SbugsCompoundEdit("Update env boundary");
            boolean bl = moveDown = newSample.getDepth() - oldSample.getDepth() > 0.0;
            if (moveDown) {
                if (newSample.getDepth() > moveTop.getBaseSample().getDepth()) {
                    throw new InvalidFieldException("New top is below base");
                }
                edit.addEdit((UndoableEdit)((Object)new EnvEdit(wellID, moveTop, IGDIntervalEnv.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()), sbdb)));
                edit.addEdit((UndoableEdit)((Object)new EnvEdit(wellID, moveBase, IGDIntervalEnv.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample), sbdb)));
            } else {
                if (newSample.getDepth() < moveBase.getTopSample().getDepth()) {
                    throw new InvalidFieldException("New base is above top");
                }
                edit.addEdit((UndoableEdit)((Object)new EnvEdit(wellID, moveBase, IGDIntervalEnv.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample), sbdb)));
                edit.addEdit((UndoableEdit)((Object)new EnvEdit(wellID, moveTop, IGDIntervalEnv.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()), sbdb)));
            }
            ((SbugsCompoundEdit)edit).doEdits();
        }
        return edit;
    }

    @Override
    String getRefreshQueryString(SBdb sbdb, int wellID, int interpID) {
        return "SELECT top_id,updated FROM " + sbdb.DBTableName("IGD_ENV") + " WHERE interp_id=" + interpID + " AND well_id=" + wellID;
    }

    @Override
    RefreshKey<IGDIntervalEnv> getRefreshKey(ResultSet rs) throws SQLException {
        final int sampID = rs.getInt("top_id");
        return new RefreshKey<IGDIntervalEnv>(){

            @Override
            public String getKey() {
                return "" + sampID;
            }

            @Override
            public boolean matches(IGDIntervalEnv e) {
                return e.getTopID() == sampID;
            }

            @Override
            public int getSampID() {
                return sampID;
            }
        };
    }

    @Override
    String getRefreshKeyString(IGDIntervalEnv e) {
        return "" + e.getTopID();
    }

    @Override
    IGDIntervalEnv load(RefreshKey<IGDIntervalEnv> refreshKey, IGDIntervalEnv e, SBdb sbdb, Well well, int interpID) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    IGDIntervalEnv copyToWorkspace(IGDIntervalEnv env, SBdb db, WsWell wsWell) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void insertStoredCopy(IGDIntervalEnv itemToCopy, int wellID, SBdb sbdb) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    int getDataType(IGDIntervalEnv t) {
        return 15;
    }

    @Override
    String getTableName() {
        return "IGD_ENV";
    }

    @Override
    String getXmlElementFilterName() {
        return "EnvironmentInterval";
    }

    @Override
    IGDIntervalEnv parseXmlItem(SBdb sbdb, WsWell well, Element xml, Set<Integer> dataTypes) throws SQLException, SBException, ParseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void checkOverlap(List<IGDIntervalEnv> zones, Sample topSample, Sample baseSample, IGDIntervalEnv original) throws InvalidFieldException {
        int nzTD = (int)(topSample.getDepth('M') * 100.0);
        int nzBD = (int)(baseSample.getDepth('M') * 100.0);
        if (zones == null) {
            zones = this.getItems();
        }
        for (IGDIntervalEnv compareWith : zones) {
            if (compareWith == original) continue;
            int cTD = (int)(compareWith.getTopSample().getDepth('M') * 100.0);
            int cBD = (int)(compareWith.getBaseSample().getDepth('M') * 100.0);
            try {
                SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD, (boolean)true);
            }
            catch (SBException sbe) {
                throw new InvalidFieldException("Error inserting palaeoenvironment: " + sbe.getMessage() + " " + compareWith.toString());
            }
        }
    }

    private static String initEnvEditPresentationName(IGDIntervalEnv originalEnv, IGDIntervalEnv.Builder builder) {
        String s = originalEnv != null && builder != null ? "update environment" : (originalEnv != null ? "delete environment" : "new environment");
        return s;
    }

    public class EnvEdit
    extends InterpEdit<IGDIntervalEnv> {
        final IGDIntervalEnv originalEnv;
        final int wellID;
        IGDIntervalEnv.Builder builder;
        IGDIntervalEnv newEnv;
        final SBdb sbdb;

        private EnvEdit(int wellID, IGDIntervalEnv originalEnv, IGDIntervalEnv.Builder builder, SBdb sbdb) {
            super(IGDIntervalEnvList.initEnvEditPresentationName(originalEnv, builder));
            this.originalEnv = originalEnv;
            this.builder = builder;
            this.wellID = wellID;
            this.sbdb = sbdb;
        }

        public void undo() {
            try {
                if (this.newEnv != null) {
                    this.deleteActionDB(this.newEnv);
                }
                if (this.originalEnv != null) {
                    this.insertActionDB(this.originalEnv);
                }
                this.sbdb.commit();
            }
            catch (SQLException | SBException e) {
                this.sbdb.doRollback();
                throw new RuntimeException("Error undoing environment edit", e);
            }
            if (this.newEnv != null) {
                this.deleteActionModel(this.newEnv);
            }
            if (this.originalEnv != null) {
                this.insertActionModel(this.originalEnv);
            }
            IGDIntervalEnvList.this.notifyObserver(this.originalEnv != null ? this.originalEnv : this.newEnv);
            super.undo();
        }

        public void redo() {
            try {
                boolean built;
                if (this.originalEnv != null) {
                    this.deleteActionDB(this.originalEnv);
                }
                if (!(built = this.buildNewEnv()) && this.newEnv != null) {
                    this.insertActionDB(this.newEnv);
                }
                this.sbdb.commit();
            }
            catch (SQLException | SBException e) {
                this.sbdb.doRollback();
                throw new RuntimeException("Error redoing environment edit", e);
            }
            if (this.originalEnv != null) {
                this.deleteActionModel(this.originalEnv);
            }
            if (this.newEnv != null) {
                this.insertActionModel(this.newEnv);
            }
            IGDIntervalEnvList.this.notifyObserver(this.newEnv != null ? this.newEnv : this.originalEnv);
            super.redo();
        }

        private boolean buildNewEnv() throws SQLException, SBException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private void insertActionDB(IGDIntervalEnv env) throws SQLException, SBException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private void insertActionModel(IGDIntervalEnv env) {
            IGDIntervalEnvList.this.insert(env);
        }

        private void deleteActionDB(IGDIntervalEnv env) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private void deleteActionModel(IGDIntervalEnv env) {
            IGDIntervalEnvList.this.remove(env);
        }

        public void doEdit() throws SQLException {
            try {
                this.redo();
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public IGDIntervalEnv getItem() {
            return this.newEnv;
        }

        @Override
        public IGDIntervalEnv getNotifier() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

