/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.db;

import com.stratadata.model3.db.ConnectionDetails;
import com.stratadata.model3.db.ConnectionFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class BasicConnectionFactory
implements ConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger(BasicConnectionFactory.class.getName());
    private final ConnectionDetails connDetails;

    public BasicConnectionFactory(ConnectionDetails connDetails) {
        this.connDetails = connDetails;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Properties props;
        if (this.connDetails.props() == null) {
            props = new Properties();
            if (this.connDetails.instanceLogin() != null) {
                props.put("user", this.connDetails.instanceLogin());
                props.put("password", this.connDetails.password());
            }
        } else {
            props = this.connDetails.props();
        }
        if (!StringUtils.isBlank((CharSequence)this.connDetails.instanceLogin())) {
            LOGGER.log(Level.INFO, "Connecting (v3.0) with:{0} (user={1}, password={2})", new Object[]{this.connDetails.driverString(), this.connDetails.instanceLogin(), this.connDetails.password() == null ? "" : "(" + this.connDetails.password().length() + " chars)"});
        } else {
            LOGGER.log(Level.INFO, "Connecting (v3.0) with:{0}  (system properties used for OS Authentication)", this.connDetails.driverString());
        }
        Connection c = DriverManager.getConnection(this.connDetails.driverString(), props);
        String initSQL = this.connDetails.getInitSQL();
        if (!initSQL.isEmpty()) {
            try (Statement stmt = c.createStatement();){
                stmt.executeUpdate(initSQL);
            }
        }
        return c;
    }

    @Override
    public String getTablePrefix() {
        return this.connDetails.tablePrefix();
    }

    @Override
    public void close() {
    }
}

