/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.db;

import com.stratadata.model3.db.ConnectionFactory;
import com.stratadata.model3.db.DBType;
import com.stratadata.model3.db.PersistentConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class ConnectionManager {
    private final ConnectionFactory factory;
    private Connection persistentConnection;
    private DatabaseMetaData persistentConnectionMetaData;
    private DBType persistentConnectionDBType;

    public ConnectionManager(ConnectionFactory factory) {
        this.factory = factory;
    }

    public void setupPersistentConnection() throws SQLException {
        this.persistentConnection = this.factory.getConnection();
        this.persistentConnection.setAutoCommit(false);
        this.persistentConnectionMetaData = this.persistentConnection.getMetaData();
        this.persistentConnectionDBType = ConnectionManager.getDBTypeFromMetaData(this.persistentConnectionMetaData);
    }

    public boolean isPersistentConnectionPresent() {
        return this.persistentConnection != null;
    }

    public Connection getNewConnection() throws SQLException {
        Connection c = this.factory.getConnection();
        c.setAutoCommit(false);
        return c;
    }

    public String getTablePrefix() {
        return this.factory.getTablePrefix();
    }

    public PersistentConnection getPersistentConnection() {
        return new PersistentConnection(this.persistentConnection);
    }

    public DatabaseMetaData getConnectionMetaData() {
        return this.persistentConnectionMetaData;
    }

    public DBType getDBType() {
        return this.persistentConnectionDBType;
    }

    public boolean isConnectionValid() {
        if (this.persistentConnection != null) {
            try {
                return this.persistentConnection.isValid(1);
            }
            catch (SQLException e) {
                return false;
            }
        }
        return false;
    }

    public void commitPersistentConnection() throws SQLException {
        if (this.persistentConnection != null) {
            this.persistentConnection.commit();
        }
    }

    public void rollbackPersistentConnection() throws SQLException {
        if (this.persistentConnection != null) {
            this.persistentConnection.rollback();
        }
    }

    public void closePersistentConnection() throws SQLException {
        if (this.persistentConnection != null) {
            this.persistentConnection.close();
            this.persistentConnection = null;
        }
    }

    public void closePersistentConnectionAndConnectionFactory() throws SQLException {
        if (this.persistentConnection != null) {
            this.persistentConnection.close();
            this.persistentConnection = null;
        }
        if (this.factory != null) {
            this.factory.close();
        }
    }

    public static DBType getDBTypeFromMetaData(DatabaseMetaData meta) throws SQLException {
        String dbTypeName = meta.getDatabaseProductName();
        if (dbTypeName.equalsIgnoreCase("ACCESS")) {
            return DBType.ACCESS;
        }
        if (dbTypeName.equalsIgnoreCase("ORACLE")) {
            return DBType.ORACLE;
        }
        if (dbTypeName.equalsIgnoreCase("Microsoft SQL Server")) {
            return DBType.MSSQLSERVER;
        }
        if (dbTypeName.equalsIgnoreCase("MySQL")) {
            return DBType.MYSQL;
        }
        if (dbTypeName.equalsIgnoreCase("SQLite")) {
            return DBType.SQLITE;
        }
        if (dbTypeName.toLowerCase().startsWith("ucanaccess")) {
            return DBType.ACCESS;
        }
        if (dbTypeName.startsWith("H2")) {
            return DBType.H2;
        }
        if (dbTypeName.equals("PostgreSQL")) {
            return DBType.POSTGRESQL;
        }
        throw new IllegalStateException("Cannot recognise database type of ODBC connection: " + dbTypeName);
    }
}

