/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.db;

public enum DBDriverType {
    H2("H2"),
    SQLSERVER("SQL Server"),
    ORACLE("Oracle"),
    ORACLE_OCI("Oracle OCI"),
    POSTGRESQL("PostgreSQL"),
    MYSQL("MySQL");

    private final String name;

    private DBDriverType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static DBDriverType getDriverType(String driverName) {
        if (driverName == null) {
            return null;
        }
        try {
            return DBDriverType.valueOf(driverName.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (driverName.contains("mysql")) {
                return MYSQL;
            }
            if (driverName.contains("sqlserver")) {
                return SQLSERVER;
            }
            if (driverName.contains("h2")) {
                return H2;
            }
            if (driverName.contains("oracle")) {
                return driverName.contains("oci") ? ORACLE_OCI : ORACLE;
            }
            if (driverName.contains("postgres")) {
                return POSTGRESQL;
            }
            return null;
        }
    }
}

