/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.external;

import com.stratadata.model3.external.SimpleLoginCredentials;
import com.stratadata.model3.external.WebServiceDescription;
import com.stratadata.model3.external.WebServiceDescriptionService;
import com.stratadata.model3.external.WebServiceType;
import com.stratadata.util.preferences.RegistryPreferencesHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import model3.ConnectionProvider;
import model3.exception.SuppressedSQLException;
import org.apache.commons.lang3.StringUtils;

public class WebServices
implements WebServiceDescriptionService {
    private final ConnectionProvider conn;
    private final Map<WebServiceType, List<WebServiceDescription>> services = new HashMap<WebServiceType, List<WebServiceDescription>>();

    public WebServices(ConnectionProvider conn) throws SQLException {
        this.conn = conn;
        this.loadAllServices();
    }

    private void loadAllServices() throws SQLException {
        try (Statement stmt = this.conn.getDatabase().createStatement();){
            String sql = "SELECT id, type, name, URL, credentials, proxy FROM " + this.conn.DBTableName("WS_SERVERS");
            ResultSet rs = stmt.executeQuery(this.conn.modQuery(sql));
            while (rs.next()) {
                String type = rs.getString("type");
                WebServiceType wsType = WebServiceType.valueOf((String)type);
                WebServiceDescription serviceDescription = new WebServiceDescription(rs.getInt("id"), wsType, rs.getString("name"), rs.getString("URL"), rs.getBoolean("credentials"), rs.getBoolean("proxy"));
                if (this.services.get(wsType) == null) {
                    this.services.put(wsType, new LinkedList());
                }
                this.services.get(wsType).add(serviceDescription);
            }
        }
    }

    public List<WebServiceDescription> getServiceDescriptions(WebServiceType type) {
        List<WebServiceDescription> servicesForType = this.services.get(type);
        if (servicesForType == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<WebServiceDescription>(servicesForType);
    }

    public Optional<WebServiceDescription> getServiceDescription(int serverID) {
        for (Collection collection : this.services.values()) {
            for (WebServiceDescription d : collection) {
                if (d.ID() != serverID) continue;
                return Optional.of(d);
            }
        }
        return Optional.empty();
    }

    public WebServiceDescription addServiceDescription(WebServiceDescription wsDetails) {
        WebServiceDescription webServiceDescription;
        block11: {
            if (StringUtils.isBlank((CharSequence)wsDetails.name())) {
                throw new IllegalArgumentException("Web service name is blank");
            }
            for (WebServiceDescription ws : this.getServiceDescriptions(wsDetails.type())) {
                if (!ws.name().equals(wsDetails.name())) continue;
                throw new IllegalArgumentException("A web service of this name already exists");
            }
            String sql = "INSERT INTO " + this.conn.DBTableName("WS_SERVERS") + " (id, type, name, URL, credentials, proxy) VALUES (?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = this.conn.getDatabase().prepareStatement(sql);
            try {
                int id = this.conn.nextControl("WS_SERVERS", "ID");
                int col = 1;
                stmt.setInt(col++, id);
                stmt.setString(col++, wsDetails.type().name());
                stmt.setString(col++, wsDetails.name());
                stmt.setString(col++, wsDetails.URL());
                stmt.setBoolean(col++, wsDetails.requiresCredentials());
                stmt.setBoolean(col++, false);
                stmt.executeUpdate();
                this.conn.commit();
                WebServiceDescription webServiceDescription2 = new WebServiceDescription(id, wsDetails.type(), wsDetails.name(), wsDetails.URL(), wsDetails.requiresCredentials(), false);
                if (this.services.get(wsDetails.type()) == null) {
                    this.services.put(wsDetails.type(), new LinkedList());
                }
                this.services.get(wsDetails.type()).add(webServiceDescription2);
                webServiceDescription = webServiceDescription2;
                if (stmt == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw SuppressedSQLException.withRollback("Error storing new web service details", ex, this.conn);
                }
            }
            stmt.close();
        }
        return webServiceDescription;
    }

    public WebServiceDescription updateServiceDescription(int id, WebServiceDescription newDetails) {
        if (StringUtils.isBlank((CharSequence)newDetails.name())) {
            throw new IllegalArgumentException("Web service name is blank");
        }
        for (WebServiceDescription ws : this.getServiceDescriptions(newDetails.type())) {
            if (ws.ID() == id || !ws.name().equalsIgnoreCase(newDetails.name())) continue;
            throw new IllegalArgumentException("Another web service of this name already exists");
        }
        WebServiceDescription original = this.getServiceDescription(id).orElseThrow(() -> new IllegalArgumentException("No existing service with ID " + id + " to update"));
        if (original.type() != newDetails.type()) {
            throw new IllegalArgumentException("Cannot change web service type");
        }
        String sql = "UPDATE " + this.conn.DBTableName("WS_SERVERS") + " SET type=?, name=?, URL=?, credentials=?, proxy=? WHERE id=" + id;
        try (PreparedStatement stmt = this.conn.getDatabase().prepareStatement(sql);){
            int col = 1;
            stmt.setString(col++, newDetails.type().name());
            stmt.setString(col++, newDetails.name());
            stmt.setString(col++, newDetails.URL());
            stmt.setBoolean(col++, newDetails.requiresCredentials());
            stmt.setBoolean(col++, false);
            stmt.executeUpdate();
            this.conn.commit();
        }
        catch (SQLException ex) {
            throw SuppressedSQLException.withRollback("Error updating external service", ex, this.conn);
        }
        this.removeServiceDescription(id);
        WebServiceDescription ws = newDetails.withID(id);
        this.services.get(ws.type()).add(ws);
        SimpleLoginCredentials originalCredentials = WebServices.getCredentials(original);
        WebServices.putCredentials(original, null);
        if (newDetails.requiresCredentials()) {
            WebServices.putCredentials(newDetails, originalCredentials);
        }
        return ws;
    }

    public void deleteServiceDescription(int serverID) {
        WebServiceDescription toDelete = this.services.values().stream().flatMap(Collection::stream).filter(d -> d.ID() == serverID).findFirst().orElseThrow(IllegalStateException::new);
        String sql = "DELETE FROM " + this.conn.DBTableName("WS_SERVERS") + " WHERE id=" + serverID;
        try (PreparedStatement stmt = this.conn.getDatabase().prepareStatement(sql);){
            stmt.executeUpdate();
            this.conn.commit();
        }
        catch (SQLException ex) {
            throw SuppressedSQLException.withRollback("Error deleting web service details", ex, this.conn);
        }
        this.removeServiceDescription(serverID);
        WebServices.putCredentials(toDelete, null);
    }

    private void removeServiceDescription(int id) {
        for (Collection collection : this.services.values()) {
            WebServiceDescription webServiceDescription = collection.stream().filter(d -> d.ID() == id).findFirst().orElse(null);
            if (webServiceDescription == null) continue;
            collection.remove(webServiceDescription);
            return;
        }
    }

    public static SimpleLoginCredentials getCredentials(WebServiceDescription serviceDescription) {
        if (serviceDescription.requiresCredentials()) {
            Preferences nodeForService = WebServices.getPreferenceNode(serviceDescription);
            String username = nodeForService.get("username", null);
            String password = nodeForService.get("password", "");
            if (username != null) {
                return new SimpleLoginCredentials(username, password);
            }
        }
        return null;
    }

    public static void putCredentials(WebServiceDescription serviceDescription, SimpleLoginCredentials credentials) {
        Preferences nodeForService = WebServices.getPreferenceNode(serviceDescription);
        if (credentials != null && !credentials.username().isEmpty()) {
            nodeForService.put("username", credentials.username());
            nodeForService.put("password", credentials.password());
        } else {
            try {
                nodeForService.removeNode();
            }
            catch (BackingStoreException e) {
                Logger.getLogger(WebServices.class.getName()).log(Level.WARNING, "Error deleting preference node for webservice", e);
            }
        }
    }

    private static Preferences getPreferenceNode(WebServiceDescription serviceDescription) {
        Preferences webServerPrefs = RegistryPreferencesHelper.getPreferences().node("webservices");
        return webServerPrefs.node(serviceDescription.name().toLowerCase().trim());
    }
}

