/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.image;

import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.ImageSet;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.ImageUtils;

public class EditableImageSet
extends ImageSet
implements ImageLoader {
    private final ImageLoader backupLoader;
    private List<ImageRecord> imageRecords;
    private Map<Integer, Image> fullSizeImages = new HashMap<Integer, Image>();

    public EditableImageSet(ImageLoader backupLoader) {
        super(0);
        this.backupLoader = backupLoader;
        this.imageRecords = new ArrayList<ImageRecord>();
    }

    public EditableImageSet(ImageSet original, ImageRecordService irs, ImageLoader backupLoader) {
        super(original.getImageSetID());
        this.backupLoader = backupLoader;
        this.imageRecords = irs != null ? original.getImageRecords(irs) : new ArrayList<ImageRecord>();
    }

    public List<ImageRecord> getImageRecords(ImageRecordService irs) {
        return this.getImageRecords();
    }

    public List<ImageRecord> getImageRecords() {
        return new ArrayList<ImageRecord>(this.imageRecords);
    }

    public int getSize() {
        return this.imageRecords.size();
    }

    public Image getImage(int imageID, Dimension imageSize) {
        return super.getImage(null, (ImageLoader)this, imageID, imageSize);
    }

    public void addImageFromFile(File file) throws IOException {
        this.addImageFromFile(this.imageRecords.size(), file);
    }

    public void addImageFromFile(int insertAt, File file) throws IOException {
        String picPath = file.getPath();
        int imageID = this.getNextID();
        ImageRecord imageRecord = new ImageRecord(imageID, "", picPath);
        this.fullSizeImages.put(imageID, ImageUtils.readImage((String)picPath));
        if (insertAt > -1 && insertAt < this.imageRecords.size()) {
            this.imageRecords.add(insertAt, imageRecord);
        } else {
            this.imageRecords.add(imageRecord);
        }
    }

    public void addNewImage(int insertAt, Image image) {
        int imageID = this.getNextID();
        ImageRecord imageRecord = new ImageRecord(imageID, "", null);
        this.fullSizeImages.put(imageID, image);
        this.imageRecords.add(insertAt, imageRecord);
    }

    public void addImageRecord(ImageRecord ir) {
        if (this.getImageSetID() > 0) {
            throw new IllegalStateException("Incorrect use of EditableImageSet");
        }
        this.imageRecords.add(ir);
    }

    public void removeImage(int n) {
        ImageRecord removed = this.imageRecords.remove(n);
        if (removed != null) {
            this.fullSizeImages.remove(removed.imageID());
        }
    }

    public void setCaption(int nImage, String caption) {
        ImageRecord imageRecord = this.imageRecords.get(nImage);
        ImageRecord newImageRecord = new ImageRecord(imageRecord.imageID(), caption, imageRecord.picPath());
        this.imageRecords.set(nImage, newImageRecord);
    }

    private int getNextID() {
        int minID = this.imageRecords.stream().map(ImageRecord::imageID).min(Integer::compareTo).orElse(0);
        if (minID > 0) {
            minID = 0;
        }
        return minID - 1;
    }

    public Image getImage(ImageRecord ir) {
        if (this.fullSizeImages.get(ir.imageID()) != null) {
            return this.fullSizeImages.get(ir.imageID());
        }
        return this.backupLoader.getImage(ir);
    }

    public boolean isTransientSource() {
        return this.backupLoader.isTransientSource();
    }
}

