/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.image;

import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.ImageRecordSet;
import com.stratadata.model3.image.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import model3.SBdb;
import model3.exception.SuppressedSQLException;
import org.apache.commons.lang3.StringUtils;
import util.SB;

public class ImageRecordServiceDbImpl
implements ImageRecordService {
    private final SBdb conn;
    private final Map<Integer, ImageRecordSet> imageSets = new HashMap<Integer, ImageRecordSet>();
    private final Map<Integer, ImageRecord> imageRecords = new HashMap<Integer, ImageRecord>();

    public ImageRecordServiceDbImpl(SBdb conn) {
        this.conn = conn;
    }

    public List<ImageRecord> getImageRecords(int imageSetID) {
        ImageRecordSet imageRecordSet = this.imageSets.get(imageSetID);
        if (imageRecordSet == null) {
            LinkedList<ImageRecord> images = new LinkedList<ImageRecord>();
            String sql = "SELECT m.image_id,m.sort,i.pic_path,i.caption FROM " + this.conn.DBTableName("IMAGE_SETMBR") + " m  LEFT JOIN " + this.conn.DBTableName("SBIMAGE") + " i on m.image_id=i.image_id WHERE m.image_set_id=" + imageSetID + " ORDER BY sort";
            try (Statement stmt = this.conn.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.conn.modQuery(sql));
                while (rs.next()) {
                    int imageID = rs.getInt("image_id");
                    String path = rs.getString("pic_path");
                    String caption = rs.getString("caption");
                    ImageRecord r = new ImageRecord(imageID, caption, path);
                    images.add(r);
                }
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withoutRollback(e);
            }
            imageRecordSet = new ImageRecordSet(imageSetID, images);
            this.imageSets.put(imageSetID, imageRecordSet);
        }
        return imageRecordSet.getImageRecords();
    }

    public ImageRecord getImageRecord(int imageID) {
        ImageRecord imageRecord = this.imageRecords.get(imageID);
        if (imageRecord == null) {
            String sql = "SELECT pic_path,caption FROM " + this.conn.DBTableName("SBIMAGE") + " WHERE image_id=" + imageID;
            try (Statement stmt = this.conn.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.conn.modQuery(sql));
                if (rs.next()) {
                    String path = rs.getString("pic_path");
                    String caption = rs.getString("caption");
                    imageRecord = new ImageRecord(imageID, caption, path);
                    this.imageRecords.put(imageID, imageRecord);
                }
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withoutRollback(e);
            }
        }
        return imageRecord;
    }

    public void deleteImageRecords(int imageSetID) {
        if (imageSetID <= 0) {
            return;
        }
        List<ImageRecord> imageRecords = this.getImageRecords(imageSetID);
        try (Statement stmt = this.conn.getDatabase().createStatement();){
            String sql = "DELETE FROM " + this.conn.DBTableName("image_setmbr") + " WHERE image_set_id=" + imageSetID;
            stmt.executeUpdate(this.conn.modQuery(sql));
            String inClause = "(" + StringUtils.join(imageRecords.stream().map(imageRecord -> "" + imageRecord.imageID()).toList(), (String)",") + ")";
            sql = "DELETE FROM " + this.conn.DBTableName("SBIMAGE") + " WHERE image_id IN " + inClause;
            stmt.executeUpdate(this.conn.modQuery(sql));
            sql = "DELETE FROM " + this.conn.DBTableName("tximage") + " WHERE image_set_id=" + imageSetID;
            stmt.executeUpdate(this.conn.modQuery(sql));
            sql = "UPDATE " + this.conn.DBTableName("taxonocc") + " SET image_set_id=null WHERE image_set_id=" + imageSetID;
            stmt.executeUpdate(this.conn.modQuery(sql));
            sql = "DELETE FROM " + this.conn.DBTableName("image_set") + " WHERE image_set_id=" + imageSetID;
            stmt.executeUpdate(this.conn.modQuery(sql));
            this.conn.commit();
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withRollback("Error deleting image set", e, this.conn);
        }
        this.imageSets.remove(imageSetID);
    }

    public void deleteImageRecord(int imageID) {
        if (imageID <= 0) {
            return;
        }
        try (Statement stmt = this.conn.getDatabase().createStatement();){
            String sql = "DELETE FROM " + this.conn.DBTableName("SBIMAGE") + " WHERE image_id=" + imageID;
            stmt.executeUpdate(this.conn.modQuery(sql));
            this.conn.commit();
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withRollback("Error deleting image set", e, this.conn);
        }
        this.imageRecords.remove(imageID);
    }

    public void updateCaption(int imageSetID, int imageID, String newCaption) {
        List<ImageRecord> imageRecords = this.getImageRecords(imageSetID);
        ImageRecord imageRecord = imageRecords.stream().filter(ir -> ir.imageID() == imageID).findFirst().orElseThrow();
        if (!Objects.equals(imageRecord.caption(), newCaption)) {
            if (imageID > 0) {
                try (Statement stmt = this.conn.getDatabase().createStatement();){
                    String sql = "UPDATE " + this.conn.DBTableName("SBIMAGE") + " SET caption=" + SB.DBString((String)newCaption) + " WHERE image_id=" + imageID;
                    stmt.executeUpdate(this.conn.modQuery(sql));
                    this.conn.commit();
                }
                catch (SQLException e) {
                    throw SuppressedSQLException.withRollback("Error updating image caption", e, this.conn);
                }
            }
            ImageRecord newRecord = new ImageRecord(imageID, newCaption, imageRecord.picPath());
            imageRecords.set(imageRecords.indexOf(imageRecord), newRecord);
            this.imageSets.get(imageSetID).setImageRecords(imageRecords);
        }
    }

    public int storeImageSet(int imageSetID, List<ImageRecord> imageRecords, ImageLoader imageSource) {
        if (imageSetID == 0 && imageRecords.isEmpty()) {
            return imageSetID;
        }
        List<ImageRecord> original = null;
        try (Statement stmt = this.conn.getDatabase().createStatement();){
            String sql;
            if (imageSetID == 0) {
                imageSetID = this.conn.nextControl("image_set", "image_set_id");
                sql = "INSERT INTO " + this.conn.DBTableName("image_set") + " (image_set_id) VALUES (" + imageSetID + ")";
                stmt.executeUpdate(this.conn.modQuery(sql));
            } else {
                original = this.getImageRecords(imageSetID);
                sql = "DELETE FROM " + this.conn.DBTableName("image_setmbr") + " WHERE image_set_id=" + imageSetID;
                stmt.executeUpdate(this.conn.modQuery(sql));
            }
            Iterator<ImageRecord> it = imageRecords.iterator();
            LinkedList<ImageRecord> storedImages = new LinkedList<ImageRecord>();
            while (it.hasNext()) {
                ImageRecord imageRecord = it.next();
                if (imageRecord.imageID() < 1) {
                    imageRecord = this.storeImage(imageRecord, imageSource);
                }
                int sort = storedImages.size() + 1;
                sql = "INSERT INTO " + this.conn.DBTableName("image_setmbr") + " (image_set_id,image_id,sort) VALUES (" + imageSetID + "," + imageRecord.imageID() + "," + sort + ")";
                stmt.executeUpdate(this.conn.modQuery(sql));
                storedImages.add(imageRecord);
            }
            if (original != null) {
                Set newIDs = imageRecords.stream().map(ir -> ir.imageID()).collect(Collectors.toSet());
                List<Integer> deletedRecords = original.stream().map(ImageRecord::imageID).filter(id -> !newIDs.contains(id)).toList();
                for (int deletedImageID : deletedRecords) {
                    sql = "DELETE FROM " + this.conn.DBTableName("sbimage") + " WHERE image_id=" + deletedImageID;
                    stmt.executeUpdate(this.conn.modQuery(sql));
                }
                this.imageSets.put(imageSetID, new ImageRecordSet(imageSetID, storedImages));
            }
            this.conn.commit();
        }
        catch (SQLException ex) {
            throw SuppressedSQLException.withRollback("Error storing image set", ex, this.conn);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return imageSetID;
    }

    public int storeImageRecord(ImageRecord imageRecord, ImageLoader imageSource) {
        if (imageRecord.imageID() > 0) {
            this.deleteImageRecord(imageRecord.imageID());
        }
        try {
            ImageRecord storedIr = this.storeImage(imageRecord, imageSource);
            return storedIr.imageID();
        }
        catch (SQLException ex) {
            throw SuppressedSQLException.withRollback("Error storing image set", ex, this.conn);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private ImageRecord storeImage(ImageRecord ir, ImageLoader imageSource) throws SQLException, IOException {
        Object picPath;
        String sql = "INSERT INTO " + this.conn.DBTableName("sbimage") + " (image_id,pic_path,caption" + (this.conn.storeImage() ? ",image_data" : "") + ") VALUES (?,?,?" + (this.conn.storeImage() ? ",?" : "") + ")";
        PreparedStatement pStmt = this.conn.getDatabase().prepareStatement(this.conn.modQuery(sql));
        int imageID = this.conn.nextControl("sbimage", "image_id");
        pStmt.setInt(1, imageID);
        if (!this.conn.storeImage()) {
            Object imageFolder = this.conn.getImageFolder();
            if (imageFolder != null && !((String)imageFolder).isEmpty() && !((String)imageFolder).endsWith(File.separator)) {
                imageFolder = (String)imageFolder + File.separator;
            }
            picPath = !ir.picPath().contains(File.separator) ? (String)imageFolder + ir.picPath() : ir.picPath();
            pStmt.setString(2, (String)picPath);
        } else {
            picPath = null;
            pStmt.setNull(2, 0);
        }
        pStmt.setString(3, ir.caption());
        ImageLoader.ImageInputStream im = imageSource.getImageInputStream(ir);
        if (this.conn.storeImage()) {
            pStmt.setBinaryStream(4, im.inputStream(), im.len());
        } else if (imageSource.isTransientSource()) {
            int nBytes;
            Object fosPath = "";
            if (!((String)picPath).contains(File.separator)) {
                fosPath = this.conn.getImageFolder();
            }
            fosPath = (String)fosPath + (String)picPath;
            FileOutputStream fos = new FileOutputStream((String)fosPath);
            byte[] bytes = new byte[Short.MAX_VALUE];
            while ((nBytes = im.inputStream().read(bytes, 0, bytes.length)) > 0) {
                fos.write(bytes, 0, nBytes);
            }
            fos.close();
            picPath = this.conn.getImageFolder() + (String)picPath;
        }
        pStmt.executeUpdate();
        pStmt.close();
        if (im.inputStream() != null) {
            im.inputStream().close();
        }
        return new ImageRecord(imageID, ir.caption(), (String)picPath);
    }

    public int getImageCount(boolean whereImagesAreStoredInDatabase) throws SQLException {
        try (Statement stmt = this.conn.getDatabase().createStatement();){
            String sql = "SELECT count(image_id) as nitems FROM " + this.conn.DBTableName("SBIMAGE") + " WHERE image_data IS ";
            if (whereImagesAreStoredInDatabase) {
                sql = sql + "NOT ";
            }
            sql = sql + " NULL";
            ResultSet rs = stmt.executeQuery(this.conn.modQuery(sql));
            int nItems = 0;
            if (rs.next()) {
                nItems = rs.getInt("nitems");
            }
            int n = nItems;
            return n;
        }
    }

    public void exportImages(File destinationDir, boolean updatePath, ImageLoader imageLoader) throws SQLException, IOException {
        ArrayList<ImageRecord> imageRecords = new ArrayList<ImageRecord>();
        try (Statement stmt = this.conn.getDatabase().createStatement();){
            String sql = "SELECT image_id,pic_path,caption FROM " + this.conn.DBTableName("SBIMAGE") + " WHERE image_data IS NOT NULL";
            ResultSet rs = stmt.executeQuery(this.conn.modQuery(sql));
            while (rs.next()) {
                int imageID = rs.getInt("image_id");
                String picPath = rs.getString("pic_path");
                String caption = rs.getString("caption");
                imageRecords.add(new ImageRecord(imageID, caption, picPath));
            }
        }
        if (imageRecords.isEmpty()) {
            return;
        }
        String sql = "UPDATE " + this.conn.DBTableName("SBIMAGE") + " SET pic_path=?,image_data=NULL WHERE image_id=?";
        try (PreparedStatement pStmt = this.conn.getDatabase().prepareStatement(this.conn.modQuery(sql));){
            for (ImageRecord imageRecord : imageRecords) {
                String exportPath = String.valueOf(destinationDir) + File.separator + "sbugs_" + imageRecord.imageID() + ".jpg";
                Image image = imageLoader.getImage(imageRecord);
                BufferedImage bi = ImageUtils.convertImageToBufferedImage((Image)image);
                if (bi == null || bi.getWidth(null) <= 0 || bi.getHeight(null) <= 0) continue;
                ImageIO.write((RenderedImage)bi, "jpg", new File(exportPath));
                if (!updatePath) continue;
                pStmt.setString(1, exportPath);
                pStmt.setInt(2, imageRecord.imageID());
                pStmt.executeUpdate();
            }
        }
        this.conn.commit();
        this.imageSets.clear();
    }

    public void importImages(File imageFolder) throws SQLException, IOException {
        ArrayList<ImageRecord> imageRecords = new ArrayList<ImageRecord>();
        try (Statement stmt = this.conn.getDatabase().createStatement();){
            String sql = "SELECT image_id,pic_path,caption FROM " + this.conn.DBTableName("SBIMAGE") + " WHERE image_data IS NULL";
            ResultSet rs = stmt.executeQuery(this.conn.modQuery(sql));
            while (rs.next()) {
                int imageID = rs.getInt("image_id");
                String picPath = rs.getString("pic_path");
                String caption = rs.getString("caption");
                imageRecords.add(new ImageRecord(imageID, caption, picPath));
            }
        }
        if (imageRecords.isEmpty()) {
            return;
        }
        String sql = "UPDATE " + this.conn.DBTableName("SBIMAGE") + " SET image_data=? WHERE image_id=?";
        try (PreparedStatement pStmt = this.conn.getDatabase().prepareStatement(this.conn.modQuery(sql));){
            for (ImageRecord imageRecord : imageRecords) {
                File picPathFile;
                String picPath;
                File imageFolderFile;
                File sourceFile = null;
                if (imageFolder != null && (imageFolderFile = new File(picPath = String.valueOf(imageFolder) + File.separator + "sbugs_" + imageRecord.imageID() + ".jpg")).exists()) {
                    sourceFile = imageFolderFile;
                }
                if (sourceFile == null && !StringUtils.isBlank((CharSequence)imageRecord.picPath()) && (picPathFile = new File(imageRecord.picPath())).exists()) {
                    sourceFile = picPathFile;
                }
                if (sourceFile != null) {
                    FileInputStream fileIn = new FileInputStream(sourceFile);
                    try {
                        pStmt.setBinaryStream(1, (InputStream)fileIn, (int)sourceFile.length());
                        pStmt.setInt(2, imageRecord.imageID());
                        pStmt.executeUpdate();
                        continue;
                    }
                    finally {
                        fileIn.close();
                        continue;
                    }
                }
                Logger.getLogger(ImageRecordServiceDbImpl.class.getName()).log(Level.WARNING, "No source file for image: " + String.valueOf(imageRecord));
            }
        }
        this.conn.commit();
    }
}

