/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.image;

import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.ImageRecordSet;
import com.stratadata.model3.image.PicPathImageLoader;
import com.stratadata.model3.image.TaxonImageService;
import com.stratadata.model3.image.TaxonImageSet;
import com.stratadata.model3.well.WellRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import model3.Well;
import org.apache.commons.lang3.StringUtils;

public class OccurrenceImageDelete {
    private static final Logger LOGGER = Logger.getLogger(OccurrenceImageDelete.class.getName());
    private final ImageRecordService imageRecordService;
    private final TaxonImageService taxonImageService;
    private final WellRepository<Well> wellRepository;
    private ImageRecordSet originalImageRecordSet;

    public OccurrenceImageDelete(ImageRecordService imageRecordService, TaxonImageService taxonImageService, WellRepository<Well> wellRepository) {
        this.imageRecordService = imageRecordService;
        this.taxonImageService = taxonImageService;
        this.wellRepository = wellRepository;
    }

    public static void deleteImageSetsWithTypeCheck(ImageRecordService imageRecordService, TaxonImageService taxonImageService, WellRepository<Well> wellRepository, Set<Integer> imageSetIDs, int wellID) {
        OccurrenceImageDelete del = new OccurrenceImageDelete(imageRecordService, taxonImageService, wellRepository);
        for (Integer imageSetID : imageSetIDs) {
            del.deleteOccurrenceImageSet(imageSetID, wellID);
        }
    }

    public void deleteOccurrenceImageSet(int imageSetID, int wellID) {
        if (imageSetID < 1) {
            return;
        }
        TaxonImageSet taxonImageSet = this.taxonImageService.getTaxonImageSet(imageSetID);
        List originalImageRecords = this.imageRecordService.getImageRecords(imageSetID);
        if (taxonImageSet.isType()) {
            Object newCaptionPrefix = "Original occurrence in well %s deleted.";
            try {
                newCaptionPrefix = String.format((String)newCaptionPrefix, ((Well)this.wellRepository.getWellByID(wellID)).getWellName()) + " ";
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Error getting well", e);
            }
            String finalNewCaptionPrefix = newCaptionPrefix;
            List<ImageRecord> updatedImageRecords = originalImageRecords.stream().map(ir -> new ImageRecord(ir.imageID(), StringUtils.truncate((String)(finalNewCaptionPrefix + " " + ir.caption()), (int)255), ir.picPath())).toList();
            this.imageRecordService.storeImageSet(imageSetID, updatedImageRecords, null);
            this.originalImageRecordSet = new ImageRecordSet(imageSetID, originalImageRecords);
        } else {
            this.imageRecordService.deleteImageRecords(imageSetID);
            this.taxonImageService.deleteTaxonImageSet(taxonImageSet.getSpecID(), taxonImageSet);
            this.originalImageRecordSet = new ImageRecordSet(0, originalImageRecords);
        }
    }

    public int restore() {
        if (this.originalImageRecordSet != null) {
            if (this.originalImageRecordSet.getImageSetID() > 0) {
                this.imageRecordService.storeImageSet(this.originalImageRecordSet.getImageSetID(), this.originalImageRecordSet.getImageRecords(), null);
                return this.originalImageRecordSet.getImageSetID();
            }
            ArrayList<ImageRecord> updatedImageRecords = new ArrayList<ImageRecord>();
            PicPathImageLoader pathImageLoader = new PicPathImageLoader();
            for (ImageRecord ir : this.originalImageRecordSet.getImageRecords()) {
                if (pathImageLoader.getImage(ir) == null) continue;
                updatedImageRecords.add(new ImageRecord(0, ir.caption(), ir.picPath()));
            }
            if (!updatedImageRecords.isEmpty()) {
                return this.imageRecordService.storeImageSet(0, updatedImageRecords, (ImageLoader)pathImageLoader);
            }
        }
        return 0;
    }
}

