/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.image;

import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecord;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;

public class ZipFileImageLoader
implements ImageLoader {
    private final String zipPath;

    public ZipFileImageLoader(String zipPath) {
        this.zipPath = zipPath;
    }

    public Image getImage(ImageRecord ir) {
        try {
            int nBytes;
            ZipFile zip = new ZipFile(this.zipPath);
            ZipEntry entry = zip.getEntry(ir.picPath());
            if (entry == null) {
                throw new IllegalStateException("Can't find zip file entry for image: " + ir.picPath());
            }
            InputStream fileIn = zip.getInputStream(entry);
            File picFile = File.createTempFile("SBImage" + ir.imageID() + "-", ".jpg");
            picFile.deleteOnExit();
            String tempPicPath = picFile.getPath();
            FileOutputStream fos = new FileOutputStream(tempPicPath);
            byte[] bytes = new byte[Short.MAX_VALUE];
            while ((nBytes = fileIn.read(bytes, 0, bytes.length)) > 0) {
                fos.write(bytes, 0, nBytes);
            }
            fos.close();
            ImageIcon imageIcon = new ImageIcon(tempPicPath);
            return imageIcon.getImage();
        }
        catch (IOException ios) {
            throw new RuntimeException("IO Exception when reading image from zip file path: " + ios.toString(), ios);
        }
    }

    public ImageLoader.ImageInputStream getImageInputStream(ImageRecord ir) throws IOException {
        ZipFile zip = new ZipFile(this.zipPath);
        ZipEntry entry = zip.getEntry(ir.picPath());
        if (entry == null) {
            throw new IllegalStateException("Can't find zip file entry for image: " + ir.picPath());
        }
        return new ImageLoader.ImageInputStream(zip.getInputStream(entry), (int)entry.getSize());
    }

    public boolean isTransientSource() {
        return true;
    }
}

