/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.analysis;

import com.stratadata.model3.well.analysis.SpeciesType;
import com.stratadata.model3.well.analysis.SpeciesTypeService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import model3.ConnectionProvider;
import model3.exception.SuppressedSQLException;
import org.apache.commons.lang3.StringUtils;
import util.SB;

public class SpeciesTypeServiceDbImpl
implements SpeciesTypeService {
    public static final String specTypeDefault = "<no sub-type>";
    private final ConnectionProvider sbdb;
    private HashMap<Integer, String> specTypes = null;

    public SpeciesTypeServiceDbImpl(ConnectionProvider sbdb) {
        this.sbdb = sbdb;
    }

    private void loadSpecTypes() {
        this.specTypes = new HashMap();
        try {
            String sql = "SELECT spec_type_id, descr FROM " + this.sbdb.DBTableName("speciestype");
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    this.specTypes.put(rs.getInt("spec_type_id"), rs.getString("descr"));
                }
                if (this.specTypes.get(0) == null) {
                    sql = "INSERT INTO " + this.sbdb.DBTableName("speciestype") + " (spec_type_id, descr) VALUES (0," + SB.DBString((String)specTypeDefault) + ")";
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                }
            }
            this.specTypes.put(0, specTypeDefault);
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withRollback("Error loading species types", e, this.sbdb);
        }
    }

    public Optional<SpeciesType> getSpeciesType(int specTypeID) {
        if (this.specTypes == null) {
            this.loadSpecTypes();
        }
        if (this.specTypes.get(specTypeID) == null) {
            return Optional.empty();
        }
        return Optional.of(new SpeciesType(specTypeID, this.specTypes.get(specTypeID)));
    }

    public Optional<SpeciesType> findSpeciesType(String specType) {
        if (StringUtils.isBlank((CharSequence)specType)) {
            return Optional.empty();
        }
        if (this.specTypes == null) {
            this.loadSpecTypes();
        }
        for (Integer key : this.specTypes.keySet()) {
            if (!this.specTypes.get(key).equalsIgnoreCase(specType)) continue;
            return Optional.of(new SpeciesType(key.intValue(), this.specTypes.get(key)));
        }
        return Optional.empty();
    }

    public SpeciesType getAddSpeciesType(String specType) {
        int typeID = this.findSpeciesType(specType).map(SpeciesType::specTypeID).orElse(-1);
        if (typeID < 0) {
            try {
                typeID = this.sbdb.nextControl("speciestype", "spec_type_id");
                String sql = "INSERT INTO " + this.sbdb.DBTableName("SPECIESTYPE") + " (spec_type_id, descr) VALUES (" + typeID + "," + SB.DBString((String)specType) + ")";
                try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                }
                this.sbdb.commit();
                this.specTypes.put(typeID, specType);
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withRollback("Error inserting species type", e, this.sbdb);
            }
        }
        return new SpeciesType(typeID, this.specTypes.get(typeID));
    }

    public void addSpeciesType(SpeciesType speciesType) {
        throw new IllegalStateException("Species type cannot be added - use getAdd instead");
    }

    public List<SpeciesType> getAllSpeciesTypes() {
        if (this.specTypes == null) {
            this.loadSpecTypes();
        }
        return this.specTypes.entrySet().stream().map(e -> new SpeciesType(((Integer)e.getKey()).intValue(), (String)e.getValue())).toList();
    }

    public SpeciesType updateSpeciesTypeDescription(int specTypeID, String newDescription) {
        if (this.specTypes == null) {
            this.loadSpecTypes();
        }
        try {
            String sql = "UPDATE " + this.sbdb.DBTableName("speciestype") + " SET descr=" + SB.DBString((String)newDescription) + " WHERE spec_type_id=" + specTypeID;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            this.sbdb.commit();
        }
        catch (SQLException ex) {
            throw SuppressedSQLException.withRollback("Error updating species type description", ex, this.sbdb);
        }
        this.specTypes.remove(specTypeID);
        this.specTypes.put(specTypeID, newDescription);
        this.getListeners().stream().forEach(SpeciesTypeService.Listener::speciesTypesUpdated);
        return new SpeciesType(specTypeID, newDescription);
    }

    public void deleteSpeciesType(SpeciesType speciesType) {
        if (this.specTypes == null) {
            this.loadSpecTypes();
        }
        if (this.specTypes.get(speciesType.specTypeID()) == null) {
            throw new IllegalArgumentException("No species type to delete:  " + String.valueOf(speciesType));
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName("speciestype") + " WHERE spec_type_id=" + speciesType.specTypeID();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            this.sbdb.commit();
        }
        catch (SQLException ex) {
            throw SuppressedSQLException.withRollback("Error deleting species type", ex, this.sbdb);
        }
        this.specTypes.remove(speciesType.specTypeID());
        this.getListeners().stream().forEach(SpeciesTypeService.Listener::speciesTypesUpdated);
    }
}

