/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.preferences;

import com.stratadata.model3.db.ModelVersion;
import com.stratadata.util.preferences.ProxySettings;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;
import util.SB;

public class RegistryPreferencesHelper {
    public static final String PREFKEY_GUIRESIZE = "resizegui";
    public static final String PREFKEY_HELPPATH = "help_path";
    public static final String PREFKEY_SILENT = "silent";
    public static final String PREFKEY_SILENTSBLOGIN = "silentsblogin";
    public static final String PREFKEY_LOOKANDFEEL = "lookandfeel";
    private static final String PREFKEY_PROXYHOST = "proxyhost";
    private static final String PREFKEY_PROXYPORT = "proxyport";
    private static final String PREFKEY_PROXYLOGIN = "proxylogin";
    private static final String PREFKEY_PROXYPWD = "proxypwd";
    private static final String CRYPTKEY_PROXY = "pRXYcRYPT";
    private static boolean initialiseFromSystem = true;

    public static Preferences getPreferences() {
        return RegistryPreferencesHelper.getPreferences(SBdb.MODEL_VERSION);
    }

    public static Preferences getPreferences(ModelVersion version) {
        Preferences prefs = Preferences.userRoot().node("jsbugs").node(version.getRegistryNodeKey());
        if (initialiseFromSystem) {
            initialiseFromSystem = false;
            try {
                if (prefs.childrenNames().length == 0) {
                    Preferences systemPrefs = Preferences.systemRoot().node("jsbugs").node(version.getRegistryNodeKey());
                    RegistryPreferencesHelper.copyChildren(systemPrefs, prefs);
                }
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(RegistryPreferencesHelper.class.getName()).log(Level.WARNING, "Error getting preferences: {0} ", ex);
            }
        }
        return prefs;
    }

    private static void copyChildren(Preferences systemNode, Preferences userNode) throws BackingStoreException {
        for (String child : systemNode.childrenNames()) {
            RegistryPreferencesHelper.copyChildren(systemNode.node(child), userNode.node(child));
        }
        for (String key : systemNode.keys()) {
            userNode.put(key, systemNode.get(key, null));
        }
    }

    public static boolean getGuiResizePreference(boolean def) {
        return RegistryPreferencesHelper.getPreferences().getBoolean(PREFKEY_GUIRESIZE, def);
    }

    public static void putGuiResizePreferece(boolean resizegui) {
        RegistryPreferencesHelper.getPreferences().putBoolean(PREFKEY_GUIRESIZE, resizegui);
    }

    public static String getHelpPathPreference() {
        return RegistryPreferencesHelper.getPreferences().get(PREFKEY_HELPPATH, "");
    }

    public static void putHelpPathPreference(String helpPath) {
        RegistryPreferencesHelper.getPreferences().put(PREFKEY_HELPPATH, helpPath);
    }

    public static void putSilent(boolean silent) {
        RegistryPreferencesHelper.getPreferences().putBoolean(PREFKEY_SILENT, silent);
    }

    public static boolean getSilentLogin() {
        return RegistryPreferencesHelper.getPreferences().getBoolean(PREFKEY_SILENT, false);
    }

    public static void putSilentSBLogin(boolean silent) {
        RegistryPreferencesHelper.getPreferences().putBoolean(PREFKEY_SILENTSBLOGIN, silent);
    }

    public static boolean getSilentSBLogin() {
        return RegistryPreferencesHelper.getPreferences().getBoolean(PREFKEY_SILENTSBLOGIN, false);
    }

    public static void putLookAndFeel(String name) {
        RegistryPreferencesHelper.getPreferences().put(PREFKEY_LOOKANDFEEL, name);
    }

    public static String getLookAndFeel(String defaultLAF) {
        return RegistryPreferencesHelper.getPreferences().get(PREFKEY_LOOKANDFEEL, defaultLAF);
    }

    public static void putProxySettings(ProxySettings settings) {
        Preferences pref = RegistryPreferencesHelper.getPreferences();
        if (settings != null) {
            pref.put(PREFKEY_PROXYHOST, settings.getProxyHost());
            pref.put(PREFKEY_PROXYPORT, settings.getProxyPort());
            if (!StringUtils.isBlank((CharSequence)settings.getProxyUser())) {
                pref.put(PREFKEY_PROXYLOGIN, settings.getProxyUser());
                pref.put(PREFKEY_PROXYPWD, SB.crypt((boolean)true, (String)CRYPTKEY_PROXY, (String)settings.getProxyPassword()));
            } else {
                pref.remove(PREFKEY_PROXYLOGIN);
                pref.remove(PREFKEY_PROXYPWD);
            }
        } else {
            pref.remove(PREFKEY_PROXYHOST);
            pref.remove(PREFKEY_PROXYPORT);
            pref.remove(PREFKEY_PROXYLOGIN);
            pref.remove(PREFKEY_PROXYPWD);
        }
    }

    public static ProxySettings getProxySettings() {
        Preferences pref = RegistryPreferencesHelper.getPreferences();
        String host = pref.get(PREFKEY_PROXYHOST, null);
        String port = pref.get(PREFKEY_PROXYPORT, null);
        ProxySettings settings = null;
        if (!StringUtils.isBlank((CharSequence)host) && !StringUtils.isBlank((CharSequence)port)) {
            settings = new ProxySettings();
            settings.setProxyHost(host);
            settings.setProxyPort(port);
            settings.setProxyUser(pref.get(PREFKEY_PROXYLOGIN, null));
            settings.setProxyPassword(StringUtils.stripToNull((String)SB.crypt((boolean)false, (String)CRYPTKEY_PROXY, (String)pref.get(PREFKEY_PROXYPWD, null))));
        }
        return settings;
    }
}

