/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.db.DBType;
import com.stratadata.model3.user.Userdef;
import com.stratadata.util.DateUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Objects;
import model3.SBdb;
import org.jdom2.Element;
import util.SB;
import util.SBException;

public class Audit
implements Comparable<Audit> {
    public static final String CREATOR = "creator";
    public static final String CREATED = "created";
    public static final String MODIFIER = "modifier";
    public static final String MODIFIED = "modified";
    public static final String UPDATER = "updater";
    public static final String UPDATED = "updated";
    int creator;
    java.util.Date created;
    int modifier;
    java.util.Date modified;
    int updater;
    java.util.Date updated;
    static java.util.Date serverDate;
    private static final String DBdf_PATTERN = "yyyy-MM-dd";
    private static final String DBdtf_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public Audit(ResultSet rs) throws SQLException {
        this.creator = rs.getInt(CREATOR);
        this.created = rs.getTimestamp(CREATED);
        this.modifier = rs.getInt(MODIFIER);
        this.modified = rs.getTimestamp(MODIFIED);
        this.updater = rs.getInt(UPDATER);
        this.updated = rs.getTimestamp(UPDATED);
        if (this.updated == null) {
            this.updated = Calendar.getInstance().getTime();
        }
    }

    public static AuditImpl getAuditFromResultSet(ResultSet rs) throws SQLException {
        return Audit.getAuditFromResultSet(rs, "");
    }

    public static AuditImpl getAuditFromResultSet(ResultSet rs, String alias) throws SQLException {
        if (!((String)alias).isEmpty() && !((String)alias).endsWith("_")) {
            alias = (String)alias + "_";
        }
        AuditImpl auditImpl = new AuditImpl();
        auditImpl.setCreatorID(rs.getInt((String)alias + CREATOR));
        Timestamp createdTimestamp = rs.getTimestamp((String)alias + CREATED);
        if (createdTimestamp != null) {
            auditImpl.setCreated(createdTimestamp.toLocalDateTime().toLocalDate());
        }
        auditImpl.setModifierID(rs.getInt((String)alias + MODIFIER));
        Timestamp modifiedTimestamp = rs.getTimestamp((String)alias + MODIFIED);
        if (modifiedTimestamp != null) {
            auditImpl.setModified(modifiedTimestamp.toLocalDateTime().toLocalDate());
        }
        auditImpl.setUpdaterID(rs.getInt((String)alias + UPDATER));
        Timestamp updatedTimestamp = rs.getTimestamp((String)alias + UPDATED);
        if (updatedTimestamp != null) {
            auditImpl.setUpdated(updatedTimestamp.toInstant());
        } else {
            auditImpl.setUpdated(Instant.now());
        }
        return auditImpl;
    }

    public Audit(ResultSet rs, String alias) throws SQLException {
        this.creator = rs.getInt(alias + CREATOR);
        this.created = rs.getTimestamp(alias + CREATED);
        this.modifier = rs.getInt(alias + MODIFIER);
        this.modified = rs.getTimestamp(alias + MODIFIED);
        this.updater = rs.getInt(alias + UPDATER);
        this.updated = rs.getTimestamp(alias + UPDATED);
    }

    public Audit(Audit rhs) {
        if (rhs == null) {
            return;
        }
        this.creator = rhs.creator;
        if (rhs.created != null) {
            this.created = new java.util.Date(rhs.created.getTime());
        }
        this.modifier = rhs.modifier;
        if (rhs.modified != null) {
            this.modified = new java.util.Date(rhs.modified.getTime());
        }
        this.updater = rhs.updater;
        if (rhs.updated != null) {
            this.updated = new java.util.Date(rhs.updated.getTime());
        }
    }

    public Audit(com.stratadata.model3.audit.Audit rhs) {
        if (rhs == null) {
            return;
        }
        this.creator = rhs.getCreatorID();
        if (rhs.getCreated() != null) {
            this.created = DateUtils.asDate((LocalDate)rhs.getCreated());
        }
        this.modifier = rhs.getModifierID();
        if (rhs.getModified() != null) {
            this.modified = DateUtils.asDate((LocalDate)rhs.getModified());
        }
        this.updater = rhs.getUpdaterID();
        if (rhs.getUpdated() != null) {
            this.updated = java.util.Date.from(rhs.getUpdated());
        }
    }

    public Audit(int creator, java.util.Date created, int modifier, java.util.Date modified) {
        this.creator = creator;
        this.created = created;
        this.modifier = modifier;
        this.modified = modified;
    }

    public Audit() {
    }

    public static String sqlFieldString() {
        return "creator,created,modifier,modified,updater,updated";
    }

    public static String sqlFieldString(String alias) {
        return alias + ".creator AS " + alias + "creator," + alias + ".created AS " + alias + "created," + alias + ".modifier AS " + alias + "modifier," + alias + ".modified AS " + alias + "modified," + alias + ".updater AS " + alias + "updater," + alias + ".updated AS " + alias + UPDATED;
    }

    public static String sqlFieldStringNoAlias(String tableAlias) {
        return tableAlias + ".creator," + tableAlias + ".created," + tableAlias + ".modifier," + tableAlias + ".modified," + tableAlias + ".updater," + tableAlias + ".updated";
    }

    public Audit(SBdb db, SBdb ws, Audit rhs) throws SQLException, SBException {
        if (rhs.creator > 0) {
            this.creator = Audit.getDBUserID(db, ws, rhs.creator);
        }
        this.created = rhs.created;
        if (rhs.modifier > 0) {
            this.modifier = Audit.getDBUserID(db, ws, rhs.modifier);
        }
        this.modified = rhs.modified;
    }

    static AuditImpl createDbAuditImpl(SBdb db, SBdb ws, com.stratadata.model3.audit.Audit source) {
        AuditImpl auditImpl = new AuditImpl();
        try {
            auditImpl.setCreated(source.getCreated());
            if (source.getCreatorID() > 0) {
                auditImpl.setCreatorID(Audit.getDBUserID(db, ws, source.getCreatorID()));
            }
            auditImpl.setModified(source.getModified());
            if (source.getModifierID() > 0) {
                auditImpl.setModifierID(Audit.getDBUserID(db, ws, source.getModifierID()));
            }
            return auditImpl;
        }
        catch (SQLException | SBException e) {
            throw new RuntimeException("Error copying audit", e);
        }
    }

    static int getDBUserID(SBdb db, SBdb ws, int wsID) throws SBException, SQLException {
        int userID = 0;
        Userdef user = ws.getUser(wsID);
        if (user == null) {
            throw new SBException("No user found in workspace for user ID : " + wsID);
        }
        if (user.getLink() == null) {
            if ((user = db.getUser(user.getAbr())) != null) {
                userID = user.getUsrID();
            }
        } else {
            userID = user.getLink().getUsrID();
        }
        return userID;
    }

    public static void setServerDate(SBdb db, Statement stmt) throws SQLException {
        serverDate = stmt != null ? Audit.getDatabaseServerDate(db, stmt) : null;
    }

    public String sqlInsert(SBdb db, Statement stmt) throws SQLException {
        if (this.creator == 0) {
            this.creator = db.getUserID();
        }
        if (this.created == null) {
            this.created = new java.util.Date();
        }
        if (this.modifier == 0) {
            this.modifier = db.getUserID();
        }
        if (this.modified == null) {
            this.modified = new java.util.Date();
        }
        this.updater = db.getUserID();
        this.updated = serverDate == null ? Audit.getDatabaseServerDate(db, stmt) : serverDate;
        return this.creator + ",'" + SB.DBdf.format(this.created) + "'," + this.modifier + ",'" + SB.DBdf.format(this.modified) + "'," + this.updater + ",'" + SB.DBdtf.format(this.updated) + "'";
    }

    public static String sqlInsert(com.stratadata.model3.audit.Audit audit) {
        return audit.getCreatorID() + ",'" + DateTimeFormatter.ofPattern(DBdf_PATTERN).format(audit.getCreated()) + "'," + audit.getModifierID() + ",'" + DateTimeFormatter.ofPattern(DBdf_PATTERN).format(audit.getModified()) + "'," + audit.getUpdaterID() + ",'" + DateTimeFormatter.ofPattern(DBdtf_PATTERN).withZone(ZoneId.systemDefault()).format(audit.getUpdated()) + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.util.Date getDatabaseServerDate(SBdb db, Statement stmt) throws SQLException {
        if (db.getDBType() == DBType.SQLITE) {
            return new java.util.Date();
        }
        Object sql = "SELECT ";
        sql = db.getDBType() == DBType.ORACLE ? (String)sql + "SYSDATE AS DT FROM DUAL" : (db.getDBType() == DBType.MSSQLSERVER ? (String)sql + "getdate() as DT" : (String)sql + "now() AS DT");
        boolean createStatement = false;
        if (stmt == null) {
            stmt = db.getDatabase().createStatement();
            createStatement = true;
        }
        try {
            ResultSet rs = stmt.executeQuery(db.modQuery((String)sql));
            java.util.Date date = new java.util.Date();
            if (rs.next()) {
                date = rs.getTimestamp("dt");
            }
            java.util.Date date2 = date;
            return date2;
        }
        finally {
            if (createStatement) {
                stmt.close();
            }
        }
    }

    public String sqlUpdate(SBdb db, Statement stmt, boolean preserveModification) throws SQLException {
        if (this.modifier == 0 || !preserveModification) {
            preserveModification = false;
            this.modifier = db.getUserID();
        }
        if (this.modified == null || !preserveModification) {
            preserveModification = false;
            this.modified = new java.util.Date();
        }
        this.updater = db.getUserID();
        this.updated = Audit.getDatabaseServerDate(db, stmt);
        Object sql = preserveModification ? "" : "modifier=" + this.modifier + ",modified='" + SB.DBdf.format(this.modified) + "',";
        sql = (String)sql + "updater=" + db.getUserID() + ",updated='" + SB.DBdtf.format(this.updated) + "'";
        return sql;
    }

    public static String sqlUpdate(com.stratadata.model3.audit.Audit audit) {
        return "modifier=" + audit.getModifierID() + ",modified='" + audit.getModified().format(DateTimeFormatter.ofPattern(DBdf_PATTERN)) + "',updater=" + audit.getUpdaterID() + ",updated='" + DateTimeFormatter.ofPattern(DBdtf_PATTERN).withZone(ZoneId.systemDefault()).format(audit.getUpdated()) + "'";
    }

    public static String sqlPreparedUpdateString() {
        return "modifier=?,modified=?,updater=?,updated=?";
    }

    public void sqlPreparedUpdate(SBdb db, PreparedStatement pStmt, int indexOfFirstParam, boolean preserveModification) throws SQLException {
        if (this.modifier == 0 || !preserveModification) {
            this.modifier = db.getUserID();
        }
        if (this.modified == null || !preserveModification) {
            this.modified = new java.util.Date();
        }
        this.updater = db.getUserID();
        this.updated = Audit.getDatabaseServerDate(db, null);
        int index = indexOfFirstParam;
        pStmt.setInt(index++, this.modifier);
        pStmt.setDate(index++, new Date(this.modified.getTime()));
        pStmt.setInt(index++, this.updater);
        pStmt.setTimestamp(index++, new Timestamp(this.updated.getTime()));
    }

    public AuditUpdate createUpdate(SBdb db, Statement stmt, boolean preserveModification) throws SQLException {
        return new AuditUpdate(this, db, stmt, preserveModification);
    }

    public LinkedList<Integer> writeXML(BufferedWriter out, int indent) throws IOException {
        return this.writeXML(out, indent, 0);
    }

    public LinkedList<Integer> writeXML(BufferedWriter out, int indent, int singleUserID) throws IOException {
        LinkedList<Integer> userIDList = new LinkedList<Integer>();
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<Audit>");
        if (this.created == null && this.creator == 0 && this.modifier == 0 && this.modified == null) {
            out.write("</Audit>\n");
            return userIDList;
        }
        out.write("\n");
        String ind2 = SB.getXMLIndent((int)(indent + 3));
        if (this.created != null) {
            out.write(ind2 + "<Created>" + SB.DBdf.format(this.created) + "</Created>\n");
        }
        if (this.creator > 0) {
            out.write(ind2 + "<Creator>" + (singleUserID > 0 ? singleUserID : this.creator) + "</Creator>\n");
            userIDList.add(this.creator);
        }
        if (this.modified != null) {
            out.write(ind2 + "<Modified>" + SB.DBdf.format(this.modified) + "</Modified>\n");
        }
        if (this.modifier > 0) {
            out.write(ind2 + "<Modifier>" + (singleUserID > 0 ? singleUserID : this.modifier) + "</Modifier>\n");
            userIDList.add(this.modifier);
        }
        out.write(ind1 + "</Audit>\n");
        return userIDList;
    }

    public Audit(SBdb db, Element xml) throws ParseException, SQLException, SBException {
        String strg = xml.getChildTextNormalize("Created");
        if (strg != null) {
            this.created = SB.DBdf.parse(strg);
        }
        if ((strg = xml.getChildTextNormalize("Creator")) != null) {
            this.creator = Integer.parseInt(strg);
            if (db.getUser(this.creator) == null) {
                System.out.println("Warning: user not found for userID: " + this.creator + " in Audit 'creator' entry");
            }
        }
        if ((strg = xml.getChildTextNormalize("Modified")) != null) {
            this.modified = SB.DBdf.parse(strg);
        }
        if ((strg = xml.getChildTextNormalize("Modifier")) != null) {
            this.modifier = Integer.parseInt(strg);
            if (db.getUser(this.modifier) == null) {
                System.out.println("Warning: user not found for userID: " + this.modifier + " in Audit 'modifier' entry");
            }
        }
    }

    public void fillWorkspace(SBdb db, SBdb ws) throws SQLException, SBException {
        assert (db.isConnected() && !ws.isConnected());
        if (this.creator > 0) {
            ws.fillUser(db, this.creator);
        }
        if (this.modifier > 0) {
            ws.fillUser(db, this.modifier);
        }
    }

    public static void fillWorkspace(com.stratadata.model3.audit.Audit audit, SBdb db, SBdb ws) throws SQLException, SBException {
        assert (db.isConnected() && !ws.isConnected());
        if (audit.getCreatorID() > 0) {
            ws.fillUser(db, audit.getCreatorID());
        }
        if (audit.getModifierID() > 0) {
            ws.fillUser(db, audit.getModifierID());
        }
    }

    void setAnalyst(int analyst) {
        this.creator = analyst;
        this.modifier = analyst;
        this.updater = analyst;
    }

    public String toString(SBdb sbdb, boolean includeCreated) {
        Object label = "";
        if (includeCreated && this.created != null) {
            label = (String)label + "Created " + SB.df.format(this.created);
            if (this.creator > 0) {
                try {
                    label = (String)label + " by " + sbdb.getUser(this.creator).getAbr();
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
        }
        if (!(this.modified == null || this.created != null && this.modified.equals(this.created))) {
            if (!((String)label).isEmpty()) {
                label = (String)label + "; ";
            }
            label = (String)label + "Modified " + SB.df.format(this.modified);
            if (this.modifier > 0) {
                try {
                    label = (String)label + " by " + sbdb.getUser(this.modifier).getAbr();
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
        }
        return label;
    }

    public java.util.Date getCreated() {
        if (this.created != null) {
            return new java.util.Date(this.created.getTime());
        }
        return null;
    }

    public int getCreator() {
        return this.creator;
    }

    public java.util.Date getModified() {
        if (this.modified != null) {
            return new java.util.Date(this.modified.getTime());
        }
        return null;
    }

    public java.util.Date getUpdated() {
        if (this.updated != null) {
            return new java.util.Date(this.updated.getTime());
        }
        return null;
    }

    public int getUpdater() {
        return this.updater;
    }

    public int getModifier() {
        return this.modifier;
    }

    @Override
    public int compareTo(Audit comp) {
        if (comp.updated == null && this.updated == null) {
            return 0;
        }
        if (comp.updated == null) {
            return 1;
        }
        if (this.updated == null) {
            return -1;
        }
        return comp.updated.compareTo(this.updated);
    }

    public class AuditUpdate {
        private final int uModifier;
        private final int uUpdater;
        private final java.util.Date uModified;
        private final java.util.Date uUpdated;
        final /* synthetic */ Audit this$0;

        private AuditUpdate(Audit this$0, SBdb db, Statement stmt, boolean preserveModification) throws SQLException {
            Audit audit = this$0;
            Objects.requireNonNull(audit);
            this.this$0 = audit;
            this.uModifier = this$0.modifier == 0 || !preserveModification ? db.getUserID() : this$0.modifier;
            this.uModified = this$0.modified == null || !preserveModification ? new java.util.Date() : this$0.modified;
            this.uUpdater = db.getUserID();
            this.uUpdated = Audit.getDatabaseServerDate(db, stmt);
        }

        public String getSql() {
            return "modifier=" + this.uModifier + ",modified='" + SB.DBdf.format(this.uModified) + "',updater=" + this.uUpdater + ",updated='" + SB.DBdtf.format(this.uUpdated) + "'";
        }

        public void doUpdate() {
            this.this$0.modified = this.uModified;
            this.this$0.modifier = this.uModifier;
            this.this$0.updated = this.uUpdated;
            this.this$0.updater = this.uUpdater;
        }
    }
}

