/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import java.awt.Color;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import model3.SBdb;
import model3.Taxon;
import util.ColourUtils;
import util.SB;
import util.listener.WeakListenerList;

public class Category
implements Comparable<Category> {
    private com.stratadata.model3.taxon.Category category;
    private int nGenera;
    private final WeakListenerList<CategoryListener> listeners = new WeakListenerList();

    public Discipline getDisc() {
        return this.category.getDiscipline();
    }

    public String getMnem() {
        return this.category.getMnemonic();
    }

    public String getName() {
        return this.category.getName();
    }

    public Category(Discipline discID, String mnemonic, String name, Color colour) {
        this.category = new com.stratadata.model3.taxon.Category(mnemonic);
        this.category.setName(name);
        this.category.setColour(colour);
        this.category.setDiscipline(discID);
    }

    public Category(com.stratadata.model3.taxon.Category category) {
        this.category = category;
    }

    public void registerListener(CategoryListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void deleteListener(CategoryListener listener) {
        this.listeners.deleteListener((Object)listener);
    }

    public String toString() {
        return this.category.getMnemonic();
    }

    public Color getColour() {
        return this.category.getColour();
    }

    public void update(SBdb sbdb, String mnem, Discipline discID, String name, Color colour) throws SQLException {
        String originalMnemonic = this.getMnem();
        if (sbdb.isConnected()) {
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                if (!mnem.equals(this.getMnem())) {
                    String sql = "INSERT INTO " + sbdb.DBTableName("category") + " (disc_id, cat_mnem, cat_name, colour) VALUES (";
                    sql = sql + SB.DBChar((char)Discipline.getChar((Discipline)discID)) + "," + SB.DBString((String)mnem) + "," + SB.DBString((String)name) + "," + ColourUtils.DBColourString((Color)colour, (boolean)false, (boolean)true) + ")";
                    stmt.executeUpdate(sbdb.modQuery(sql));
                    sql = "UPDATE " + sbdb.DBTableName("genus") + " SET cat_mnem=" + SB.DBString((String)mnem) + " WHERE cat_mnem=" + SB.DBString((String)this.category.getMnemonic());
                    stmt.executeUpdate(sbdb.modQuery(sql));
                    sql = "DELETE FROM " + sbdb.DBTableName("category") + " WHERE cat_mnem=" + SB.DBString((String)this.category.getMnemonic());
                    stmt.executeUpdate(sbdb.modQuery(sql));
                    this.category = new com.stratadata.model3.taxon.Category(mnem);
                }
                String sql = "UPDATE " + sbdb.DBTableName("category") + " SET disc_id=" + SB.DBChar((char)Discipline.getChar((Discipline)discID)) + ", cat_name=" + SB.DBString((String)name) + ", colour=" + ColourUtils.DBColourString((Color)colour, (boolean)false, (boolean)true) + " WHERE cat_mnem=" + SB.DBString((String)mnem);
                stmt.executeUpdate(sbdb.modQuery(sql));
            }
        } else if (!mnem.equals(originalMnemonic)) {
            this.category = new com.stratadata.model3.taxon.Category(mnem);
        }
        this.category.setDiscipline(discID);
        this.category.setName(name);
        this.category.setColour(colour);
        this.listeners.notify(listener -> listener.onCategoryDetailsUpdated(originalMnemonic, this.category));
    }

    public void delete(SBdb sbdb) throws SQLException {
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "SELECT spec_id FROM " + sbdb.DBTableName("genus") + " g, " + sbdb.DBTableName("species") + " s WHERE g.cat_mnem=" + SB.DBString((String)this.getMnem()) + " AND g.gen_id=s.gen_id";
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            LinkedList<Integer> specIDs = new LinkedList<Integer>();
            while (rs.next()) {
                int specID = rs.getInt("spec_id");
                specIDs.add(specID);
            }
            if (specIDs.size() > 0) {
                Taxon.deleteSpecies(sbdb, specIDs, true, null);
                Iterator it = specIDs.iterator();
                sql = "DELETE FROM " + sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=?";
                try (PreparedStatement pStmt = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));){
                    while (it.hasNext()) {
                        pStmt.setInt(1, (Integer)it.next());
                        pStmt.executeUpdate();
                    }
                }
                it = specIDs.iterator();
                sql = "UPDATE " + sbdb.DBTableName("EVENTDIC") + " SET spec_id=0, generate='N' WHERE spec_id=?";
                pStmt = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
                try {
                    while (it.hasNext()) {
                        pStmt.setInt(1, (Integer)it.next());
                        pStmt.executeUpdate();
                    }
                }
                finally {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
            }
            sql = "DELETE FROM " + sbdb.DBTableName("genus") + " WHERE cat_mnem=" + SB.DBString((String)this.getMnem());
            stmt.executeUpdate(sbdb.modQuery(sql));
            sql = "DELETE FROM " + sbdb.DBTableName("category") + " WHERE cat_mnem=" + SB.DBString((String)this.getMnem());
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
    }

    public int getNGenera() {
        return this.nGenera;
    }

    public void setNGenera(int nGenera) {
        this.nGenera = nGenera;
    }

    @Override
    public int compareTo(Category c) {
        return this.category.compareTo(c.category);
    }

    public com.stratadata.model3.taxon.Category getCategoryCopy() {
        return com.stratadata.model3.taxon.Category.copy((com.stratadata.model3.taxon.Category)this.category);
    }

    static interface CategoryListener {
        public void onCategoryDetailsUpdated(String var1, com.stratadata.model3.taxon.Category var2);
    }
}

