/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.db.DBType;
import com.stratadata.model3.user.Userdef;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import model3.Audit;
import model3.DEXFile;
import model3.IGDIntervalEnv;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;
import util.ColourUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsLink;
import util.status.SbugsStatus;

public class EnvScheme
extends SBRestrictable
implements SbugsStatus,
Comparable,
SbugsLink {
    private static final String NOTERMTEXT = "<no term>";
    private static final String[] intervalFields = new String[]{"up", "ud", "lp", "ld", "qual"};
    private static final String[] analysisFields = new String[]{"proximal", "distal"};
    private static final int MAXCLASSES = 30;
    private final SBdb sbdb;
    private int ID;
    private String name;
    EnvScheme link = null;
    private final LinkedList<EnvTerm> classes = new LinkedList();
    private Audit audit = new Audit();
    Color status = UNKNOWN;

    public EnvScheme(SBdb sbdb, int ID, String name) {
        super("ENV_SCH", "ENVSCH_ID", false);
        this.sbdb = sbdb;
        this.ID = ID;
        this.name = name;
        this.setAcm(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EnvScheme createCopy(EnvScheme rhs, SBdb sbdb) throws SQLException, SBException {
        EnvScheme scheme = new EnvScheme(sbdb, 0, rhs.name);
        for (EnvTerm t : rhs.classes) {
            EnvTerm et = new EnvTerm(t.name);
            et.colour = t.colour;
            et.comment = t.comment;
            scheme.classes.add(et);
        }
        scheme.setAcm(rhs.getAcm());
        if (sbdb != rhs.sbdb) {
            if (sbdb.isConnected() && !rhs.sbdb.isConnected()) {
                scheme.audit = new Audit(sbdb, rhs.sbdb, rhs.audit);
                return scheme;
            } else {
                if (sbdb.isConnected() || !rhs.sbdb.isConnected()) throw new IllegalStateException("Illegal Env Scheme copy");
                scheme.audit = new Audit(rhs.audit);
                scheme.audit.fillWorkspace(rhs.sbdb, sbdb);
                scheme.link = rhs;
                scheme.ID = rhs.ID;
            }
            return scheme;
        } else {
            scheme.audit = new Audit(rhs.audit);
        }
        return scheme;
    }

    EnvScheme(SBdb ws, Element xml) throws ParseException, SQLException, SBException {
        super("ENV_SCH", "ENVSCH_ID", false);
        Element el;
        this.sbdb = ws;
        String strg = xml.getChildText("SchemeName");
        if (strg != null) {
            this.name = strg;
        }
        if ((strg = xml.getChildTextNormalize("SchemeID")) != null) {
            this.ID = Integer.parseInt(strg);
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.audit = new Audit(ws, el);
        } else {
            System.out.println("Warning: no audit info for Scheme: " + String.valueOf(this));
        }
        IteratorIterable it = xml.getDescendants((Filter)new ElementFilter("Member"));
        while (it.hasNext()) {
            Element termEl = (Element)it.next();
            EnvTerm term = null;
            strg = termEl.getChildTextNormalize("Term");
            if (strg != null) {
                term = new EnvTerm(strg);
            }
            if (term == null) continue;
            Element cEl = termEl.getChild("Colour");
            if (cEl != null) {
                term.colour = SB.parseColour((Element)cEl);
            }
            this.classes.add(term);
        }
        this.setAcm(0);
    }

    public Color getColour(int indexNumber) {
        return this.classes.get((int)(indexNumber - 1)).colour;
    }

    public String getComment(int indexNumber) {
        return this.classes.get((int)(indexNumber - 1)).comment;
    }

    public int getNoccs(int indexNumber) {
        return this.classes.get((int)(indexNumber - 1)).nOccs;
    }

    public void setNoccs(int indexNumber, int n) {
        this.classes.get((int)(indexNumber - 1)).nOccs = n;
    }

    EnvScheme(DEXFile.DEXsection section, SBdb db) throws SBException, SQLException {
        super("ENV_SCH", "ENVSCH_ID", false);
        this.sbdb = db;
        this.name = "Dex scheme";
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = ((String)section.value.get(i)).trim();
            if (label.equalsIgnoreCase("Scheme ID")) {
                this.ID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Scheme name")) {
                this.name = value;
                continue;
            }
            if (label.equalsIgnoreCase("Number of columns")) continue;
            if (label.equalsIgnoreCase("Column Name")) {
                this.classes.add(new EnvTerm(value));
                continue;
            }
            if (!label.equalsIgnoreCase("Colour") || this.classes.isEmpty()) continue;
            this.classes.getLast().colour = ColourUtils.getColour((String)value);
        }
        this.setAcm(0);
    }

    public int compareTo(Object rhs) {
        return this.name.compareTo(rhs.toString());
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public Date getModified() {
        return this.audit.modified;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public boolean match(EnvScheme rhs) {
        if (this.classes.size() != rhs.classes.size()) {
            return false;
        }
        for (int i = 0; i < this.classes.size(); ++i) {
            if (this.classes.get((int)i).name.equals(rhs.classes.get((int)i).name)) continue;
            return false;
        }
        return true;
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.name;
    }

    public EnvScheme getLink() {
        return this.link;
    }

    public String getLinkTerm(int termIndex) {
        if (this.link == null) {
            return null;
        }
        if (this.classes.get((int)(termIndex - 1)).linkTerm > 0) {
            return this.link.getTerm(this.classes.get((int)(termIndex - 1)).linkTerm);
        }
        return null;
    }

    public String getLinkComment(int termIndex) {
        if (this.link == null) {
            return null;
        }
        if (this.classes.get((int)(termIndex - 1)).linkTerm > 0) {
            return this.link.getComment(this.classes.get((int)(termIndex - 1)).linkTerm);
        }
        return null;
    }

    public Integer getLinkTermIndex(int termIndex) {
        if (this.link == null) {
            return null;
        }
        if (this.classes.get((int)(termIndex - 1)).linkTerm > 0) {
            return this.classes.get((int)(termIndex - 1)).linkTerm;
        }
        return null;
    }

    public Color getLinkColour(int termIndex) {
        if (this.link == null) {
            return Color.WHITE;
        }
        if (this.classes.get((int)(termIndex - 1)).linkTerm > 0) {
            return this.link.getColour(this.classes.get((int)(termIndex - 1)).linkTerm);
        }
        return Color.WHITE;
    }

    public void setLinkTerm(int termIndex, String className) throws SBException {
        if (this.link == null) {
            return;
        }
        this.classes.get((int)(termIndex - 1)).linkTerm = this.link.getTermIndex(className);
    }

    public void setLink(EnvScheme scheme) {
        for (EnvTerm t : this.classes) {
            t.linkTerm = 0;
        }
        this.link = scheme;
        if (this.link != null) {
            boolean allMatched = true;
            for (EnvTerm t : this.classes) {
                try {
                    t.linkTerm = this.link.getTermIndex(t.name);
                }
                catch (Exception ex) {
                    allMatched = false;
                }
            }
            this.status = allMatched ? STORED : PARTSTORED;
        } else {
            this.status = NOTSTORED;
        }
    }

    public String toString() {
        if (this.name.length() == 0 && this.ID != 0) {
            return "Scheme ID no. " + this.ID;
        }
        return this.name;
    }

    EnvScheme(SBdb sbdb, int iID) throws SQLException {
        super("ENV_SCH", "ENVSCH_ID", false);
        this.sbdb = sbdb;
        String sql = "SELECT name,acm," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("ENV_SCH") + " WHERE envsch_id=" + iID;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                this.ID = iID;
                this.name = SB.getDBString((ResultSet)rs, (String)"name");
                this.setAcm(rs.getInt("acm"));
                this.audit = new Audit(rs);
                rs.close();
                sql = "SELECT term_no, term, colour, comments FROM " + sbdb.DBTableName("ENVSCHMBR") + " WHERE envsch_id=" + iID + " ORDER BY term_no";
                rs = stmt.executeQuery(sbdb.modQuery(sql));
                while (rs.next()) {
                    int i = rs.getInt("term_no") - 1;
                    if (i >= 30 || i < 0) {
                        throw new IllegalStateException("Incorrect term_no " + i + " found in ENVSCHMBR for scheme ID: " + iID + "\nMax no. allowable classes=30");
                    }
                    EnvTerm t = new EnvTerm(SB.getDBString((ResultSet)rs, (String)"term"));
                    t.colour = ColourUtils.getDBColour((String)rs.getString("colour"));
                    t.comment = rs.getString("comments");
                    this.classes.add(t);
                }
            }
        }
    }

    static EnvScheme load(SBdb sbdb, int schID, EnvScheme scheme) throws SQLException, SBException {
        if (scheme != null && scheme.getID() != schID) {
            throw new IllegalArgumentException("Attempt to refresh env scheme using different ID");
        }
        EnvScheme temp = new EnvScheme(sbdb, schID);
        if (scheme != null) {
            scheme.name = temp.name;
            scheme.audit = new Audit(temp.audit);
            scheme.classes.clear();
            scheme.classes.addAll(temp.classes);
        } else {
            scheme = temp;
        }
        return scheme;
    }

    public void insertRow(int insertPoint) throws SBException {
        if (this.ID > 0 && this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to update env scheme");
        }
        if (this.classes.size() + 1 >= 30) {
            throw new SBException("Maxiumum number of classes (30) reached");
        }
        this.classes.add(insertPoint, new EnvTerm(""));
    }

    public void addRow() throws SBException {
        this.insertRow(this.classes.size());
    }

    public void setTerm(int row, String term) throws SBException {
        if (this.ID > 0 && this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to update env scheme");
        }
        if (row >= this.classes.size()) {
            throw new SBException("Attempt to update env scheme row: " + row + " outside range: " + this.classes.size());
        }
        if (term == null) {
            term = "";
        }
        this.classes.get((int)row).name = term;
    }

    public void setColour(int row, Color colour) throws SBException, SQLException {
        if (this.ID > 0 && this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to update env scheme");
        }
        if (row >= this.classes.size()) {
            throw new SBException("Attempt to update env scheme row: " + row + " outside range: " + this.classes.size());
        }
        if (colour == null) {
            colour = Color.CYAN;
        }
        this.classes.get((int)row).colour = colour;
    }

    public void setComment(int row, String comment) throws SBException, SQLException {
        if (this.ID > 0 && this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to update env scheme");
        }
        if (row >= this.classes.size()) {
            throw new SBException("Attempt to update env scheme row: " + row + " outside range: " + this.classes.size());
        }
        if ((comment = comment.trim()).isEmpty()) {
            comment = null;
        }
        this.classes.get((int)row).comment = comment;
    }

    public void deleteRow(int deletePoint) {
        if (this.ID > 0 && this.sbdb != null && this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to update env scheme");
        }
        this.classes.remove(deletePoint);
    }

    public boolean checkNameUnique() throws SQLException {
        String sql = "SELECT envsch_id FROM " + this.sbdb.DBTableName("ENV_SCH") + " WHERE ucase(name)='" + this.name.toUpperCase() + "'";
        if (this.ID != 0) {
            sql = sql + " AND envsch_id <> " + this.ID;
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            boolean unique = true;
            if (rs.next()) {
                unique = false;
            }
            boolean bl = unique;
            return bl;
        }
    }

    public int getNoccs() throws SQLException {
        String sql = "SELECT count(envsch_id) as nOcc FROM " + this.sbdb.DBTableName("IGD_ENV") + " WHERE envsch_id=" + this.ID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            int nDbOccs = 0;
            if (rs.next()) {
                nDbOccs = rs.getInt("nOcc");
            }
            int n = nDbOccs;
            return n;
        }
    }

    public int getNAnalyHdrOccs() throws SQLException {
        String sql = "SELECT count(envsch_id) as nOcc FROM " + this.sbdb.DBTableName("ANALY_HDR") + " WHERE envsch_id=" + this.ID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            int nDbOccs = 0;
            if (rs.next()) {
                nDbOccs = rs.getInt("nOcc");
            }
            int n = nDbOccs;
            return n;
        }
    }

    public List getOccs(int entryNo) throws SQLException {
        String sql = "SELECT DISTINCT w.well_name,w.well_code FROM " + this.sbdb.DBTableName("IGD_ENV") + " i," + this.sbdb.DBTableName("WELLS") + " w WHERE i.envsch_id=" + this.ID + " AND i.well_id=w.well_id";
        if (entryNo > 0) {
            sql = sql + " AND (i.up=" + entryNo + " OR i.ud=" + entryNo + " OR i.lp=" + entryNo + " OR i.ld=" + entryNo + " OR i.qual=" + entryNo + ")";
        }
        sql = sql + " ORDER BY well_name";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            ArrayList<CallSite> occs = new ArrayList<CallSite>();
            while (rs.next()) {
                occs.add((CallSite)((Object)(rs.getString("well_name") + " (" + rs.getString("well_code") + ") ")));
            }
            sql = "SELECT DISTINCT w.well_name,w.well_code FROM " + this.sbdb.DBTableName("SMPDTL") + " s," + this.sbdb.DBTableName("WELLS") + " w," + this.sbdb.DBTableName("ANALY_HDR") + " h WHERE h.envsch_id=" + this.ID + " AND h.well_id=s.well_id AND h.analy_id=s.analy_id AND h.well_id=w.well_id";
            if (entryNo > 0) {
                sql = sql + " AND (s.proximal=" + entryNo + " OR s.distal=" + entryNo + ")";
            }
            sql = sql + " ORDER BY well_name";
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                occs.add((CallSite)((Object)(rs.getString("well_name") + " (" + rs.getString("well_code") + ") - Sample analyses")));
            }
            ArrayList<CallSite> arrayList = occs;
            return arrayList;
        }
    }

    public void setDBOccs() throws SQLException {
        for (int entry = 1; entry <= this.classes.size(); ++entry) {
            this.setNoccs(entry, this.getNdbOccs(entry) + this.getNdbAnalyOccs(entry));
        }
    }

    public int getNdbOccs(int entry) throws SQLException {
        int occs = 0;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            Object sql = "SELECT count(well_id) as total FROM " + this.sbdb.DBTableName("IGD_ENV") + " WHERE envsch_id=" + this.ID + " AND (";
            for (String field : intervalFields) {
                sql = (String)sql + field + "=" + entry + " OR ";
            }
            sql = ((String)sql).substring(0, ((String)sql).length() - 3);
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)(sql = (String)sql + ")")));
            if (rs.next()) {
                occs = rs.getInt("total");
            }
        }
        return occs;
    }

    private int getNdbAnalyOccs(int entry) throws SQLException {
        int occs = 0;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            Object sql = "SELECT count(*) as total FROM " + this.sbdb.DBTableName("SMPDTL") + " s  INNER JOIN " + this.sbdb.DBTableName("ANALY_HDR") + " h  ON (s.WELL_ID=h.WELL_ID AND s.ANALY_ID=h.ANALY_ID AND h.ENVSCH_ID=" + this.ID + " AND (";
            for (String field : analysisFields) {
                sql = (String)sql + "s." + field + "=" + entry + " OR ";
            }
            sql = ((String)sql).substring(0, ((String)sql).length() - 3);
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)(sql = (String)sql + "))")));
            if (rs.next()) {
                occs = rs.getInt("total");
            }
        }
        return occs;
    }

    void deleteEntries() throws SQLException {
        if (this.ID != 0) {
            String sql = "DELETE FROM " + this.sbdb.DBTableName("IGD_ENV") + " WHERE envsch_id=" + this.ID;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
    }

    void delete() throws SQLException, SBPermissionException {
        if (this.ID != 0) {
            if (!EnvScheme.canWrite(this.sbdb)) {
                throw new SBPermissionException(this.getDeniedReason(this.sbdb, "scheme", true));
            }
            String[] sql = new String[]{"DELETE FROM " + this.sbdb.DBTableName("ENVSCHMBR") + " WHERE envsch_id=" + this.ID, "DELETE FROM " + this.sbdb.DBTableName("ENV_SCH_ACL") + " WHERE envsch_id=" + this.ID, "DELETE FROM " + this.sbdb.DBTableName("ENV_SCH") + " WHERE envsch_id=" + this.ID};
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                for (String sqlq : sql) {
                    stmt.executeUpdate(this.sbdb.modQuery(sqlq));
                }
            }
        }
    }

    public void update(EnvScheme rhs) throws SQLException, SBPermissionException, SBException {
        if (this.ID == 0) {
            throw new IllegalArgumentException("Attempt to update unstored EnvScheme");
        }
        if (!EnvScheme.canWrite(this.sbdb)) {
            throw new SBPermissionException(this.getDeniedReason(this.sbdb, "scheme", true));
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            Audit intervalAudit = new Audit();
            if (rhs.getNClasses() != this.getNClasses()) {
                int[] occs = new int[this.classes.size()];
                int termIndex = 1;
                for (EnvTerm t : this.classes) {
                    int nOccs = this.getNdbOccs(termIndex) + this.getNdbAnalyOccs(termIndex);
                    if (nOccs > 0 && !rhs.hasTerm(t.name)) {
                        throw new SBException("Can't delete a term which is used in intervals or analyses");
                    }
                    occs[termIndex - 1] = nOccs;
                    ++termIndex;
                }
                if (rhs.getNClasses() < this.getNClasses()) {
                    termIndex = 1;
                    for (EnvTerm t : this.classes) {
                        if (occs[termIndex - 1] > 0 && rhs.getTermIndex(t.name) != termIndex) {
                            int newTermIndex = rhs.getTermIndex(t.name);
                            this.updateTermRecords(stmt, intervalAudit, termIndex, newTermIndex);
                        }
                        ++termIndex;
                    }
                } else {
                    for (termIndex = this.getNClasses(); termIndex > 0; --termIndex) {
                        EnvTerm t = this.classes.get(termIndex - 1);
                        if (rhs.getTermIndex(t.name) == termIndex || occs[termIndex - 1] <= 0) continue;
                        int newTermIndex = rhs.getTermIndex(t.name);
                        this.updateTermRecords(stmt, intervalAudit, termIndex, newTermIndex);
                    }
                }
            }
            String sql = "DELETE FROM " + this.sbdb.DBTableName("ENVSCHMBR") + " WHERE envsch_id=" + this.ID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            Audit temp = new Audit(this.audit);
            sql = "UPDATE " + this.sbdb.DBTableName("ENV_SCH") + " SET name=" + SB.DBString((String)this.name) + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE envsch_id=" + this.ID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            for (String s : rhs.getClassesSQLInsert(this.ID)) {
                stmt.executeUpdate(this.sbdb.modQuery(s));
            }
            this.audit = temp;
        }
        this.sbdb.commit();
        this.name = rhs.name.trim();
        this.classes.clear();
        for (EnvTerm t : rhs.classes) {
            EnvTerm n = new EnvTerm(t.name);
            n.colour = t.colour;
            n.comment = t.comment;
            this.classes.add(n);
        }
        this.sbdb.refresh();
    }

    private void updateTermRecords(Statement stmt, Audit intervalAudit, int termIndex, int newTermIndex) throws SQLException {
        String sql;
        for (String field : intervalFields) {
            sql = "UPDATE " + this.sbdb.DBTableName("IGD_ENV") + " SET " + field + "=" + newTermIndex + "," + intervalAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE " + field + "=" + termIndex + " AND envsch_id=" + this.ID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        for (String field : analysisFields) {
            sql = this.sbdb.getDBType() == DBType.MSSQLSERVER ? "UPDATE  s SET " + field + "=" + newTermIndex + "," + intervalAudit.sqlUpdate(this.sbdb, stmt, false) + " FROM " + this.sbdb.DBTableName("SMPDTL") + " AS s  WHERE EXISTS (SELECT * FROM " + this.sbdb.DBTableName("ANALY_HDR") + " WHERE well_id=s.well_id AND analy_id=s.analy_id AND envsch_id=" + this.ID + " AND s." + field + "=" + termIndex + ")" : "UPDATE " + this.sbdb.DBTableName("SMPDTL") + " s SET " + field + "=" + newTermIndex + "," + intervalAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE EXISTS (SELECT * FROM " + this.sbdb.DBTableName("ANALY_HDR") + " WHERE well_id=s.well_id AND analy_id=s.analy_id AND envsch_id=" + this.ID + " AND s." + field + "=" + termIndex + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    void store() throws SQLException, SBException, SBPermissionException {
        if (this.ID > 0 || !this.sbdb.isConnected()) {
            throw new IllegalStateException("Illegal attempt to store EnvScheme");
        }
        if (!EnvScheme.canWrite(this.sbdb)) {
            throw new SBPermissionException(this.getDeniedReason(this.sbdb, "scheme", true));
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            int tempID = this.sbdb.nextControl("ENV_SCH", "ENVSCH_ID");
            String sql = "INSERT INTO " + this.sbdb.DBTableName("ENV_SCH") + " (envsch_id,name," + Audit.sqlFieldString() + " ) VALUES (" + tempID + "," + SB.DBString((String)this.name) + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            for (String s : this.getClassesSQLInsert(tempID)) {
                stmt.executeUpdate(this.sbdb.modQuery(s));
            }
            this.ID = tempID;
        }
    }

    private String[] getClassesSQLInsert(int tempID) {
        String[] sql = new String[this.classes.size()];
        for (int i = 0; i < this.classes.size(); ++i) {
            EnvTerm t = this.classes.get(i);
            sql[i] = "INSERT INTO " + this.sbdb.DBTableName("ENVSCHMBR") + " (envsch_id,term_no,term,colour,comments) VALUES (" + tempID + "," + (i + 1) + "," + SB.DBString((String)t.name) + "," + ColourUtils.DBColourString((Color)t.colour, (boolean)false, (boolean)true) + "," + SB.DBString((String)t.comment) + ")";
        }
        return sql;
    }

    public String getTerm(int classNumber, boolean includeComments) {
        if (classNumber > 0 && classNumber <= this.classes.size()) {
            EnvTerm envTerm = this.classes.get(classNumber - 1);
            Object term = envTerm.name;
            if (includeComments && !StringUtils.isBlank((CharSequence)envTerm.comment)) {
                term = (String)term + " (" + envTerm.comment.trim() + ")";
            }
            return term;
        }
        return NOTERMTEXT;
    }

    public String getTerm(int classNumber) {
        return this.getTerm(classNumber, false);
    }

    public int getTermIndex(String className) throws SBException {
        if (className.equals(NOTERMTEXT)) {
            return 0;
        }
        for (EnvTerm t : this.classes) {
            if (!className.equalsIgnoreCase(t.name)) continue;
            return this.classes.indexOf(t) + 1;
        }
        throw new SBException("Cannot find palaeoenvironment term '" + className + "' in scheme: " + this.name);
    }

    private boolean hasTerm(String className) throws SBException {
        for (EnvTerm t : this.classes) {
            if (!className.equalsIgnoreCase(t.name)) continue;
            return true;
        }
        return false;
    }

    static void loadAll(SBdb sbdb, HashMap<Integer, EnvScheme> envSchemes) throws SQLException {
        String sql = "SELECT envsch_id FROM " + sbdb.DBTableName("env_sch") + " ORDER BY envsch_id";
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int ID = rs.getInt("envsch_id");
                if (envSchemes.get(ID) != null) continue;
                envSchemes.put(ID, new EnvScheme(sbdb, ID));
            }
        }
    }

    public void fillCombo(JComboBox combo, int selectedIndex, boolean allowBlank) {
        combo.removeAllItems();
        if (allowBlank) {
            combo.addItem("");
        }
        for (EnvTerm t : this.classes) {
            combo.addItem(t.name);
        }
        if (selectedIndex > 0 && selectedIndex <= this.classes.size()) {
            combo.setSelectedIndex(selectedIndex - (allowBlank ? 0 : 1));
        }
    }

    void writeDEX(FileWriter out, String eol) throws IOException {
        out.write("[Palaeoenvironment Scheme]" + eol);
        out.write("Scheme name = " + this.name + eol);
        out.write("  Scheme ID : " + this.ID + eol);
        out.write("  Number of columns : ");
        out.write(this.classes.size() + eol);
        for (EnvTerm t : this.classes) {
            out.write("Column name = " + t.name + eol);
            out.write("  Colour : " + t.colour.getRed() + "," + t.colour.getGreen() + "," + t.colour.getBlue() + eol);
        }
        out.write(eol);
    }

    void writeXML(BufferedWriter out, int indent) throws IOException {
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        out.write("<EnvironmentScheme>\n");
        out.write((String)ind + "<SchemeName>" + this.name + "</SchemeName>\n");
        out.write((String)ind + "<SchemeID>" + this.ID + "</SchemeID>\n");
        for (EnvTerm t : this.classes) {
            out.write((String)ind + "<Member>\n");
            out.write((String)ind + (String)ind + "<Term>" + SB.getXMLstring((String)t.name) + "</Term>\n");
            SB.writeXMLColour((Color)t.colour, (BufferedWriter)out, (String)((String)ind + (String)ind));
            out.write((String)ind + "</Member>\n");
        }
        out.write("</EnvironmentScheme>\n");
    }

    @Override
    public int getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws SBException, SQLException {
        if (this.ID > 0 && this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to update env scheme");
        }
        this.name = name;
    }

    public int getNClasses() {
        return this.classes.size();
    }

    public void resetNoccs() {
        for (EnvTerm t : this.classes) {
            t.nOccs = 0;
        }
    }

    public void updateSchemeFromLink() throws SBException, SQLException {
        boolean updateZones = false;
        if (this.link == null) {
            throw new SBException("Link null in updateFromLink");
        }
        for (int i = 0; i < this.classes.size(); ++i) {
            if (this.classes.get((int)i).linkTerm == i + 1) continue;
            updateZones = true;
            break;
        }
        if (updateZones) {
            System.out.println("Updating zones from env scheme link...");
            int[] linkTerm = new int[this.classes.size()];
            for (int i = 0; i < linkTerm.length; ++i) {
                linkTerm[i] = this.classes.get((int)i).linkTerm;
            }
            Iterator<Well> it = this.sbdb.getWellIterator();
            while (it.hasNext()) {
                Well well = it.next();
                Iterator<WellInterp> iti = well.getInterpIterator();
                while (iti.hasNext()) {
                    WellInterp wellInterp = iti.next();
                    for (IGDIntervalEnv zone : wellInterp.getEnvs()) {
                        if (zone.getSchID() != this.getID()) continue;
                        zone.updateFromLink(zone.getUp() > 0 ? linkTerm[zone.getUp() - 1] : 0, zone.getUd() > 0 ? linkTerm[zone.getUd() - 1] : 0, zone.getLp() > 0 ? linkTerm[zone.getLp() - 1] : 0, zone.getLd() > 0 ? linkTerm[zone.getLd() - 1] : 0, zone.getQual() > 0 ? linkTerm[zone.getQual() - 1] : 0);
                    }
                }
            }
        }
        this.classes.clear();
        for (EnvTerm t : this.link.classes) {
            EnvTerm n = new EnvTerm(t.name);
            n.colour = t.colour;
            n.comment = t.comment;
            this.classes.add(n);
        }
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for env scheme: " + String.valueOf(this));
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    public int reassignFromLink() throws SBException, SQLException, SBPermissionException {
        if (this.link == null) {
            throw new SBException("Link null in EnvScheme.reassignFromLink");
        }
        if (this.sbdb == null || !this.sbdb.isConnected()) {
            throw new SBException("Attempt to reassign EnvScheme in workspace or no database connection" + String.valueOf(this));
        }
        if (!EnvScheme.canWrite(this.sbdb)) {
            throw new SBPermissionException(this.getDeniedReason(this.sbdb, "scheme", true));
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            Audit temp = new Audit();
            for (String field : intervalFields) {
                for (int entry = 1; entry <= this.classes.size(); ++entry) {
                    Integer linkIndex = this.getLinkTermIndex(entry);
                    if (linkIndex == null) {
                        linkIndex = entry;
                    }
                    String sql = "UPDATE " + this.sbdb.DBTableName("igd_env") + " set " + field + "= -" + linkIndex + " WHERE " + field + "=" + entry + " AND envsch_id=" + this.ID;
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                }
            }
            String sql = "UPDATE " + this.sbdb.DBTableName("igd_env") + " SET up=-up, ud=-ud, lp=-lp, ld=-ld, qual=-qual, envsch_id=" + this.link.getID() + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE envsch_id=" + this.ID;
            int nIGDEnvRows = stmt.executeUpdate(this.sbdb.modQuery(sql));
            for (String field : analysisFields) {
                for (int entry = 1; entry <= this.classes.size(); ++entry) {
                    Integer linkIndex = this.getLinkTermIndex(entry);
                    if (linkIndex == null) {
                        linkIndex = entry;
                    }
                    sql = this.sbdb.getDBType() == DBType.MSSQLSERVER ? "UPDATE s SET " + field + "= -" + linkIndex + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " FROM " + this.sbdb.DBTableName("smpdtl") + " AS s WHERE " + field + "=" + entry + " AND EXISTS (SELECT 1 FROM " + this.sbdb.DBTableName("analy_hdr") + " h WHERE h.envsch_id=" + this.ID + " AND h.analy_id=s.analy_id AND h.well_id=s.well_id)" : "UPDATE " + this.sbdb.DBTableName("smpdtl") + " s SET " + field + "= -" + linkIndex + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE " + field + "=" + entry + " AND EXISTS (SELECT 1 FROM " + this.sbdb.DBTableName("analy_hdr") + " h WHERE h.envsch_id=" + this.ID + " AND h.analy_id=s.analy_id AND h.well_id=s.well_id)";
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                }
                sql = this.sbdb.getDBType() == DBType.MSSQLSERVER ? "UPDATE s SET " + field + "= -" + field + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " FROM " + this.sbdb.DBTableName("smpdtl") + " AS s WHERE EXISTS (SELECT 1 FROM " + this.sbdb.DBTableName("analy_hdr") + " h WHERE h.envsch_id=" + this.ID + " AND h.analy_id=s.analy_id AND h.well_id=s.well_id)" : "UPDATE " + this.sbdb.DBTableName("smpdtl") + " s SET " + field + "= -" + field + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE EXISTS (SELECT 1 FROM " + this.sbdb.DBTableName("analy_hdr") + " h WHERE h.envsch_id=" + this.ID + " AND h.analy_id=s.analy_id AND h.well_id=s.well_id)";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            sql = "UPDATE " + this.sbdb.DBTableName("analy_hdr") + " SET envsch_id=" + this.link.getID() + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE envsch_id=" + this.ID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("chtpanl") + " SET envsch_id=" + this.link.getID() + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE envsch_id=" + this.ID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            int n = nIGDEnvRows;
            return n;
        }
    }

    private static class EnvTerm {
        String name;
        String comment;
        Color colour = Color.CYAN;
        int nOccs;
        int linkTerm;

        EnvTerm(String name) {
            if (name == null) {
                name = "";
            }
            this.name = name;
        }
    }
}

