/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.scheme.Boundary;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import model3.Audit;
import model3.IGDIntervalZone;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.wellinterp.InterpItem;
import org.jdom2.Element;
import util.SB;
import util.SBException;
import util.SortEntry;
import util.status.SbugsStatus;

public class Fault
implements Comparable<Fault>,
SbugsStatus,
SortEntry,
InterpItem {
    private final SBdb db;
    private Sample sample;
    private String label;
    private double faultThrow;
    private Boundary bnd = Boundary.FAULT;
    private Audit audit = new Audit();
    private Color status = UNKNOWN;
    public static final String NOUN = "disconformity";

    public Fault(SBdb db, Sample sample, Boundary bnd, double faultThrow, String label, Audit audit) {
        if (bnd == null || !bnd.isDisconformable()) {
            throw new IllegalArgumentException("Can't create Fault with bnd: " + String.valueOf(bnd));
        }
        this.sample = sample;
        this.bnd = bnd;
        this.faultThrow = faultThrow;
        this.label = label;
        this.audit = audit;
        this.db = db;
    }

    public Fault(SBdb db, Sample sample, Boundary bnd, int wellID, double faultThrow, String label, int interpID) throws SQLException {
        if (bnd == null || !bnd.isDisconformable()) {
            throw new IllegalArgumentException("Can't create Fault with bnd: " + String.valueOf(bnd));
        }
        this.sample = sample;
        this.bnd = bnd;
        this.faultThrow = faultThrow;
        this.label = label;
        this.db = db;
        this.store(wellID, interpID);
    }

    public static Fault load(SBdb db, Well well, int interpID, int sampID, Fault f) throws SQLException {
        Sample sample = well.getSample(sampID);
        String sql = "SELECT bnd,throw,label," + Audit.sqlFieldString() + " FROM " + db.DBTableName("FAULTS") + " WHERE well_id=" + well.getWellID() + " AND interp_id=" + interpID + " AND samp_id=" + sampID;
        try (Statement stmt = db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            if (rs.next()) {
                Boundary bnd = Boundary.getBnd((int)rs.getInt("bnd"));
                if (!bnd.isDisconformable()) {
                    bnd = Boundary.FAULT;
                }
                double faultThrow = rs.getDouble("throw");
                String label = rs.getString("label");
                Audit audit = new Audit(rs);
                if (f != null) {
                    f.bnd = bnd;
                    f.label = label;
                    f.faultThrow = faultThrow;
                    f.audit = audit;
                    Fault fault = f;
                    return fault;
                }
                Fault fault = new Fault(db, sample, bnd, faultThrow, label, audit);
                return fault;
            }
            throw new IllegalStateException("No disconformity found in refresh");
        }
    }

    public static Fault copyToDatabase(Fault wsFault, SBdb db) throws SBException, SQLException {
        return new Fault(db, wsFault.getSample().getLink(), wsFault.getBnd(), wsFault.getThrow(), wsFault.getLabel(), new Audit(db, wsFault.db, wsFault.getAudit()));
    }

    static void LoadFaults(SBdb sbdb, Well well, int interpID, List<Fault> faults) throws SQLException {
        if (!faults.isEmpty()) assert (false);
        faults.clear();
        String sql = "SELECT samp_id,bnd,throw,label," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("FAULTS") + " WHERE interp_id=" + interpID + " AND well_id=" + well.getWellID();
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int sampID = rs.getInt("samp_id");
                int bndInt = rs.getInt("bnd");
                Boundary bnd = Boundary.getBnd((int)bndInt);
                if (!bnd.isDisconformable()) {
                    bnd = Boundary.FAULT;
                }
                int faultThrow = rs.getInt("throw");
                String strg = rs.getString("label");
                Fault fault = new Fault(sbdb, well.getSample(sampID), bnd, faultThrow, strg, new Audit(rs));
                faults.add(fault);
            }
        }
        Collections.sort(faults);
    }

    static void insert(Fault fault, List<Fault> faults) {
        if (!faults.isEmpty()) {
            ListIterator<Fault> it = faults.listIterator(faults.size() - 1);
            while (it.hasPrevious()) {
                Fault f = it.previous();
                if (!(f.sample.getDepth() < fault.sample.getDepth())) continue;
                it.add(fault);
                return;
            }
        }
        faults.add(fault);
    }

    void copy(Fault rhs) {
        assert (this.db == rhs.db);
        this.faultThrow = rhs.faultThrow;
        this.bnd = rhs.bnd;
        this.label = rhs.label;
        this.sample = rhs.sample;
        this.audit = new Audit(rhs.audit);
    }

    @Override
    public Sample getSample() {
        return this.sample;
    }

    public double getThrow() {
        return this.faultThrow;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public Date getUpdated() {
        return this.audit.updated;
    }

    public Boundary getBnd() {
        return this.bnd;
    }

    public final void store(int wellID, int interpID) throws SQLException {
        if (wellID <= 0 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to Fault.store, wellID: " + wellID + ", interpID: " + interpID);
        }
        try (Statement stmt = this.db.getDatabase().createStatement();){
            String sql = "INSERT INTO " + this.db.DBTableName("faults") + " (well_id,interp_id,samp_id,bnd,throw,label," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + interpID + "," + this.sample.getSampID() + "," + this.bnd.getBndInt() + "," + this.faultThrow + "," + SB.DBString((String)this.label) + "," + this.audit.sqlInsert(this.db, stmt) + ")";
            stmt.executeUpdate(this.db.modQuery(sql));
        }
    }

    @Override
    public void delete(int wellID, int interpID, Statement existingStmt) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal argument to Fault.delete: wellID is " + wellID + ", interpID is " + interpID);
        }
        String sql = "DELETE FROM " + this.db.DBTableName("faults") + " WHERE well_id=" + wellID + " AND samp_id=" + this.sample.getSampID() + " AND interp_id=" + interpID;
        try (Statement stmt = this.db.getDatabase().createStatement();){
            stmt.executeUpdate(this.db.modQuery(sql));
        }
    }

    @Override
    public boolean mergeSamples(Sample donor, Sample target) {
        if (this.sample == donor) {
            this.sample = target;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Fault comp) {
        int sComp = this.sample.getSortEntry().compareTo(comp.sample.getSortEntry());
        if (sComp == 0) assert (false);
        return sComp;
    }

    @Override
    public List<Integer> writeXML(BufferedWriter out, int indent, char units) throws IOException {
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<Disconformity>\n");
        String ind2 = SB.getXMLIndent((int)(indent + 3));
        out.write(ind2 + "<SampleID>" + this.sample.getSampID() + "</SampleID>\n");
        out.write(ind2 + "<Boundary>" + IGDIntervalZone.getBoundary(this.bnd.getBndInt()) + "</Boundary>\n");
        if (this.label != null && !this.label.trim().isEmpty()) {
            out.write(ind2 + "<Label>" + this.label.trim() + "</Label>\n");
        }
        if (this.bnd.isFault()) {
            out.write(ind2 + "<FaultThrow>" + this.faultThrow + "</FaultThrow>\n");
        }
        LinkedList<Integer> users = this.audit.writeXML(out, indent);
        out.write(ind1 + "</Disconformity>\n");
        return users;
    }

    public Fault(SBdb db, Well well, Element xml) throws SQLException, SBException, ParseException {
        Element el;
        this.db = db;
        String strg = xml.getChildTextNormalize("SampleID");
        if (strg != null) {
            int sampID = Integer.parseInt(strg);
            this.sample = well.getSample(sampID);
            if (this.sample == null) {
                throw new SBException("Cannot find top sample in disconformity for ID: " + sampID);
            }
        }
        if ((strg = xml.getChildTextNormalize("Boundary")) != null) {
            this.bnd = Boundary.getBnd((int)IGDIntervalZone.getBoundaryTypeFromString(strg));
            if (!this.bnd.isDisconformable()) {
                throw new SBException("No disconformable boundary for disconformity at " + String.valueOf(this.sample));
            }
        } else {
            throw new SBException("No surface scheme specified for Pick: " + String.valueOf(this.sample));
        }
        strg = xml.getChildTextNormalize("Label");
        if (strg != null && !strg.isEmpty()) {
            this.label = strg.trim();
        }
        if ((strg = xml.getChildTextNormalize("FaultThrow")) != null) {
            assert (this.bnd.isFault());
            this.faultThrow = Double.parseDouble(strg);
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.audit = new Audit(db, el);
        } else {
            System.out.println("Warning: no audit info for fault: " + String.valueOf(this));
        }
    }

    void updateStatus(List<Fault> faults) throws SBException {
        this.status = NOTSTORED;
        for (Fault fault : faults) {
            if (fault == this || !this.isFuncEquivalent(fault)) continue;
            this.status = STORED;
            if (fault.bnd != this.bnd) {
                this.status = CONFLICT;
                break;
            }
            if (!Objects.equals(fault.label, this.label)) {
                this.status = CONFLICT;
                break;
            }
            if (!(Math.abs(fault.faultThrow - this.faultThrow) > 0.001)) break;
            this.status = CONFLICT;
            break;
        }
    }

    public Audit getAudit() {
        return this.audit;
    }

    public Color getStatus() {
        return this.status;
    }

    public void setStatus(Color status) {
        this.status = status;
    }

    public String statusString() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getSortEntry() {
        return this.sample.getSortEntry();
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return e instanceof Fault && this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    @Override
    public Sample getBaseSample() {
        return null;
    }

    @Override
    public Discipline getDiscipline() {
        return null;
    }

    @Override
    public int getSchID() {
        return 0;
    }

    @Override
    public void move(int wellID, int interpID, int newInterpID) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeDEX(FileWriter out, String eol, char units, SimpleDateFormat df) throws IOException, SBException, SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getItemDesc() {
        return NOUN;
    }

    @Override
    public String getItemDescPlural() {
        return "disconformities";
    }
}

