/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeImpl;
import com.stratadata.model3.well.sample.SampleType;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;
import javax.swing.JOptionPane;
import model3.AnalystHeader;
import model3.Audit;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.Well;
import model3.WsWell;
import util.SBException;
import util.SBPermissionException;
import util.status.MergeStatus;

public final class GeoSciReader {
    private final Set<Integer> dataTypes;
    private final char units;
    SBdb ws;
    int specID = 0;
    AbundanceSchemeImpl abnScheme;
    int reworkedAbundanceClass = -1;
    private SourceDetails sourceDetails = new SourceDetails();

    public GeoSciReader(SBdb ws, String fileName, Set<Integer> dataTypes, char discID, char units, Userdef analyst, boolean useSampleTops) throws SBException, SQLException {
        this.dataTypes = dataTypes;
        this.units = units;
        this.sourceDetails.analystID = ws.getAddUserID(analyst.getAbr());
        Userdef wsAnalyst = ws.getUser(this.sourceDetails.analystID);
        wsAnalyst.setLink(analyst);
        this.ws = ws;
        Well well = null;
        AnalystHeader analyHdr = null;
        try (BufferedReader in = new BufferedReader(new FileReader(fileName));){
            Sample sample = null;
            Smpdtl smpdtl = null;
            try {
                Object buff = in.readLine();
                if (buff == null || ((String)buff).length() < 1 || ((String)buff).charAt(0) != '*') {
                    throw new SBException("Expecting first character as a '*': is this a GeoSci file?");
                }
                String[] fileHeader = ((String)buff).split(" ");
                int nTaxa = Integer.parseInt(fileHeader[1]);
                String prependWith = null;
                while ((buff = in.readLine()) != null) {
                    if (prependWith != null) {
                        buff = prependWith + (String)buff;
                    }
                    if (((String)buff).endsWith("=0A=")) {
                        buff = ((String)buff).substring(0, ((String)buff).length() - 4);
                    } else if (((String)buff).endsWith("=")) {
                        prependWith = ((String)buff).substring(0, ((String)buff).length() - 1);
                        continue;
                    }
                    prependWith = null;
                    if (((String)buff).isEmpty() || ((String)buff).length() < 2) continue;
                    char recordType = Character.toUpperCase(((String)buff).charAt(0));
                    buff = ((String)buff).substring(2).trim();
                    switch (recordType) {
                        case 'A': {
                            this.parseAbnScheme((String)buff);
                            break;
                        }
                        case 'F': {
                            int nTaxon = this.parseTaxon((String)buff);
                            if (nTaxon <= nTaxa) break;
                            throw new SBException("Taxon number: " + nTaxon + " exceeds expected total of: " + nTaxa);
                        }
                        case 'W': {
                            if (well != null) {
                                ((WsWell)well).updateStatus(dataTypes);
                                System.out.println("For well: " + well.toString() + " Read: " + well.getAnalyses('\u0000', null, 0).size() + " analyses.");
                            }
                            String[] t = ((String)buff).split(" ", 2);
                            String[] t2 = t[1].split("[|]");
                            well = ws.addWellToWorkspace(0, fileName);
                            well.loadInterps();
                            well.getHeader().setWellName(t2[0]);
                            well.getHeader().setWellCode(Well.makeCode(t2[0]));
                            String[] t3 = t2[1].split(" ");
                            if (t3[1].toUpperCase().contains("F")) {
                                units = (char)70;
                                well.getHeader().setWellUnits(units);
                            }
                            well.getHeader().setWellUnits(units);
                            analyHdr = well.getAnalystHeader(analyst.getAbr(), discID, 1, true);
                            if (this.abnScheme != null) {
                                analyHdr.setAbnScheme(this.abnScheme.getAbnSchID());
                            }
                            well.getSamples();
                            break;
                        }
                        case 'D': {
                            if (well == null) {
                                throw new SBException("no well record for depth record: " + (String)buff);
                            }
                            try {
                                try {
                                    if (Double.parseDouble((String)buff) < -9998.0) {
                                        break;
                                    }
                                }
                                catch (NumberFormatException ne) {
                                    System.out.println("Can't parse depth: " + (String)buff);
                                }
                                Sample.Builder builder = Sample.parseDepthTypeLabelString((String)buff, units, false, useSampleTops, SectionType.WELL, SampleType.CU);
                                if (sample != null && sample.isEquivalent(builder)) {
                                    System.out.println("Duplicate sample at depth: " + (String)buff);
                                    break;
                                }
                                sample = well.addSample(builder, 0, null);
                                sample.displayUnits = units;
                                Audit audit = new Audit(analyHdr.getAnalystUsrid(), null, analyHdr.getAnalystUsrid(), new Date());
                                smpdtl = new Smpdtl(ws, sample, analyHdr, null, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, audit, Smpdtl.AnalysisType.ANALYSED);
                                sample.insert(smpdtl);
                                if (sample.getBaseDepth('M') > well.getTD()) {
                                    well.getHeader().setTD(sample.getBaseDepth('M'));
                                }
                                dataTypes.add(1);
                            }
                            catch (NumberFormatException ne) {
                                System.out.println("Error parsing depth string: " + (String)buff);
                            }
                            break;
                        }
                        case 'L': {
                            break;
                        }
                        case 'E': {
                            String[] ftoks = ((String)buff).split(" ");
                            int nPairs = ftoks.length / 2;
                            for (int i = 0; i < nPairs; ++i) {
                                int specID = Integer.parseInt(ftoks[i * 2]);
                                int abund = Integer.parseInt(ftoks[i * 2 + 1]);
                                String subjAbund = null;
                                boolean questionable = false;
                                boolean reworked = false;
                                if (abund == 0) {
                                    questionable = true;
                                } else if (abund == this.reworkedAbundanceClass) {
                                    reworked = true;
                                } else {
                                    subjAbund = this.abnScheme.findEntryByCount(abund).map(AbundanceScheme.AbundanceSchemeEntry::abr).orElse(null);
                                }
                                Taxon taxon = ws.getTaxon(specID);
                                TaxonOcc.Builder occBuilder = new TaxonOcc.Builder(ws, taxon, reworked ? Situation.RW : Situation.INSITU, questionable, 0);
                                occBuilder = occBuilder.subjAbund(subjAbund);
                                smpdtl.insertOccurrence(occBuilder, well.getWellID(), false);
                            }
                            sample.status = MergeStatus.merge((Color)sample.status, (Color)smpdtl.status);
                            this.addDataType(SBdb.did2dtype(smpdtl.getDiscID()));
                        }
                    }
                }
                System.out.println("For well: " + well.toString() + " Read: " + well.getAnalyses('\u0000', null, 0).size() + " analyses.");
                ((WsWell)well).updateStatus(dataTypes);
                ws.getAbundanceSchemeService().addAbundanceScheme((AbundanceScheme)this.abnScheme);
            }
            catch (IOException | SQLException | SBException | SBPermissionException eio) {
                eio.printStackTrace();
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Cannot open file: " + ioe.getMessage());
        }
    }

    private void parseAbnScheme(String buff) throws SBException, SQLException {
        if (this.abnScheme == null) {
            this.abnScheme = new AbundanceSchemeImpl(1);
            this.abnScheme.setName("GeoSci Scheme");
        }
        String[] toks = buff.split(" ", 3);
        String className = toks[2].trim();
        String abr = toks[0].trim();
        int lowBound = Integer.parseInt(toks[1]);
        if (abr.equals("^")) {
            this.reworkedAbundanceClass = lowBound;
            return;
        }
        if (lowBound == 0 && abr.equals("?")) {
            return;
        }
        if (lowBound == 0) {
            throw new SBException("Abundance scheme entry invalid: " + buff);
        }
        this.abnScheme.addEntry(new AbundanceScheme.AbundanceSchemeEntry(className, abr, lowBound, lowBound));
    }

    int parseTaxon(String strg) {
        String[] fields = strg.split(" ", 3);
        int specID = Integer.parseInt(fields[0]);
        Taxon t = this.ws.getTaxon(fields[2], specID, true);
        return specID;
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(dType)) {
            this.dataTypes.add(dType);
        }
    }

    private static class SourceDetails {
        String analystName;
        String sourceName;
        Date analysisDate;
        int analystID;

        private SourceDetails() {
        }
    }
}

