/*
 * Decompiled with CFR 0.152.
 */
package model3;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import model3.GrainSizeDepth;
import model3.SBdb;
import util.SB;
import util.SBException;

public class GrainSizeList
extends ArrayList<GrainSizeDepth> {
    boolean isDirty = false;
    boolean isLoaded = false;

    public GrainSizeList(GrainSizeList grainSize) throws SBException {
        for (GrainSizeDepth d : grainSize) {
            this.add(new GrainSizeDepth(d.getDepth(), d.getGrainSize()));
        }
    }

    public GrainSizeList() {
    }

    public void setDirty() {
        this.isDirty = true;
    }

    @Override
    public boolean add(GrainSizeDepth grainSize) {
        Iterator it = this.iterator();
        int insertPoint = 0;
        int nzD = (int)(grainSize.depth * 100.0);
        boolean ignore = false;
        while (it.hasNext()) {
            GrainSizeDepth compareWith = (GrainSizeDepth)it.next();
            if (compareWith != grainSize) {
                int cD = (int)(compareWith.depth * 100.0);
                if (nzD == cD) {
                    ignore = true;
                }
                if (nzD < cD) break;
                ++insertPoint;
                continue;
            }
            return false;
        }
        if (!ignore) {
            super.add(insertPoint, grainSize);
            this.isDirty = true;
        }
        return true;
    }

    public void load(SBdb sbdb, int wellID) throws SQLException {
        if (!this.isLoaded && sbdb.isConnected()) {
            this.clear();
            String sql = "SELECT depth, grain_size FROM " + sbdb.DBTableName("sbgs") + "  WHERE well_id=" + wellID;
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                while (rs.next()) {
                    double depth = rs.getDouble("depth");
                    float grainSize = rs.getFloat("grain_size");
                    GrainSizeDepth GrainSize = new GrainSizeDepth(depth, grainSize);
                    this.add(GrainSize);
                }
            }
            this.isDirty = false;
        }
        this.isLoaded = true;
    }

    public void deleteAll(SBdb sbdb, int wellID) throws SQLException {
        String sql = "DELETE FROM " + sbdb.DBTableName("sbgs") + " WHERE well_id=" + wellID;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
    }

    @Override
    public void clear() {
        this.isDirty = false;
        this.isLoaded = false;
        super.clear();
    }

    public void store(SBdb SB2, int wellID) throws SQLException {
        if (this.isDirty) {
            Iterator it = this.iterator();
            this.deleteAll(SB2, wellID);
            it = this.iterator();
            String sql = "INSERT INTO " + SB2.DBTableName("sbgs") + "(well_id,depth,grain_size) VALUES (?,?,?)";
            PreparedStatement stmt = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
            while (it.hasNext()) {
                GrainSizeDepth grainSize = (GrainSizeDepth)it.next();
                if (!(Math.abs(grainSize.depth) > 0.0)) continue;
                stmt.setInt(1, wellID);
                stmt.setDouble(2, grainSize.depth);
                stmt.setFloat(3, grainSize.grainSize);
                stmt.executeUpdate();
            }
            stmt.close();
            this.isDirty = false;
            this.isLoaded = true;
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        if (this.size() > 0) {
            Iterator it = this.iterator();
            out.write("[GrainSize]" + eol);
            while (it.hasNext()) {
                GrainSizeDepth GrainSize = (GrainSizeDepth)it.next();
                out.write("Depth/GrainSize = " + SB.getDepthString((double)GrainSize.depth, (char)units, (int)2).trim() + " : " + SB.floatString((float)GrainSize.grainSize, (int)4) + eol);
            }
            out.write(eol);
        }
    }
}

