/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.user.Userdef;
import java.awt.Color;
import java.awt.geom.Area;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import model3.Audit;
import model3.Chron;
import model3.DEXFile;
import model3.IGDAge;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.IGDUnitClass;
import model3.LithostratUnit;
import model3.LithostratUnitClass;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Surface;
import model3.Well;
import model3.WellInterp;
import model3.WellOccRec;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsLink;
import util.exception.StackError;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public class IGDScheme
extends SBRestrictable
implements SbugsStatus,
SbugsLink,
Comparable {
    private final SBdb sbdb;
    private final int igdType;
    private String name;
    private String comments;
    private int schID;
    private SequenceType sqType;
    private Discipline discID;
    private int parentID;
    private boolean archived;
    private List<IGDUnitBase> units;
    private List<Surface> surfaces;
    final Object lockObj;
    private Audit audit;
    private Color status;
    private IGDScheme link;
    private boolean interpRefresh;
    static final double SMALL = 1.0E-6;
    static final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShadeInterval> getShadingIntervals(float min, float max) {
        Object object = this.lockObj;
        synchronized (object) {
            LinkedList<ShadeInterval> list = new LinkedList<ShadeInterval>();
            for (int hier = IGDIntervalZone.getNHier(this.igdType, true); hier > 0; --hier) {
                for (IGDUnitBase unit : this.units) {
                    if (unit.getHier() != hier || !unit.hasAges() || !(unit.getLage() > (double)min) || !(unit.getUage() < (double)max)) continue;
                    float top = (float)Math.max(unit.getUage(), (double)min);
                    float base = (float)Math.min(unit.getLage(), (double)max);
                    if (list.isEmpty()) {
                        list.add(new ShadeInterval(top, base, unit.getColour()));
                        continue;
                    }
                    ShadeInterval si = (ShadeInterval)list.get(0);
                    if (si.uAge > min && top < si.uAge) {
                        list.add(0, new ShadeInterval(top, Math.min(si.uAge, base), unit.getColour()));
                    }
                    si = (ShadeInterval)list.get(list.size() - 1);
                    if (si.lAge < max && base > si.lAge) {
                        list.add(new ShadeInterval(Math.max(si.lAge, top), base, unit.getColour()));
                    }
                    boolean added = true;
                    block5: while (added) {
                        added = false;
                        for (int i = 0; i < list.size() - 1; ++i) {
                            si = (ShadeInterval)list.get(i);
                            ShadeInterval siNext = (ShadeInterval)list.get(i + 1);
                            if (!(si.lAge < siNext.uAge) || !(top < siNext.uAge) || !(base > si.lAge)) continue;
                            list.add(i + 1, new ShadeInterval(Math.max(si.lAge, top), Math.min(siNext.uAge, base), unit.getColour()));
                            added = true;
                            continue block5;
                        }
                    }
                }
            }
            return list;
        }
    }

    void setSchID(int schID) {
        if (this.schID != 0) {
            throw new IllegalStateException("Attempt to set schID on saved scheme " + String.valueOf(this));
        }
        if (schID <= 0) {
            throw new IllegalArgumentException("Attempt to set schID to " + schID);
        }
        this.schID = schID;
    }

    public IGDScheme(SBdb ws, int igdType, String name, String comments, Discipline disc, SequenceType sqType, int parentID) {
        super("IGD_SCH", "SCH_ID", false, true);
        this.name = "";
        this.comments = "";
        this.units = null;
        this.surfaces = null;
        this.lockObj = new Object();
        this.audit = new Audit();
        this.status = UNKNOWN;
        this.link = null;
        this.interpRefresh = false;
        this.sbdb = ws;
        this.igdType = igdType;
        this.name = name;
        this.comments = comments;
        if (this.isBiozone() && disc == null) {
            throw new IllegalArgumentException("No discipline set for biozone scheme '" + name + "'");
        }
        this.discID = disc;
        if (this.isSequence() && sqType == null) {
            throw new IllegalArgumentException("No sequence type set for sequence scheme '" + name + "'");
        }
        this.sqType = sqType;
        this.parentID = parentID;
        this.units = new LinkedList<IGDUnitBase>();
        this.surfaces = new LinkedList<Surface>();
    }

    static IGDScheme parseDEX(DEXFile.DEXsection section, SBdb db) throws SBException, SQLException {
        int igdType;
        try {
            igdType = IGDInterval.getIGDType(section.type.substring(0, section.type.lastIndexOf("SCHEME")).trim());
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new SBException("Scheme in DEX file of type: " + section.type + " is not recognised.");
        }
        IGDScheme scheme = new IGDScheme(db, igdType, "", "", (Discipline)(igdType == 4 ? Discipline.MICRO : null), igdType == 10 ? SequenceType.DEPOSITIONAL : null, 0);
        scheme.units = new LinkedList<IGDUnitBase>();
        IGDUnitBase.Builder builder = null;
        int unitID = 0;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("Scheme name")) {
                scheme.name = value;
                continue;
            }
            if (label.equalsIgnoreCase("Scheme ID")) {
                scheme.schID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Discipline")) {
                scheme.discID = Discipline.getDisc((String)value);
                continue;
            }
            if (label.equalsIgnoreCase("Number of units")) {
                int n = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("Unit")) {
                if (builder != null) {
                    try {
                        scheme.addUnit(builder, unitID);
                    }
                    catch (IllegalStateException | InvalidFieldException e) {
                        System.out.println("Error parsing unit: " + e.getMessage());
                    }
                }
                builder = igdType == 2 ? new LithostratUnit.Builder(db) : new IGDUnit.Builder(db);
                builder.name(value);
                continue;
            }
            if (label.equalsIgnoreCase("Abbreviation")) {
                if (builder == null) continue;
                if (builder instanceof LithostratUnit.Builder) {
                    ((LithostratUnit.Builder)builder).abr(value);
                    continue;
                }
                if (!(builder instanceof IGDUnit.Builder)) continue;
                ((IGDUnit.Builder)builder).abr(value);
                continue;
            }
            if (label.equalsIgnoreCase("Type")) {
                if (value.equalsIgnoreCase("Scheme")) {
                    value = "Zone";
                }
                if (builder == null) continue;
                builder.hier(IGDIntervalZone.getHierNumber(igdType, value, true));
                continue;
            }
            if (label.equalsIgnoreCase("Youngest")) {
                if (builder == null) continue;
                if (builder instanceof LithostratUnit.Builder) {
                    ((LithostratUnit.Builder)builder).age(1, Double.parseDouble(value));
                    ((LithostratUnit.Builder)builder).age(0, Double.parseDouble(value));
                    continue;
                }
                if (!(builder instanceof IGDUnit.Builder)) continue;
                ((IGDUnit.Builder)builder).age(true, new IGDAge(Double.parseDouble(value)));
                continue;
            }
            if (label.equalsIgnoreCase("Oldest")) {
                if (builder == null) continue;
                if (builder instanceof LithostratUnit.Builder) {
                    ((LithostratUnit.Builder)builder).age(2, Double.parseDouble(value));
                    ((LithostratUnit.Builder)builder).age(3, Double.parseDouble(value));
                    continue;
                }
                if (!(builder instanceof IGDUnit.Builder)) continue;
                ((IGDUnit.Builder)builder).age(false, new IGDAge(Double.parseDouble(value)));
                continue;
            }
            if (label.equalsIgnoreCase("Colour")) {
                if (builder == null) continue;
                StringTokenizer tok = new StringTokenizer(value, ",");
                int red = Integer.parseInt(tok.nextToken());
                int green = Integer.parseInt(tok.nextToken());
                int blue = Integer.parseInt(tok.nextToken());
                if (builder instanceof LithostratUnit.Builder) {
                    ((LithostratUnit.Builder)builder).colour(new Color((char)red, (char)green, (char)blue));
                    continue;
                }
                if (!(builder instanceof IGDUnit.Builder)) continue;
                ((IGDUnit.Builder)builder).colour(new Color((char)red, (char)green, (char)blue));
                continue;
            }
            if (!label.equalsIgnoreCase("Dictionary ID")) continue;
            unitID = Integer.parseInt(value);
        }
        if (builder != null) {
            try {
                scheme.addUnit(builder, unitID);
            }
            catch (IllegalStateException | InvalidFieldException e) {
                System.out.println("Error parsing unit: " + e.getMessage());
            }
        }
        if (scheme.schID <= 0) {
            throw new IllegalStateException("No scheme ID found during DEX parsing for scheme: " + scheme.name);
        }
        return scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IGDScheme(SBdb ws, Element xml, List<SBException> exceptions) throws ParseException, SQLException, SBException {
        super("IGD_SCH", "SCH_ID", false, true);
        Element el;
        this.name = "";
        this.comments = "";
        this.units = null;
        this.surfaces = null;
        this.lockObj = new Object();
        this.audit = new Audit();
        this.status = UNKNOWN;
        this.link = null;
        this.interpRefresh = false;
        this.sbdb = ws;
        this.units = new LinkedList<IGDUnitBase>();
        this.surfaces = new LinkedList<Surface>();
        String strg = xml.getChildTextNormalize("SchemeType");
        if (strg == null) {
            throw new SBException("No igdType found");
        }
        this.igdType = IGDInterval.getIGDType(strg);
        strg = xml.getChildText("SchemeName");
        if (strg != null) {
            this.name = strg;
        }
        if ((strg = xml.getChildText("Comments")) != null) {
            this.comments = strg;
        }
        if ((strg = xml.getChildTextNormalize("SchemeID")) != null) {
            this.schID = Integer.parseInt(strg);
        }
        if ((strg = xml.getChildTextNormalize("Discipline")) != null) {
            this.discID = Discipline.getDisc((String)strg);
        }
        if ((strg = xml.getChildTextNormalize("SequenceModel")) != null && strg.length() > 0) {
            this.sqType = SequenceType.get(strg.charAt(0));
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.audit = new Audit(ws, el);
        } else {
            exceptions.add(new SBException("Warning: no audit info for Scheme: " + String.valueOf(this)));
            System.out.println("Warning: no audit info for Scheme: " + String.valueOf(this));
        }
        LinkedList<IGDUnitBase> parsed = new LinkedList<IGDUnitBase>();
        IteratorIterable it = xml.getDescendants((Filter)new ElementFilter("Unit"));
        block10: while (it.hasNext()) {
            switch (this.igdType) {
                case 2: {
                    parsed.add(new LithostratUnit(ws, this.schID, (Element)it.next()));
                    continue block10;
                }
            }
            parsed.add(new IGDUnit(ws, this.schID, this.igdType, (Element)it.next()));
        }
        it = xml.getDescendants((Filter)new ElementFilter("LithostratUnit"));
        if (it.hasNext()) assert (this.igdType == 2);
        while (it.hasNext()) {
            parsed.add(new LithostratUnit(ws, this.schID, (Element)it.next()));
        }
        it = xml.getDescendants((Filter)new ElementFilter("Chron"));
        if (it.hasNext()) assert (this.igdType == 26);
        while (it.hasNext()) {
            parsed.add(new Chron(ws, this.schID, (Element)it.next()));
        }
        Collections.sort(parsed, new UnitHierComparator());
        for (IGDUnitBase base : parsed) {
            if (!(base instanceof IGDUnit)) continue;
            ((IGDUnit)base).calcAges(parsed);
        }
        if (this.igdType == 2) {
            ArrayList<IGDUnitBase> parsed2 = new ArrayList<IGDUnitBase>();
            for (IGDUnitBase base : parsed) {
                try {
                    parsed2.add(base);
                    IGDScheme.checkSchemeUnitsBase(parsed2);
                }
                catch (InvalidFieldException ife) {
                    exceptions.add(new SBException("Resetting lithostrat unit ages for '" + base.getName() + "': " + ife.getMessage()));
                    System.out.println("Resetting lithostrat unit ages for '" + base.getName() + "': " + ife.getMessage());
                    LithostratUnit lu = (LithostratUnit)base;
                    LithostratUnit.Builder b = new LithostratUnit.Builder(this.sbdb, lu);
                    b.x(lu.getXs()).colour(lu.getColour()).abr(lu.getAbr()).lithology(lu.getLithology()).bnd(true, lu.getUBnd().getBndInt()).bnd(false, lu.getLBnd().getBndInt()).name(lu.getName()).hier(lu.getHier()).status(IGDUnitBase.NOTSTORED);
                    b.age(new double[]{0.0, 0.0, 0.0, 0.0});
                    parsed2.remove(base);
                    IGDUnitBase replacement = b.build(lu.getUnitID(), this.schID);
                    parsed2.add(replacement);
                }
            }
            parsed.clear();
            parsed.addAll(parsed2);
        }
        try {
            IGDScheme.checkSchemeUnitsBase(parsed);
        }
        catch (InvalidFieldException ife) {
            exceptions.add(new SBException("Error from Scheme unit checking: " + ife.getMessage()));
            System.out.println("Error from Scheme unit checking: " + ife.getMessage());
        }
        Object object = this.lockObj;
        synchronized (object) {
            this.units.addAll(parsed);
            it = xml.getDescendants((Filter)new ElementFilter("Surface"));
            while (it.hasNext()) {
                this.surfaces.add(new Surface(ws, this.schID, (Element)it.next()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IGDScheme copyToWorkspace(SBdb ws, IGDScheme dbScheme) throws SQLException, SBException {
        if (ws.isConnected()) {
            throw new IllegalArgumentException("Attempt to copy scheme to connected workspace");
        }
        IGDScheme scheme = new IGDScheme(ws, dbScheme.igdType, dbScheme.name, dbScheme.comments, dbScheme.discID, dbScheme.sqType, 0);
        scheme.schID = dbScheme.schID;
        scheme.units = new LinkedList<IGDUnitBase>();
        Object object = scheme.lockObj;
        synchronized (object) {
            Object b;
            dbScheme.loadUnits();
            for (IGDUnitBase base : dbScheme.units) {
                b = IGDUnitBase.Builder.copyOf(base, ws);
                ((IGDUnitBase.Builder)b).getAudit().fillWorkspace(dbScheme.sbdb, scheme.sbdb);
                scheme.units.add(((IGDUnitBase.Builder)b).build(base.getUnitID(), scheme.schID));
            }
            scheme.surfaces = new LinkedList<Surface>();
            for (Surface surface : dbScheme.getSurfaces()) {
                b = Surface.Builder.copyOf(ws, surface);
                ((Surface.Builder)b).getAudit().fillWorkspace(dbScheme.sbdb, scheme.sbdb);
                scheme.surfaces.add(((Surface.Builder)b).build(surface.getSurfaceID(), scheme.schID));
            }
            scheme.audit = new Audit(dbScheme.audit);
            scheme.audit.fillWorkspace(dbScheme.sbdb, scheme.sbdb);
            scheme.link = dbScheme;
            return scheme;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IGDScheme copyToDatabase(SBdb db, IGDScheme rhs) throws SQLException, SBException {
        if (!db.isConnected()) {
            throw new IllegalArgumentException("Attempt to copy scheme to unconnected database");
        }
        IGDScheme scheme = new IGDScheme(db, rhs.igdType, rhs.name, rhs.comments, rhs.discID, rhs.sqType, 0);
        scheme.storeDetails();
        assert (scheme.schID > 0);
        Object object = scheme.lockObj;
        synchronized (object) {
            scheme.units = new LinkedList<IGDUnitBase>();
            for (IGDUnitBase base : rhs.units) {
                IGDUnitBase.Builder builder = IGDUnitBase.Builder.copyOf(base, scheme.sbdb);
                scheme.units.add(builder.store(scheme.igdType, scheme.schID));
            }
            scheme.surfaces = new LinkedList<Surface>();
            for (Surface surface : rhs.getSurfaces()) {
                Surface.Builder b = Surface.Builder.copyOf(scheme.sbdb, surface);
                scheme.surfaces.add(b.store(scheme.schID));
            }
            scheme.audit = new Audit(rhs.audit);
            return scheme;
        }
    }

    private void copyPrimitives(IGDScheme rhs) {
        this.discID = rhs.discID;
        this.sqType = rhs.sqType;
        this.name = rhs.name;
    }

    public boolean needsRefresh() {
        return this.interpRefresh;
    }

    public Surface addSurface(Surface.Builder builder) throws InvalidFieldException, SQLException, SBException {
        Surface surface;
        if (builder.getOriginalID() > 0) {
            throw new IllegalArgumentException("Attempt to update original surface in IGDScheme.addSurface");
        }
        if (builder.getModel() != this.sbdb) {
            throw new IllegalArgumentException("Attempt to add surface to scheme from different workspace");
        }
        if (!this.isSequence()) {
            throw new IllegalArgumentException("Attempt to add surface to non-sequence scheme: " + String.valueOf(this));
        }
        if (this.getSurface(builder.getName(), builder.getType()) != null) {
            throw new InvalidFieldException("Surface '" + builder.getName() + "' already exists in scheme: " + String.valueOf(this));
        }
        if (this.sbdb.isConnected()) {
            if (!this.canWrite(this.sbdb, null)) {
                throw new SBException(this.getDeniedReason(this.sbdb, "scheme (surface)", true));
            }
            surface = builder.store(this.schID);
        } else {
            builder.status(NOTSTORED);
            surface = builder.build(this.getNewSurfaceID(), this.schID);
        }
        Surface.insert(this.surfaces, surface);
        this.setChanged();
        return surface;
    }

    private int getNewSurfaceID() throws SQLException {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to get workspace ID for new surface in connected database");
        }
        int max = 1;
        if (this.surfaces.isEmpty()) {
            return max;
        }
        for (Surface surface : this.surfaces) {
            if (surface.getSurfaceID() <= max) continue;
            max = surface.getSurfaceID() + 1;
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNewUnitID() throws SQLException {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to get workspace ID for new unit in connected database");
        }
        int max = 1;
        Object object = this.lockObj;
        synchronized (object) {
            if (this.units.isEmpty()) {
                return max;
            }
            for (IGDUnitBase unit : this.units) {
                if (unit.getUnitID() < max) continue;
                max = unit.getUnitID() + 1;
            }
            return max;
        }
    }

    public Surface getSurface(IGDUnit unit, char which) throws SQLException, SBException {
        if (this.igdType != 10) {
            return null;
        }
        if (which == 'T' || which == ' ') {
            if (unit.getUage() < 1.0E-6) {
                if (which == 'T') {
                    return null;
                }
            } else {
                for (Surface surface : this.getSurfaces()) {
                    if (!(Math.abs(surface.getAge() - unit.getUage()) < 1.0E-6)) continue;
                    return surface;
                }
            }
        }
        if (which == 'B' || which == ' ') {
            if (unit.getLage() < 1.0E-6) {
                return null;
            }
            for (Surface surface : this.getSurfaces()) {
                if (!(Math.abs(surface.getAge() - unit.getLage()) < 1.0E-6)) continue;
                return surface;
            }
        }
        return null;
    }

    public String getSurfaces(IGDUnit unit) throws SQLException, SBException {
        Object string = "";
        if (this.igdType != 10) {
            return null;
        }
        for (Surface surface : this.getSurfaces()) {
            if (!(surface.getAge() > 1.0E-6) || !(surface.getAge() >= unit.getUage()) || !(surface.getAge() <= unit.getLage())) continue;
            if (((String)string).length() > 0) {
                string = (String)string + ",";
            }
            string = (String)string + surface.getName();
        }
        return string;
    }

    public static String getSurfaces(List<Surface.Builder> surfaces, IGDUnitBase.Builder unit) {
        Object string = "";
        if (unit.getUage() == null || unit.getLage() == null) {
            return string;
        }
        for (Surface.Builder surface : surfaces) {
            if (!(surface.getAge() > 1.0E-6) || !(surface.getAge() >= unit.getUage()) || !(surface.getAge() <= unit.getLage())) continue;
            if (((String)string).length() > 0) {
                string = (String)string + ",";
            }
            string = (String)string + surface.getName();
        }
        return string;
    }

    void insert(Surface surface) {
        boolean inserted = false;
        int i = 0;
        for (Surface s : this.surfaces) {
            if (s.getSortEntry().compareTo(surface.getSortEntry()) > 0) {
                this.surfaces.add(i, surface);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            this.surfaces.add(surface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGDUnitBase getHigherUnit(IGDUnitBase unit, int genHier) {
        if (this.units.isEmpty()) {
            return null;
        }
        Object object = this.lockObj;
        synchronized (object) {
            for (IGDUnitBase u : this.units) {
                if (u.getHier() != genHier || !(unit.getUage() >= u.getUage()) || !(unit.getLage() <= u.getLage())) continue;
                return u;
            }
            return null;
        }
    }

    public void setStatus(Color status) {
        this.status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IGDScheme copyToSequence(SBdb ws, IGDScheme scheme) throws SQLException, SBException {
        if (scheme.igdType == 10) {
            throw new IllegalArgumentException("Attempt to convert sequence scheme to sequence scheme");
        }
        if (scheme.igdType == 26) {
            throw new IllegalArgumentException("Attempt to convert chron scheme to sequence scheme");
        }
        IGDScheme sqSch = new IGDScheme(ws, 10, scheme.name, scheme.comments, null, SequenceType.DEPOSITIONAL, 0);
        sqSch.schID = scheme.getSchID();
        int oldMaxHier = IGDIntervalZone.getNHier(scheme.getIGDType(), true);
        int maxHier = IGDIntervalZone.getNHier(10, true);
        int factor = oldMaxHier - maxHier;
        sqSch.units = new LinkedList<IGDUnitBase>();
        Object object = sqSch.lockObj;
        synchronized (object) {
            for (IGDUnitBase unit : scheme.units) {
                IGDUnitBase.Builder copy = IGDUnitBase.Builder.copyOf((IGDUnit)unit, ws);
                if (copy.getHier() - factor > 0) {
                    copy.hier(unit.getHier() - factor);
                }
                if (copy.getHier() == 0) {
                    copy.hier(1);
                }
                sqSch.units.add(copy.build(unit.getUnitID(), sqSch.getSchID()));
            }
            sqSch.surfaces = new LinkedList<Surface>();
        }
        return sqSch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MatchSchemes> findMatches(SBdb db, List<IGDIntervalZone> informalTerms) throws SQLException, SBException {
        if (!this.units.isEmpty() && !(this.units.get(0) instanceof IGDUnitBase)) {
            return null;
        }
        boolean isLithostrat = !this.units.isEmpty() && this.units.get(0) instanceof LithostratUnit || this.igdType == 2;
        LinkedList<MatchSchemes> matchSchemes = new LinkedList<MatchSchemes>();
        Object object = this.lockObj;
        synchronized (object) {
            try (Statement stmt = db.getDatabase().createStatement();){
                for (IGDUnitBase unit : this.units) {
                    String sql = !isLithostrat ? "SELECT sch_id FROM " + db.DBTableName("IGD_DICT") + " WHERE ucase(name)=" + SB.DBString((String)unit.getName().toUpperCase()) + " AND igd_type=" + this.igdType : "SELECT sch_id FROM " + db.DBTableName("IGD_DICT_LSTRAT") + " WHERE ucase(name)=" + SB.DBString((String)unit.getName().toUpperCase());
                    ResultSet rs = stmt.executeQuery(db.modQuery(sql));
                    while (rs.next()) {
                        int msSchID = rs.getInt("sch_id");
                        boolean found = false;
                        for (MatchSchemes ms : matchSchemes) {
                            if (ms.scheme.getSchID() != msSchID) continue;
                            ++ms.nMatches;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        matchSchemes.add(new MatchSchemes(db.getIGDScheme(msSchID)));
                    }
                }
                HashSet<String> uniqueNames = new HashSet<String>();
                for (IGDIntervalZone zone : informalTerms) {
                    if (zone.getUppInf() != null && zone.getUppInf().length() > 0 && !uniqueNames.contains(zone.getUppInf().toUpperCase())) {
                        uniqueNames.add(zone.getUppInf().toUpperCase());
                    }
                    if (zone.getLowInf() == null || zone.getLowInf().length() <= 0 || uniqueNames.contains(zone.getLowInf().toUpperCase())) continue;
                    uniqueNames.add(zone.getLowInf().toUpperCase());
                }
                for (String term : uniqueNames) {
                    String sql = !isLithostrat ? "SELECT sch_id FROM " + db.DBTableName("IGD_DICT") + " WHERE ucase(name)=" + SB.DBString((String)term) + " AND igd_type=" + this.igdType : "SELECT sch_id FROM " + db.DBTableName("IGD_DICT_LSTRAT") + " WHERE ucase(name)=" + SB.DBString((String)term);
                    ResultSet rs = stmt.executeQuery(db.modQuery(sql));
                    while (rs.next()) {
                        int msSchID = rs.getInt("sch_id");
                        boolean found = false;
                        for (MatchSchemes ms : matchSchemes) {
                            if (ms.scheme.getSchID() != msSchID) continue;
                            ++ms.nInformalMatches;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        matchSchemes.add(new MatchSchemes(db.getIGDScheme(msSchID), uniqueNames.size()));
                    }
                }
                if (matchSchemes.isEmpty()) {
                    System.out.println("No Matching schemes");
                }
                for (MatchSchemes ms : matchSchemes) {
                    System.out.println("Scheme name: " + ms.scheme.toString() + "\t\tNo. Matches: " + ms.nMatches);
                }
            }
        }
        return matchSchemes;
    }

    public List<MatchSchemes> findMatches(SBdb db) throws SQLException, SBException {
        if (this.igdType != 10) {
            throw new SBException("Attempt to findMatches on non-sequence scheme");
        }
        if (this.surfaces.isEmpty()) {
            return null;
        }
        LinkedList<MatchSchemes> matchSchemes = new LinkedList<MatchSchemes>();
        try (Statement stmt = db.getDatabase().createStatement();){
            for (Surface surface : this.surfaces) {
                String sql = "SELECT sch_id FROM " + db.DBTableName("SURFACE") + " WHERE ucase(name)=" + SB.DBString((String)surface.getName().toUpperCase());
                ResultSet rs = stmt.executeQuery(db.modQuery(sql));
                while (rs.next()) {
                    int msSchID = rs.getInt("sch_id");
                    boolean found = false;
                    for (MatchSchemes ms : matchSchemes) {
                        if (ms.scheme.getSchID() != msSchID) continue;
                        ++ms.nMatches;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    matchSchemes.add(new MatchSchemes(db.getIGDScheme(msSchID)));
                }
            }
        }
        if (matchSchemes.isEmpty()) {
            System.out.println("No Matching schemes");
        }
        for (MatchSchemes ms : matchSchemes) {
            System.out.println("Scheme name: " + ms.scheme.toString() + "\t\tNo. Matches: " + ms.nMatches);
        }
        return matchSchemes;
    }

    public List<Surface> getSurfaces() throws SQLException {
        if (this.surfaces == null) {
            this.loadSurfaces();
        }
        return this.surfaces;
    }

    public List<Surface> getSurfacesX() {
        LinkedList<Surface> newList = new LinkedList<Surface>();
        newList.addAll(this.surfaces);
        return newList;
    }

    @Override
    public int getID() {
        return this.schID;
    }

    public char getDiscID() {
        return this.discID.getChar();
    }

    public Discipline getDiscipline() {
        return this.discID;
    }

    public SequenceType getSqType() {
        return this.sqType;
    }

    public int compareTo(Object rhs) {
        return this.name.compareToIgnoreCase(rhs.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IGDUnit findUnit(double uAge, double lAge, int hier) {
        int upper = (int)(uAge * 1000000.0);
        int lower = (int)(lAge * 1000000.0);
        if (lower == 0) {
            return null;
        }
        Object object = this.lockObj;
        synchronized (object) {
            for (IGDUnitBase unit : this.units) {
                if (unit.getHier() != hier || unit.getUageInt() > upper || unit.getLageInt() < lower) continue;
                return (IGDUnit)unit;
            }
            return null;
        }
    }

    int getSchID() {
        return this.schID;
    }

    public int getParentSchID() {
        return this.parentID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IGDUnit> getUnits() throws SQLException {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.units == null) {
                this.loadUnits();
            }
            return this.getUnitsX();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IGDUnit> getUnitsX() {
        LinkedList<IGDUnit> newList = new LinkedList<IGDUnit>();
        Object object = this.lockObj;
        synchronized (object) {
            for (IGDUnitBase base : this.units) {
                if (!(base instanceof IGDUnit)) continue;
                newList.add((IGDUnit)base);
            }
            return newList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LithostratUnit> getLithostratUnits() throws SQLException {
        LinkedList<LithostratUnit> newList = new LinkedList<LithostratUnit>();
        Object object = this.lockObj;
        synchronized (object) {
            if (this.units == null) {
                this.loadUnits();
            }
            for (IGDUnitBase base : this.units) {
                if (!(base instanceof LithostratUnit)) continue;
                newList.add((LithostratUnit)base);
            }
            return newList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IGDUnitBase> getUnitBases() {
        if (this.units == null) {
            return null;
        }
        Object object = this.lockObj;
        synchronized (object) {
            return new LinkedList<IGDUnitBase>(this.units);
        }
    }

    public int getnUnits() {
        if (this.units != null) {
            return this.units.size();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMinAge() throws SQLException {
        double minAge = 99999.0;
        boolean assigned = false;
        Object object = this.lockObj;
        synchronized (object) {
            this.loadUnits();
            for (IGDUnitBase unit : this.units) {
                if (unit.getUage() == null || !(unit.getUage() < minAge)) continue;
                minAge = unit.getUage();
                assigned = true;
            }
            return assigned ? minAge : 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMaxAge() throws SQLException {
        double maxAge = 0.0;
        boolean assigned = false;
        Object object = this.lockObj;
        synchronized (object) {
            this.loadUnits();
            for (IGDUnitBase unit : this.units) {
                if (unit.getLage() == null || !(unit.getLage() > maxAge)) continue;
                maxAge = unit.getLage();
                assigned = true;
            }
            return assigned ? maxAge : 500.0;
        }
    }

    public SBdb getDatabase() {
        return this.sbdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnit(IGDUnitClass b) throws InvalidFieldException {
        Object object = this.lockObj;
        synchronized (object) {
            for (IGDUnitBase u : this.units) {
                if (u.getSortEntry().equals(b.getSortEntry())) {
                    throw new InvalidFieldException("Unit '" + u.getName() + "' already exists in scheme: " + this.name);
                }
                if (b.getName().compareToIgnoreCase(u.getName()) != 0) continue;
                throw new InvalidFieldException("Unit: '" + b.getName() + "' already exists in scheme as: " + u.getName() + " in scheme: " + this.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface getSurface(int surfaceID) throws SQLException {
        Object object = this.lockObj;
        synchronized (object) {
            for (Surface surface : this.getSurfaces()) {
                if (surface.getSurfaceID() != surfaceID) continue;
                return surface;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface getSurface(String surfaceName, Surface.SurfaceType type) throws SQLException {
        String nameOnly = "";
        Object nameAndType = "";
        if (type == null) {
            type = Surface.SurfaceType.parseType(surfaceName, Surface.SurfaceType.SB);
            nameOnly = surfaceName.replace(type.toString(), "").trim();
        } else if (!surfaceName.contains(type.toString())) {
            nameAndType = surfaceName + " " + type.toString();
        } else {
            nameOnly = surfaceName.replace(type.toString(), "").trim();
        }
        Object object = this.lockObj;
        synchronized (object) {
            for (Surface surface : this.getSurfaces()) {
                if ((surface.getName().equals(surfaceName) || surface.getName().equals(nameOnly)) && Surface.SurfaceType.isEquivalent(surface.getType(), type)) {
                    return surface;
                }
                if (!surface.getName().equals(nameAndType)) continue;
                return surface;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface getSurface(double age, String surfaceName, Surface.SurfaceType type) throws SQLException {
        if (age < 1.0E-6) {
            return null;
        }
        if (type == null) {
            type = Surface.SurfaceType.parseType(surfaceName, Surface.SurfaceType.SB);
        }
        Object object = this.lockObj;
        synchronized (object) {
            for (Surface surface : this.getSurfaces()) {
                if (!(Math.abs(age - surface.getAge()) < 1.0E-6) || !Surface.SurfaceType.isEquivalent(surface.getType(), type)) continue;
                return surface;
            }
            return null;
        }
    }

    public Surface getSurface(String surfaceName) throws SQLException {
        return this.getSurface(surfaceName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface getSurface(String surfaceName, boolean matchCase) throws SQLException {
        Surface matcher = null;
        Object object = this.lockObj;
        synchronized (object) {
            for (Surface surface : this.getSurfaces()) {
                if ((!matchCase || !surface.getName().equals(surfaceName)) && !surface.getName().equalsIgnoreCase(surfaceName)) continue;
                if (matcher == null) {
                    matcher = surface;
                    continue;
                }
                matcher = null;
                break;
            }
        }
        return matcher;
    }

    public int findSurfaceID(int unitID, Surface.SurfaceType type) throws SQLException, SBException {
        IGDUnit unit = this.findUnit(unitID);
        if (unit != null) {
            return this.findSurfaceID(unit.getName() + " " + String.valueOf((Object)type), type, true);
        }
        System.out.println("IGDScheme.getSurfaceID Attempt to get surface ID for unknown unit: " + unitID);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findSurfaceID(String unitName, Surface.SurfaceType type, boolean create) throws SQLException, SBException {
        Object object = this.lockObj;
        synchronized (object) {
            for (Surface surface : this.getSurfaces()) {
                if (!surface.getName().equals(unitName) && !surface.getName().equals(unitName + " " + String.valueOf((Object)type))) continue;
                return surface.getSurfaceID();
            }
            if (create) {
                try {
                    Surface surface = this.addSurface(new Surface.Builder(this.sbdb).name(unitName + " " + String.valueOf((Object)type)).type(type));
                    return surface.getSurfaceID();
                }
                catch (InvalidFieldException e) {
                    throw new SBException(e.getMessage());
                }
            }
            return 0;
        }
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(Statement stmt) throws SQLException, SBException {
        SbugsLink notifier;
        Object object;
        if (this.units != null) {
            object = this.lockObj;
            synchronized (object) {
                notifier = this.igdType == 26 ? Chron.refresh(this.sbdb, this.schID, this.units, stmt) : (this.igdType == 2 ? LithostratUnit.refresh(this.sbdb, this.schID, this.units, stmt) : IGDUnit.refresh(this.sbdb, this.schID, this.units, stmt));
                if (notifier != null) {
                    this.setChanged();
                    this.notifyObservers(notifier);
                }
            }
        }
        if (this.surfaces != null) {
            object = this.lockObj;
            synchronized (object) {
                notifier = Surface.refresh(stmt, this.sbdb, this.schID, this.surfaces);
                if (notifier != null) {
                    this.setChanged();
                    this.notifyObservers(notifier);
                }
            }
        }
        this.interpRefresh = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSurfaces() throws SQLException {
        if (this.surfaces != null) {
            return;
        }
        Object object = this.lockObj;
        synchronized (object) {
            this.loadUnits();
            this.surfaces = new LinkedList<Surface>();
            if (this.sbdb != null && this.sbdb.isConnected()) {
                Surface.load(this.sbdb, this.schID, this.surfaces, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkNewUnit(IGDUnitBase.Builder builder) throws InvalidFieldException {
        if (this.units == null) {
            return;
        }
        Object object = this.lockObj;
        synchronized (object) {
            LinkedList<IGDUnitClass> list = new LinkedList<IGDUnitClass>();
            list.addAll(this.units);
            list.add(builder);
            IGDScheme.checkSchemeUnitsBase(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkUpdatedUnit(IGDUnitBase.Builder builder) throws InvalidFieldException {
        if (this.units == null) {
            return;
        }
        Object object = this.lockObj;
        synchronized (object) {
            LinkedList<IGDUnitClass> list = new LinkedList<IGDUnitClass>();
            for (IGDUnitBase unit : this.units) {
                if (builder.getOriginalID() == unit.getUnitID()) continue;
                list.add(unit);
            }
            list.add(builder);
            IGDScheme.checkSchemeUnitsBase(list);
        }
    }

    public IGDUnitBase addUnit(IGDUnitBase.Builder builder) throws InvalidFieldException, SQLException, SBException {
        return this.addUnit(builder, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGDUnitBase addUnit(IGDUnitBase.Builder builder, int workspaceUnitID) throws InvalidFieldException, SQLException, SBException {
        IGDUnitBase unit;
        if (builder.getOriginalID() > 0) {
            throw new IllegalArgumentException("Attempt to update original unit in IGDScheme.addUnit");
        }
        if (builder.getModel() != this.sbdb) {
            throw new IllegalArgumentException("Attempt to add unit to scheme from different workspace");
        }
        if (workspaceUnitID > 0 && this.findUnitBase(workspaceUnitID) != null) {
            throw new IllegalArgumentException("Unit with ID " + workspaceUnitID + " already exists in scheme as " + String.valueOf(this.findUnitBase(workspaceUnitID)));
        }
        this.checkNewUnit(builder);
        if (this.sbdb.isConnected()) {
            if (!this.canWrite(this.sbdb, null)) {
                throw new SBException(this.getDeniedReason(this.sbdb, "scheme (unit)", true));
            }
            unit = builder.store(this.igdType, this.schID);
        } else {
            builder.status(NOTSTORED);
            if (workspaceUnitID <= 0) {
                workspaceUnitID = this.getNewUnitID();
            }
            unit = builder.build(workspaceUnitID, this.schID);
        }
        Object object = this.lockObj;
        synchronized (object) {
            IGDUnitBase.insert(unit, this.units);
        }
        this.setChanged();
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUnit(IGDUnitBase unit) throws SQLException {
        if (this.units == null) {
            throw new IllegalStateException("units null in IGDScheme.deleteUnit");
        }
        Object object = this.lockObj;
        synchronized (object) {
            if (!this.units.contains(unit)) {
                throw new IllegalStateException("Attempt to delete unit when not in scheme");
            }
            unit.delete(null);
            this.units.remove(unit);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSurface(Surface surface) throws SQLException {
        if (this.surfaces == null) {
            throw new IllegalStateException("surfaces null in IGDScheme.deleteSurface");
        }
        Object object = this.lockObj;
        synchronized (object) {
            if (!this.surfaces.contains(surface)) {
                throw new IllegalStateException("Attempt to delete surface when not in scheme");
            }
            surface.delete(null);
            this.surfaces.remove(surface);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGDUnitBase updateUnit(IGDUnitBase.Builder builder) throws SQLException, InvalidFieldException, SBException {
        if (this.units == null) {
            throw new IllegalStateException("units null in IGDScheme.updateUnit");
        }
        if (builder.getOriginalID() < 0) {
            throw new IllegalArgumentException("Attempt to update unit using builder with no original link");
        }
        if (this.findUnitBase(builder.getOriginalID()) == null) {
            throw new IllegalArgumentException("Scheme can only update its own units");
        }
        if (!this.canWrite(this.sbdb, null)) {
            throw new SBException(this.getDeniedReason(this.sbdb, "scheme (unit)", true));
        }
        Object object = this.lockObj;
        synchronized (object) {
            if (!this.findUnitBase(builder.getOriginalID()).getName().equals(builder.getName()) && this.findUnit(builder.getName()) != null) {
                throw new InvalidFieldException("Cannot update unit: new name already exists in scheme");
            }
            ArrayList<IGDUnitBase> toUpdate = new ArrayList<IGDUnitBase>();
            IGDUnitBase original = this.findUnitBase(builder.getOriginalID());
            if (builder.getHier() != original.getHier() || (builder.getUage() != null ? Math.abs(builder.getUage() - original.getUage()) > 1.0E-7 : original.getUage() == null) || (builder.getLage() == null ? original.getLage() == null : Math.abs(builder.getLage() - original.getLage()) > 1.0E-7)) {
                LinkedList<Object> bases = new LinkedList<Object>();
                for (IGDUnitBase base : this.units) {
                    if (base == original) continue;
                    if (base instanceof IGDUnit && (((IGDUnit)base).getAgeRef(true) == original.getUnitID() || ((IGDUnit)base).getAgeRef(false) == original.getUnitID())) {
                        IGDUnit.Builder[] b = (IGDUnit.Builder)IGDUnit.Builder.copyOf(base, this.sbdb);
                        boolean[] blArray = new boolean[]{true, false};
                        int n = blArray.length;
                        for (int i = 0; i < n; ++i) {
                            boolean bool = blArray[i];
                            if (b.getigdAge(bool).getRefID() != original.getUnitID()) continue;
                            b.getigdAge(bool).calcAge(builder);
                        }
                        bases.add(b);
                        toUpdate.add(base);
                        continue;
                    }
                    bases.add(base);
                }
                bases.add(builder);
                IGDScheme.checkSchemeUnitsBase(bases);
                this.checkChildSchemes(bases);
            }
            if (builder instanceof IGDUnit.Builder) {
                IGDUnit.Builder b = (IGDUnit.Builder)builder;
                IGDUnit o = (IGDUnit)original;
                if (b.getigdAge(true).getConfidence() != o.getConfidence(true) || b.getigdAge(false).getConfidence() != o.getConfidence(false)) {
                    IGDUnit.Builder[] arr = new IGDUnit.Builder[2];
                    for (IGDUnitBase unit : this.units) {
                        if (builder.getHier() == unit.getHier()) {
                            if (b.getigdAge(true).getConfidence() != o.getConfidence(true) && Math.abs(builder.getUage() - unit.getLage()) < 1.0E-6) {
                                arr[0] = (IGDUnit.Builder)IGDUnitBase.Builder.copyOf(unit, this.sbdb);
                                arr[0].getigdAge(false).setConfidence(b.getigdAge(true).getConfidence());
                            }
                            if (b.getigdAge(false).getConfidence() != o.getConfidence(false) && Math.abs(builder.getLage() - unit.getUage()) < 1.0E-6) {
                                arr[1] = (IGDUnit.Builder)IGDUnitBase.Builder.copyOf(unit, this.sbdb);
                                arr[1].getigdAge(true).setConfidence(b.getigdAge(false).getConfidence());
                            }
                        }
                        if (arr[0] == null || arr[1] == null) continue;
                        break;
                    }
                    for (IGDUnit.Builder confUpdate : arr) {
                        if (confUpdate == null) continue;
                        ((IGDUnitBase.Builder)confUpdate).store(this.igdType, this.schID);
                    }
                }
            }
            IGDUnitBase unit = builder.store(this.igdType, this.schID);
            if (!toUpdate.isEmpty()) {
                try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                    for (IGDUnitBase base : toUpdate) {
                        if (!(base instanceof IGDUnit)) continue;
                        ((IGDUnit)base).updateAges((IGDUnit)original, stmt);
                    }
                }
            }
            this.setChanged();
            if (this.igdType != 26) {
                this.sbdb.refreshIntervals(this);
            }
            if (this.igdType == 3 || this.igdType == 10) {
                this.updateChildren();
            }
            return unit;
        }
    }

    public Surface updateSurface(Surface.Builder builder) throws SQLException, InvalidFieldException, SBException {
        if (this.surfaces == null) {
            throw new IllegalStateException("surfaces null in IGDScheme.updateSurface");
        }
        if (builder.getOriginalID() < 0) {
            throw new IllegalArgumentException("Attempt to update surface using builder with no original link");
        }
        Surface orig = this.findSurface(builder.getOriginalID());
        if (orig == null) {
            throw new IllegalArgumentException("Scheme can only update its own surfaces");
        }
        if (!(orig.getName().equals(builder.getName()) && orig.getType() == builder.getType() || this.getSurface(builder.getName(), builder.getType()) == null)) {
            throw new InvalidFieldException("Cannot update surface: new name/type combination already exists in scheme");
        }
        if (!this.canWrite(this.sbdb, null)) {
            throw new SBException(this.getDeniedReason(this.sbdb, "scheme (surface)", true));
        }
        Surface surface = builder.store(this.schID);
        this.setChanged();
        return surface;
    }

    public IGDUnit findUnit(String unitName) throws SQLException {
        IGDUnitBase found = this.findUnitBase(unitName);
        if (found != null && found instanceof IGDUnit) {
            return (IGDUnit)found;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGDUnitBase findUnitBase(String unitName) throws SQLException {
        this.loadUnits();
        Object object = this.lockObj;
        synchronized (object) {
            for (IGDUnitBase unit : this.units) {
                if (!unit.getName().equalsIgnoreCase(unitName)) continue;
                return unit;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGDUnitBase findUnitBase(String unitName, int hier) throws SQLException {
        this.loadUnits();
        Object object = this.lockObj;
        synchronized (object) {
            for (IGDUnitBase unit : this.units) {
                if (!unit.getName().equalsIgnoreCase(unitName) || unit.getHier() != hier) continue;
                return unit;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGDUnit findUnit(int hier, double uAge, double lAge) throws SQLException {
        this.loadUnits();
        IGDUnitBase match = null;
        Object object = this.lockObj;
        synchronized (object) {
            for (IGDUnitBase unit : this.units) {
                if (unit.getHier() != hier || unit.getUage() == null || unit.getLage() == null || !(Math.abs(uAge - unit.getUage()) < 1.0E-6) || !(Math.abs(lAge - unit.getLage()) < 1.0E-6)) continue;
                match = unit;
                break;
            }
            return (IGDUnit)match;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface findSurface(double age, Surface.SurfaceType type) throws SBException, SQLException {
        this.getSurfaces();
        Object object = this.lockObj;
        synchronized (object) {
            for (Surface surface : this.surfaces) {
                if (!(Math.abs(surface.getAge() - age) < 0.001)) continue;
                if (surface.getType() == type) {
                    return surface;
                }
                if (!Surface.SurfaceType.isSBorCC(surface.getType()) || !Surface.SurfaceType.isSBorCC(type)) continue;
                return surface;
            }
            return null;
        }
    }

    public IGDUnit findUnit(int unitID) throws SQLException {
        IGDUnitBase base = this.findUnitBase(unitID);
        if (base != null) {
            return (IGDUnit)base;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGDUnitBase findUnitBase(int unitID) throws SQLException {
        if (unitID == 0) {
            return null;
        }
        this.loadUnits();
        Object object = this.lockObj;
        synchronized (object) {
            for (IGDUnitBase unit : this.units) {
                if (unit.getUnitID() != unitID) continue;
                return unit;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface findSurface(int surfaceID) throws SQLException {
        if (surfaceID == 0) {
            return null;
        }
        Object object = this.lockObj;
        synchronized (object) {
            for (Surface surface : this.getSurfaces()) {
                if (surface.getSurfaceID() != surfaceID) continue;
                return surface;
            }
            return null;
        }
    }

    public IGDUnit findUnit(double age) throws SBException, SQLException {
        return this.findUnit(age, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGDUnit findUnit(double age, boolean upper, boolean ignoreZero) throws SQLException {
        this.loadUnits();
        if (age < 1.0E-6 && ignoreZero) {
            return null;
        }
        IGDUnitBase match = null;
        Object object = this.lockObj;
        synchronized (object) {
            for (IGDUnitBase unit : this.units) {
                if (!unit.hasAges()) continue;
                if (upper) {
                    if (!(age >= unit.getUage()) || !(age < unit.getLage())) continue;
                    match = unit;
                    continue;
                }
                if (!(age > unit.getUage()) || !(age <= unit.getLage())) continue;
                match = unit;
            }
            return (IGDUnit)match;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IGDUnit> findMatchingUnits(IGDUnitBase unit, IGDIntervalZone.BoundaryType bndType) throws SQLException {
        this.loadUnits();
        HashSet<IGDUnit> matches = new HashSet<IGDUnit>();
        if (!(unit != null && this.units.contains(unit) && unit instanceof IGDUnit && ((IGDUnit)unit).hasAges())) {
            return matches;
        }
        Object object = this.lockObj;
        synchronized (object) {
            for (IGDUnitBase u : this.units) {
                if (u == unit || !((IGDUnit)u).hasAges()) continue;
                double d = bndType == IGDIntervalZone.BoundaryType.TOP ? unit.getUage() : unit.getLage();
                Double d2 = bndType == IGDIntervalZone.BoundaryType.TOP ? u.getUage() : u.getLage();
                if (!(Math.abs(d - d2) < 0.001)) continue;
                matches.add((IGDUnit)u);
            }
            return matches;
        }
    }

    public static IGDUnitBase.Builder findUnit(LinkedList<IGDUnitBase.Builder> list, double age, boolean upper) {
        if (age < 1.0E-6) {
            return null;
        }
        IGDUnitBase.Builder match = null;
        for (IGDUnitBase.Builder unit : list) {
            if (unit.getUage() == null || unit.getLage() == null) continue;
            if (upper) {
                if (!(age >= unit.getUage()) || !(age < unit.getLage())) continue;
                match = unit;
                continue;
            }
            if (!(age > unit.getUage()) || !(age <= unit.getLage())) continue;
            match = unit;
        }
        return match;
    }

    public Color getDbStatus() {
        return this.link != null ? this.link.status : null;
    }

    public String dbStatusString() {
        return this.link != null ? this.link.statusString() : null;
    }

    public Color getStatus() {
        if (this.status == UNKNOWN && this.name.length() > 0) {
            this.status = this.schID != 0 ? STORED : NOTSTORED;
        }
        return this.status;
    }

    public boolean isArchived() {
        return this.archived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUnits() throws SQLException {
        if (this.units != null) {
            return;
        }
        this.units = new LinkedList<IGDUnitBase>();
        if (!this.sbdb.isConnected()) {
            return;
        }
        Object object = this.lockObj;
        synchronized (object) {
            IGDScheme parentScheme = null;
            if (this.parentID > 0) {
                parentScheme = this.sbdb.getIGDScheme(this.parentID);
            }
            switch (this.igdType) {
                case 3: 
                case 4: 
                case 10: {
                    IGDUnit.loadAll(this.sbdb, this.schID, this.igdType, this.units, parentScheme);
                    break;
                }
                case 2: {
                    LithostratUnit.loadAll(this.sbdb, this.schID, this.units);
                    break;
                }
                case 26: {
                    Chron.loadAll(this.sbdb, this.schID, this.igdType, this.units);
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal IGD Type for IGDScheme: " + this.igdType);
                }
            }
            for (IGDUnitBase unit : this.units) {
                if (!(unit instanceof IGDUnit)) continue;
                ((IGDUnit)unit).calcAges(parentScheme, this, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDeletedUnits(List<IGDUnitBase.Builder> list) throws SQLException {
        if (!this.sbdb.isConnected() || this.igdType == 26) {
            return true;
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            Object object = this.lockObj;
            synchronized (object) {
                for (IGDUnitBase base : this.units) {
                    String sql;
                    ResultSet rs;
                    boolean deleted = true;
                    for (IGDUnitBase.Builder builder : list) {
                        if (builder.getOriginalID() != base.getUnitID()) continue;
                        deleted = false;
                        break;
                    }
                    if (!deleted || !(rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT top_id FROM " + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " WHERE sch_id=" + this.schID + " AND (upp_zone=" + base.getUnitID() + " OR low_zone=" + base.getUnitID() + ")"))).next()) continue;
                    stmt.close();
                    boolean bl = false;
                    return bl;
                }
            }
        }
        {
            return true;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void linkUnits() throws SQLException {
        if (this.link == null) {
            return;
        }
        for (IGDUnitBase unit : this.getUnitBases()) {
            if (unit.getLink() != null && (unit.getLink().getSchID() != this.link.getID() || this.link.findUnitBase(unit.getLink().getUnitID()) == null)) {
                unit.setLink(null, null);
            }
            if (unit.getLink() != null) continue;
            if (this.igdType != 2) {
                unit.setLink(this.link.findUnitBase(unit.getName(), unit.getHier()), null);
                continue;
            }
            this.loadUnits();
            matches = new LinkedList<IGDUnitBase>();
            it = 0;
            terminate = false;
            block10: while (unit.getLink() == null && it < 3) {
                matches.clear();
                for (IGDUnitBase u : this.link.units) {
                    switch (it) {
                        case 0: {
                            if (!u.getName().equalsIgnoreCase(unit.getName())) break;
                            matches.add(u);
                            break;
                        }
                        case 1: {
                            if (!u.getName().equalsIgnoreCase(unit.getName()) || u.getHier() != unit.getHier()) break;
                            matches.add(u);
                            break;
                        }
                        case 2: {
                            if (!u.getSortEntry().equals(unit.getSortEntry())) break;
                            matches.add(u);
                        }
                    }
                }
                if (terminate) break;
                if (matches.size() == 1) {
                    unit.setLink((IGDUnitBase)matches.get(0), null);
                    break;
                }
                if (!matches.isEmpty()) ** GOTO lbl-1000
                switch (it) {
                    case 0: {
                        break block10;
                    }
                    case 1: 
                    case 2: {
                        --it;
                        terminate = true;
                        continue block10;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        ++it;
                        continue block10;
                    }
                }
            }
            if (unit.getLink() != null || matches.isEmpty()) continue;
            for (IGDUnitBase match : matches) {
                if (!((LithostratUnit)unit).getArea().equals(((LithostratUnit)match).getArea())) continue;
                unit.setLink(match, null);
                break;
            }
            if (unit.getLink() != null) continue;
            unit.setLink((IGDUnitBase)matches.get(0), null);
        }
    }

    public void linkSurfaces() throws SQLException {
        if (this.link == null) {
            return;
        }
        for (Surface surface : this.getSurfacesX()) {
            if (surface.getLink() != null && (surface.getLink().getSchID() != this.link.getID() || this.link.findSurface(surface.getLink().getSurfaceID()) == null)) {
                surface.setLink(null);
            }
            if (surface.getLink() != null) continue;
            surface.setLink(this.link.getSurface(surface.getName(), surface.getType()));
        }
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        if (this.isArchived()) {
            return this.name + " [archived]";
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getComments() {
        return this.comments;
    }

    static List<IGDScheme> getSchemes(SBdb sbdb, int igdType) throws SQLException {
        if (!sbdb.isConnected()) {
            return null;
        }
        LinkedList<IGDScheme> schemes = new LinkedList<IGDScheme>();
        String sql = "SELECT sch_id,igd_type,archive,disc_id,sqtype,name,comments,parent," + Audit.sqlFieldString() + ",acm FROM " + sbdb.DBTableName("IGD_SCH");
        if (igdType > 0) {
            sql = sql + " WHERE igd_type=" + igdType;
        }
        sql = sql + " ORDER BY name";
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int schID = rs.getInt("sch_id");
                int type = rs.getInt("igd_type");
                boolean archived = rs.getBoolean("archive");
                char discID = SB.getDBChar((ResultSet)rs, (String)"disc_id");
                char sqType = SB.getDBChar((ResultSet)rs, (String)"sqtype");
                String name = rs.getString("name");
                String comments = rs.getString("comments");
                int parentID = rs.getInt("parent");
                IGDScheme scheme = null;
                try {
                    scheme = new IGDScheme(sbdb, type, name, comments, Discipline.getDisc((char)discID), SequenceType.get(sqType), 0);
                }
                catch (IllegalArgumentException e) {
                    if (type == 4 && Discipline.getDisc((char)discID) == null) {
                        StackError.showStackError((String)"Error loading scheme", (Throwable)new SBException(e.getMessage() + "\n Discipline reset to 'Micro'. You must open and save this scheme."));
                        scheme = new IGDScheme(sbdb, type, name, comments, Discipline.MICRO, SequenceType.get(sqType), 0);
                    }
                    throw e;
                }
                scheme.schID = schID;
                scheme.archived = archived;
                scheme.parentID = parentID;
                scheme.audit = new Audit(rs);
                scheme.setAcm(rs.getInt("acm"));
                scheme.units = null;
                scheme.surfaces = null;
                scheme.status = STORED;
                schemes.add(scheme);
            }
        }
        return schemes;
    }

    IGDScheme(SBdb sbdb, int schID) throws SQLException, SBException {
        block7: {
            super("IGD_SCH", "SCH_ID", false, true);
            this.name = "";
            this.comments = "";
            this.units = null;
            this.surfaces = null;
            this.lockObj = new Object();
            this.audit = new Audit();
            this.status = UNKNOWN;
            this.link = null;
            this.interpRefresh = false;
            String sql = "SELECT name,comments,igd_type,archive,disc_id,sqtype,parent," + Audit.sqlFieldString() + ",acm FROM " + sbdb.DBTableName("IGD_SCH") + " WHERE sch_id=" + schID;
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                if (rs.next()) {
                    this.sbdb = sbdb;
                    this.name = rs.getString("name");
                    this.comments = rs.getString("comments");
                    this.igdType = rs.getInt("igd_type");
                    this.archived = rs.getBoolean("archive");
                    this.discID = Discipline.getDisc((char)SB.getDBChar((ResultSet)rs, (String)"disc_id"));
                    this.sqType = SequenceType.get(SB.getDBChar((ResultSet)rs, (String)"sqtype"));
                    this.parentID = rs.getInt("parent");
                    this.schID = schID;
                    this.audit = new Audit(rs);
                    this.setAcm(rs.getInt("acm"));
                    break block7;
                }
                throw new SBException("Scheme with ID=" + schID + ", not found in database");
            }
        }
    }

    static IGDScheme load(SBdb sbdb, int schID, IGDScheme scheme) throws SQLException, SBException {
        if (scheme != null && scheme.getSchID() != schID) {
            throw new IllegalArgumentException("Attempt to refresh scheme using different ID");
        }
        IGDScheme temp = new IGDScheme(sbdb, schID);
        if (scheme != null) {
            scheme.name = temp.name;
            scheme.discID = temp.discID;
            scheme.sqType = temp.sqType;
            scheme.parentID = temp.parentID;
            scheme.audit = new Audit(temp.audit);
            scheme.setAcm(temp.getAcm());
        } else {
            scheme = temp;
        }
        return scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSurfaces() throws SBException {
        Object object = this.lockObj;
        synchronized (object) {
            for (Surface surface : this.surfaces) {
                if (surface.getName() == null || surface.getName().length() == 0) {
                    throw new SBException("Surface name missing");
                }
                for (Surface compare : this.surfaces) {
                    if (compare == surface) continue;
                    if (compare.getName().equalsIgnoreCase(surface.getName())) {
                        throw new SBException("Duplicate surface name: " + compare.getName());
                    }
                    if (!(compare.getAge() > 0.0) || !(Math.abs(compare.getAge() - surface.getAge()) < 1.0E-5)) continue;
                    throw new SBException("Duplicate ages in surfaces: " + compare.getName() + " / " + surface.getName());
                }
            }
        }
    }

    private static IGDUnitBase.Builder findBuilder(List<IGDUnitBase.Builder> list, int unitID) {
        for (IGDUnitBase.Builder b : list) {
            if (b.getOriginalID() != unitID) continue;
            return b;
        }
        return null;
    }

    private static Surface.Builder findBuilder(int surfaceID, List<Surface.Builder> list) {
        for (Surface.Builder b : list) {
            if (b.getOriginalID() != surfaceID) continue;
            return b;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(List<IGDUnitBase.Builder> builders, List<Surface.Builder> surfaceBuilders, String name, String comments, Discipline discID, SequenceType sqType, int parentID) throws SQLException, SBException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            if (!this.canWrite(this.sbdb, stmt)) {
                throw new SBException(this.getDeniedReason(this.sbdb, "scheme", true));
            }
            Audit temp = new Audit(this.audit);
            LinkedList<IGDUnitBase> newUnits = new LinkedList<IGDUnitBase>();
            Collections.sort(builders, new UnitHierComparator());
            for (IGDUnitBase.Builder object : builders) {
                IGDUnitBase base = object.store(this.igdType, this.schID);
                newUnits.add(base);
                for (IGDUnitBase.Builder b2 : builders) {
                    if (b2 == object || !(b2 instanceof IGDUnit.Builder)) continue;
                    if (((IGDUnit.Builder)b2).u_age_ref == object) {
                        ((IGDUnit.Builder)b2).u_age_ref = base;
                    }
                    if (((IGDUnit.Builder)b2).l_age_ref != object) continue;
                    ((IGDUnit.Builder)b2).l_age_ref = base;
                }
            }
            Collections.sort(newUnits);
            LinkedList<Surface> newSurfaces = null;
            if (this.isSequence()) {
                newSurfaces = new LinkedList<Surface>();
                for (Surface.Builder builder : surfaceBuilders) {
                    newSurfaces.add(builder.store(this.schID));
                }
                Collections.sort(newSurfaces);
            }
            if (!name.equals(this.name) || sqType != this.getSqType() || discID != this.discID || this.parentID != parentID) {
                String string = "UPDATE " + this.sbdb.DBTableName("IGD_SCH") + " set name=" + SB.DBString((String)name) + ",comments=" + SB.DBString((String)comments) + ",sqtype=" + SB.DBChar((char)SequenceType.getChar(sqType)) + ",disc_id=" + SB.DBChar((char)Discipline.getChar((Discipline)discID)) + ",parent=" + String.valueOf(parentID > 0 ? Integer.valueOf(parentID) : "NULL") + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.schID;
                stmt.executeUpdate(this.sbdb.modQuery(string));
            }
            Object object = this.lockObj;
            synchronized (object) {
                Iterator<IGDUnitBase> itr = this.units.iterator();
                while (itr.hasNext()) {
                    IGDUnitBase unit = itr.next();
                    if (IGDScheme.findBuilder(builders, unit.getUnitID()) != null) continue;
                    unit.delete(stmt);
                    itr.remove();
                }
                if (this.isSequence()) {
                    Iterator<Surface> itrS = this.surfaces.iterator();
                    while (itrS.hasNext()) {
                        Surface surface = itrS.next();
                        if (IGDScheme.findBuilder(surface.getSurfaceID(), surfaceBuilders) != null) continue;
                        surface.delete(stmt);
                        itrS.remove();
                    }
                }
            }
            this.units = newUnits;
            this.surfaces = newSurfaces;
            this.name = name;
            this.sqType = sqType;
            this.discID = discID;
            this.parentID = parentID;
            this.audit = temp;
            if (!this.isSequence()) {
                this.sbdb.refreshIntervals(this);
            }
        }
        this.updateChildren();
        this.setChanged();
    }

    public void setArchived(boolean archived) throws SQLException {
        if (this.archived != archived) {
            String sql = "UPDATE " + this.sbdb.DBTableName("IGD_SCH") + " set ARCHIVE=? WHERE sch_id=" + this.schID;
            try (PreparedStatement pStmt = this.sbdb.getDatabase().prepareStatement(sql);){
                pStmt.setBoolean(1, archived);
                pStmt.execute();
            }
            this.archived = archived;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChildren() throws SQLException {
        Collection<Integer>[] parentOccs = this.getParentOccs();
        for (Integer id : parentOccs[0]) {
            IGDScheme childScheme = this.sbdb.getIGDScheme(id);
            if (childScheme.getIGDType() == 26 || childScheme.getIGDType() == 2) continue;
            Object object = childScheme.lockObj;
            synchronized (object) {
                childScheme.loadUnits();
                Statement stmt = this.sbdb.getDatabase().createStatement();
                LinkedList<IGDUnitBase> list = new LinkedList<IGDUnitBase>(childScheme.units);
                Collections.sort(list, new UnitHierComparator());
                try {
                    for (IGDUnitClass iGDUnitClass : list) {
                        IGDUnit unit = (IGDUnit)iGDUnitClass;
                        unit.calcAges(this, childScheme, stmt);
                    }
                }
                finally {
                    stmt.close();
                }
                if (childScheme.isSequence()) {
                    childScheme.updateChildren();
                }
            }
        }
    }

    public int getNoccs() throws SQLException {
        if (this.igdType == 26) {
            return 0;
        }
        String sql = this.igdType == 10 ? "SELECT count(s.surface_id) as nOcc FROM " + this.sbdb.DBTableName("SURFACE") + " s, " + this.sbdb.DBTableName("SQPICK") + " p WHERE p.surface_id=s.surface_id AND s.sch_id=" + this.schID : "SELECT count(sch_id) as nOcc FROM " + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " WHERE sch_id=" + this.schID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            int nOccs = 0;
            if (rs.next()) {
                nOccs = rs.getInt("nOcc");
            }
            int n = nOccs;
            return n;
        }
    }

    public List<String> getOccs() throws SQLException {
        if (this.igdType == 26) {
            assert (false);
            return null;
        }
        ArrayList<String> occs = new ArrayList<String>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs;
            String sql;
            if (this.igdType != 10) {
                sql = "SELECT DISTINCT w.well_id,w.well_name,w.well_code FROM " + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " i," + this.sbdb.DBTableName("WELLS") + " w WHERE i.sch_id=" + this.schID + " AND i.well_id=w.well_id ORDER BY well_name";
                rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int wellID = rs.getInt("well_id");
                    occs.add((this.igdType == 10 ? "Intervals: " : "") + rs.getString("well_name") + " (" + rs.getString("well_code") + ")");
                }
            }
            if (this.igdType == 10) {
                sql = "SELECT DISTINCT w.well_id,w.well_name,w.well_code FROM " + this.sbdb.DBTableName("SQPICK") + " i," + this.sbdb.DBTableName("SURFACE") + " s," + this.sbdb.DBTableName("WELLS") + " w WHERE i.surface_id=s.surface_id AND s.sch_id=" + this.schID + " AND i.well_id=w.well_id ORDER BY well_name";
                rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    rs.getInt("well_id");
                    occs.add("Picks: " + rs.getString("well_name") + " (" + rs.getString("well_code") + ")");
                }
            }
        }
        return occs;
    }

    public int getNHdrOccs() throws SQLException {
        if (this.igdType == 26) {
            assert (false);
            return 0;
        }
        String sql = "SELECT count(sch_id) as nOcc FROM " + this.sbdb.DBTableName("IGD_HDR") + " WHERE sch_id=" + this.schID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            int nOccs = 0;
            if (rs.next()) {
                nOccs = rs.getInt("nOcc");
            }
            int n = nOccs;
            return n;
        }
    }

    public Collection<Integer>[] getParentOccs() throws SQLException {
        HashSet[] arr = new HashSet[3];
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT sch_id FROM " + this.sbdb.DBTableName("IGD_SCH") + " WHERE parent=" + this.schID + " AND sch_id<>" + this.schID;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            HashSet<Integer> set = new HashSet<Integer>();
            while (rs.next()) {
                set.add(rs.getInt("sch_id"));
            }
            arr[0] = set;
            sql = "SELECT std_id FROM " + this.sbdb.DBTableName("CMPSTD") + " WHERE parent=" + this.schID;
            ResultSet rs2 = stmt.executeQuery(this.sbdb.modQuery(sql));
            HashSet<Integer> set2 = new HashSet<Integer>();
            while (rs2.next()) {
                set2.add(rs2.getInt("std_id"));
            }
            arr[1] = set2;
            sql = "SELECT curve_id FROM " + this.sbdb.DBTableName("AGE_CURVE") + " WHERE sch_id=" + this.schID;
            ResultSet rs3 = stmt.executeQuery(this.sbdb.modQuery(sql));
            HashSet<Integer> set3 = new HashSet<Integer>();
            while (rs3.next()) {
                set3.add(rs3.getInt("curve_id"));
            }
            arr[2] = set3;
        }
        return arr;
    }

    public List<WellOccRec> getWellOccs() throws SQLException, SBException {
        ArrayList<WellOccRec> occs;
        if (this.igdType == 26) {
            assert (false);
            return null;
        }
        Object sql = "SELECT DISTINCT w.well_id, w.well_name, w.well_alt_name, w.well_code,w.acm FROM ";
        sql = this.igdType != 10 ? (String)sql + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " i," + this.sbdb.DBTableName("WELLS") + " w WHERE i.sch_id=" + this.schID + " AND i.well_id=w.well_id ORDER BY well_name" : (String)sql + this.sbdb.DBTableName("SQPICK") + " i," + this.sbdb.DBTableName("SURFACE") + " s," + this.sbdb.DBTableName("WELLS") + " w WHERE i.surface_id=s.surface_id AND s.sch_id=" + this.schID + " AND i.well_id=w.well_id ORDER BY well_name";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
            occs = new ArrayList<WellOccRec>();
            while (rs.next()) {
                WellOccRec wellRef = new WellOccRec(rs.getInt("well_id"), rs.getString("well_name"), rs.getString("well_alt_name"), rs.getString("well_code"), rs.getInt("acm"));
                try {
                    if (wellRef.acm() > 0) {
                        this.sbdb.getWell(wellRef.wellID());
                    }
                    occs.add(wellRef);
                }
                catch (SBException sbe) {
                    System.out.println("No permission to access well with ID: " + wellRef.wellID() + " Exception: " + sbe.getMessage());
                }
            }
        }
        return occs;
    }

    public List getWellInterps(Well well) throws SQLException, SBException {
        ArrayList<WellInterp> occs;
        if (this.igdType == 26) {
            assert (false);
            return null;
        }
        String sql = this.igdType == 10 ? "SELECT DISTINCT i.interp_id FROM " + this.sbdb.DBTableName("SQPICK") + " i," + this.sbdb.DBTableName("SURFACE") + " s WHERE i.surface_id=s.surface_id AND s.sch_id=" + this.schID + " AND i.well_id=" + well.getWellID() : "SELECT DISTINCT i.interp_id FROM " + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " i WHERE i.sch_id=" + this.schID + " AND i.well_id=" + well.getWellID();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            occs = new ArrayList<WellInterp>();
            boolean hasDefaultInterp = false;
            well.loadInterps();
            while (rs.next()) {
                int interpID = rs.getInt("interp_id");
                if (interpID <= 0 && hasDefaultInterp) continue;
                occs.add(well.getAddInterp(this.sbdb.getInterp(interpID)));
                if (interpID != 0) continue;
                hasDefaultInterp = true;
            }
        }
        return occs;
    }

    public final void storeDetails() throws SQLException, SBException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql;
            if (!this.canWrite(this.sbdb, stmt)) {
                throw new SBException(this.getDeniedReason(this.sbdb, "scheme", true));
            }
            if (this.schID <= 0) {
                this.schID = this.sbdb.nextControl("IGD_SCH", "SCH_ID");
                sql = "INSERT INTO " + this.sbdb.DBTableName("IGD_SCH") + " (sch_id,name,igd_type,disc_id,sqtype,parent," + Audit.sqlFieldString() + ") VALUES (" + this.schID + "," + SB.DBString((String)this.name) + "," + this.igdType + "," + SB.DBChar((char)Discipline.getChar((Discipline)this.discID)) + "," + SB.DBChar((char)SequenceType.getChar(this.sqType)) + "," + String.valueOf(this.parentID > 0 ? Integer.valueOf(this.parentID) : "NULL") + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
            } else {
                sql = "UPDATE " + this.sbdb.DBTableName("IGD_SCH") + " set name=" + SB.DBString((String)this.name) + ",comments=" + SB.DBString((String)this.comments) + ",sqtype=" + SB.DBChar((char)this.sqType.getCharType()) + ",disc_id=" + SB.DBChar((char)Discipline.getChar((Discipline)this.discID)) + ",parent=" + String.valueOf(this.parentID > 0 ? Integer.valueOf(this.parentID) : "NULL") + "," + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.schID;
            }
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    public void setName(String name) throws SBException, SQLException {
        if (this.schID > 0 && this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set name");
        }
        this.name = name;
    }

    public static void checkSchemeUnits(List<IGDUnitBase.Builder> units) throws InvalidFieldException {
        for (IGDUnitBase.Builder baseBuilder : units) {
            if (!(baseBuilder instanceof IGDUnit.Builder)) continue;
            IGDUnit.Builder builder = (IGDUnit.Builder)baseBuilder;
            if (builder.u_age_ref != null && builder.u_age_ref instanceof IGDUnitBase.Builder && builder.u_age_ref.getHier() >= builder.getHier()) {
                throw new InvalidFieldException("Illegal unit reference: " + String.valueOf(builder) + " derives upper boundary from " + String.valueOf(builder.u_age_ref) + " at equal or lower hierarchy level");
            }
            if (builder.l_age_ref == null || !(builder.l_age_ref instanceof IGDUnitBase.Builder) || builder.l_age_ref.getHier() < builder.getHier()) continue;
            throw new InvalidFieldException("Illegal unit reference: " + String.valueOf(builder) + " derives lower boundary from " + String.valueOf(builder.l_age_ref) + " at equal or lower hierarchy level");
        }
        IGDScheme.checkSchemeUnitsBase(units);
    }

    private static void checkSchemeUnitsBase(List<? extends IGDUnitClass> units) throws InvalidFieldException {
        if (units.isEmpty()) {
            return;
        }
        for (IGDUnitClass iGDUnitClass : units) {
            if (iGDUnitClass.getName().isEmpty()) {
                throw new InvalidFieldException("No name for unit with age: " + iGDUnitClass.getUage() + "-" + iGDUnitClass.getLage());
            }
            if (iGDUnitClass.getHier() == 0) {
                throw new InvalidFieldException("Hierarchy level not specified for unit: '" + iGDUnitClass.getName() + "'");
            }
            if (iGDUnitClass.hasAges() && iGDUnitClass.getUage() > iGDUnitClass.getLage()) {
                throw new InvalidFieldException("Youngest age is greater than oldest age for unit : '" + iGDUnitClass.getName() + "'");
            }
            if (iGDUnitClass instanceof LithostratUnitClass) {
                LithostratUnitClass lStratUnit = (LithostratUnitClass)iGDUnitClass;
                if (lStratUnit.getAge(0) > lStratUnit.getAge(3)) {
                    throw new InvalidFieldException("Youngest age is greater than oldest age for West of unit : '" + iGDUnitClass.getName() + "'");
                }
                if (lStratUnit.getAge(1) > lStratUnit.getAge(2)) {
                    throw new InvalidFieldException("Youngest age is greater than oldest age for East of unit : '" + iGDUnitClass.getName() + "'");
                }
                if (lStratUnit.getX(0) > lStratUnit.getX(1)) {
                    throw new InvalidFieldException("West greater than East at youngest '" + iGDUnitClass.getName() + "'");
                }
                if (lStratUnit.getX(3) > lStratUnit.getX(2)) {
                    throw new InvalidFieldException("West greater than East at oldest '" + iGDUnitClass.getName() + "'");
                }
                if (LithostratUnit.hasAges(lStratUnit) && Math.abs(lStratUnit.getAge(0) - lStratUnit.getAge(3)) < 0.01 && (double)Math.abs(lStratUnit.getX(0) - lStratUnit.getX(3)) < 0.01 && Math.abs(lStratUnit.getAge(1) - lStratUnit.getAge(2)) < 0.01 && (double)Math.abs(lStratUnit.getX(1) - lStratUnit.getX(2)) < 0.01) {
                    throw new InvalidFieldException("Oldest and Youngest points equal East and West of '" + iGDUnitClass.getName() + "'");
                }
            }
            for (IGDUnitClass iGDUnitClass2 : units) {
                if (iGDUnitClass2 == iGDUnitClass) continue;
                if (iGDUnitClass instanceof LithostratUnitClass) {
                    LithostratUnitClass A = (LithostratUnitClass)iGDUnitClass;
                    LithostratUnitClass B = (LithostratUnitClass)iGDUnitClass2;
                    IGDScheme.testLithostratUnits(A, B);
                    continue;
                }
                if (iGDUnitClass.getHier() != iGDUnitClass2.getHier()) continue;
                if (iGDUnitClass.getName().equalsIgnoreCase(iGDUnitClass2.getName())) {
                    throw new InvalidFieldException("Duplicate unit name: " + iGDUnitClass.getName());
                }
                if (!iGDUnitClass.hasAges() || !iGDUnitClass2.hasAges()) continue;
                if (iGDUnitClass.getUage() < iGDUnitClass2.getUage() && iGDUnitClass.getLage() > iGDUnitClass2.getUage()) {
                    throw new InvalidFieldException("Unit : '" + iGDUnitClass.getName() + "' overlaps unit : '" + iGDUnitClass2.getName() + "' (check unit type).");
                }
                if (!iGDUnitClass.getUage().equals(iGDUnitClass2.getUage()) || !(iGDUnitClass.getLage() > iGDUnitClass.getUage()) || !(iGDUnitClass2.getLage() > iGDUnitClass2.getUage())) continue;
                throw new InvalidFieldException("Unit : '" + iGDUnitClass.getName() + "' overlaps unit : '" + iGDUnitClass2.getName() + "' (check unit type).");
            }
        }
    }

    public static void testLithostratUnits(LithostratUnitClass A, LithostratUnitClass B) throws InvalidFieldException {
        Area areaB;
        if (!LithostratUnit.hasAges(A) || !LithostratUnit.hasAges(B)) {
            return;
        }
        Area areaA = A.getArea();
        if (areaA.equals(areaB = B.getArea())) {
            if (A.getHier() == B.getHier()) {
                throw new InvalidFieldException("Units '" + String.valueOf(A) + "' and '" + String.valueOf(B) + "' are equal at the same hierarchy level");
            }
            return;
        }
        Area intersection = new Area(areaA);
        intersection.intersect(areaB);
        if (!intersection.isEmpty()) {
            if (intersection.equals(areaA)) {
                if (A.getHier() <= B.getHier()) {
                    throw new InvalidFieldException("Unit '" + String.valueOf(B) + "' contains unit '" + String.valueOf(A) + "' but belongs to equal or lower level.");
                }
            } else if (intersection.equals(areaB)) {
                if (B.getHier() <= A.getHier()) {
                    throw new InvalidFieldException("Unit '" + String.valueOf(A) + "' contains unit '" + String.valueOf(B) + "' but belongs to equal or lower level.");
                }
            } else {
                throw new InvalidFieldException("Units '" + String.valueOf(A) + "' and '" + String.valueOf(B) + "' overlap.\n(For lithostratigraphic schemes, a unit cannot intersect another unit regardless of hierachy)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSchemeSurfaces() throws SBException {
        Object object = this.lockObj;
        synchronized (object) {
            for (Surface surface : this.surfaces) {
                if (surface.getName().isEmpty()) {
                    throw new SBException("Surface name blank at age: " + surface.getAge());
                }
                this.updateSurfaceStatus(surface);
            }
        }
    }

    public static void checkSchemeSurfaces(List<Surface.Builder> surfaces) throws InvalidFieldException {
        if (surfaces.isEmpty()) {
            return;
        }
        for (Surface.Builder surface : surfaces) {
            if (surface.getName().isEmpty()) {
                throw new InvalidFieldException("Surface name blank at age: " + surface.getAge());
            }
            for (Surface.Builder builder : surfaces) {
                if (builder == surface || !surface.getName().equalsIgnoreCase(builder.getName()) || surface.getType() != builder.getType() && (!Surface.SurfaceType.isSBorCC(surface.getType()) || !Surface.SurfaceType.isSBorCC(builder.getType()))) continue;
                throw new InvalidFieldException("Duplicate surface: " + surface.getName() + " " + surface.getTypeString());
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void checkChildSchemes(List<? extends IGDUnitClass> units) throws InvalidFieldException, SQLException, SBException {
        if (!this.sbdb.isConnected()) {
            return;
        }
        if (this.igdType != 3 && this.igdType != 10) {
            return;
        }
        Collection<Integer>[] parentOccs = this.getParentOccs();
        if (parentOccs[0].isEmpty() && parentOccs[1].isEmpty()) {
            return;
        }
        ArrayList<IGDUnit.Builder> changedUnits = new ArrayList<IGDUnit.Builder>();
        for (IGDUnitClass unit : units) {
            IGDUnit.Builder builder;
            if (!(unit instanceof IGDUnit.Builder) || (builder = (IGDUnit.Builder)unit).equalsOriginalAge()) continue;
            changedUnits.add(builder);
        }
        if (changedUnits.isEmpty()) {
            return;
        }
        Collection<Integer> schIDs = parentOccs[0];
        if (!schIDs.isEmpty()) {
            LinkedList updatedScheme = new LinkedList();
            for (Integer id : schIDs) {
                IGDScheme childScheme = this.sbdb.getIGDScheme(id);
                childScheme.loadUnits();
                updatedScheme.clear();
                LinkedList<IGDUnit.Builder> justCopied = new LinkedList<IGDUnit.Builder>();
                LinkedList<IGDUnit.Builder> updated = new LinkedList<IGDUnit.Builder>();
                for (IGDUnit u : childScheme.getUnitsX()) {
                    IGDUnit.Builder copy = (IGDUnit.Builder)IGDUnitBase.Builder.copyOf(u, this.sbdb);
                    boolean hadReferences = false;
                    for (IGDUnit.Builder b : changedUnits) {
                        if (u.getAgeRef(true) == b.getOriginalID()) {
                            copy.getigdAge(true).calcAge(b);
                            hadReferences = true;
                        }
                        if (u.getAgeRef(false) != b.getOriginalID()) continue;
                        copy.getigdAge(false).calcAge(b);
                        hadReferences = true;
                    }
                    if (hadReferences) {
                        updated.add(copy);
                        continue;
                    }
                    justCopied.add(copy);
                }
                if (updated.isEmpty()) continue;
                for (IGDUnit.Builder mightNeedUpdating : justCopied) {
                    if (mightNeedUpdating.getigdAge(true).getRefID() <= 0) continue;
                    for (IGDUnitBase.Builder hasChanged : updated) {
                        if (hasChanged.getOriginalID() == mightNeedUpdating.getigdAge(true).getRefID()) {
                            mightNeedUpdating.getigdAge(true).calcAge(hasChanged);
                        }
                        if (hasChanged.getOriginalID() != mightNeedUpdating.getigdAge(false).getRefID()) continue;
                        mightNeedUpdating.getigdAge(false).calcAge(hasChanged);
                    }
                }
                updatedScheme.addAll(justCopied);
                updatedScheme.addAll(updated);
                try {
                    IGDScheme.checkSchemeUnitsBase(updatedScheme);
                }
                catch (InvalidFieldException ife) {
                    throw new InvalidFieldException("Update causes error in child scheme: '" + String.valueOf(childScheme) + "':\n" + ife.getMessage());
                }
                if (!childScheme.isSequence()) continue;
                childScheme.checkChildSchemes(updatedScheme);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUnitStatus(IGDUnitBase unit) {
        Object object = this.lockObj;
        synchronized (object) {
            for (IGDUnitBase unit2 : this.units) {
                if (unit == unit2 || unit.getLink() == unit2) continue;
                if (unit instanceof LithostratUnit) {
                    try {
                        IGDScheme.testLithostratUnits((LithostratUnit)unit, (LithostratUnit)unit2);
                    }
                    catch (InvalidFieldException e) {
                        System.out.println("Setting status to CONFLICT for unit " + String.valueOf(unit) + ": " + e.getMessage());
                        unit.status = IGDUnit.CONFLICT;
                    }
                    continue;
                }
                if (unit.getName().equalsIgnoreCase(unit2.getName()) && unit.getHier() == unit2.getHier()) {
                    unit.status = IGDUnit.CONFLICT;
                    break;
                }
                if (unit.getHier() != unit2.getHier() || unit.getUage() == null || unit2.getUage() == null || unit.getLage() == null || unit2.getLage() == null) continue;
                if (unit.getUage() != null && unit.getUage() > unit2.getUage() && unit.getUage() < unit2.getLage()) {
                    unit.status = IGDUnit.CONFLICT;
                    break;
                }
                if (unit.getLage() != null && unit.getLage() > unit2.getUage() && unit.getLage() < unit2.getLage()) {
                    unit.status = SbugsStatus.CONFLICT;
                    break;
                }
                if (unit.getUage() != null && unit.getLage() != null && unit.getUage() < unit2.getUage() && unit.getLage() > unit2.getLage()) {
                    unit.status = SbugsStatus.CONFLICT;
                    break;
                }
                if (!(Math.abs(unit.getUage() - unit2.getUage()) < 1.0E-6) && !(Math.abs(unit.getLage() - unit2.getLage()) < 1.0E-6) || !(unit.getLage() > unit.getUage()) || !(unit2.getLage() > unit2.getUage())) continue;
                unit.status = IGDUnit.CONFLICT;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSurfaceStatus(Surface surface) throws SBException {
        Object object = this.lockObj;
        synchronized (object) {
            Iterator<Surface> it2 = this.surfaces.iterator();
            surface.setStatus(NOTSTORED);
            while (it2.hasNext()) {
                Surface surface2 = it2.next();
                if (surface == surface2 || !surface.getName().equalsIgnoreCase(surface2.getName()) || surface.getType() != surface2.getType()) continue;
                surface.setStatus(CONFLICT);
                throw new SBException("Duplicate surface: " + surface.getName() + " " + surface.getTypeString());
            }
        }
    }

    public static boolean isOverlap(List<IGDUnitBase.Builder> list, IGDUnitBase.Builder newUnit) {
        if (newUnit.getUage() < 1.0E-6 && newUnit.getLage() < 1.0E-6) {
            return false;
        }
        for (IGDUnitBase.Builder unit : list) {
            if (unit.getHier() != newUnit.getHier() || unit.getUage() < newUnit.getUage() && unit.getLage() <= newUnit.getUage() || unit.getLage() > newUnit.getLage() && unit.getUage() >= newUnit.getLage()) continue;
            return true;
        }
        return false;
    }

    void delete() throws SQLException, SBException {
        if (this.schID <= 0) {
            throw new IllegalStateException("Attempt to delete unstored scheme");
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            if (!this.canWrite(this.sbdb, stmt)) {
                throw new SBException(this.getDeniedReason(this.sbdb, "scheme", true));
            }
            String[] sql = new String[7];
            switch (this.igdType) {
                case 26: {
                    sql[1] = "DELETE FROM " + this.sbdb.DBTableName("CHRON") + " WHERE sch_id=" + this.schID;
                    break;
                }
                case 10: {
                    sql[3] = "DELETE FROM " + this.sbdb.DBTableName("SURFACE") + " WHERE sch_id=" + this.schID;
                }
                default: {
                    sql[0] = "UPDATE " + this.sbdb.DBTableName("IGD_DICT") + " set u_unit_ref=NULL,l_unit_ref=NULL WHERE sch_id=" + this.schID;
                    sql[1] = "DELETE FROM " + this.sbdb.DBTableName("IGD_DICT_LSTRAT") + " WHERE sch_id=" + this.schID;
                    sql[2] = "DELETE FROM " + this.sbdb.DBTableName("IGD_DICT") + " WHERE sch_id=" + this.schID;
                    sql[4] = "DELETE FROM " + this.sbdb.DBTableName("IGD_HDR") + " WHERE sch_id=" + this.schID;
                }
            }
            sql[5] = "DELETE FROM " + this.sbdb.DBTableName("IGD_SCH_ACL") + " WHERE sch_id=" + this.schID;
            sql[6] = "DELETE FROM " + this.sbdb.DBTableName("IGD_SCH") + " WHERE sch_id=" + this.schID;
            for (int i = 0; i < sql.length; ++i) {
                if (sql[i] == null) continue;
                int n = stmt.executeUpdate(this.sbdb.modQuery(sql[i]));
                if (i != 4 || n <= 0) continue;
                System.out.println("Number of header records deleted with scheme: " + n);
            }
        }
        this.status = NOTSTORED;
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDEX(FileWriter out, String eol) throws IOException {
        out.write("[" + IGDInterval.getIGDName(this.igdType) + " Scheme]" + eol);
        out.write("Scheme name = " + this.name + eol);
        out.write("Scheme ID : " + this.schID + eol);
        if (this.discID != null) {
            out.write("Discipline: " + this.discID.getAdj() + eol);
        }
        out.write("Number of units : " + this.units.size() + eol);
        out.write(eol);
        Object object = this.lockObj;
        synchronized (object) {
            Iterator<IGDUnitBase> it = this.units.iterator();
            while (it.hasNext()) {
                it.next().writeDEX(out, eol, this.igdType);
            }
        }
        out.write(eol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeXML(BufferedWriter out, int indent) throws IOException, SQLException, SBException {
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<StratigraphicScheme Name=\"" + SB.getXMLstring((String)this.name) + "\">\n");
        String ind = SB.getXMLIndent((int)(indent + 3));
        out.write(ind + "<SchemeType>" + IGDInterval.getIGDName(this.igdType) + "</SchemeType>\n");
        out.write(ind + "<SchemeName>" + SB.getXMLstring((String)this.name) + "</SchemeName>\n");
        if (this.comments != null && !this.comments.isBlank()) {
            out.write(ind + "<Comments>" + SB.getXMLstring((String)this.name) + "</Comments>\n");
        }
        out.write(ind + "<SchemeID>" + this.schID + "</SchemeID>\n");
        if (this.discID != null) {
            out.write(ind + "<Discipline>" + this.discID.getNoun() + "</Discipline>\n");
        }
        if (this.sqType != null) {
            out.write(ind + "<SequenceModel>" + this.sqType.getCharType() + "</SequenceModel>\n");
        }
        this.audit.writeXML(out, indent + 3);
        this.loadUnits();
        Object object = this.lockObj;
        synchronized (object) {
            Iterator<IGDUnitBase> it = this.units.iterator();
            while (it.hasNext()) {
                it.next().writeXML(out, indent + 3, this.igdType, this.units);
            }
            Iterator<Surface> its = this.getSurfaces().iterator();
            while (its.hasNext()) {
                out.write(ind + "<Surface>\n");
                its.next().writeXML(out, indent + 3);
                out.write(ind + "</Surface>\n");
            }
        }
        out.write(ind1 + "</StratigraphicScheme>\n");
    }

    public void linkInformal(UnlinkedInterval interval, IGDUnitBase unit, boolean updateInformal) throws SQLException, SBException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            Audit intervalAudit = new Audit();
            String sql = "UPDATE " + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " SET upp_zone=" + unit.getUnitID() + "," + intervalAudit.sqlUpdate(this.sbdb, stmt, false);
            if (updateInformal) {
                sql = sql + ",upp_inf=" + SB.DBString((String)unit.getName());
            }
            sql = sql + " WHERE sch_id=" + this.schID + " AND upp_zone is null AND upp_inf=" + SB.DBString((String)interval.informalName);
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " SET low_zone=" + unit.getUnitID() + "," + intervalAudit.sqlUpdate(this.sbdb, stmt, false);
            if (updateInformal) {
                sql = sql + ",low_inf=" + SB.DBString((String)unit.getName());
            }
            sql = sql + " WHERE sch_id=" + this.schID + " AND low_zone is null AND low_inf=" + SB.DBString((String)interval.informalName);
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.sbdb.refreshIntervals(this);
    }

    public void linkInformal(UnlinkedInterval interval) throws SQLException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            Audit intervalAudit = new Audit();
            String sql = "UPDATE " + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " SET upp_zone=" + interval.matchingUnitID + "," + intervalAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.schID + " AND upp_zone is null AND upp_inf=" + SB.DBString((String)interval.informalName);
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " SET low_zone=" + interval.matchingUnitID + "," + intervalAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.schID + " AND low_zone is null AND low_inf=" + SB.DBString((String)interval.informalName);
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.interpRefresh = true;
    }

    public List<UnlinkedInterval> getUnlinkedIntervals() throws SQLException {
        LinkedList<UnlinkedInterval> list = new LinkedList<UnlinkedInterval>();
        String sql = "SELECT upp_inf FROM " + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " WHERE sch_id=" + this.schID + " AND upp_zone is null";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs1 = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs1.next()) {
                String infName = rs1.getString("upp_inf");
                if (infName == null || infName.length() <= 0) continue;
                boolean occurs = false;
                for (UnlinkedInterval item : list) {
                    if (!item.informalName.equals(infName)) continue;
                    ++item.occs;
                    occurs = true;
                    break;
                }
                if (occurs) continue;
                UnlinkedInterval item = new UnlinkedInterval(infName);
                IGDUnitBase unit = this.findUnitBase(infName);
                if (unit != null) {
                    item.matchingUnitID = unit.getUnitID();
                }
                list.add(item);
            }
            sql = "SELECT low_inf FROM " + this.sbdb.DBTableName(this.igdType == 2 ? "IGD_LSTRAT" : "IGD") + " WHERE sch_id=" + this.schID + " AND low_zone is null";
            ResultSet rs2 = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs2.next()) {
                UnlinkedInterval item;
                String infName = rs2.getString("low_inf");
                if (infName == null || infName.length() <= 0) continue;
                boolean occurs = false;
                for (UnlinkedInterval item2 : list) {
                    if (!item2.informalName.equals(infName)) continue;
                    ++item2.occs;
                    occurs = true;
                    break;
                }
                if (occurs) continue;
                item = new UnlinkedInterval(infName);
                item.occs = 1;
                IGDUnitBase unit = this.findUnitBase(infName);
                if (unit != null) {
                    item.matchingUnitID = unit.getUnitID();
                }
                list.add(item);
            }
        }
        Collections.sort(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fixDictIGDtype(SBdb SB2) throws SQLException {
        String sql = "SELECT DISTINCT s.sch_id, s.igd_type FROM " + SB2.DBTableName("IGD_SCH") + " s, " + SB2.DBTableName("IGD_DICT") + " d WHERE d.sch_id=s.sch_id AND (d.igd_type is null OR d.igd_type=0)";
        try (Statement stmt2 = null;
             Statement stmt = SB2.getDatabase().createStatement();){
            stmt2 = SB2.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
            while (rs.next()) {
                int schID = rs.getInt("sch_id");
                int igdType = rs.getInt("igd_type");
                sql = "UPDATE " + SB2.DBTableName("IGD_DICT") + " SET igd_type=" + igdType + " WHERE sch_id=" + schID + " AND (igd_type is null OR igd_type=0)";
                stmt2.executeUpdate(SB2.modQuery(sql));
            }
        }
    }

    public static void fixMfs(SBdb db, IGDScheme scheme) throws SQLException {
        try (Statement stmt = db.getDatabase().createStatement();
             Statement stmt2 = db.getDatabase().createStatement();){
            String sql = "SELECT surface_id, name FROM " + db.DBTableName("SURFACE") + " WHERE sch_id=" + scheme.getID() + " AND type=3";
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                int id = rs.getInt("surface_id");
                String name = rs.getString("name");
                sql = "SELECT count(*) AS nOccs FROM " + db.DBTableName("sqpick") + " WHERE surface_id=" + id;
                ResultSet rs2 = stmt2.executeQuery(db.modQuery(sql));
                int nOccs = 0;
                if (rs2.next()) {
                    nOccs = rs2.getInt("nOccs");
                }
                if (nOccs <= 0) continue;
                System.out.println("Processing: " + name);
                if (name.endsWith("SB")) {
                    name = name.substring(0, name.lastIndexOf("SB")).trim();
                }
                if ((rs2 = stmt2.executeQuery(db.modQuery(sql = "SELECT surface_id, name FROM " + db.DBTableName("SURFACE") + " WHERE sch_id=" + scheme.getID() + " AND type=1 AND name like " + SB.DBString((String)(name + "%"))))).next()) {
                    int mfsID = rs2.getInt("surface_id");
                    System.out.println("Switching to: " + mfsID + " name: " + rs2.getString("name"));
                    sql = "UPDATE " + db.DBTableName("sqpick") + " SET surface_id=" + mfsID + " WHERE surface_id=" + id;
                    int nRows = stmt2.executeUpdate(db.modQuery(sql));
                    System.out.println(nRows + " rows updated");
                    continue;
                }
                System.out.println("Cannot find MFS for: " + name);
            }
        }
    }

    public int getIGDType() {
        return this.igdType;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public Date getModified() {
        return this.audit.modified;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public void clearLink() {
        for (IGDUnitBase unit : this.units) {
            unit.link = null;
            unit.status = SbugsStatus.NOTSTORED;
        }
        for (Surface s : this.surfaces) {
            s.setLink(null);
        }
        this.link = null;
    }

    public void setLink(IGDScheme dbScheme) throws SQLException {
        if (this.link == dbScheme) {
            return;
        }
        for (IGDUnitBase unit : this.units) {
            unit.setLink(null, null);
        }
        for (Surface s : this.surfaces) {
            s.setLink(null);
        }
        this.link = dbScheme;
        if (this.link != null) {
            this.link.loadUnits();
            this.link.loadSurfaces();
        }
        this.linkUnits();
        this.linkSurfaces();
        this.updateStatus();
    }

    public IGDScheme getLink() {
        return this.link;
    }

    String statusString(Color status) {
        if (status == NOTSTORED) {
            return "NOT STORED";
        }
        if (status == STORED) {
            return "STORED";
        }
        if (status == PARTSTORED) {
            return "PARTSTORED";
        }
        if (status == CONFLICT) {
            return "CONFLICT";
        }
        return " NOT SET";
    }

    public void updateStatus() throws SQLException {
        if (this.link == null) {
            this.status = NOTSTORED;
            if (this.units != null) {
                for (IGDUnitBase unit : this.units) {
                    unit.status = IGDUnit.NOTSTORED;
                    try {
                        this.updateUnitStatus(unit);
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.surfaces != null) {
                for (Surface surface : this.surfaces) {
                    surface.setStatus(NOTSTORED);
                }
            }
            return;
        }
        this.status = STORED;
        try {
            for (IGDUnitBase unit : this.units) {
                unit.updateStatusLink(this.units);
                this.updateUnitStatus(unit);
                this.link.loadUnits();
                this.link.updateUnitStatus(unit);
                this.status = MergeStatus.merge((Color)this.status, (Color)unit.status);
            }
            for (Surface surface : this.surfaces) {
                this.updateSurfaceStatus(surface);
                if (surface.getStatus() != CONFLICT) {
                    if (surface.getLink() == null) {
                        surface.setLink(this.link.getSurface(surface.getName()));
                    }
                    if (surface.getLink() == null) {
                        surface.setStatus(NOTSTORED);
                    } else {
                        surface.setStatus(STORED);
                        if (!surface.getName().equals(surface.getLink().getName())) {
                            surface.setStatus(CONFLICT);
                        }
                        if (surface.getType() != surface.getLink().getType()) {
                            surface.setStatus(CONFLICT);
                        }
                        if (Math.abs(surface.getAge() - surface.getLink().getAge()) > 0.001) {
                            if (surface.getAge() > 0.001) {
                                surface.setStatus(CONFLICT);
                            } else {
                                surface.setStatus(PARTSTORED);
                            }
                        }
                    }
                }
                this.status = MergeStatus.merge((Color)this.status, (Color)surface.getStatus());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setChanged();
    }

    public static IGDScheme recalibrate(SBdb db, IGDScheme original, IGDScheme chronoOld, IGDScheme chronoNew, String newSchemeName) throws SQLException, SBException, InvalidFieldException {
        if (chronoOld.getIGDType() != 3 || chronoNew.getIGDType() != 3) {
            throw new IllegalArgumentException("Attempt to recalibrate scheme using non-chronostrat schemes");
        }
        LinkedList<IGDUnitBase.Builder> builders = new LinkedList<IGDUnitBase.Builder>(IGDScheme.copyUnits(original, db));
        if (original.getIGDType() == 2) {
            IGDScheme.recalibrateUnitsLithostrat(builders, chronoOld, chronoNew);
        } else {
            IGDScheme.recalibrateReferencedUnits(builders, original, chronoOld, chronoNew);
        }
        IGDScheme.checkSchemeUnits(new LinkedList<IGDUnitBase.Builder>(builders));
        LinkedList<Surface.Builder> surfaceBuilders = new LinkedList<Surface.Builder>();
        if (original.isSequence()) {
            original.loadSurfaces();
            for (Surface surface : original.getSurfacesX()) {
                Surface.Builder builder = new Surface.Builder(db).age(surface.getAge()).name(surface.getName()).magnitude(surface.getMagnitude()).type(surface.getType()).confidence(surface.getConfidence());
                builder.age(chronoNew.getRecalibratedAge(chronoOld, surface.getAge()));
                surfaceBuilders.add(builder);
            }
        }
        IGDScheme scheme = new IGDScheme(db, original.igdType, newSchemeName, original.comments, original.discID, original.sqType, chronoNew.schID);
        scheme.storeDetails();
        scheme.update(builders, surfaceBuilders, scheme.getName(), scheme.getComments(), scheme.getDiscipline(), scheme.getSqType(), chronoNew.schID);
        db.commit();
        db.addIGDScheme(scheme);
        return scheme;
    }

    private static void recalibrateReferencedUnits(LinkedList<IGDUnitBase.Builder> builders, IGDScheme original, IGDScheme chronoOld, IGDScheme chronoNew) throws SQLException {
        int i;
        IGDUnit.Builder builder;
        for (IGDUnitBase.Builder b : builders) {
            builder = (IGDUnit.Builder)b;
            builder.clearOriginal();
            for (i = 0; i < 2; ++i) {
                IGDUnitClass iref;
                IGDUnitClass iGDUnitClass = iref = i == 0 ? builder.u_age_ref : builder.l_age_ref;
                if (iref != null && iref instanceof IGDUnit) {
                    IGDUnit ref = (IGDUnit)iref;
                    if (ref.getSchID() == chronoOld.getID()) {
                        IGDUnit newRef = chronoNew.findUnit(ref.getName());
                        if (newRef != null) {
                            builder.ageRef(i == 0, newRef.getUnitID());
                            if (i == 0) {
                                builder.u_age_ref = newRef;
                                continue;
                            }
                            builder.l_age_ref = newRef;
                            continue;
                        }
                        builder.ageRef(i == 0, 0);
                        builder.age(i == 0, chronoNew.getRecalibratedAge(chronoOld, i == 0 ? builder.getUage() : builder.getLage()));
                        continue;
                    }
                    assert (ref.getSchID() == original.getID());
                    continue;
                }
                builder.age(i == 0, chronoNew.getRecalibratedAge(chronoOld, i == 0 ? builder.getUage() : builder.getLage()));
            }
        }
        for (IGDUnitBase.Builder b : builders) {
            builder = (IGDUnit.Builder)b;
            for (i = 0; i < 2; ++i) {
                IGDAge age = builder.getigdAge(i == 0);
                if (age.getRefID() <= 0) continue;
                age.calcAge(i == 0 ? builder.u_age_ref : builder.l_age_ref);
            }
        }
    }

    private static void recalibrateUnitsLithostrat(LinkedList<IGDUnitBase.Builder> builders, IGDScheme chronoOld, IGDScheme chronoNew) throws SQLException {
        for (IGDUnitBase.Builder b : builders) {
            LithostratUnit.Builder builder = (LithostratUnit.Builder)b;
            builder.clearOriginal();
            for (int i = 0; i < 4; ++i) {
                builder.age(i, chronoNew.getRecalibratedAge(chronoOld, builder.getAge(i)));
            }
        }
    }

    public static Collection<IGDUnitBase.Builder> copyUnits(IGDScheme scheme, SBdb db) throws SQLException, SBException {
        IGDUnitBase.Builder baseBuilder;
        IGDUnitBase.Builder builder;
        IGDScheme parentScheme = null;
        scheme.loadUnits();
        if (scheme.getParentSchID() > 0) {
            parentScheme = db.getIGDScheme(scheme.getParentSchID());
            parentScheme.loadUnits();
        }
        HashMap<Integer, IGDUnitBase.Builder> map = new HashMap<Integer, IGDUnitBase.Builder>();
        for (IGDUnitBase unit : scheme.getUnitBases()) {
            builder = IGDUnitBase.Builder.copyOf(unit, db);
            builder.setNOccs(unit.getNoccs(true));
            map.put(unit.getUnitID(), builder);
        }
        Iterator<IGDUnitBase> iterator = map.values().iterator();
        while (iterator.hasNext() && (baseBuilder = (IGDUnitBase.Builder)((Object)iterator.next())) instanceof IGDUnit.Builder) {
            builder = (IGDUnit.Builder)baseBuilder;
            int[] refIDarr = new int[]{((IGDUnit.Builder)builder).getigdAge(true).getRefID(), ((IGDUnit.Builder)builder).getigdAge(false).getRefID()};
            for (int i = 0; i < 2; ++i) {
                int refID = refIDarr[i];
                if (refID <= 0) continue;
                IGDUnit unit = null;
                if (parentScheme != null) {
                    unit = parentScheme.findUnit(refID);
                }
                if (unit != null) {
                    if (i == 0) {
                        ((IGDUnit.Builder)builder).u_age_ref = unit;
                        continue;
                    }
                    ((IGDUnit.Builder)builder).l_age_ref = unit;
                    continue;
                }
                if (i == 0) {
                    ((IGDUnit.Builder)builder).u_age_ref = (IGDUnitClass)map.get(refID);
                    continue;
                }
                ((IGDUnit.Builder)builder).l_age_ref = (IGDUnitClass)map.get(refID);
            }
        }
        ArrayList<IGDUnitBase.Builder> list = new ArrayList<IGDUnitBase.Builder>(map.values());
        Collections.sort(list, new UnitAgeComparator(new UnitHierComparator()));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Double getRecalibratedAge(IGDScheme chronoOld, Double oldAge) throws SQLException {
        if (oldAge == null) {
            return null;
        }
        double newAge = oldAge;
        if (oldAge < 1.0E-6) {
            return 0.0;
        }
        IGDUnitBase nearest = null;
        double unitSpan = -1.0;
        chronoOld.loadUnits();
        Object object = chronoOld.lockObj;
        synchronized (object) {
            for (IGDUnitBase base : chronoOld.units) {
                double lAge;
                IGDUnit unit = (IGDUnit)base;
                IGDUnit newUnit = this.findUnit(unit.getName());
                if (newUnit == null) continue;
                if (unit.getUage() != null && Math.abs(unit.getUage() - oldAge) < 1.0E-6) {
                    return newUnit.getUage();
                }
                if (unit.getLage() != null && Math.abs(unit.getLage() - oldAge) < 1.0E-6) {
                    return newUnit.getLage();
                }
                if (unit.getUage() == null && unit.getLage() == null) continue;
                double uAge = unit.getUage() == null ? 0.0 : unit.getUage();
                double d = lAge = unit.getLage() == null ? 0.0 : unit.getLage();
                if (!(uAge < oldAge) || !(lAge > oldAge) || !(unitSpan < 0.0) && !(lAge - uAge < unitSpan)) continue;
                unitSpan = lAge - uAge;
                nearest = unit;
            }
            if (nearest != null) {
                IGDUnit newUnit = this.findUnit(nearest.getName());
                newAge = (oldAge - ((IGDUnit)nearest).getUage()) * (newUnit.getLage() - newUnit.getUage()) / (((IGDUnit)nearest).getLage() - ((IGDUnit)nearest).getUage()) + newUnit.getUage();
                newAge = SB.roundToSignificantFigures((double)newAge, (int)4);
            }
            return newAge;
        }
    }

    void recalibrateAge(IGDScheme chronoOld, IGDUnit.Builder unit) throws SQLException {
        IGDUnit newRef;
        IGDUnit oldRef;
        if (unit.getigdAge(true).getRefID() > 0 && (oldRef = chronoOld.findUnit(unit.getigdAge(true).getRefID())) != null && (newRef = this.findUnit(oldRef.getName())) != null) {
            unit.u_age_ref = newRef;
        }
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for scheme: " + String.valueOf(this));
        }
        for (IGDUnitBase unit : this.getUnitBases()) {
            unit.setAnalyst(analyst);
        }
        for (Surface surface : this.getSurfaces()) {
            surface.setAnalyst(analyst);
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    public final boolean isSequence() {
        return this.igdType == 10;
    }

    public final boolean isBiozone() {
        return this.igdType == 4;
    }

    public final boolean isMagneto() {
        return this.igdType == 26;
    }

    public static class ShadeInterval {
        private float uAge;
        private float lAge;
        Color colour;

        public ShadeInterval(float uAge, float lAge, Color colour) {
            this.uAge = uAge;
            this.lAge = lAge;
            this.colour = colour;
        }

        public float getUage() {
            return this.uAge;
        }

        public float getLage() {
            return this.lAge;
        }

        public Color getColour() {
            return this.colour;
        }
    }

    public static enum SequenceType {
        DEPOSITIONAL('D', "Depositional (Vail)"),
        GENETIC('G', "Genetic (Galloway)");

        final char charType;
        final String descr;

        private SequenceType(char charType, String descr) {
            this.charType = charType;
            this.descr = descr;
        }

        public char getCharType() {
            return this.charType;
        }

        static SequenceType get(char c) {
            switch (c) {
                case 'G': 
                case 'g': {
                    return GENETIC;
                }
            }
            return DEPOSITIONAL;
        }

        public static char getChar(SequenceType t) {
            if (t == null) {
                return '\u0000';
            }
            return t.getCharType();
        }

        public String toString() {
            return this.descr;
        }
    }

    public static class UnitHierComparator
    implements Comparator<IGDUnitClass> {
        @Override
        public int compare(IGDUnitClass o1, IGDUnitClass o2) {
            if (o1.getHier() == o2.getHier()) {
                return 0;
            }
            if (o1.getHier() < o2.getHier()) {
                return -1;
            }
            return 1;
        }
    }

    public static class MatchSchemes {
        IGDScheme scheme;
        int nMatches;
        int nInformalMatches;
        int nUniqieInformal;

        public IGDScheme getScheme() {
            return this.scheme;
        }

        public int getNMatches() {
            return this.nMatches;
        }

        public int getNInformal() {
            return this.nInformalMatches;
        }

        public int getnUniqiueInformal() {
            return this.nUniqieInformal;
        }

        private MatchSchemes(IGDScheme iGDScheme) {
            this.scheme = iGDScheme;
            this.nMatches = 1;
        }

        private MatchSchemes(IGDScheme iGDScheme, int unique) {
            this.scheme = iGDScheme;
            this.nUniqieInformal = unique;
            this.nInformalMatches = 1;
        }
    }

    public static class UnlinkedInterval
    implements Comparable {
        public final String informalName;
        private int occs;
        private Integer matchingUnitID;

        private UnlinkedInterval(String informalName) {
            this.informalName = informalName;
            this.occs = 1;
        }

        public Integer getMatchingUnitID() {
            return this.matchingUnitID;
        }

        public int getOccs() {
            return this.occs;
        }

        public int compareTo(Object rhs) {
            if (rhs instanceof UnlinkedInterval) {
                return this.informalName.compareTo(((UnlinkedInterval)rhs).informalName);
            }
            return 0;
        }
    }

    public static class UnitAgeComparator
    implements Comparator<IGDUnitClass> {
        UnitHierComparator cascade = null;

        public UnitAgeComparator(UnitHierComparator cascade) {
            this.cascade = cascade;
        }

        @Override
        public int compare(IGDUnitClass o1, IGDUnitClass o2) {
            if (o1.hasAges() && !o2.hasAges()) {
                return 1;
            }
            if (o2.hasAges() && !o1.hasAges()) {
                return -1;
            }
            if (o1.hasAges() && o2.hasAges()) {
                if (o1.getUage() < o2.getUage()) {
                    return -1;
                }
                if (o1.getUage() > o2.getUage()) {
                    return 1;
                }
                if (o1.getLage() < o2.getLage()) {
                    return 1;
                }
                if (o1.getLage() > o2.getLage()) {
                    return -1;
                }
            }
            if (this.cascade != null) {
                return this.cascade.compare(o1, o2);
            }
            return 0;
        }
    }

    public static class MissingSchemeException
    extends RuntimeException {
        public MissingSchemeException(String message) {
            super(message);
        }
    }
}

