/*
 * Decompiled with CFR 0.152.
 */
package model3;

import model3.ImportFileReaderType;

public interface ImportFileReader {
    public ImportFileReaderType getType();

    public ImportFileReaderColumn[] getColumns();

    default public void setArrayIndex(String cell, int index) {
        ImportFileReaderColumn[] COLUMNS = this.getColumns();
        for (int pos = 0; pos < COLUMNS.length; ++pos) {
            for (String colTitle : COLUMNS[pos].names) {
                if (!cell.equalsIgnoreCase(colTitle) || COLUMNS[pos].required == null) continue;
                COLUMNS[pos].index = index;
                COLUMNS[pos].columnNameInFile = cell;
                return;
            }
        }
    }

    default public String checkColumns() {
        ImportFileReaderColumn[] COLUMNS = this.getColumns();
        for (int pos = 0; pos < COLUMNS.length; ++pos) {
            if (COLUMNS[pos].required != null && COLUMNS[pos].required.booleanValue() && COLUMNS[pos].index == -1) {
                Object err = "Required column not found: ";
                for (String s : COLUMNS[pos].names) {
                    err = (String)err + s + "/";
                }
                err = ((String)err).substring(0, ((String)err).length() - 1);
                return err;
            }
            for (int pos2 = 0; pos2 < COLUMNS.length; ++pos2) {
                if (pos == pos2 || COLUMNS[pos].index < 0 || COLUMNS[pos].index != COLUMNS[pos2].index) continue;
                return "Duplicate columns found: " + COLUMNS[pos].columnNameInFile + " + " + COLUMNS[pos2].columnNameInFile;
            }
        }
        return null;
    }

    default public ImportFileReaderColumn getColumn(int index) {
        for (ImportFileReaderColumn col : this.getColumns()) {
            if (col.index != index) continue;
            return col;
        }
        return null;
    }

    public static class ImportFileReaderColumn {
        String[] names;
        int colNumber;
        Boolean required;
        int index = -1;
        String columnNameInFile = null;

        ImportFileReaderColumn(int colNumber, Boolean required, String ... names) {
            this.colNumber = colNumber;
            this.required = required;
            this.names = names;
        }

        public String toString() {
            Object n = "";
            for (String s : this.names) {
                n = (String)n + s + " / ";
            }
            n = ((String)n).substring(0, ((String)n).length() - 2);
            n = this.required == null ? (String)n + "[IGNORED]" : (this.required != false ? (String)n + "[REQUIRED]" : (String)n + "[OPTIONAL]");
            return n;
        }
    }
}

